/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.commands.Disasters;
import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.disasters.AcidStorm;
import deadlydisasters.events.disasters.BlackPlague;
import deadlydisasters.events.disasters.Blizzard;
import deadlydisasters.events.disasters.CaveIn;
import deadlydisasters.events.disasters.CustomDisasterMob;
import deadlydisasters.events.disasters.CustomEvent;
import deadlydisasters.events.disasters.Earthquake;
import deadlydisasters.events.disasters.EndStorm;
import deadlydisasters.events.disasters.ExtremeWinds;
import deadlydisasters.events.disasters.Geyser;
import deadlydisasters.events.disasters.Hurricane;
import deadlydisasters.events.disasters.MeteorShower;
import deadlydisasters.events.disasters.Purge;
import deadlydisasters.events.disasters.SandStorm;
import deadlydisasters.events.disasters.Sinkhole;
import deadlydisasters.events.disasters.SolarStorm;
import deadlydisasters.events.disasters.SoulStorm;
import deadlydisasters.events.disasters.Supernova;
import deadlydisasters.events.disasters.Tornado;
import deadlydisasters.events.disasters.Tsunami;
import deadlydisasters.handlers.Catalog;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CustomDisaster {
    public static Map<String, YamlConfiguration> disasterFiles = new HashMap<String, YamlConfiguration>();
    private Main plugin;
    private YamlConfiguration yaml;
    private int level;
    private Random rand;
    private Location startPos;
    private String nameID;
    private int amount = -1;
    private Map<Integer, Queue<CustomEvent>> list = new LinkedHashMap<Integer, Queue<CustomEvent>>();
    private Map<String, ItemStack> itemMap = new HashMap<String, ItemStack>();
    private Map<String, CustomDisasterMob> entityMap = new HashMap<String, CustomDisasterMob>();

    public CustomDisaster(int n, Main main, YamlConfiguration yamlConfiguration) {
        this.rand = main.random;
        this.level = n;
        this.plugin = main;
        this.yaml = yamlConfiguration;
    }

    public static void loadFiles(Main main) {
        File file = new File(main.getDataFolder().getAbsolutePath(), "custom disasters");
        file.mkdirs();
        if (!file.exists()) {
            Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&cCould not create custom disasters directory plugin was denied access?! Please create this folder manually in the plugins directory next to the config file &d'custom disasters'"));
            return;
        }
        disasterFiles.clear();
        new File(main.getDataFolder().getAbsolutePath(), "custom disasters").mkdirs();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            CustomDisaster.loadDisaster(file2);
            ++n2;
        }
    }

    public static void loadDisaster(File file) {
        try {
            YamlConfiguration yamlConfiguration = new YamlConfiguration();
            yamlConfiguration.load(file);
            if (yamlConfiguration.contains("catalog.id") && Catalog.catalogFileNames.contains(file.getName().substring(0, file.getName().indexOf(46)))) {
                Catalog.downloadedDisasters.put(yamlConfiguration.getInt("catalog.id"), file);
            }
            disasterFiles.put(yamlConfiguration.getString("settings.name"), yamlConfiguration);
            Disasters.addDisaster(yamlConfiguration.getString("settings.name"));
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&cCould not load &e'" + file.getName() + "' &cinvalid disaster configuration!\n" + invalidConfigurationException.getMessage()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void start(final Location location, final Player player) {
        this.startPos = location;
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                CustomDisaster.this.preInit();
                CustomDisaster.this.init(WorldObject.findWorldObject((World)location.getWorld()).offset);
                CustomDisaster.this.updateValues(location.getWorld(), player);
                String string = "core.level " + CustomDisaster.this.level + '.';
                int n = 10;
                if (CustomDisaster.this.yaml.contains(String.valueOf(string) + "interval_seconds")) {
                    n = CustomDisaster.this.yaml.getInt(String.valueOf(string) + "interval_seconds");
                }
                int n2 = 0;
                if (CustomDisaster.this.yaml.contains("settings.start_delay")) {
                    n2 = CustomDisaster.this.yaml.getInt("settings.start_delay") * 20;
                }
                if (CustomDisaster.this.yaml.getString(String.valueOf(string) + "operation").equals("random") && CustomDisaster.this.yaml.contains(String.valueOf(string) + "number_of_events")) {
                    CustomDisaster.this.amount = CustomDisaster.this.yaml.getInt(String.valueOf(string) + "number_of_events");
                }
                final Iterator<Map.Entry<Integer, Queue<CustomEvent>>> iterator = CustomDisaster.this.list.entrySet().iterator();
                new RepeatingTask(CustomDisaster.this.plugin, n2, n * 20){

                    @Override
                    public void run() {
                        if ((this).CustomDisaster.this.amount == 0) {
                            if ((this).CustomDisaster.this.yaml.contains("settings.ending_message")) {
                                CustomDisaster.this.broadcastEndingMessage(location.getWorld());
                            }
                            this.cancel();
                            return;
                        }
                        if ((this).CustomDisaster.this.amount > 0) {
                            --(this).CustomDisaster.this.amount;
                        }
                        if (iterator.hasNext()) {
                            ((Queue)((Map.Entry)iterator.next()).getValue()).forEach(customEvent -> customEvent.trigger((this).CustomDisaster.this.rand, (this).CustomDisaster.this.plugin));
                        } else {
                            if ((this).CustomDisaster.this.yaml.contains("settings.ending_message")) {
                                CustomDisaster.this.broadcastEndingMessage(location.getWorld());
                            }
                            this.cancel();
                        }
                    }
                };
            }
        });
    }

    public void createTimedStart(int n, final Vector vector, final Player player) {
        final Location location = player.getLocation();
        if (!DestructionDisaster.currentLocations.containsKey(location.getWorld())) {
            DestructionDisaster.currentLocations.put(location.getWorld(), new ArrayDeque());
        }
        DestructionDisaster.currentLocations.get(location.getWorld()).add(player);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!DestructionDisaster.currentLocations.containsKey(location.getWorld()) || !DestructionDisaster.currentLocations.get(location.getWorld()).contains(player)) {
                    return;
                }
                DestructionDisaster.currentLocations.get(location.getWorld()).remove(player);
                if (DestructionDisaster.currentLocations.get(location.getWorld()).isEmpty()) {
                    DestructionDisaster.currentLocations.remove(location.getWorld());
                }
                if (!player.isOnline() || !player.getWorld().equals(location.getWorld())) {
                    return;
                }
                WorldObject worldObject = WorldObject.findWorldObject(player.getWorld());
                if (Utils.isPlayerImmune(player) || !worldObject.naturalAllowed || !worldObject.allowed.contains((Object)Disaster.CUSTOM)) {
                    return;
                }
                final Location location2 = player.getLocation().add(vector);
                if (((Boolean)worldObject.settings.get("event_broadcast")).booleanValue()) {
                    CustomDisaster.this.broadcastMessage(location, player);
                }
                if (DestructionDisaster.currentLocations.containsKey(player.getWorld())) {
                    for (Entity entity : player.getNearbyEntities((double)worldObject.maxRadius, (double)worldObject.maxRadius, (double)worldObject.maxRadius)) {
                        if (!(entity instanceof Player) || !DestructionDisaster.currentLocations.get(player.getWorld()).contains(entity)) continue;
                        DestructionDisaster.currentLocations.get(player.getWorld()).remove(entity);
                    }
                    if (DestructionDisaster.currentLocations.get(player.getWorld()).isEmpty()) {
                        DestructionDisaster.currentLocations.remove(player.getWorld());
                    }
                }
                CustomDisaster.this.plugin.getServer().getScheduler().runTaskLater((Plugin)CustomDisaster.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        CustomDisaster.this.start(location2, player);
                        Metrics.incrementValue(Metrics.disasterOccurredMap, Disaster.CUSTOM.getMetricsLabel());
                    }
                }, 0L);
            }
        }, (long)(n * 20));
    }

    public void broadcastEndingMessage(World world) {
        String string = Utils.chat(this.yaml.getString("settings.ending_message"));
        for (Player player : world.getPlayers()) {
            player.sendMessage(string);
        }
        Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + string + Utils.chat(" &a(" + world.getName() + ")"));
    }

    public void broadcastMessage(Location location, Player player) {
        if (this.yaml.contains("settings.start_message")) {
            String string = this.yaml.getString("settings.start_message");
            char c = Utils.getLevelChar(this.level);
            string = string.replace("%level%", String.valueOf(this.level)).replace("%level_char%", "&" + c);
            string = Utils.chat(string.replace("%disaster%", this.yaml.getString("settings.title")).replace("%location%", String.valueOf(location.getBlockX()) + " " + location.getBlockY() + " " + location.getBlockZ()).replace("%player%", player.getName()));
            for (Player player2 : location.getWorld().getPlayers()) {
                player2.sendMessage(string);
            }
            Main.consoleSender.sendMessage(Utils.chat(String.valueOf(string) + " &a(" + location.getWorld().getName() + ")"));
        } else {
            String string = WorldObject.findWorldObject((World)location.getWorld()).configFile.getString("messages.destructive.level " + this.level);
            string = Utils.chat(string.replace("%disaster%", this.yaml.getString("settings.title")).replace("%location%", String.valueOf(location.getBlockX()) + " " + location.getBlockY() + " " + location.getBlockZ()).replace("%player%", player.getName()));
            for (Player player3 : location.getWorld().getPlayers()) {
                player3.sendMessage(string);
            }
            Main.consoleSender.sendMessage(Utils.chat(String.valueOf(string) + " &a(" + location.getWorld().getName() + ")"));
        }
    }

    public void updateValues(World world, Player player) {
        Iterator<Map.Entry<Integer, Queue<CustomEvent>>> iterator = this.list.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().forEach(customEvent -> customEvent.initValues(world, player, this.startPos));
        }
    }

    public void preInit() {
        String string;
        if (this.yaml.contains("items")) {
            for (String string2 : this.yaml.getConfigurationSection("items").getKeys(false)) {
                Object object;
                string = "items." + string2 + '.';
                ItemStack itemStack = new ItemStack(Material.valueOf((String)this.yaml.getString(String.valueOf(string) + "type").toUpperCase()));
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (this.yaml.contains(String.valueOf(string) + "name")) {
                    itemMeta.setDisplayName(Utils.chat(this.yaml.getString(String.valueOf(string) + "name")));
                }
                if (this.yaml.contains(String.valueOf(string) + "lore")) {
                    object = new ArrayList<String>();
                    for (Object object2 : this.yaml.getStringList(String.valueOf(string) + "lore")) {
                        object.add(Utils.chat((String)object2));
                    }
                    itemMeta.setLore(object);
                }
                if (this.yaml.contains(String.valueOf(string) + "enchantments")) {
                    Object object2;
                    object2 = this.yaml.getConfigurationSection(String.valueOf(string) + "enchantments").getKeys(false).iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        String string3 = String.valueOf(string) + "enchantments." + (String)object + '.';
                        itemMeta.addEnchant(Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)this.yaml.getString(String.valueOf(string3) + "enchantment").toLowerCase())), this.yaml.getInt(String.valueOf(string3) + "level"), true);
                    }
                }
                if (this.yaml.contains(String.valueOf(string) + "hide_enchants") && this.yaml.getBoolean(String.valueOf(string) + "hide_enchants")) {
                    itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                itemStack.setItemMeta(itemMeta);
                this.itemMap.put(string2, itemStack);
            }
        }
        if (this.yaml.contains("entities")) {
            for (String string2 : this.yaml.getConfigurationSection("entities").getKeys(false)) {
                string = "entities." + string2 + '.';
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                if (this.yaml.contains(String.valueOf(string) + "health")) {
                    d = this.yaml.getDouble(String.valueOf(string) + "health");
                }
                if (this.yaml.contains(String.valueOf(string) + "range")) {
                    d2 = this.yaml.getDouble(String.valueOf(string) + "range");
                }
                if (this.yaml.contains(String.valueOf(string) + "speed")) {
                    d3 = this.yaml.getDouble(String.valueOf(string) + "speed");
                }
                if (this.yaml.contains(String.valueOf(string) + "damage")) {
                    d4 = this.yaml.getDouble(String.valueOf(string) + "damage");
                }
                if (this.yaml.contains(String.valueOf(string) + "knockback")) {
                    d5 = this.yaml.getDouble(String.valueOf(string) + "knockback");
                }
                if (this.yaml.contains(String.valueOf(string) + "resistance")) {
                    d6 = this.yaml.getDouble(String.valueOf(string) + "resistance");
                }
                ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR)};
                ItemStack itemStack = new ItemStack(Material.AIR);
                ItemStack itemStack2 = new ItemStack(Material.AIR);
                if (this.yaml.contains(String.valueOf(string) + "equipment")) {
                    if (this.yaml.contains(String.valueOf(string) + "equipment.mainHand")) {
                        itemStack = this.getItemByName(this.yaml.getString(String.valueOf(string) + "equipment.mainHand"));
                    }
                    if (this.yaml.contains(String.valueOf(string) + "equipment.offHand")) {
                        itemStack2 = this.getItemByName(this.yaml.getString(String.valueOf(string) + "equipment.offHand"));
                    }
                    if (this.yaml.contains(String.valueOf(string) + "equipment.helmet")) {
                        itemStackArray[3] = this.getItemByName(this.yaml.getString(String.valueOf(string) + "equipment.helmet"));
                    }
                    if (this.yaml.contains(String.valueOf(string) + "equipment.chest")) {
                        itemStackArray[2] = this.getItemByName(this.yaml.getString(String.valueOf(string) + "equipment.chest"));
                    }
                    if (this.yaml.contains(String.valueOf(string) + "equipment.legs")) {
                        itemStackArray[1] = this.getItemByName(this.yaml.getString(String.valueOf(string) + "equipment.legs"));
                    }
                    if (this.yaml.contains(String.valueOf(string) + "equipment.boots")) {
                        itemStackArray[0] = this.getItemByName(this.yaml.getString(String.valueOf(string) + "equipment.boots"));
                    }
                }
                float[] fArray = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f};
                if (this.yaml.contains(String.valueOf(string) + "dropChances")) {
                    if (this.yaml.contains(String.valueOf(string) + "dropChances.mainHand")) {
                        fArray[4] = (float)this.yaml.getDouble(String.valueOf(string) + "dropChances.mainHand");
                    }
                    if (this.yaml.contains(String.valueOf(string) + "dropChances.offHand")) {
                        fArray[5] = (float)this.yaml.getDouble(String.valueOf(string) + "dropChances.offHand");
                    }
                    if (this.yaml.contains(String.valueOf(string) + "dropChances.helmet")) {
                        fArray[0] = (float)this.yaml.getDouble(String.valueOf(string) + "dropChances.helmet");
                    }
                    if (this.yaml.contains(String.valueOf(string) + "dropChances.chest")) {
                        fArray[1] = (float)this.yaml.getDouble(String.valueOf(string) + "dropChances.chest");
                    }
                    if (this.yaml.contains(String.valueOf(string) + "dropChances.legs")) {
                        fArray[2] = (float)this.yaml.getDouble(String.valueOf(string) + "dropChances.legs");
                    }
                    if (this.yaml.contains(String.valueOf(string) + "dropChances.boots")) {
                        fArray[3] = (float)this.yaml.getDouble(String.valueOf(string) + "dropChances.boots");
                    }
                }
                boolean bl = false;
                if (this.yaml.contains(String.valueOf(string) + "silent")) {
                    bl = this.yaml.getBoolean(String.valueOf(string) + "silent");
                }
                boolean bl2 = false;
                if (this.yaml.contains(String.valueOf(string) + "pickUpItems")) {
                    bl2 = this.yaml.getBoolean(String.valueOf(string) + "pickUpItems");
                }
                boolean bl3 = false;
                if (this.yaml.contains(String.valueOf(string) + "despawn")) {
                    bl3 = this.yaml.getBoolean(String.valueOf(string) + "despawn");
                }
                String string4 = null;
                if (this.yaml.contains(String.valueOf(string) + "name")) {
                    string4 = Utils.chat(this.yaml.getString(String.valueOf(string) + "name"));
                }
                CustomDisasterMob customDisasterMob = new CustomDisasterMob(EntityType.valueOf((String)this.yaml.getString(String.valueOf(string) + "type").toUpperCase()), d, d2, d3, d4, d5, d6, itemStackArray, itemStack, itemStack2, fArray, bl, string4, bl2, bl3);
                this.entityMap.put(string2, customDisasterMob);
            }
        }
    }

    public void init(int n2) {
        String string2 = "core.level " + this.level;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Object object : this.yaml.getConfigurationSection(String.valueOf(string2) + ".events").getKeys(false)) {
            ArrayDeque<CustomEvent> arrayDeque = new ArrayDeque<CustomEvent>();
            for (String string3 : this.yaml.getConfigurationSection(String.valueOf(string2) + ".events." + (String)object).getKeys(false)) {
                Object object2;
                Object object3;
                Object object4;
                Material[] materialArray;
                boolean bl;
                String string4;
                block264: {
                    string4 = String.valueOf(string2) + ".events." + (String)object + '.' + string3 + '.';
                    if (!string3.contains("disaster")) break block264;
                    int n3 = 0;
                    n3 = this.yaml.contains(String.valueOf(string4) + "level") ? this.yaml.getInt(String.valueOf(string4) + "level") : this.rand.nextInt(6) + 1;
                    int n4 = 0;
                    if (this.yaml.contains(String.valueOf(string4) + "target")) {
                        if (this.yaml.getString(String.valueOf(string4) + "target").equals("all")) {
                            n4 = -1;
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("random")) {
                            n4 = this.yaml.getInt(this.yaml.getString(String.valueOf(string4) + "targetAmount"));
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("startPos")) {
                            n4 = -2;
                        }
                    }
                    int n5 = Math.max(n2, 1);
                    if (this.yaml.contains(String.valueOf(string4) + "offset")) {
                        n5 = Math.max(this.yaml.getInt(String.valueOf(string4) + "offset"), 1);
                    }
                    String[] stringArray = new String[]{"0", "0", "0"};
                    if (this.yaml.contains(String.valueOf(string4) + "location")) {
                        n5 = -1;
                        stringArray[0] = this.yaml.getString(String.valueOf(string4) + "location.x");
                        stringArray[1] = this.yaml.getString(String.valueOf(string4) + "location.y");
                        stringArray[2] = this.yaml.getString(String.valueOf(string4) + "location.z");
                    }
                    bl = false;
                    if (this.yaml.contains(String.valueOf(string4) + "broadcastAllowed")) {
                        bl = this.yaml.getBoolean(String.valueOf(string4) + "broadcastAllowed");
                    }
                    switch (this.yaml.getString(String.valueOf(string4) + "type")) {
                        case "acidstorm": {
                            materialArray = new AcidStorm(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                materialArray.setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "melt_items")) {
                                materialArray.setMeltItems(this.yaml.getBoolean(String.valueOf(string4) + "melt_items"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "melt_armor")) {
                                materialArray.setMeltArmor(this.yaml.getBoolean(String.valueOf(string4) + "melt_armor"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "damage")) {
                                materialArray.setDamage(this.yaml.getDouble(String.valueOf(string4) + "damage"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                materialArray.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("wd", materialArray, bl));
                            break;
                        }
                        case "plague": {
                            object4 = new BlackPlague(n3);
                            arrayDeque.add(new CustomEvent("wd", object4, bl));
                            break;
                        }
                        case "blizzard": {
                            object3 = new Blizzard(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                ((WeatherDisaster)object3).setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "freezeMobs")) {
                                ((Blizzard)object3).setMobsFreeze(this.yaml.getBoolean(String.valueOf(string4) + "freezeMobs"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "leatherProtect")) {
                                ((Blizzard)object3).setLeatherProtect(this.yaml.getBoolean(String.valueOf(string4) + "leatherProtect"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                ((WeatherDisaster)object3).setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("wd", object3, bl));
                            break;
                        }
                        case "endstorm": {
                            EndStorm endStorm = new EndStorm(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                endStorm.setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "maxEntities")) {
                                endStorm.setMaxEntities(this.yaml.getInt(String.valueOf(string4) + "maxEntities"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "teleportRange")) {
                                endStorm.setRange(this.yaml.getInt(String.valueOf(string4) + "teleportRange"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                endStorm.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("wd", endStorm, bl));
                            break;
                        }
                        case "extremewinds": {
                            ExtremeWinds extremeWinds = new ExtremeWinds(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                extremeWinds.setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "force")) {
                                extremeWinds.setTempForce(this.yaml.getDouble(String.valueOf(string4) + "force"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "particleType")) {
                                extremeWinds.setParticle(Particle.valueOf((String)this.yaml.getString(String.valueOf(string4) + "particleType").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "maxParticles")) {
                                extremeWinds.setMaxParticles(this.yaml.getInt(String.valueOf(string4) + "maxParticles"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "blockForce")) {
                                extremeWinds.setBreakForce(this.yaml.getDouble(String.valueOf(string4) + "blockForce"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                extremeWinds.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("wd", extremeWinds, bl));
                            break;
                        }
                        case "meteorshower": {
                            MeteorShower meteorShower = new MeteorShower(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                meteorShower.setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "night")) {
                                meteorShower.setNight(this.yaml.getBoolean(String.valueOf(string4) + "night"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "particleType")) {
                                meteorShower.setParticle(Particle.valueOf((String)this.yaml.getString(String.valueOf(string4) + "particleType").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "smokeTime")) {
                                meteorShower.setSmokeTime(this.yaml.getInt(String.valueOf(string4) + "smokeTime"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "spawnRate")) {
                                meteorShower.setSpawnRate(this.yaml.getInt(String.valueOf(string4) + "spawnRate"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "maxMeteors")) {
                                meteorShower.setMax(this.yaml.getInt(String.valueOf(string4) + "maxMeteors"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                meteorShower.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            int[] nArray = new int[]{1, 2, 3};
                            double[] dArray = new double[]{1.0, 1.0, 1.0};
                            int[][] nArrayArray = new int[][]{{2, 6}, {2, 6}, {2, 6}};
                            if (this.yaml.contains(String.valueOf(string4) + "normalMeteor")) {
                                if (this.yaml.contains(String.valueOf(string4) + "normalMeteor.allowed") && !this.yaml.getBoolean(String.valueOf(string4) + "normalMeteor.allowed")) {
                                    nArray[0] = 0;
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "normalMeteor.material")) {
                                    meteorShower.setNormalMaterial(Material.valueOf((String)this.yaml.getString(String.valueOf(string4) + "normalMeteor.material").toUpperCase()));
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "normalMeteor.generateOres")) {
                                    meteorShower.setSpawnOres(this.yaml.getBoolean(String.valueOf(string4) + "normalMeteor.generateOres"));
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "normalMeteor.speed")) {
                                    dArray[0] = this.yaml.getDouble(String.valueOf(string4) + "normalMeteor.speed");
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "normalMeteor.minSize")) {
                                    nArrayArray[0][0] = this.yaml.getInt(String.valueOf(string4) + "normalMeteor.minSize");
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "normalMeteor.maxSize")) {
                                    nArrayArray[0][1] = this.yaml.getInt(String.valueOf(string4) + "normalMeteor.maxSize");
                                }
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "explodingMeteor")) {
                                if (this.yaml.contains(String.valueOf(string4) + "explodingMeteor.allowed") && !this.yaml.getBoolean(String.valueOf(string4) + "explodingMeteor.allowed")) {
                                    nArray[1] = 0;
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "explodingMeteor.material")) {
                                    meteorShower.setExplodingMaterial(Material.valueOf((String)this.yaml.getString(String.valueOf(string4) + "explodingMeteor.material").toUpperCase()));
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "explodingMeteor.damage")) {
                                    meteorShower.setExplosionDamage(this.yaml.getDouble(String.valueOf(string4) + "explodingMeteor.damage"));
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "explodingMeteor.speed")) {
                                    dArray[1] = this.yaml.getDouble(String.valueOf(string4) + "explodingMeteor.speed");
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "explodingMeteor.minSize")) {
                                    nArrayArray[1][0] = this.yaml.getInt(String.valueOf(string4) + "explodingMeteor.minSize");
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "explodingMeteor.maxSize")) {
                                    nArrayArray[1][1] = this.yaml.getInt(String.valueOf(string4) + "explodingMeteor.maxSize");
                                }
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "splittingMeteor")) {
                                if (this.yaml.contains(String.valueOf(string4) + "splittingMeteor.allowed") && !this.yaml.getBoolean(String.valueOf(string4) + "splittingMeteor.allowed")) {
                                    nArray[0] = 0;
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "splittingMeteor.material")) {
                                    meteorShower.setSplittingMaterial(Material.valueOf((String)this.yaml.getString(String.valueOf(string4) + "splittingMeteor.material").toUpperCase()));
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "splittingMeteor.impactSpeed")) {
                                    meteorShower.setSplitImpact(this.yaml.getDouble(String.valueOf(string4) + "splittingMeteor.impactSpeed"));
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "splittingMeteor.speed")) {
                                    dArray[2] = this.yaml.getDouble(String.valueOf(string4) + "splittingMeteor.speed");
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "splittingMeteor.minSize")) {
                                    nArrayArray[2][0] = this.yaml.getInt(String.valueOf(string4) + "splittingMeteor.minSize");
                                }
                                if (this.yaml.contains(String.valueOf(string4) + "splittingMeteor.maxSize")) {
                                    nArrayArray[2][1] = this.yaml.getInt(String.valueOf(string4) + "splittingMeteor.maxSize");
                                }
                            }
                            int n6 = 0;
                            while (n6 < nArray.length) {
                                if (nArray[n6] == 0) {
                                    nArray = Utils.removeElement(nArray, n6);
                                    --n6;
                                }
                                ++n6;
                            }
                            meteorShower.setAllowedTypes(nArray);
                            meteorShower.setSpeeds(dArray);
                            meteorShower.setMeteorSizes(nArrayArray);
                            arrayDeque.add(new CustomEvent("wd", meteorShower, bl));
                            break;
                        }
                        case "sandstorm": {
                            SandStorm sandStorm = new SandStorm(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                sandStorm.setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "customMobs")) {
                                sandStorm.setCustom(this.yaml.getBoolean(String.valueOf(string4) + "customMobs"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "wither")) {
                                sandStorm.setWitherActive(this.yaml.getBoolean(String.valueOf(string4) + "wither"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "skulls")) {
                                sandStorm.setMobsDropSkulls(this.yaml.getBoolean(String.valueOf(string4) + "skulls"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                sandStorm.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("wd", sandStorm, bl));
                            break;
                        }
                        case "soulstorm": {
                            SoulStorm soulStorm = new SoulStorm(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                soulStorm.setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "customMobs")) {
                                soulStorm.setVexSpawn(this.yaml.getBoolean(String.valueOf(string4) + "customMobs"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                soulStorm.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("wd", soulStorm, bl));
                            break;
                        }
                        case "solarstorm": {
                            SolarStorm solarStorm = new SolarStorm(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                solarStorm.setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "spawnPhantoms")) {
                                solarStorm.setSpawnMobs(this.yaml.getBoolean(String.valueOf(string4) + "spawnPhantoms"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                solarStorm.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("wd", solarStorm, bl));
                            break;
                        }
                        case "sinkhole": {
                            Sinkhole sinkhole = new Sinkhole(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "size")) {
                                sinkhole.setSize(this.yaml.getDouble(String.valueOf(string4) + "size"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "tickSpeed")) {
                                sinkhole.setSpeed(this.yaml.getInt(String.valueOf(string4) + "tickSpeed"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                sinkhole.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("dd", sinkhole, n4, n5, stringArray));
                            break;
                        }
                        case "earthquake": {
                            Earthquake earthquake = new Earthquake(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "size")) {
                                earthquake.setSize(this.yaml.getDouble(String.valueOf(string4) + "size"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "force")) {
                                earthquake.setForce(this.yaml.getDouble(String.valueOf(string4) + "force"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "length")) {
                                earthquake.setRadius(this.yaml.getInt(String.valueOf(string4) + "length"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "width")) {
                                earthquake.setWidth(this.yaml.getInt(String.valueOf(string4) + "width"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "tilt")) {
                                earthquake.setTilt(this.yaml.getDouble(String.valueOf(string4) + "tilt"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                earthquake.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("dd", earthquake, n4, n5, stringArray));
                            break;
                        }
                        case "supernova": {
                            ArrayList arrayList;
                            Object object5;
                            Supernova supernova = new Supernova(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "size")) {
                                supernova.setSizeMultiplier(this.yaml.getDouble(String.valueOf(string4) + "size"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "particleChance")) {
                                supernova.setParticles(this.yaml.getInt(String.valueOf(string4) + "particleChance"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "particleType")) {
                                supernova.setParticle(Particle.valueOf((String)this.yaml.getString(String.valueOf(string4) + "particleType").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "flash")) {
                                supernova.setFlash(this.yaml.getBoolean(String.valueOf(string4) + "flash"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                supernova.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "materials")) {
                                object5 = this.yaml.getStringList(String.valueOf(string4) + "materials");
                                arrayList = new ArrayList();
                                object5.forEach(string -> {
                                    boolean bl = arrayList.add(Material.valueOf((String)string.toUpperCase()));
                                });
                                supernova.setMaterials(arrayList.toArray(new Material[0]));
                            }
                            arrayDeque.add(new CustomEvent("dd", supernova, n4, n5, stringArray));
                            break;
                        }
                        case "cavein": {
                            Object object6;
                            ArrayList arrayList;
                            Object object5 = new CaveIn(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "size")) {
                                ((CaveIn)object5).setSize(this.yaml.getDouble(String.valueOf(string4) + "size"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "depth")) {
                                ((CaveIn)object5).setDepth(this.yaml.getInt(String.valueOf(string4) + "depth"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "fallSpeed")) {
                                ((CaveIn)object5).setFallSpeed(this.yaml.getDouble(String.valueOf(string4) + "fallSpeed"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                ((DestructionDisaster)object5).setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "materials")) {
                                arrayList = this.yaml.getStringList(String.valueOf(string4) + "materials");
                                object6 = new ArrayList();
                                arrayList.forEach(arg_0 -> CustomDisaster.lambda$2((List)object6, arg_0));
                                ((CaveIn)object5).setMaterials(object6.toArray(new Material[0]));
                            }
                            arrayDeque.add(new CustomEvent("dd", object5, n4, n5, stringArray));
                            break;
                        }
                        case "geyser": {
                            ArrayList arrayList = new Geyser(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "width")) {
                                ((Geyser)((Object)arrayList)).setWidth(this.yaml.getInt(String.valueOf(string4) + "width") - 1);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "amount")) {
                                ((Geyser)((Object)arrayList)).setMiniGeyserAmount(this.yaml.getInt(String.valueOf(string4) + "amount"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "damage")) {
                                ((Geyser)((Object)arrayList)).setDamage(this.yaml.getDouble(String.valueOf(string4) + "damage"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "material")) {
                                ((Geyser)((Object)arrayList)).setMaterial(Material.valueOf((String)this.yaml.getString(String.valueOf(string4) + "material").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "tickSpeed")) {
                                ((Geyser)((Object)arrayList)).setTickSpeed(this.yaml.getInt(String.valueOf(string4) + "tickSpeed"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "velocity")) {
                                ((Geyser)((Object)arrayList)).setYVelocity(this.yaml.getDouble(String.valueOf(string4) + "velocity"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "particleType")) {
                                ((Geyser)((Object)arrayList)).setParticle(Particle.valueOf((String)this.yaml.getString(String.valueOf(string4) + "particleType").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "minReach")) {
                                ((Geyser)((Object)arrayList)).setMinReach(this.yaml.getInt(String.valueOf(string4) + "minReach"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "maxReach")) {
                                ((Geyser)((Object)arrayList)).setMaxReach(this.yaml.getInt(String.valueOf(string4) + "maxReach"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "range")) {
                                ((Geyser)((Object)arrayList)).setRange(this.yaml.getInt(String.valueOf(string4) + "range"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "spawnTicks")) {
                                ((Geyser)((Object)arrayList)).setSpawnInterval(this.yaml.getInt(String.valueOf(string4) + "spawnTicks"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                ((DestructionDisaster)((Object)arrayList)).setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "sound")) {
                                ((Geyser)((Object)arrayList)).setSound(this.getSound(this.yaml.getString(String.valueOf(string4) + "sound").toUpperCase()));
                            }
                            arrayDeque.add(new CustomEvent("dd", arrayList, n4, n5, stringArray));
                            break;
                        }
                        case "hurricane": {
                            Object object6 = new Hurricane(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "size")) {
                                ((Hurricane)object6).setSize(this.yaml.getInt(String.valueOf(string4) + "size"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                ((Hurricane)object6).setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "lightning")) {
                                ((Hurricane)object6).setLightning(this.yaml.getInt(String.valueOf(string4) + "lightning"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "blockForce")) {
                                ((Hurricane)object6).setBlockForce(this.yaml.getDouble(String.valueOf(string4) + "blockForce"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "minForce")) {
                                ((Hurricane)object6).setMinForce(this.yaml.getDouble(String.valueOf(string4) + "minForce"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "maxForce")) {
                                ((Hurricane)object6).setMaxForce(this.yaml.getDouble(String.valueOf(string4) + "maxForce"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "particleType")) {
                                ((Hurricane)object6).setParticle(Particle.valueOf((String)this.yaml.getString(String.valueOf(string4) + "particleType").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                ((DestructionDisaster)object6).setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("dd", object6, n4, n5, stringArray));
                            break;
                        }
                        case "purge": {
                            Purge purge = new Purge(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "maxEntities")) {
                                purge.setMax(this.yaml.getInt(String.valueOf(string4) + "maxEntities"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "showBar")) {
                                purge.setShowBar(this.yaml.getBoolean(String.valueOf(string4) + "showBar"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "barTitle")) {
                                purge.setBarTitle(this.yaml.getString(String.valueOf(string4) + "barTitle"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "barColor")) {
                                purge.setBarColor(BarColor.valueOf((String)this.yaml.getString(String.valueOf(string4) + "barColor").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "spawnDistance")) {
                                purge.setSpawnDistance(this.yaml.getInt(String.valueOf(string4) + "spawnDistance"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "despawnSpeed")) {
                                purge.setDespawnSpeed(this.yaml.getInt(String.valueOf(string4) + "despawnSpeed"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "spawnTickSpeed")) {
                                purge.setSpawnSpeed(this.yaml.getInt(String.valueOf(string4) + "spawnTickSpeed"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "endMessage")) {
                                purge.setEndMessage(this.yaml.getString(String.valueOf(string4) + "endMessage"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                purge.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            arrayDeque.add(new CustomEvent("dd", purge, n4, n5, stringArray));
                            break;
                        }
                        case "tornado": {
                            ArrayList arrayList;
                            Object object7;
                            Tornado tornado = new Tornado(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "size")) {
                                tornado.setSize(this.yaml.getInt(String.valueOf(string4) + "size"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "time")) {
                                tornado.setTime(this.yaml.getInt(String.valueOf(string4) + "time") * 20);
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "maxBlocks")) {
                                tornado.setMaxBlocks(this.yaml.getInt(String.valueOf(string4) + "maxBlocks"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "pullForce")) {
                                tornado.setPullForce(this.yaml.getDouble(String.valueOf(string4) + "pullForce"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "yVelocity")) {
                                tornado.setyVelocity(this.yaml.getDouble(String.valueOf(string4) + "yVelocity"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "speed")) {
                                tornado.setSpeed(this.yaml.getDouble(String.valueOf(string4) + "speed"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "height")) {
                                tornado.setHeight(this.yaml.getInt(String.valueOf(string4) + "height"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "particleChance")) {
                                tornado.setParticles(this.yaml.getDouble(String.valueOf(string4) + "particleChance"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "width")) {
                                tornado.setWidth(this.yaml.getInt(String.valueOf(string4) + "width"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "particleType")) {
                                tornado.setParticleType(Particle.valueOf((String)this.yaml.getString(String.valueOf(string4) + "particleType").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                tornado.setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "materials")) {
                                object7 = this.yaml.getStringList(String.valueOf(string4) + "materials");
                                arrayList = new ArrayList();
                                object7.forEach(string -> {
                                    boolean bl = arrayList.add(Material.valueOf((String)string.toUpperCase()));
                                });
                                tornado.setMaterials(arrayList.toArray(new Material[0]));
                            }
                            arrayDeque.add(new CustomEvent("dd", tornado, n4, n5, stringArray));
                            break;
                        }
                        case "tsunami": {
                            ArrayList arrayList;
                            Object object7 = new Tsunami(n3);
                            if (this.yaml.contains(String.valueOf(string4) + "size")) {
                                ((Tsunami)object7).setRadius(this.yaml.getInt(String.valueOf(string4) + "size"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "height")) {
                                ((Tsunami)object7).setHeight(this.yaml.getInt(String.valueOf(string4) + "height"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "damage")) {
                                ((Tsunami)object7).setDamage(this.yaml.getDouble(String.valueOf(string4) + "damage"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "tickSpeed")) {
                                ((Tsunami)object7).setTickSpeed(this.yaml.getInt(String.valueOf(string4) + "tickSpeed"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "removeLiquid")) {
                                ((Tsunami)object7).setRemoveWater(this.yaml.getBoolean(String.valueOf(string4) + "removeLiquid"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "ignoreOcean")) {
                                ((Tsunami)object7).setIgnoreOcean(this.yaml.getBoolean(String.valueOf(string4) + "ignoreOcean"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "liquidMaterial")) {
                                ((Tsunami)object7).setLiquid(Material.valueOf((String)this.yaml.getString(String.valueOf(string4) + "liquidMaterial").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "particleType")) {
                                ((Tsunami)object7).setParticleType(Particle.valueOf((String)this.yaml.getString(String.valueOf(string4) + "particleType").toUpperCase()));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "minDepth")) {
                                ((Tsunami)object7).setDepth(this.yaml.getInt(String.valueOf(string4) + "minDepth"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                                ((DestructionDisaster)object7).setVolume(this.yaml.getDouble(String.valueOf(string4) + "volume"));
                            }
                            if (this.yaml.contains(String.valueOf(string4) + "materials")) {
                                arrayList = this.yaml.getStringList(String.valueOf(string4) + "materials");
                                ArrayList arrayList2 = new ArrayList();
                                arrayList.forEach(string -> {
                                    boolean bl = arrayList2.add(Material.valueOf((String)string.toUpperCase()).createBlockData());
                                });
                                ((Tsunami)object7).setMaterials(arrayList2.toArray(new BlockData[0]));
                            }
                            arrayDeque.add(new CustomEvent("dd", object7, n4, n5, stringArray));
                            break;
                        }
                    }
                    continue;
                }
                if (string3.contains("broadcast")) {
                    int n7 = 0;
                    if (this.yaml.contains(String.valueOf(string4) + "target")) {
                        if (this.yaml.getString(String.valueOf(string4) + "target").equals("all")) {
                            n7 = -1;
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("random")) {
                            n7 = this.yaml.getInt(this.yaml.getString(String.valueOf(string4) + "targetAmount"));
                        }
                    }
                    arrayDeque.add(new CustomEvent("b", this.yaml.getString(String.valueOf(string4) + "message"), n7, 0, null));
                    continue;
                }
                if (string3.contains("fill")) {
                    int n8 = 0;
                    if (this.yaml.contains(String.valueOf(string4) + "target")) {
                        if (this.yaml.getString(String.valueOf(string4) + "target").equals("all")) {
                            n8 = -1;
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("random")) {
                            n8 = this.yaml.getInt(this.yaml.getString(String.valueOf(string4) + "targetAmount"));
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("startPos")) {
                            n8 = -2;
                        }
                    }
                    String[] stringArray = new String[]{"0", "0", "0", "0", "0", "0"};
                    if (this.yaml.contains(String.valueOf(string4) + "firstPoint")) {
                        stringArray[0] = this.yaml.getString(String.valueOf(string4) + "firstPoint.x");
                        stringArray[1] = this.yaml.getString(String.valueOf(string4) + "firstPoint.y");
                        stringArray[2] = this.yaml.getString(String.valueOf(string4) + "firstPoint.z");
                    }
                    if (this.yaml.contains(String.valueOf(string4) + "secondPoint")) {
                        stringArray[3] = this.yaml.getString(String.valueOf(string4) + "secondPoint.x");
                        stringArray[4] = this.yaml.getString(String.valueOf(string4) + "secondPoint.y");
                        stringArray[5] = this.yaml.getString(String.valueOf(string4) + "secondPoint.z");
                    }
                    boolean bl2 = false;
                    if (this.yaml.contains(String.valueOf(string4) + "fillSolids")) {
                        bl2 = this.yaml.getBoolean(String.valueOf(string4) + "fillSolids");
                    }
                    HashSet<Material> hashSet = new HashSet<Material>();
                    bl = true;
                    if (this.yaml.contains(String.valueOf(string4) + "blacklist")) {
                        object2 = this.yaml.getStringList(String.valueOf(string4) + "blacklist");
                        materialArray = new ArrayList();
                        object2.forEach(arg_0 -> CustomDisaster.lambda$5((List)materialArray, arg_0));
                        hashSet.addAll((Collection<Material>)materialArray);
                    } else if (this.yaml.contains(String.valueOf(string4) + "whitelist")) {
                        bl = false;
                        object2 = this.yaml.getStringList(String.valueOf(string4) + "whitelist");
                        materialArray = new ArrayList();
                        object2.forEach(string -> {
                            Material material = Material.valueOf((String)string.toUpperCase());
                            if (!Utils.passStrengthTest(material)) {
                                materialArray.add(material);
                            }
                        });
                        hashSet.addAll((Collection<Material>)materialArray);
                    }
                    int n9 = 1;
                    if (this.yaml.contains(String.valueOf(string4) + "partition")) {
                        n9 = this.yaml.getInt(String.valueOf(string4) + "partition");
                    }
                    materialArray = new Material[]{Material.AIR};
                    if (this.yaml.contains(String.valueOf(string4) + "materials")) {
                        object4 = this.yaml.getStringList(String.valueOf(string4) + "materials");
                        object3 = new ArrayList();
                        object4.forEach(arg_0 -> CustomDisaster.lambda$7((List)object3, arg_0));
                        materialArray = object3.toArray(new Material[0]);
                    }
                    arrayDeque.add(new CustomEvent("f", n8, stringArray, bl, hashSet, bl2, n9, materialArray));
                    continue;
                }
                if (string3.contains("summon")) {
                    CustomDisasterMob customDisasterMob = this.entityMap.get(this.yaml.get(String.valueOf(string4) + "type"));
                    int n10 = 0;
                    if (this.yaml.contains(String.valueOf(string4) + "target")) {
                        if (this.yaml.getString(String.valueOf(string4) + "target").equals("all")) {
                            n10 = -1;
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("random")) {
                            n10 = this.yaml.getInt(this.yaml.getString(String.valueOf(string4) + "targetAmount"));
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("startPos")) {
                            n10 = -2;
                        }
                    }
                    boolean bl3 = false;
                    if (this.yaml.contains(String.valueOf(string4) + "force")) {
                        bl3 = this.yaml.getBoolean(String.valueOf(string4) + "force");
                    }
                    int n11 = 0;
                    if (this.yaml.contains(String.valueOf(string4) + "offset") && (n11 = this.yaml.getInt(String.valueOf(string4) + "offset")) < 1) {
                        n11 = 1;
                    }
                    bl = false;
                    if (this.yaml.contains(String.valueOf(string4) + "setTarget")) {
                        bl = this.yaml.getBoolean(String.valueOf(string4) + "setTarget");
                    }
                    object2 = new String[]{"0", "0", "0"};
                    if (this.yaml.contains(String.valueOf(string4) + "location")) {
                        object2[0] = this.yaml.getString(String.valueOf(string4) + "location.x");
                        object2[1] = this.yaml.getString(String.valueOf(string4) + "location.y");
                        object2[2] = this.yaml.getString(String.valueOf(string4) + "location.z");
                    }
                    arrayDeque.add(new CustomEvent("s", customDisasterMob, n10, n11, (String[])object2, bl3, bl));
                    continue;
                }
                if (string3.contains("particle")) {
                    int n12 = 0;
                    if (this.yaml.contains(String.valueOf(string4) + "target")) {
                        if (this.yaml.getString(String.valueOf(string4) + "target").equals("all")) {
                            n12 = -1;
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("random")) {
                            n12 = this.yaml.getInt(this.yaml.getString(String.valueOf(string4) + "targetAmount"));
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("startPos")) {
                            n12 = -2;
                        }
                    }
                    Particle particle = Particle.CLOUD;
                    if (this.yaml.contains(String.valueOf(string4) + "type")) {
                        String string5 = this.yaml.getString(String.valueOf(string4) + "type").toUpperCase();
                        if (string5.equals("BLOCK_CRACK") || string5.equals("BLOCK_DUST") || string5.equals("BLOCK_MARKER") || string5.equals("FALLING_DUST") || string5.equals("REDSTONE") || string5.equals("ITEM_CRACK") || string5.equals("DUST_COLOR_TRANSITION")) {
                            Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&eWARNING in '" + this.nameID + "' file! &f'" + string5 + "' &eparticle is not supported! Error at &fLevel " + this.level + " in " + (String)object + "&e! Ignoring this action.."));
                            continue;
                        }
                        particle = Particle.valueOf((String)string5);
                    }
                    double[] dArray = new double[]{10.0, 0.1, 0.0, 0.0, 0.0, 1.0, 1.0};
                    if (this.yaml.contains(String.valueOf(string4) + "count")) {
                        dArray[0] = this.yaml.getDouble(String.valueOf(string4) + "count");
                    }
                    if (this.yaml.contains(String.valueOf(string4) + "speed")) {
                        dArray[1] = this.yaml.getDouble(String.valueOf(string4) + "speed");
                    }
                    if (this.yaml.contains(String.valueOf(string4) + "range")) {
                        dArray[2] = this.yaml.getDouble(String.valueOf(string4) + "range.x");
                        dArray[3] = this.yaml.getDouble(String.valueOf(string4) + "range.y");
                        dArray[4] = this.yaml.getDouble(String.valueOf(string4) + "range.z");
                    }
                    if (this.yaml.contains(String.valueOf(string4) + "repeat")) {
                        dArray[5] = this.yaml.getInt(String.valueOf(string4) + "repeat");
                    }
                    if (this.yaml.contains(String.valueOf(string4) + "intervalTicks")) {
                        dArray[6] = this.yaml.getInt(String.valueOf(string4) + "intervalTicks");
                    }
                    String[] stringArray = new String[]{"0", "0", "0"};
                    if (this.yaml.contains(String.valueOf(string4) + "location")) {
                        stringArray[0] = this.yaml.getString(String.valueOf(string4) + "location.x");
                        stringArray[1] = this.yaml.getString(String.valueOf(string4) + "location.y");
                        stringArray[2] = this.yaml.getString(String.valueOf(string4) + "location.z");
                    }
                    arrayDeque.add(new CustomEvent("p", n12, particle, dArray, stringArray));
                    continue;
                }
                if (string3.contains("sound")) {
                    int n13 = 0;
                    if (this.yaml.contains(String.valueOf(string4) + "target")) {
                        if (this.yaml.getString(String.valueOf(string4) + "target").equals("all")) {
                            n13 = -1;
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("random")) {
                            n13 = this.yaml.getInt(this.yaml.getString(String.valueOf(string4) + "targetAmount"));
                        } else if (this.yaml.getString(String.valueOf(string4) + "target").equals("startPos")) {
                            n13 = -2;
                        }
                    }
                    Sound sound = Sound.AMBIENT_CAVE;
                    if (this.yaml.contains(String.valueOf(string4) + "type")) {
                        sound = this.getSound(this.yaml.getString(String.valueOf(string4) + "type").toUpperCase());
                    }
                    double[] dArray = new double[]{1.0, 1.0, 1.0, 20.0};
                    if (this.yaml.contains(String.valueOf(string4) + "volume")) {
                        dArray[0] = this.yaml.getDouble(String.valueOf(string4) + "volume");
                    }
                    if (this.yaml.contains(String.valueOf(string4) + "pitch")) {
                        dArray[1] = this.yaml.getDouble(String.valueOf(string4) + "pitch");
                    }
                    if (this.yaml.contains(String.valueOf(string4) + "repeat")) {
                        dArray[2] = this.yaml.getInt(String.valueOf(string4) + "repeat");
                    }
                    if (this.yaml.contains(String.valueOf(string4) + "intervalTicks")) {
                        dArray[3] = this.yaml.getInt(String.valueOf(string4) + "intervalTicks");
                    }
                    String[] stringArray = new String[]{"0", "0", "0"};
                    if (this.yaml.contains(String.valueOf(string4) + "location")) {
                        stringArray[0] = this.yaml.getString(String.valueOf(string4) + "location.x");
                        stringArray[1] = this.yaml.getString(String.valueOf(string4) + "location.y");
                        stringArray[2] = this.yaml.getString(String.valueOf(string4) + "location.z");
                    }
                    arrayDeque.add(new CustomEvent("n", n13, sound, dArray, stringArray));
                    continue;
                }
                Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&eWARNING in '" + this.nameID + "' file! &f'" + string3 + "' &eis not reconized as an action at &fLevel " + this.level + " in " + (String)object + "&e! Ignoring this entry.."));
            }
            if (((String)object).length() < 7) {
                Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&eWARNING in '" + this.nameID + "' file! &f'" + (String)object + " &eis not a valid event format! Ignoring this section.. Format should be as follows" + "\n    events:\n        event 1:\n            <actions>\n        event 2:\n            <actions>..."));
                continue;
            }
            linkedHashMap.put(Integer.parseInt(((String)object).substring(6)), arrayDeque);
        }
        if (this.yaml.contains(String.valueOf(string2) + ".operation") && this.yaml.getString(String.valueOf(string2) + ".operation").equals("random")) {
            Object object;
            object = new ArrayList(linkedHashMap.keySet());
            Collections.shuffle(object);
            object.forEach(n -> {
                Queue<CustomEvent> queue = this.list.put((Integer)n, (Queue)linkedHashMap.get(n));
            });
        } else {
            this.list.putAll(linkedHashMap);
        }
    }

    public ItemStack getItemByName(String string) {
        if (this.itemMap.containsKey(string)) {
            return this.itemMap.get(string);
        }
        if (ItemsHandler.allItems.containsKey(string)) {
            return ItemsHandler.allItems.get(string);
        }
        return new ItemStack(Material.valueOf((String)string.toUpperCase()));
    }

    public Sound getSound(String string) {
        return Sound.valueOf((String)string);
    }

    public YamlConfiguration getYaml() {
        return this.yaml;
    }

    public void setYaml(YamlConfiguration yamlConfiguration) {
        this.yaml = yamlConfiguration;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public Location getStartPos() {
        return this.startPos;
    }

    public void setStartPos(Location location) {
        this.startPos = location;
    }

    public String getNameID() {
        return this.nameID;
    }

    public void setNameID(String string) {
        this.nameID = string;
    }

    private static /* synthetic */ void lambda$2(List list, String string) {
        boolean bl = list.add(Material.valueOf((String)string.toUpperCase()));
    }

    private static /* synthetic */ void lambda$5(List list, String string) {
        boolean bl = list.add(Material.valueOf((String)string.toUpperCase()));
    }

    private static /* synthetic */ void lambda$7(List list, String string) {
        boolean bl = list.add(Material.valueOf((String)string.toUpperCase()));
    }
}

