/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.entities.endstormentities.BabyEndTotem;
import deadlydisasters.entities.endstormentities.EndTotem;
import deadlydisasters.entities.endstormentities.EndWorm;
import deadlydisasters.entities.endstormentities.VoidArcher;
import deadlydisasters.entities.endstormentities.VoidGuardian;
import deadlydisasters.entities.endstormentities.VoidStalker;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class EndStorm
extends WeatherDisaster {
    private int range;
    private int maxEntities;
    private Random rand = new Random();
    private EntityHandler handler;
    public Queue<CustomEntity> entities = new ArrayDeque<CustomEntity>();
    public Set<UUID> mobs = new HashSet<UUID>();
    private Map<UUID, UUID> targets = new HashMap<UUID, UUID>();

    public EndStorm(int n) {
        super(n);
        this.handler = this.plugin.handler;
        if (n > 5) {
            n = 5;
        }
        this.time = this.configFile.getInt("endstorm.time.level " + this.level) * 20;
        this.delay = this.configFile.getInt("endstorm.start_delay") * 20;
        this.range = this.configFile.getInt("endstorm.max_tp_range");
        this.maxEntities = this.configFile.getInt("endstorm.max_rift_entities");
        this.volume = this.configFile.getDouble("endstorm.volume");
        this.type = Disaster.ENDSTORM;
    }

    @Override
    public void start(final World world, Player player, boolean bl) {
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            Utils.broadcastEvent(this.level, "weather", this.type, world);
        }
        final EndStorm endStorm = this;
        DeathMessages.endstorms.add(this);
        this.addPlayersToWeatherSurvivalChannel(world, this.survivingPlayers);
        new RepeatingTask(this.plugin, this.delay, 20){

            @Override
            public void run() {
                if (EndStorm.this.time <= 0) {
                    this.cancel();
                    EndStorm.this.clearEntities();
                    DeathMessages.endstorms.remove(endStorm);
                    EndStorm.this.awardPlayersInSet(EndStorm.this.survivingPlayers, 1, "master.series.void_master", 0);
                    EndStorm.this.removePlayersFromWeatherSurvivalChannel(EndStorm.this.survivingPlayers);
                    return;
                }
                EndStorm endStorm2 = EndStorm.this;
                endStorm2.time = endStorm2.time - 20;
                for (LivingEntity livingEntity : world.getLivingEntities()) {
                    int n;
                    int n2;
                    if (EndStorm.this.mobs.contains(livingEntity.getUniqueId()) && ((Mob)livingEntity).getTarget() == null && Bukkit.getEntity((UUID)EndStorm.this.targets.get(livingEntity.getUniqueId())) != null) {
                        ((Mob)livingEntity).setTarget((LivingEntity)Bukkit.getEntity((UUID)EndStorm.this.targets.get(livingEntity.getUniqueId())));
                    }
                    if (livingEntity instanceof Enderman || livingEntity instanceof Endermite || livingEntity instanceof EnderDragon || livingEntity instanceof ArmorStand || livingEntity instanceof Player && (((Player)livingEntity).getGameMode() == GameMode.CREATIVE || ((Player)livingEntity).getGameMode() == GameMode.SPECTATOR) || Utils.isZoneProtected(livingEntity.getLocation())) continue;
                    if (EndStorm.this.rand.nextInt(20) == 1 && !livingEntity.hasMetadata("dd-endstormentity") && !(livingEntity instanceof ArmorStand)) {
                        n2 = 0;
                        while (n2 < 3) {
                            n = (int)(livingEntity.getLocation().getX() + (double)(EndStorm.this.rand.nextInt(EndStorm.this.range * 2) - EndStorm.this.range));
                            int n3 = (int)(livingEntity.getLocation().getZ() + (double)(EndStorm.this.rand.nextInt(EndStorm.this.range * 2) - EndStorm.this.range));
                            Location location = livingEntity.getLocation().clone();
                            location.setX((double)n);
                            location.setY((double)(world.getHighestBlockYAt(n, n3) + 1));
                            location.setZ((double)n3);
                            if (!(livingEntity.getLocation().distance(location) > (double)EndStorm.this.range)) {
                                livingEntity.teleport(location);
                                world.playSound(livingEntity.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, SoundCategory.HOSTILE, 1.0f, 1.0f);
                                if (!(livingEntity instanceof Player)) break;
                                ((Player)livingEntity).spawnParticle(Particle.DRAGON_BREATH, livingEntity.getLocation().add(0.0, 1.5, 0.0), 30, 3.0, 1.0, 3.0, 3.0);
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!(livingEntity instanceof Player) || EndStorm.this.rand.nextInt(20) != 0) continue;
                    n2 = (int)(livingEntity.getLocation().getX() + (double)(EndStorm.this.rand.nextInt(14) - 7));
                    n = (int)(livingEntity.getLocation().getZ() + (double)(EndStorm.this.rand.nextInt(14) - 7));
                    if (!(livingEntity.getLocation().distance(world.getHighestBlockAt(n2, n).getLocation()) <= 10.0)) continue;
                    EndStorm.this.createRift(world.getHighestBlockAt(n2, n).getLocation().add(0.0, 3.0, 0.0), (Player)livingEntity);
                }
            }
        };
        new RepeatingTask(this.plugin, this.delay, 200){

            @Override
            public void run() {
                if (EndStorm.this.time <= 0) {
                    this.cancel();
                    return;
                }
                for (Player player : world.getPlayers()) {
                    if (Utils.isZoneProtected(player.getLocation()) || player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR || !(EndStorm.this.plugin.mcVersion >= 1.16)) continue;
                    player.stopSound(Sound.AMBIENT_SOUL_SAND_VALLEY_LOOP);
                    player.playSound(player.getLocation(), Sound.AMBIENT_SOUL_SAND_VALLEY_LOOP, SoundCategory.AMBIENT, (float)(2.0 * EndStorm.this.volume), 2.0f);
                }
            }
        };
        new RepeatingTask(this.plugin, this.delay, 1){

            @Override
            public void run() {
                if (EndStorm.this.time <= 0) {
                    EndStorm.this.clear();
                    this.cancel();
                    return;
                }
                for (Player player : world.getPlayers()) {
                    if (Utils.isZoneProtected(player.getLocation()) || player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) continue;
                    player.spawnParticle(Particle.DRAGON_BREATH, player.getLocation().add(0.0, 1.5, 0.0), 25, 3.0, 1.0, 3.0, 3.0);
                    player.spawnParticle(Particle.SMOKE_LARGE, player.getLocation().add(0.0, 1.5, 0.0), 10, 3.0, 1.0, 3.0, 1.5);
                }
            }
        };
    }

    public void createRift(final Location location, final Player player) {
        final int[] nArray = new int[]{40, this.rand.nextInt(4) + 1};
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            CustomEntity customEntity = (CustomEntity)iterator.next();
            if (customEntity.getEntity() != null && !customEntity.getEntity().isDead()) continue;
            customEntity.clean();
            iterator.remove();
        }
        final boolean bl = (Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("custom_mob_spawning");
        final ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), new ItemStack(Material.LEATHER_HELMET)};
        if (!bl) {
            int n = 0;
            while (n < 3) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStackArray[n].getItemMeta();
                leatherArmorMeta.setColor(Color.fromBGR((int)50, (int)50, (int)50));
                itemStackArray[n].setItemMeta((ItemMeta)leatherArmorMeta);
                ++n;
            }
        }
        new RepeatingTask(this.plugin, 0, 5){

            @Override
            public void run() {
                EndStorm.this.world.spawnParticle(Particle.PORTAL, location, 20, 0.2, 0.2, 0.2, 1.5);
                EndStorm.this.world.spawnParticle(Particle.SQUID_INK, location.clone().add(0.0, 0.5, 0.0), 30, 0.25, 0.25, 0.25, 1.0E-4);
                EndStorm.this.world.playSound(location, Sound.BLOCK_PORTAL_AMBIENT, SoundCategory.AMBIENT, 0.7f, 1.0f);
                for (Entity entity : EndStorm.this.world.getNearbyEntities(location, 0.5, 0.5, 0.5)) {
                    if (!(entity instanceof Player) || ((Player)entity).getGameMode() != GameMode.SURVIVAL && ((Player)entity).getGameMode() != GameMode.ADVENTURE) continue;
                    Utils.pureDamageEntity((LivingEntity)entity, 1.0, "dd-unstablerift", true, null);
                }
                if (nArray[0] > 0) {
                    nArray[0] = nArray[0] - 5;
                } else {
                    Entity entity;
                    if (EndStorm.this.entities.size() >= EndStorm.this.maxEntities) {
                        this.cancel();
                        return;
                    }
                    nArray[0] = 40;
                    entity = null;
                    Object object = null;
                    if (!bl) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        entity.getEquipment().setItemInMainHand(new ItemStack(Material.IRON_SWORD));
                        entity.getEquipment().setItemInOffHand(new ItemStack(Material.SHIELD));
                        entity.getEquipment().setArmorContents(itemStackArray);
                        EndStorm.this.targets.put(entity.getUniqueId(), player.getUniqueId());
                        EndStorm.this.mobs.add(entity.getUniqueId());
                        nArray[1] = nArray[1] - 1;
                        if (nArray[1] <= 0) {
                            this.cancel();
                        }
                        return;
                    }
                    int n = EndStorm.this.rand.nextInt(100);
                    if (n < 15 && CustomEntityType.ENDTOTEM.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.WITHER_SKELETON);
                        entity.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
                        object = new EndTotem((Mob)entity, EndStorm.this.plugin, EndStorm.this.rand);
                    } else if (n < 35 && CustomEntityType.ENDWORM.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        object = new EndWorm((Mob)entity, EndStorm.this.plugin, EndStorm.this.rand);
                    } else if (n < 45 && CustomEntityType.VOIDARCHER.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.SKELETON);
                        object = new VoidArcher((Mob)entity, EndStorm.this.plugin, EndStorm.this.rand);
                    } else if (n < 70 && CustomEntityType.VOIDSTALKER.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.PHANTOM);
                        object = new VoidStalker((Mob)entity, EndStorm.this.plugin, EndStorm.this.rand);
                    } else if (CustomEntityType.VOIDGUARDIAN.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        object = new VoidGuardian((Mob)entity, EndStorm.this.plugin, EndStorm.this.rand);
                    }
                    nArray[1] = nArray[1] - 1;
                    if (nArray[1] <= 0) {
                        this.cancel();
                    }
                    if (entity == null) {
                        return;
                    }
                    entity.setMetadata("dd-endstormentity", (MetadataValue)new FixedMetadataValue((Plugin)EndStorm.this.plugin, (Object)"protected"));
                    EndStorm.this.entities.add((CustomEntity)object);
                    EndStorm.this.handler.addEntity(object);
                    EndStorm.this.targets.put(entity.getUniqueId(), player.getUniqueId());
                    EndStorm.this.mobs.add(entity.getUniqueId());
                }
            }
        };
    }

    public static void createUnstableRift(final Location location, int n, final ProjectileSource projectileSource) {
        final double[] dArray = new double[]{n, 1.0};
        final World world = location.getWorld();
        final Main main = Main.getInstance();
        final Random random = new Random();
        final boolean bl = WorldObject.findWorldObject((World)location.getWorld()).configFile.getBoolean("customitems.items.void_wrath.remove_items");
        new RepeatingTask(main, 0, 5){

            @Override
            public void run() {
                Location location2;
                Entity entity2;
                dArray[0] = dArray[0] - 5.0;
                if (dArray[0] <= 0.0) {
                    this.cancel();
                    return;
                }
                dArray[1] = dArray[1] + 0.1;
                world.spawnParticle(Particle.PORTAL, location.clone().add(0.0, 1.3, 0.0), 20, 0.2, 0.2, 0.2, 1.5);
                world.spawnParticle(Particle.SQUID_INK, location.add(0.0, 0.2, 0.0).clone().add(0.0, 0.3, 0.0), 30, 0.25, 0.25, 0.25, 1.0E-4);
                world.playSound(location, Sound.BLOCK_PORTAL_AMBIENT, SoundCategory.AMBIENT, 0.7f, 1.0f);
                for (Entity entity2 : world.getNearbyEntities(location, 4.0, 4.0, 4.0)) {
                    if (entity2 instanceof Player && (((Player)entity2).getGameMode() == GameMode.CREATIVE || ((Player)entity2).getGameMode() == GameMode.SPECTATOR)) continue;
                    location2 = entity2.getLocation();
                    entity2.setVelocity(new Vector(location2.getX() - location.getX(), location2.getY() - location.getY(), location2.getZ() - location.getZ()).normalize().multiply(-1).multiply(0.3));
                    if (entity2 instanceof LivingEntity && !entity2.isDead() && location2.distance(location) < 1.0 && !(entity2 instanceof ItemFrame)) {
                        Utils.pureDamageEntity((LivingEntity)entity2, 1.0, "dd-unstablerift", true, null);
                        if (!entity2.isDead() || !(projectileSource instanceof Player) || Utils.isPlayerImmune((Player)projectileSource) || !((LivingEntity)entity2).getPersistentDataContainer().has(CustomEntityType.VOIDARCHER.nameKey, PersistentDataType.BYTE)) continue;
                        main.achievementsHandler.awardProgress(((Player)projectileSource).getUniqueId(), "master.series.void_master", 1, 3);
                        continue;
                    }
                    if (entity2 instanceof LivingEntity || !(location2.distanceSquared(location) < 4.0) || entity2 instanceof Item && !bl) continue;
                    entity2.remove();
                }
                entity2 = world.getBlockAt(location.getBlockX() + (random.nextInt(8) - 4), (int)((double)location.getBlockY() - dArray[1]), location.getBlockZ() + (random.nextInt(8) - 4));
                if (entity2.getType().isBlock() && !Utils.passStrengthTest(entity2.getType()) && !Utils.isZoneProtected(entity2.getLocation())) {
                    FallingBlock fallingBlock = world.spawnFallingBlock(entity2.getLocation(), entity2.getBlockData());
                    fallingBlock.setHurtEntities(true);
                    fallingBlock.setDropItem(false);
                    fallingBlock.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
                    if (main.CProtect) {
                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", entity2.getLocation(), entity2.getType(), entity2.getBlockData());
                    }
                    entity2.setType(Material.AIR);
                    location2 = entity2.getLocation();
                    fallingBlock.setVelocity(new Vector(location2.getX() - location.getX(), location2.getY() - location.getY(), location2.getZ() - location.getZ()).normalize().multiply(-1).multiply(0.3));
                }
            }
        };
    }

    public void createCustomRift(final Location location) {
        final int[] nArray = new int[]{60, 7};
        this.world = location.getWorld();
        final boolean bl = (Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("custom_mob_spawning");
        final ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), new ItemStack(Material.LEATHER_HELMET)};
        if (!bl) {
            int n = 0;
            while (n < 3) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStackArray[n].getItemMeta();
                leatherArmorMeta.setColor(Color.fromBGR((int)50, (int)50, (int)50));
                itemStackArray[n].setItemMeta((ItemMeta)leatherArmorMeta);
                ++n;
            }
        }
        new RepeatingTask(this.plugin, 0, 5){

            @Override
            public void run() {
                EndStorm.this.world.spawnParticle(Particle.PORTAL, location, 20, 0.2, 0.2, 0.2, 1.5);
                EndStorm.this.world.spawnParticle(Particle.SQUID_INK, location.clone().add(0.0, 0.5, 0.0), 30, 0.25, 0.25, 0.25, 1.0E-4);
                EndStorm.this.world.playSound(location, Sound.BLOCK_PORTAL_AMBIENT, SoundCategory.AMBIENT, 0.7f, 1.0f);
                for (Entity entity : EndStorm.this.world.getNearbyEntities(location, 0.5, 0.5, 0.5)) {
                    if (!(entity instanceof Player) || ((Player)entity).getGameMode() != GameMode.SURVIVAL && ((Player)entity).getGameMode() != GameMode.ADVENTURE) continue;
                    Utils.pureDamageEntity((LivingEntity)entity, 1.0, "dd-unstablerift", true, null);
                }
                if (nArray[0] > 0) {
                    nArray[0] = nArray[0] - 5;
                } else {
                    Entity entity;
                    nArray[0] = 60;
                    entity = null;
                    Object object = null;
                    if (!bl) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        entity.getEquipment().setItemInMainHand(new ItemStack(Material.IRON_SWORD));
                        entity.getEquipment().setItemInOffHand(new ItemStack(Material.SHIELD));
                        entity.getEquipment().setArmorContents(itemStackArray);
                        nArray[1] = nArray[1] - 1;
                        if (nArray[1] <= 0) {
                            this.cancel();
                        }
                        return;
                    }
                    if (nArray[1] >= 6 && CustomEntityType.VOIDGUARDIAN.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        object = new VoidGuardian((Mob)entity, EndStorm.this.plugin, EndStorm.this.rand);
                    } else if (nArray[1] >= 4 && CustomEntityType.VOIDSTALKER.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.PHANTOM);
                        object = new VoidStalker((Mob)entity, EndStorm.this.plugin, EndStorm.this.rand);
                    } else if (nArray[1] == 3 && CustomEntityType.ENDWORM.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        object = new EndWorm((Mob)entity, EndStorm.this.plugin, EndStorm.this.rand);
                    } else if (nArray[1] == 2 && CustomEntityType.ENDTOTEM.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.WITHER_SKELETON);
                        entity.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
                        object = new EndTotem((Mob)entity, EndStorm.this.plugin, EndStorm.this.rand);
                    } else if (CustomEntityType.BABYENDTOTEM.canSpawn()) {
                        entity = (Mob)location.getWorld().spawnEntity(location, EntityType.WOLF);
                        object = new BabyEndTotem((Mob)entity, EndStorm.this.plugin.dataFile, EndStorm.this.plugin, EndStorm.this.rand);
                    }
                    nArray[1] = nArray[1] - 1;
                    if (nArray[1] <= 0) {
                        this.cancel();
                    }
                    if (entity == null) {
                        return;
                    }
                    EndStorm.this.handler.addEntity(object);
                }
            }
        };
    }

    @Override
    public void clear() {
        this.time = 0;
    }

    public void clearEntities() {
        for (CustomEntity customEntity : this.entities) {
            customEntity.clean();
            if (customEntity.getEntity() == null) continue;
            customEntity.getEntity().remove();
        }
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int n) {
        this.range = n;
    }

    public int getMaxEntities() {
        return this.maxEntities;
    }

    public void setMaxEntities(int n) {
        this.maxEntities = n;
    }
}

