/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.DisasterEvent;
import deadlydisasters.listeners.CoreListener;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class Hurricane
extends DestructionDisaster {
    public World world;
    private int time;
    private int size;
    private int lightning;
    private double lvl;
    private double blockForce;
    private double minForce;
    private double maxForce;
    private Particle particle;
    private int blocksDestroyed;
    public static Set<Biome> oceans = new HashSet<Biome>();

    public Hurricane(int n) {
        super(n);
        this.size = (int)((double)(n * 60) * this.configFile.getDouble("hurricane.size"));
        this.time = this.configFile.getInt("hurricane.time") * 20;
        this.lightning = (int)((double)((7 - n) * 10) * this.configFile.getDouble("hurricane.lightning_frequency"));
        this.volume = (float)(0.33 * (double)n * this.configFile.getDouble("hurricane.volume"));
        this.blockForce = this.configFile.getDouble("hurricane.block_break_force");
        this.minForce = (double)n / 100.0;
        this.maxForce = (double)n / 50.0;
        this.particle = Particle.CLOUD;
        this.type = Disaster.HURRICANE;
    }

    @Override
    public void start(Location location, Player player) {
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, location, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        this.loc = location;
        this.world = location.getWorld();
        this.lvl = this.level;
        DeathMessages.hurricanes.add(this);
        ongoingDisasters.add(this);
        this.startHurricane();
    }

    public void startHurricane() {
        final Random random = this.plugin.random;
        final Vector vector = new Vector(random.nextDouble() - 0.5, 0.0, random.nextDouble() - 0.5).normalize().setY(0.18333333333333335 * this.lvl);
        final Vector vector2 = vector.clone().multiply(0.03333333333333333 * this.lvl).setY(0);
        final double[] dArray = new double[]{0.0, this.lvl * 1.0E-4, this.minForce, this.maxForce, 0.0};
        final int[] nArray = new int[1];
        final int n = this.size / 20;
        final double d = 33.0 * this.lvl;
        final boolean bl = this.plugin.CProtect;
        final ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        final HashMap hashMap = new HashMap();
        final FixedMetadataValue fixedMetadataValue = new FixedMetadataValue((Plugin)this.plugin, (Object)"protected");
        final RepeatingTask repeatingTask = new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                if (Hurricane.this.time <= 0) {
                    return;
                }
                Hurricane.this.loc.add(vector2.clone().multiply(dArray[4]));
                Hurricane.this.world.spawnParticle(Hurricane.this.particle, Hurricane.this.loc, (int)(Hurricane.this.lvl * 10.0 * dArray[4]), 1.0, 1.0, 1.0, 0.1);
                dArray[0] = dArray[0] + dArray[1];
                if (dArray[1] > 0.0 && dArray[0] > dArray[3] || dArray[1] < 0.0 && dArray[0] < dArray[2]) {
                    dArray[1] = dArray[1] * -1.0;
                }
                Vector vector5 = vector.clone().multiply(dArray[0] * dArray[4]);
                Vector vector22 = vector5.clone().setY(vector5.getY() / 2.0).multiply(10);
                Vector vector3 = vector5.clone().multiply(-1).setY(0);
                for (Map.Entry entry : concurrentHashMap.entrySet()) {
                    Entity entity = (Entity)entry.getKey();
                    double d4 = (double)Hurricane.this.size - (Double)entry.getValue();
                    if (entity instanceof LivingEntity) {
                        if (entity instanceof Player) {
                            Location location = entity.getLocation();
                            double d2 = Math.max((Double)entry.getValue() / 2.0, 15.0 * ((6.0 - Hurricane.this.lvl) / 2.0));
                            double d3 = Math.min(dArray[0] * d4 * 10.0, 50.0);
                            Vector vector4 = vector3.clone().multiply(d3 * 10.0);
                            Player player = (Player)entity;
                            int n2 = 0;
                            while ((double)n2 < d4 * Hurricane.this.lvl * dArray[4]) {
                                player.spawnParticle(Hurricane.this.particle, random.nextDouble() * d2 - d2 / 2.0 + location.getX() + vector4.getX(), random.nextDouble() * d2 - d2 / 4.0 + location.getY(), random.nextDouble() * d2 - d2 / 2.0 + location.getZ() + vector4.getZ(), 0, vector5.getX(), 0.001, vector5.getZ(), d3);
                                ++n2;
                            }
                            if (player.isFlying()) continue;
                        }
                        entity.setVelocity(entity.getVelocity().setY(Math.min(entity.getVelocity().getY(), 0.3)).add(vector5.clone().multiply(d4 / d)));
                        continue;
                    }
                    entity.setVelocity(vector22);
                }
                int n3 = nArray[0];
                while (n3 < nArray[0] + n) {
                    for (Entity entity : Hurricane.this.world.getNearbyEntities(Hurricane.this.loc, (double)n3, (double)n3, (double)n3)) {
                        if (hashMap.containsKey(entity) || !(entity.getLocation().getY() > 60.0) || Utils.isZoneProtected(entity.getLocation())) continue;
                        hashMap.put(entity, Hurricane.this.loc.distance(entity.getLocation()));
                    }
                    ++n3;
                }
                nArray[0] = nArray[0] + n;
                if (nArray[0] >= Hurricane.this.size) {
                    nArray[0] = 0;
                    concurrentHashMap.clear();
                    concurrentHashMap.putAll(hashMap);
                    hashMap.clear();
                }
                if (dArray[4] < 1.0) {
                    dArray[4] = dArray[4] + 0.0015;
                }
            }
        };
        final double d2 = 2.0 / (double)this.size;
        final double d3 = this.size / 4 * 3;
        final BukkitTask[] bukkitTaskArray = new BukkitTask[1];
        final BukkitScheduler bukkitScheduler = this.plugin.getServer().getScheduler();
        final Hurricane hurricane = this;
        bukkitTaskArray[0] = bukkitScheduler.runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (Hurricane.this.time <= 0) {
                    DisasterEvent.ongoingDisasters.remove(hurricane);
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, Hurricane.this.type.getMetricsLabel(), Hurricane.this.blocksDestroyed);
                    hurricane.triggerRegen(true);
                    bukkitTaskArray[0].cancel();
                    repeatingTask.cancel();
                    DeathMessages.hurricanes.remove(hurricane);
                    bukkitScheduler.runTask((Plugin)Hurricane.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            (this).Hurricane.this.world.setStorm(false);
                            (this).Hurricane.this.world.setThundering(false);
                        }
                    });
                    return;
                }
                if (!Hurricane.this.world.hasStorm()) {
                    bukkitScheduler.runTask((Plugin)Hurricane.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            (this).Hurricane.this.world.setStorm(true);
                            (this).Hurricane.this.world.setThunderDuration((this).Hurricane.this.time);
                        }
                    });
                }
                Hurricane.this.time -= 10;
                for (final Map.Entry entry : concurrentHashMap.entrySet()) {
                    if (!(entry.getKey() instanceof Player)) continue;
                    Player player = (Player)entry.getKey();
                    final Location location = player.getLocation();
                    player.playSound(location.clone().add(new Vector(location.getX() - Hurricane.this.loc.getX(), -2.0, location.getZ() - Hurricane.this.loc.getZ()).normalize().multiply(-3)), Sound.WEATHER_RAIN_ABOVE, (float)(d2 * ((double)Hurricane.this.size - (Double)entry.getValue()) * Hurricane.this.volume * dArray[4]), 0.5f);
                    if (!((double)Hurricane.this.size - (Double)entry.getValue() > d3)) continue;
                    bukkitScheduler.runTask((Plugin)Hurricane.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            EntityChangeBlockEvent entityChangeBlockEvent;
                            if (random.nextInt((this).Hurricane.this.lightning) == 0) {
                                (this).Hurricane.this.world.spawnEntity((this).Hurricane.this.world.getHighestBlockAt(location.clone().add((double)(random.nextInt(6) - 3), 0.0, (double)(random.nextInt(6) - 3))).getLocation().add(0.0, 1.0, 0.0), EntityType.LIGHTNING);
                            }
                            if (dArray[0] < (this).Hurricane.this.blockForce) {
                                return;
                            }
                            if (location.clone().add(0.0, 2.0, 0.0).getBlock().getType().isSolid()) {
                                Block block = location.clone().add(0.0, 2.0, 0.0).getBlock();
                                if (bl) {
                                    Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                }
                                FallingBlock fallingBlock = (this).Hurricane.this.world.spawnFallingBlock(block.getLocation().clone().add(0.5, 0.5, 0.5), block.getBlockData());
                                fallingBlock.setDropItem(false);
                                fallingBlock.setHurtEntities(true);
                                fallingBlock.setMetadata("dd-fb", (MetadataValue)fixedMetadataValue);
                                concurrentHashMap.put(fallingBlock, Hurricane.this.loc.distance(fallingBlock.getLocation()));
                                if (block.getState() instanceof InventoryHolder) {
                                    CoreListener.addBlockInventory((Entity)fallingBlock, ((InventoryHolder)block.getState()).getInventory().getContents());
                                }
                                Hurricane.this.addBlockWithTopToList(block, block.getState());
                                block.setType(Material.AIR);
                                entityChangeBlockEvent = new EntityChangeBlockEvent((Entity)fallingBlock, block, Material.AIR.createBlockData());
                                Bukkit.getPluginManager().callEvent((Event)entityChangeBlockEvent);
                                ++(this).Hurricane.this.blocksDestroyed;
                            }
                            location.add(vector2.clone().multiply(-6)).add(0.0, 2.0, 0.0);
                            int n = 12 - (this).Hurricane.this.level;
                            int n2 = 0;
                            while ((double)n2 < ((double)(this).Hurricane.this.size - (Double)entry.getValue()) / 10.0 / (double)(7 - (this).Hurricane.this.level)) {
                                entityChangeBlockEvent = location.clone().add((double)(random.nextInt(n) - n / 2), (double)(random.nextInt(n / 2) - n / 4), (double)(random.nextInt(n) - n / 2)).getBlock();
                                if (entityChangeBlockEvent.getType().isSolid() && !Utils.passStrengthTest(entityChangeBlockEvent.getType()) && !Utils.isZoneProtected(entityChangeBlockEvent.getLocation())) {
                                    if (bl) {
                                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", entityChangeBlockEvent.getLocation(), entityChangeBlockEvent.getType(), entityChangeBlockEvent.getBlockData());
                                    }
                                    FallingBlock fallingBlock = (this).Hurricane.this.world.spawnFallingBlock(entityChangeBlockEvent.getLocation().clone().add(0.5, 0.5, 0.5), entityChangeBlockEvent.getBlockData());
                                    fallingBlock.setDropItem(false);
                                    fallingBlock.setHurtEntities(true);
                                    fallingBlock.setMetadata("dd-fb", (MetadataValue)fixedMetadataValue);
                                    concurrentHashMap.put(fallingBlock, Hurricane.this.loc.distance(fallingBlock.getLocation()));
                                    if (entityChangeBlockEvent.getState() instanceof InventoryHolder) {
                                        CoreListener.addBlockInventory((Entity)fallingBlock, ((InventoryHolder)entityChangeBlockEvent.getState()).getInventory().getContents());
                                    }
                                    Hurricane.this.addBlockWithTopToList((Block)entityChangeBlockEvent, entityChangeBlockEvent.getState());
                                    entityChangeBlockEvent.setType(Material.AIR);
                                    EntityChangeBlockEvent entityChangeBlockEvent2 = new EntityChangeBlockEvent((Entity)fallingBlock, (Block)entityChangeBlockEvent, Material.AIR.createBlockData());
                                    Bukkit.getPluginManager().callEvent((Event)entityChangeBlockEvent2);
                                    ++(this).Hurricane.this.blocksDestroyed;
                                }
                                ++n2;
                            }
                        }
                    });
                }
            }
        }, 0L, 10L);
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if ((location = location.add(0.0, 7.0, 0.0)).getBlockY() < this.type.getMinHeight()) {
            return null;
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(Utils.getBlockBelow(location).getLocation().add(0.0, 7.0, 0.0), player);
    }

    public void clear() {
        this.time = 0;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getLightning() {
        return this.lightning;
    }

    public void setLightning(int n) {
        this.lightning = n;
    }

    public double getBlockForce() {
        return this.blockForce;
    }

    public void setBlockForce(double d) {
        this.blockForce = d;
    }

    public double getMinForce() {
        return this.minForce;
    }

    public void setMinForce(double d) {
        this.minForce = d;
    }

    public double getMaxForce() {
        return this.maxForce;
    }

    public void setMaxForce(double d) {
        this.maxForce = d;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }
}

