/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.entities.infestedcavesentities.InfestedDevourer;
import deadlydisasters.entities.infestedcavesentities.InfestedWorm;
import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.AsyncRepeatingTask;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Warden;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.BlockVector;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class InfestedCaves
extends DestructionDisaster
implements Listener {
    private Random rand;
    private int size;
    private int time;
    private int maxHeight;
    private int threads;
    private int delay;
    private BlockData data;
    public Material material;
    private Set<Chunk> chunks = new HashSet<Chunk>();
    private Map<Block, Object[]> map = new LinkedHashMap<Block, Object[]>();
    private Set<Block> blocks = new HashSet<Block>();
    private Particle.DustOptions dust = new Particle.DustOptions(Color.fromRGB((int)9, (int)74, (int)72), 1.0f);
    private Map<Block, BlockData>[] rows;
    private boolean earlyBroadcast;
    private boolean canShriek;
    private double sizeSquared;
    private double wardenSpawnChance;
    private double spawnPocketChance;
    public LivingEntity warden;
    private Map<UUID, Integer> shriekCooldownMap = new HashMap<UUID, Integer>();
    private Queue<InfestedDevourer> devourers = new ArrayDeque<InfestedDevourer>();
    private Queue<InfestedWorm> worms = new ArrayDeque<InfestedWorm>();
    private Map<String, EntityType> speciesMap = new HashMap<String, EntityType>();
    public Map<UUID, UUID> targetMap = new HashMap<UUID, UUID>();

    public InfestedCaves(int n) {
        super(n);
        this.rand = this.plugin.random;
        this.volume = this.configFile.getDouble("infestedcaves.volume");
        switch (n) {
            case 1: {
                this.size = (int)(this.configFile.getDouble("infestedcaves.size") * 20.0);
                this.wardenSpawnChance = 10.0;
                break;
            }
            case 2: {
                this.size = (int)(this.configFile.getDouble("infestedcaves.size") * 30.0);
                this.wardenSpawnChance = 20.0;
                break;
            }
            case 3: {
                this.size = (int)(this.configFile.getDouble("infestedcaves.size") * 40.0);
                this.wardenSpawnChance = 30.0;
                break;
            }
            case 4: {
                this.size = (int)(this.configFile.getDouble("infestedcaves.size") * 50.0);
                this.wardenSpawnChance = 40.0;
                break;
            }
            case 5: {
                this.size = (int)(this.configFile.getDouble("infestedcaves.size") * 60.0);
                this.wardenSpawnChance = 50.0;
                break;
            }
            case 6: {
                this.size = (int)(this.configFile.getDouble("infestedcaves.size") * 80.0);
                this.wardenSpawnChance = 100.0;
            }
        }
        this.maxHeight = this.configFile.getInt("infestedcaves.max_height");
        this.threads = this.configFile.getInt("infestedcaves.threads_for_operation");
        this.delay = this.configFile.getInt("infestedcaves.start_delay") * 20;
        this.spawnPocketChance = 40.0 * this.configFile.getDouble("infestedcaves.mob_spawn_multiplier");
        this.rows = new Map[this.size + 1];
        this.material = this.plugin.mcVersion >= 1.19 ? Material.SCULK : Material.NETHERRACK;
        this.data = this.material.createBlockData();
        this.time = this.configFile.getInt("infestedcaves.time.level " + n);
        this.speciesMap.put("infestedskeleton", EntityType.WITHER_SKELETON);
        this.speciesMap.put("infestedzombie", EntityType.ZOMBIE);
        this.speciesMap.put("infestedcreeper", EntityType.CREEPER);
        this.speciesMap.put("infestedenderman", EntityType.ENDERMAN);
        this.speciesMap.put("infestedspirit", EntityType.VEX);
        this.speciesMap.put("infestedtribesman", EntityType.ZOMBIE);
        this.speciesMap.put("infesteddevourer", EntityType.ZOMBIE);
        this.speciesMap.put("infestedhowler", EntityType.ZOMBIE);
        this.speciesMap.put("shadowleech", EntityType.ZOMBIE);
        this.type = Disaster.INFESTEDCAVES;
    }

    @Override
    public void start(final Location location, Player player) {
        Object object;
        int n;
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, location, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        if (this.earlyBroadcast) {
            this.delay = 0;
        }
        final World world = location.getWorld();
        this.loc = location;
        this.sizeSquared = this.size * this.size;
        ongoingDisasters.add(this);
        DeathMessages.infestedcaves.add(this);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        final BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
        BukkitScheduler bukkitScheduler = this.plugin.getServer().getScheduler();
        final InfestedCaves infestedCaves = this;
        int n2 = -this.size - 16;
        while (n2 <= this.size + 16) {
            int n3 = -this.size - 16;
            while (n3 <= this.size + 16) {
                n = -this.size - 16;
                while (n <= this.size + 16) {
                    object = blockVector.clone().add(new Vector(n2, n3, n));
                    Block block = world.getBlockAt(object.toLocation(world));
                    if (!(blockVector.distance(object) > (double)this.size) && !this.chunks.contains(block.getChunk())) {
                        this.chunks.add(block.getChunk());
                    }
                    n += 16;
                }
                n3 += 16;
            }
            n2 += 16;
        }
        for (Chunk chunk : this.chunks) {
            if (chunk.isLoaded()) continue;
            chunk.load(true);
        }
        int n4 = 0;
        while (n4 < this.rows.length) {
            this.rows[n4] = new ConcurrentHashMap<Block, BlockData>();
            ++n4;
        }
        final int[] nArray = new int[1];
        int n5 = 0;
        while (n5 < this.threads) {
            n = this.size * 2 / this.threads * n5 - this.size;
            bukkitScheduler.runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    HashSet<Block> hashSet = new HashSet<Block>();
                    int n6 = n + InfestedCaves.this.size * 2 / InfestedCaves.this.threads;
                    int n2 = n;
                    while (n2 < n6) {
                        if (blockVector.getBlockY() + n2 > InfestedCaves.this.maxHeight) break;
                        int n3 = -InfestedCaves.this.size;
                        while (n3 < InfestedCaves.this.size) {
                            int n4 = -InfestedCaves.this.size;
                            while (n4 < InfestedCaves.this.size) {
                                Block block;
                                Vector vector = blockVector.clone().add(new Vector(n3, n2, n4));
                                int n5 = (int)blockVector.distance(vector);
                                if (!(n5 > InfestedCaves.this.size || n5 > InfestedCaves.this.size - 8 && InfestedCaves.this.rand.nextInt((int)((double)(InfestedCaves.this.size - n5) * 1.5 + 1.0)) == 0 || hashSet.contains(block = world.getBlockAt(vector.toLocation(world))) || block.getType() == Material.AIR || block.isLiquid() || Utils.isZoneProtected(block.getLocation()) || Utils.isBlockImmune(block.getType()))) {
                                    hashSet.add(block);
                                    if (block.isPassable()) {
                                        InfestedCaves.this.rows[n5].put(block, Material.AIR.createBlockData());
                                    } else {
                                        InfestedCaves.this.rows[n5].put(block, InfestedCaves.this.data);
                                    }
                                }
                                ++n4;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    nArray[0] = nArray[0] + 1;
                }
            });
            ++n5;
        }
        final int[] nArray2 = new int[1];
        new RepeatingTask(this.plugin, 0, 2){

            @Override
            public void run() {
                for (Chunk chunk : InfestedCaves.this.chunks) {
                    if (chunk.isLoaded()) continue;
                    chunk.load(true);
                }
                if (nArray[0] >= InfestedCaves.this.threads) {
                    this.cancel();
                    if (!InfestedCaves.this.earlyBroadcast && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
                        Utils.broadcastEvent(InfestedCaves.this.level, "destructive", InfestedCaves.this.type, location, InfestedCaves.this.p);
                    }
                    if (InfestedCaves.this.rand.nextDouble() * 100.0 < InfestedCaves.this.wardenSpawnChance) {
                        InfestedCaves.this.spawnWarden(location);
                    } else if (InfestedCaves.this.plugin.mcVersion >= 1.19) {
                        InfestedCaves.this.plugin.getServer().getScheduler().runTaskLater((Plugin)InfestedCaves.this.plugin, () -> {
                            boolean bl = InfestedCaves.this.canShriek = true;
                        }, 100L);
                    }
                    new RepeatingTask(InfestedCaves.this.plugin, InfestedCaves.this.delay, 2){

                        @Override
                        public void run() {
                            if (nArray2[0] >= (this).InfestedCaves.this.size) {
                                this.cancel();
                                return;
                            }
                            for (Map.Entry<Block, BlockData> entry : (this).InfestedCaves.this.rows[nArray2[0]].entrySet()) {
                                Block block = entry.getKey();
                                (this).InfestedCaves.this.map.putIfAbsent(block, new Object[]{block.getBlockData(), block.getState()});
                                block.setBlockData(entry.getValue());
                                if (block.getType() == Material.AIR) continue;
                                (this).InfestedCaves.this.blocks.add(block);
                            }
                            nArray2[0] = nArray2[0] + 1;
                        }
                    };
                }
            }
        };
        int[] nArray3 = new int[1];
        object = new HashSet();
        new RepeatingTask(this.plugin, 0, 20, (Set)object, nArray2, nArray3, world, location, bukkitScheduler){
            private final /* synthetic */ Set val$playedSound;
            private final /* synthetic */ int[] val$tick;
            private final /* synthetic */ int[] val$spawning;
            private final /* synthetic */ World val$world;
            private final /* synthetic */ Location val$loc;
            private final /* synthetic */ BukkitScheduler val$scheduler;
            {
                this.val$playedSound = set;
                this.val$tick = nArray;
                this.val$spawning = nArray2;
                this.val$world = world;
                this.val$loc = location;
                this.val$scheduler = bukkitScheduler;
                super(javaPlugin, n, n2);
            }

            @Override
            public void run() {
                Player player;
                if (InfestedCaves.this.time <= 0) {
                    this.cancel();
                    if (InfestedCaves.this.map.isEmpty()) {
                        ongoingDisasters.remove(infestedCaves);
                        DeathMessages.infestedcaves.remove(infestedCaves);
                        HandlerList.unregisterAll((Listener)infestedCaves);
                        InfestedCaves.this.clearEntities();
                        return;
                    }
                    this.val$playedSound.clear();
                    final Map<Block, Object[]> map = Utils.reverseMap(InfestedCaves.this.map);
                    final int n = map.size() / (InfestedCaves.this.size * 2);
                    new RepeatingTask(InfestedCaves.this.plugin, 0, 1){

                        @Override
                        public void run() {
                            int n2 = 0;
                            Iterator iterator = map.entrySet().iterator();
                            Block block = null;
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                block = (Block)entry.getKey();
                                (this).InfestedCaves.this.blocks.remove(block);
                                block.setBlockData((BlockData)((Object[])entry.getValue())[0]);
                                if (((Object[])entry.getValue())[1] != null) {
                                    ((BlockState)((Object[])entry.getValue())[1]).update();
                                }
                                iterator.remove();
                                if (++n2 >= n) break;
                            }
                            if ((this).InfestedCaves.this.plugin.mcVersion >= 1.19 && block != null) {
                                double d = block.getLocation().distance(val$loc) + 10.0;
                                for (Entity entity2 : val$world.getNearbyEntities(new BoundingBox((double)val$loc.getBlockX() - d, (double)val$loc.getBlockY() - d, (double)val$loc.getBlockZ() - d, (double)val$loc.getBlockX() + d, (double)val$loc.getBlockY() + d, (double)val$loc.getBlockZ() + d), entity -> entity instanceof Player)) {
                                    if (!(entity2.getLocation().distance(val$loc) > d - 25.0) || val$playedSound.contains(entity2.getUniqueId())) continue;
                                    ((Player)entity2).playSound(entity2.getLocation(), Sound.ENTITY_WARDEN_DIG, 2.0f, 0.5f);
                                    val$playedSound.add(entity2.getUniqueId());
                                }
                            }
                            if (map.isEmpty()) {
                                ongoingDisasters.remove(infestedCaves);
                                DeathMessages.infestedcaves.remove(infestedCaves);
                                HandlerList.unregisterAll((Listener)infestedCaves);
                                InfestedCaves.this.clearEntities();
                                this.cancel();
                            }
                        }
                    };
                    return;
                }
                if (this.val$tick[0] >= InfestedCaves.this.size) {
                    --InfestedCaves.this.time;
                }
                if (this.val$tick[0] == 0) {
                    return;
                }
                this.val$spawning[0] = this.val$spawning[0] + 1;
                for (Entity object2 : this.val$world.getNearbyEntities(new BoundingBox((double)(this.val$loc.getBlockX() - this.val$tick[0] - 10), (double)(this.val$loc.getBlockY() - this.val$tick[0] - 10), (double)(this.val$loc.getBlockZ() - this.val$tick[0] - 10), (double)(this.val$loc.getBlockX() + this.val$tick[0] + 10), (double)(this.val$loc.getBlockY() + this.val$tick[0] + 10), (double)(this.val$loc.getBlockZ() + this.val$tick[0] + 10)), entity -> entity instanceof Player)) {
                    player = (Player)object2;
                    if (Utils.isPlayerImmune(player)) continue;
                    if (player.getLocation().distance(this.val$loc) <= (double)this.val$tick[0]) {
                        if (this.val$spawning[0] % 8 == 0 && InfestedCaves.this.rand.nextDouble() * 100.0 < InfestedCaves.this.spawnPocketChance) {
                            InfestedCaves.this.spawnPocket((LivingEntity)player, 1.8 + InfestedCaves.this.rand.nextDouble());
                        }
                        if (this.val$spawning[0] % 5 == 0 && InfestedCaves.this.rand.nextInt(2) == 0) {
                            InfestedCaves.this.spawnWorm((LivingEntity)player);
                            if (InfestedCaves.this.plugin.mcVersion >= 1.19) {
                                switch (InfestedCaves.this.rand.nextInt(4)) {
                                    case 0: {
                                        player.playSound(player.getLocation().add((double)(InfestedCaves.this.rand.nextInt(6) - 3), (double)(InfestedCaves.this.rand.nextInt(7) - 2), (double)(InfestedCaves.this.rand.nextInt(6) - 3)), Sound.ENTITY_WARDEN_NEARBY_CLOSER, 2.0f, InfestedCaves.this.rand.nextFloat() + 0.5f);
                                        break;
                                    }
                                    case 1: {
                                        player.playSound(player.getLocation().add((double)(InfestedCaves.this.rand.nextInt(6) - 3), (double)(InfestedCaves.this.rand.nextInt(7) - 2), (double)(InfestedCaves.this.rand.nextInt(6) - 3)), Sound.ENTITY_WARDEN_NEARBY_CLOSEST, 2.0f, InfestedCaves.this.rand.nextFloat() + 0.5f);
                                        break;
                                    }
                                    case 2: {
                                        player.playSound(player.getLocation().add((double)(InfestedCaves.this.rand.nextInt(6) - 3), (double)(InfestedCaves.this.rand.nextInt(7) - 2), (double)(InfestedCaves.this.rand.nextInt(6) - 3)), Sound.ENTITY_WARDEN_AGITATED, 2.0f, 0.5f);
                                        break;
                                    }
                                    case 3: {
                                        player.playSound(player.getLocation().add((double)(InfestedCaves.this.rand.nextInt(6) - 3), (double)(InfestedCaves.this.rand.nextInt(7) - 2), (double)(InfestedCaves.this.rand.nextInt(6) - 3)), Sound.ENTITY_WARDEN_AMBIENT, 2.0f, 0.5f);
                                    }
                                }
                            }
                        }
                        if (this.val$spawning[0] % 8 == 0) {
                            InfestedCaves.this.closeRoute((LivingEntity)player, 8);
                        }
                        if (InfestedCaves.this.plugin.mcVersion >= 1.19 && InfestedCaves.this.rand.nextInt(3) == 0) {
                            InfestedCaves.this.spawnVibration(player.getEyeLocation(), 1, 9, 5, 10);
                        }
                    }
                    if (this.val$tick[0] >= InfestedCaves.this.size || !(InfestedCaves.this.plugin.mcVersion >= 1.19)) continue;
                    if (!this.val$playedSound.contains(player.getUniqueId())) {
                        player.playSound(player.getLocation(), Sound.ENTITY_WARDEN_EMERGE, 2.0f, 0.5f);
                        this.val$playedSound.add(player.getUniqueId());
                    }
                    player.playSound(player.getLocation(), Sound.BLOCK_SCULK_SPREAD, 2.0f, InfestedCaves.this.rand.nextFloat() / 2.0f + 0.5f);
                    this.val$scheduler.runTaskLater((Plugin)InfestedCaves.this.plugin, () -> player.playSound(player.getLocation(), Sound.BLOCK_SCULK_SPREAD, 2.0f, InfestedCaves.this.rand.nextFloat() / 2.0f + 0.5f), 10L);
                }
                for (Map.Entry entry : InfestedCaves.this.targetMap.entrySet()) {
                    player = (Mob)Bukkit.getEntity((UUID)((UUID)entry.getKey()));
                    if (player == null || player.isDead()) {
                        return;
                    }
                    if (player.getTarget() == null && Bukkit.getEntity((UUID)((UUID)entry.getValue())) == null) {
                        player.setTarget((LivingEntity)Bukkit.getEntity((UUID)((UUID)entry.getValue())));
                    }
                    if (player.getLocation().distanceSquared(this.val$loc) > InfestedCaves.this.sizeSquared) {
                        player.setVelocity(Utils.getVectorTowards(player.getLocation(), this.val$loc).multiply(3));
                        player.damage(2.0);
                    }
                    if (InfestedCaves.this.warden == null) continue;
                    ((Warden)InfestedCaves.this.warden).setAnger((Entity)player, 0);
                }
                for (InfestedDevourer infestedDevourer : InfestedCaves.this.devourers) {
                    if (infestedDevourer.getEntity() == null || infestedDevourer.getEntity().isDead()) {
                        return;
                    }
                    player = (Mob)infestedDevourer.getEntity();
                    if (player.getLocation().distanceSquared(this.val$loc) > InfestedCaves.this.sizeSquared) {
                        player.setVelocity(Utils.getVectorTowards(player.getLocation(), this.val$loc).multiply(3));
                        player.damage(2.0);
                    }
                    if (InfestedCaves.this.warden == null) continue;
                    ((Warden)InfestedCaves.this.warden).setAnger((Entity)player, 0);
                }
                Iterator<Map.Entry<UUID, Integer>> iterator = InfestedCaves.this.shriekCooldownMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<UUID, Integer> entry = iterator.next();
                    entry.setValue((Integer)entry.getValue() - 1);
                    if ((Integer)entry.getValue() > 0) continue;
                    iterator.remove();
                }
            }
        };
    }

    public void shriekEvent(final LivingEntity livingEntity, boolean bl) {
        if (bl && this.canShriek) {
            if (this.warden == null && this.rand.nextInt(3) == 0 || this.warden != null && !this.loc.getWorld().getNearbyEntities(new BoundingBox((double)(this.loc.getBlockX() - this.size - 15), (double)(this.loc.getBlockY() - this.size - 15), (double)(this.loc.getBlockZ() - this.size - 15), (double)(this.loc.getBlockX() + this.size + 15), (double)(this.loc.getBlockY() + this.size + 15), (double)(this.loc.getBlockZ() + this.size + 15)), entity -> entity instanceof Player).stream().anyMatch(entity -> ((Warden)this.warden).getAnger(entity) >= 80)) {
                if (this.warden != null) {
                    for (Object object2 : this.warden.getNearbyEntities(25.0, 25.0, 25.0)) {
                        ((Warden)this.warden).setAnger(object2, 0);
                    }
                    Utils.mergeEntityData((Entity)this.warden, "{Brain:{memories:{\"minecraft:dig_cooldown\":{ttl:0L,value:{}},\"minecraft:sniff_cooldown\":{ttl:200L,value:{}},\"minecraft:vibration_cooldown\":{ttl:200L,value:{}}}}}");
                    this.canShriek = false;
                }
                new RepeatingTask(this.plugin, 100, 10){

                    @Override
                    public void run() {
                        if (InfestedCaves.this.time <= 0 || !livingEntity.getWorld().equals(InfestedCaves.this.loc.getWorld()) || livingEntity.getLocation().distanceSquared(InfestedCaves.this.loc) > InfestedCaves.this.sizeSquared) {
                            this.cancel();
                            return;
                        }
                        if (InfestedCaves.this.warden == null || InfestedCaves.this.warden.isDead()) {
                            InfestedCaves.this.spawnWarden(Utils.getSpotInSquareRadius(livingEntity.getLocation(), 5));
                            ((Warden)InfestedCaves.this.warden).setAnger((Entity)livingEntity, 60);
                            this.cancel();
                        }
                    }
                };
            }
        } else if (this.warden != null) {
            ((Warden)this.warden).increaseAnger((Entity)livingEntity, 50);
        }
        if (livingEntity instanceof Player && !this.shriekCooldownMap.containsKey(livingEntity.getUniqueId())) {
            this.spawnPocket(livingEntity, this.size);
            this.shriekCooldownMap.put(livingEntity.getUniqueId(), 8);
            if (this.plugin.mcVersion >= 1.19) {
                Object object2;
                livingEntity.getWorld().playSound(Utils.getSpotInSquareRadius(livingEntity.getLocation(), 8), Sound.ENTITY_WARDEN_ROAR, 2.0f, 0.5f);
                livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, 60, 0, true, false));
                for (Object object2 : livingEntity.getNearbyEntities(15.0, 15.0, 15.0)) {
                    if (!(object2 instanceof Player) || Utils.isPlayerImmune((Player)object2)) continue;
                    ((Player)object2).addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, 60, 0, true, false));
                }
                object2 = new int[1];
                new AsyncRepeatingTask(this.plugin, 10, 5, (int[])object2){
                    private final /* synthetic */ int[] val$amount;
                    {
                        this.val$amount = nArray;
                        super(javaPlugin, n, n2);
                    }

                    @Override
                    public void run() {
                        if (livingEntity != null) {
                            InfestedCaves.this.spawnVibration(livingEntity.getEyeLocation(), 25, 12, 10, 200);
                        }
                        this.val$amount[0] = this.val$amount[0] + 1;
                        if (this.val$amount[0] >= 8) {
                            this.cancel();
                        }
                    }
                };
            }
        }
    }

    public void spawnVibration(Location location, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            block9: {
                Location location2 = location.clone();
                Vector vector = new Vector(this.rand.nextDouble() * 2.0 - 1.0, this.rand.nextDouble() * 2.0 - 1.0, this.rand.nextDouble() * 2.0 - 1.0).normalize();
                int n7 = 0;
                while (n7 < this.rand.nextInt(n2) + 1) {
                    location2.add(vector);
                    if (!location2.getBlock().isPassable()) {
                        if (n7 >= 3) {
                            location2.add(vector.clone().multiply(-1));
                            break;
                        }
                        break block9;
                    }
                    ++n7;
                }
                if (location2.getWorld().equals(this.loc.getWorld()) && location2.getBlockY() <= this.maxHeight && !(location2.distanceSquared(this.loc) > this.sizeSquared)) {
                    Location location3 = null;
                    Vector vector2 = new Vector(this.rand.nextDouble() * 2.0 - 1.0, this.rand.nextDouble() * 2.0 - 1.0, this.rand.nextDouble() * 2.0 - 1.0).normalize();
                    int n8 = 1;
                    while (n8 < n3) {
                        Block block = location2.clone().add(vector2.clone().multiply(n8)).getBlock();
                        if (!block.isPassable() && this.blocks.contains(block)) {
                            location3 = location2.clone().add(vector2.clone().multiply(n8));
                            break;
                        }
                        ++n8;
                    }
                    if (location3 == null) break;
                    Location location4 = null;
                    int n9 = 1;
                    while (n9 < n3) {
                        Block block = location2.clone().add(vector2.clone().multiply(-n9)).getBlock();
                        if (!block.isPassable() && this.blocks.contains(block)) {
                            location4 = location2.clone().add(vector2.clone().multiply(-n9));
                            break;
                        }
                        ++n9;
                    }
                    if (location4 == null || location3.distanceSquared(location4) <= 3.0) break;
                    location2.getWorld().spawnParticle(Particle.VIBRATION, location3, 1, 0.0, 0.0, 0.0, 1.0, (Object)new Vibration(location3, (Vibration.Destination)new Vibration.Destination.BlockDestination(location4), this.rand.nextInt(10) + 10));
                    location2.getWorld().playSound(location3, Sound.BLOCK_SCULK_SENSOR_CLICKING, SoundCategory.BLOCKS, 0.5f, this.rand.nextFloat() / 2.0f + 0.5f);
                    if (++n5 >= n) break;
                }
            }
            ++n6;
        }
    }

    public void spawnPocket(final LivingEntity livingEntity, final double d) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Location location = livingEntity.getEyeLocation();
                final World world = livingEntity.getWorld();
                int n = 0;
                while (n < 20) {
                    Vector vector = new Vector(InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0, 0.0, InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0).normalize().setY(InfestedCaves.this.rand.nextDouble());
                    Location location2 = location.clone().add(vector);
                    int n2 = 0;
                    block14: while (n2 < 15) {
                        if (!location2.getBlock().isPassable()) {
                            Object object;
                            double d7;
                            if (location2.getBlock().getType() != InfestedCaves.this.material) break;
                            Location location3 = location2.clone();
                            int n3 = 0;
                            while ((double)n3 < d * 2.0) {
                                location2.add(vector);
                                if (location2.getBlock().getType() != InfestedCaves.this.material) break block14;
                                ++n3;
                            }
                            location2.add(vector.clone().multiply(-d));
                            Block block = location2.getBlock();
                            if (block.getType() != InfestedCaves.this.material || block.getRelative(BlockFace.DOWN).getType() != InfestedCaves.this.material || block.getRelative(BlockFace.UP).getType() != InfestedCaves.this.material || block.getRelative(BlockFace.NORTH).getType() != InfestedCaves.this.material || block.getRelative(BlockFace.EAST).getType() != InfestedCaves.this.material || block.getRelative(BlockFace.SOUTH).getType() != InfestedCaves.this.material || block.getRelative(BlockFace.WEST).getType() != InfestedCaves.this.material) break;
                            final Location location4 = location2.clone();
                            BlockVector blockVector = new BlockVector(location2.getX(), location2.getY(), location2.getZ());
                            final ArrayDeque<Block> arrayDeque = new ArrayDeque<Block>();
                            double d2 = -d;
                            while (d2 < d) {
                                double d3 = -d;
                                while (d3 < d) {
                                    d7 = -d;
                                    while (d7 < d) {
                                        Block block2;
                                        object = blockVector.clone().add(new Vector(d2, d3, d7));
                                        if (!(blockVector.distance((Vector)object) > d) && (block2 = world.getBlockAt(object.toLocation(world))).getType() == InfestedCaves.this.material && block2.getRelative(BlockFace.DOWN).getType() == InfestedCaves.this.material && block2.getRelative(BlockFace.UP).getType() == InfestedCaves.this.material && block2.getRelative(BlockFace.NORTH).getType() == InfestedCaves.this.material && block2.getRelative(BlockFace.EAST).getType() == InfestedCaves.this.material && block2.getRelative(BlockFace.SOUTH).getType() == InfestedCaves.this.material && block2.getRelative(BlockFace.WEST).getType() == InfestedCaves.this.material) {
                                            arrayDeque.add(block2);
                                        }
                                        d7 += 0.5;
                                    }
                                    d3 += 0.5;
                                }
                                d2 += 0.5;
                            }
                            Location location5 = location2.clone().add(new Vector(InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0, InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0, InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0).normalize().multiply(d));
                            int n4 = 0;
                            while (n4 < 15) {
                                Block block3 = location2.clone().add(new Vector(InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0, InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0, InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0).normalize().multiply(d)).getBlock();
                                if (arrayDeque.contains(block3)) {
                                    location5 = block3.getLocation().add(0.5, 0.5, 0.5);
                                    break;
                                }
                                ++n4;
                            }
                            final Location location6 = location5.clone();
                            blockVector = new BlockVector(location5.getX(), location5.getY(), location5.getZ());
                            double d4 = InfestedCaves.this.rand.nextDouble() * (d / 2.0) + d / 2.0;
                            d7 = -d4;
                            while (d7 < d4) {
                                double d5 = -d4;
                                while (d5 < d4) {
                                    double d6 = -d4;
                                    while (d6 < d4) {
                                        Block block4;
                                        Vector vector2 = blockVector.clone().add(new Vector(d7, d5, d6));
                                        if (!(blockVector.distance(vector2) > d4) && !arrayDeque.contains(block4 = world.getBlockAt(vector2.toLocation(world))) && block4.getType() == InfestedCaves.this.material && block4.getRelative(BlockFace.DOWN).getType() == InfestedCaves.this.material && block4.getRelative(BlockFace.UP).getType() == InfestedCaves.this.material && block4.getRelative(BlockFace.NORTH).getType() == InfestedCaves.this.material && block4.getRelative(BlockFace.EAST).getType() == InfestedCaves.this.material && block4.getRelative(BlockFace.SOUTH).getType() == InfestedCaves.this.material && block4.getRelative(BlockFace.WEST).getType() == InfestedCaves.this.material) {
                                            arrayDeque.add(block4);
                                        }
                                        d6 += 0.5;
                                    }
                                    d5 += 0.5;
                                }
                                d7 += 0.5;
                            }
                            final boolean bl = (Boolean)WorldObject.findWorldObject((World)world).settings.get("custom_mob_spawning");
                            final int n5 = (int)(d * 2.0);
                            object = new ArrayList();
                            if (bl) {
                                int n6 = 0;
                                while (n6 < n5) {
                                    if (InfestedCaves.this.rand.nextInt(2) == 0) {
                                        switch (InfestedCaves.this.rand.nextInt(5)) {
                                            case 0: {
                                                object.add("infestedskeleton");
                                                break;
                                            }
                                            case 1: {
                                                object.add("infestedzombie");
                                                break;
                                            }
                                            case 2: {
                                                object.add("infestedcreeper");
                                                break;
                                            }
                                            case 3: {
                                                object.add("infestedenderman");
                                                break;
                                            }
                                            case 4: {
                                                object.add("infestedspirit");
                                            }
                                        }
                                        ++n6;
                                        continue;
                                    }
                                    switch (InfestedCaves.this.rand.nextInt(4)) {
                                        case 0: {
                                            int n7 = 0;
                                            while (n7 < 4) {
                                                object.add("infestedtribesman");
                                                ++n7;
                                            }
                                            n6 += 2;
                                            break;
                                        }
                                        case 1: {
                                            int n8 = 0;
                                            while (n8 < 2) {
                                                object.add("infesteddevourer");
                                                ++n8;
                                            }
                                            ++n6;
                                            break;
                                        }
                                        case 2: {
                                            object.add("infestedhowler");
                                            ++n6;
                                            break;
                                        }
                                        case 3: {
                                            object.add("shadowleech");
                                            ++n6;
                                        }
                                    }
                                }
                            }
                            InfestedCaves.this.plugin.getServer().getScheduler().runTask((Plugin)InfestedCaves.this.plugin, new Runnable((List)object, location3, d){
                                private final /* synthetic */ List val$entities;
                                private final /* synthetic */ Location val$opening;
                                private final /* synthetic */ double val$pocketSize;
                                {
                                    this.val$entities = list;
                                    this.val$opening = location3;
                                    this.val$pocketSize = d;
                                }

                                @Override
                                public void run() {
                                    Object object;
                                    for (Block block : arrayDeque) {
                                        if (!(this).InfestedCaves.this.blocks.contains(block)) continue;
                                        block.setType(Material.AIR);
                                    }
                                    if (!bl) {
                                        int n = 0;
                                        while (n < n5 / 3 * 2) {
                                            ((Mob)world.spawnEntity(location4, EntityType.ZOMBIE)).setTarget(livingEntity);
                                            ++n;
                                        }
                                        n = 0;
                                        while (n < n5 / 3) {
                                            ((Mob)world.spawnEntity(location6, EntityType.ZOMBIE)).setTarget(livingEntity);
                                            ++n;
                                        }
                                    } else {
                                        Entity entity;
                                        int n = this.val$entities.size() - 1;
                                        while (n >= this.val$entities.size() / 3) {
                                            object = (String)this.val$entities.get(n);
                                            entity = world.spawnEntity(location4, (this).InfestedCaves.this.speciesMap.get(object));
                                            (this).InfestedCaves.this.plugin.handler.addEntityBySpecies((String)object, entity);
                                            if (((String)object).equals("infesteddevourer")) {
                                                (this).InfestedCaves.this.devourers.add((InfestedDevourer)(this).InfestedCaves.this.plugin.handler.findEntity((LivingEntity)entity));
                                            } else {
                                                (this).InfestedCaves.this.targetMap.put(entity.getUniqueId(), livingEntity.getUniqueId());
                                            }
                                            ((Mob)entity).setTarget(livingEntity);
                                            this.val$entities.remove(n);
                                            --n;
                                        }
                                        for (String string : this.val$entities) {
                                            entity = world.spawnEntity(location6, (this).InfestedCaves.this.speciesMap.get(string));
                                            (this).InfestedCaves.this.plugin.handler.addEntityBySpecies(string, entity);
                                            if (string.equals("infesteddevourer")) {
                                                (this).InfestedCaves.this.devourers.add((InfestedDevourer)(this).InfestedCaves.this.plugin.handler.findEntity((LivingEntity)entity));
                                            } else {
                                                (this).InfestedCaves.this.targetMap.put(entity.getUniqueId(), livingEntity.getUniqueId());
                                            }
                                            ((Mob)entity).setTarget(livingEntity);
                                        }
                                    }
                                    BlockVector blockVector = new BlockVector(this.val$opening.getX(), this.val$opening.getY(), this.val$opening.getZ());
                                    object = new double[]{0.0};
                                    double d = Math.max(this.val$pocketSize, 2.0);
                                    new RepeatingTask((this).InfestedCaves.this.plugin, 0, 15, (double[])object, d, blockVector, world, this.val$opening){
                                        private final /* synthetic */ double[] val$tick;
                                        private final /* synthetic */ double val$maxDoorSize;
                                        private final /* synthetic */ BlockVector val$door;
                                        private final /* synthetic */ World val$world;
                                        private final /* synthetic */ Location val$opening;
                                        {
                                            this.val$tick = dArray;
                                            this.val$maxDoorSize = d;
                                            this.val$door = blockVector;
                                            this.val$world = world;
                                            this.val$opening = location;
                                            super(javaPlugin, n, n2);
                                        }

                                        @Override
                                        public void run() {
                                            if (this.val$tick[0] >= this.val$maxDoorSize) {
                                                this.cancel();
                                                return;
                                            }
                                            double d = -this.val$tick[0];
                                            while (d < this.val$tick[0]) {
                                                double d2 = -this.val$tick[0];
                                                while (d2 < this.val$tick[0]) {
                                                    double d3 = -this.val$tick[0];
                                                    while (d3 < this.val$tick[0]) {
                                                        Block block;
                                                        Vector vector = this.val$door.clone().add(new Vector(d, d2, d3));
                                                        double d4 = this.val$door.distance(vector);
                                                        if (!(d4 < this.val$tick[0] - 1.0) && !(d4 > this.val$tick[0]) && ((this).this).InfestedCaves.this.blocks.contains(block = this.val$world.getBlockAt(vector.toLocation(this.val$world)))) {
                                                            block.setType(Material.AIR);
                                                        }
                                                        d3 += 0.5;
                                                    }
                                                    d2 += 0.5;
                                                }
                                                d += 0.5;
                                            }
                                            if (((this).this).InfestedCaves.this.plugin.mcVersion >= 1.19) {
                                                this.val$opening.getWorld().playSound(this.val$opening, Sound.BLOCK_SCULK_SPREAD, 1.0f, ((this).this).InfestedCaves.this.rand.nextFloat() / 2.0f + 0.5f);
                                            }
                                            this.val$tick[0] = this.val$tick[0] + 0.5;
                                        }
                                    };
                                }
                            });
                            return;
                        }
                        location2.add(vector);
                        ++n2;
                    }
                    ++n;
                }
            }
        });
    }

    private void spawnWarden(Location location) {
        if (this.plugin.mcVersion < 1.19) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            boolean bl = this.canShriek = true;
        }, 300L);
        int n = 1;
        while (n < 30) {
            Location location2 = Utils.findSmartYSpawn(location, location.clone().add((double)(this.rand.nextInt(n) - n / 2 + 1), 0.0, (double)(this.rand.nextInt(n) - n / 2 + 1)), 3, this.size / 2);
            if (!(location2 == null || location2.getBlock().getRelative(BlockFace.DOWN).isPassable() || location2.getBlock().getRelative(BlockFace.DOWN, 2).isPassable() || location2.getBlock().getRelative(BlockFace.DOWN, 3).isPassable())) {
                this.warden = (LivingEntity)location.getWorld().spawnEntity(location2, EntityType.WARDEN);
                this.warden.setInvisible(true);
                Utils.mergeEntityData((Entity)this.warden, "{Brain:{memories:{\"minecraft:dig_cooldown\":{ttl:" + this.time * 20 + "L,value:{}},\"minecraft:is_emerging\":{ttl:134L,value:{}}}}}");
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.warden.setInvisible(false), 10L);
                break;
            }
            ++n;
        }
    }

    public void spawnWorm(final LivingEntity livingEntity) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Location location = livingEntity.getLocation().add(0.0, 2.0, 0.0);
                ArrayList<BlockFace> arrayList = new ArrayList<BlockFace>(Arrays.asList(BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST));
                int n = 0;
                while (n < 30) {
                    Location location2 = location.clone();
                    Vector vector = new Vector(InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0, InfestedCaves.this.rand.nextDouble() * 1.6 - 0.8, InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0).normalize();
                    int n2 = 0;
                    while (n2 < 15) {
                        location2.add(vector);
                        Block block = location2.getBlock();
                        if (!block.isPassable()) {
                            BlockFace blockFace2;
                            if (n2 < 7 || !InfestedCaves.this.blocks.contains(block)) break;
                            int n3 = 0;
                            for (BlockFace blockFace2 : arrayList) {
                                if (block.getRelative(blockFace2).isPassable()) continue;
                                ++n3;
                            }
                            if (n3 < 3 || n3 > 5) break;
                            blockFace2 = null;
                            int n4 = 0;
                            while (n4 < arrayList.size()) {
                                block8: {
                                    BlockFace blockFace3 = (BlockFace)arrayList.get(InfestedCaves.this.rand.nextInt(arrayList.size()));
                                    if (block.getRelative(blockFace3).isPassable()) {
                                        int n5 = 1;
                                        while (n5 < 4) {
                                            if (block.getRelative(blockFace3, n5).isPassable()) {
                                                ++n5;
                                                continue;
                                            }
                                            break block8;
                                        }
                                        blockFace2 = blockFace3;
                                        break;
                                    }
                                }
                                ++n4;
                            }
                            if (blockFace2 == null) break;
                            BlockFace blockFace4 = blockFace2;
                            InfestedCaves.this.plugin.getServer().getScheduler().runTask((Plugin)InfestedCaves.this.plugin, () -> {
                                InfestedWorm infestedWorm = new InfestedWorm(block, blockFace4, InfestedCaves.this.plugin, InfestedCaves.this.rand);
                                InfestedCaves.this.plugin.handler.addFalseEntity(infestedWorm);
                                InfestedCaves.this.worms.add(infestedWorm);
                            });
                            return;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        });
    }

    public void closeRoute(LivingEntity livingEntity, int n) {
        Vector vector = null;
        for (Map.Entry<UUID, UUID> entry : this.targetMap.entrySet()) {
            Entity entity = Bukkit.getEntity((UUID)entry.getKey());
            if (entity == null || !((Mob)entity).hasLineOfSight((Entity)livingEntity)) continue;
            vector = Utils.getVectorTowards(Bukkit.getEntity((UUID)entry.getKey()).getLocation(), livingEntity.getLocation());
            break;
        }
        if (vector == null) {
            vector = new Vector(this.rand.nextDouble() * 2.0 - 1.0, this.rand.nextDouble() * 1.6 - 0.8, this.rand.nextDouble() * 2.0 - 1.0).normalize();
        }
        this.closeRoute(livingEntity, n, vector);
    }

    public void closeRoute(LivingEntity livingEntity, final int n, final Vector vector) {
        final Location location = livingEntity.getEyeLocation();
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                int n7 = 0;
                while (n7 < 30) {
                    block20: {
                        Location location2 = location.clone();
                        Vector vector4 = vector.clone().add(new Vector(InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0, InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0, InfestedCaves.this.rand.nextDouble() * 2.0 - 1.0)).normalize();
                        int n2 = 0;
                        while (n2 < 10) {
                            location2.add(vector4);
                            if (location2.getBlock().isPassable()) {
                                ++n2;
                                continue;
                            }
                            break block20;
                        }
                        if (location2.getWorld().equals(InfestedCaves.this.loc.getWorld()) && location2.getBlockY() <= InfestedCaves.this.maxHeight && !(location2.distanceSquared(InfestedCaves.this.loc) > InfestedCaves.this.sizeSquared)) {
                            Block block;
                            final Set[] setArray = new Set[n];
                            int n3 = 0;
                            while (n3 < setArray.length) {
                                setArray[n3] = new HashSet();
                                ++n3;
                            }
                            Vector vector2 = new Vector(vector4.getZ(), 0.0, -vector4.getX());
                            Vector vector3 = location2.getY() > location.getY() ? new Vector(-vector4.getX(), 1.0, -vector4.getY()) : new Vector(vector4.getX(), 1.0, vector4.getY());
                            int[] nArray = new int[4];
                            int n4 = 1;
                            while (n4 < n) {
                                block = location2.clone().add(vector2.clone().multiply(n4)).getBlock();
                                if (!block.isPassable() && InfestedCaves.this.blocks.contains(block)) {
                                    nArray[0] = n4;
                                    break;
                                }
                                ++n4;
                            }
                            if (nArray[0] != 0) {
                                n4 = 1;
                                while (n4 < n) {
                                    block = location2.clone().add(vector2.clone().multiply(-n4)).getBlock();
                                    if (!block.isPassable() && InfestedCaves.this.blocks.contains(block)) {
                                        nArray[1] = n4;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (nArray[1] != 0) {
                                    location2.add(vector2.clone().multiply(-nArray[1])).add(vector2.clone().multiply((nArray[0] + nArray[1]) / 2));
                                    n4 = 1;
                                    while (n4 < n) {
                                        block = location2.clone().add(vector3.clone().multiply(n4)).getBlock();
                                        if (!block.isPassable() && InfestedCaves.this.blocks.contains(block)) {
                                            nArray[2] = n4;
                                            break;
                                        }
                                        ++n4;
                                    }
                                    if (nArray[2] != 0) {
                                        n4 = 1;
                                        while (n4 < n) {
                                            block = location2.clone().add(vector3.clone().multiply(-n4)).getBlock();
                                            if (!block.isPassable() && InfestedCaves.this.blocks.contains(block)) {
                                                nArray[3] = n4;
                                                break;
                                            }
                                            ++n4;
                                        }
                                        if (nArray[3] != 0) {
                                            location2.add(vector3.clone().multiply(-nArray[3])).add(vector3.clone().multiply((nArray[2] + nArray[3]) / 2));
                                            n4 = -n;
                                            while (n4 <= n) {
                                                int n5 = -n;
                                                while (n5 <= n) {
                                                    int n6;
                                                    Block block2 = location2.clone().add(vector2.clone().multiply(n4)).add(vector3.clone().multiply(n5)).getBlock();
                                                    if (!(InfestedCaves.this.blocks.contains(block2) || Utils.isBlockImmune(block2.getType()) || Utils.isZoneProtected(block2.getLocation()) || setArray[n6 = (int)Math.min((double)(n - 1), block2.getLocation().distance(location2))].contains(block2))) {
                                                        setArray[n6].add(block2);
                                                    }
                                                    ++n5;
                                                }
                                                ++n4;
                                            }
                                            final int[] nArray2 = new int[]{n - 1};
                                            block = location2.clone();
                                            new RepeatingTask(InfestedCaves.this.plugin, 0, 10, (Location)block){
                                                private final /* synthetic */ Location val$centerLoc;
                                                {
                                                    this.val$centerLoc = location;
                                                    super(javaPlugin, n, n2);
                                                }

                                                @Override
                                                public void run() {
                                                    if ((this).InfestedCaves.this.time <= 0 || nArray2[0] < 0) {
                                                        this.cancel();
                                                        return;
                                                    }
                                                    for (Block block : setArray[nArray2[0]]) {
                                                        (this).InfestedCaves.this.map.putIfAbsent(block, new Object[]{block.getBlockData(), block.getState()});
                                                        block.setBlockData((this).InfestedCaves.this.data);
                                                        (this).InfestedCaves.this.blocks.add(block);
                                                    }
                                                    if ((this).InfestedCaves.this.plugin.mcVersion >= 1.19) {
                                                        for (Block block : this.val$centerLoc.getWorld().getNearbyEntities(this.val$centerLoc, 15.0, 15.0, 15.0, entity -> entity instanceof Player)) {
                                                            ((Player)block).playSound(block.getLocation(), Sound.BLOCK_SCULK_SPREAD, 2.0f, (this).InfestedCaves.this.rand.nextFloat() / 2.0f + 0.5f);
                                                        }
                                                    }
                                                    nArray2[0] = nArray2[0] - 1;
                                                }
                                            };
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ++n7;
                }
            }
        });
    }

    public void clearEntities() {
        for (UUID object : this.targetMap.keySet()) {
            Entity entity = Bukkit.getEntity((UUID)object);
            if (entity == null) continue;
            entity.remove();
        }
        for (InfestedDevourer infestedDevourer : this.devourers) {
            if (infestedDevourer.getEntity() == null) continue;
            infestedDevourer.getEntity().remove();
        }
        if (this.warden != null && !this.warden.isDead()) {
            for (Entity entity : this.warden.getNearbyEntities(20.0, 20.0, 20.0)) {
                ((Warden)this.warden).setAnger(entity, 0);
            }
            Utils.mergeEntityData((Entity)this.warden, "{Brain:{memories:{\"minecraft:dig_cooldown\":{ttl:0L,value:{}},\"minecraft:sniff_cooldown\":{ttl:200L,value:{}},\"minecraft:vibration_cooldown\":{ttl:200L,value:{}}}}}");
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.warden != null && !this.warden.isDead()) {
                    this.warden.remove();
                }
            }, 160L);
        }
        for (InfestedWorm infestedWorm : this.worms) {
            infestedWorm.clean();
            infestedWorm.shouldRemove = true;
        }
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if (location.getBlockY() + 15 > this.configFile.getInt("corruptedcaves.max_height")) {
            return null;
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(location, player);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        if (this.blocks.contains(blockBreakEvent.getBlock())) {
            blockBreakEvent.setCancelled(true);
            final Block block = blockBreakEvent.getBlock();
            block.breakNaturally(new ItemStack(Material.AIR));
            block.getWorld().spawnParticle(Particle.REDSTONE, block.getLocation().add(0.5, 0.5, 0.5), 30, 0.3, 0.3, 0.3, 0.1, (Object)this.dust);
            if (this.plugin.mcVersion >= 1.19) {
                Location location = block.getLocation().add(0.5, 0.5, 0.5);
                block.getWorld().playSound(location, Sound.ENTITY_WARDEN_TENDRIL_CLICKS, 2.0f, this.rand.nextFloat() / 2.0f + 0.5f);
                Vector vector = Utils.getVectorTowards(location, blockBreakEvent.getPlayer().getEyeLocation());
                int n = 0;
                block0: while (n < 10) {
                    Location location2 = location.clone();
                    Vector vector2 = vector.clone().add(new Vector(this.rand.nextDouble() * 2.0 - 1.0, this.rand.nextDouble() * 2.0 - 1.0, this.rand.nextDouble() * 2.0 - 1.0)).normalize();
                    int n2 = 0;
                    while (n2 < 10) {
                        location2.add(vector2);
                        if (!location2.getBlock().isPassable()) {
                            if (n2 < 2 || !this.blocks.contains(location2.getBlock())) break;
                            block.getWorld().spawnParticle(Particle.VIBRATION, location, 1, 0.0, 0.0, 0.0, 1.0, (Object)new Vibration(location, (Vibration.Destination)new Vibration.Destination.BlockDestination(location2.getBlock().getLocation().add(0.5, 0.5, 0.5)), this.rand.nextInt(10) + 5));
                            break block0;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (Utils.isBlockImmune(block.getType())) {
                        InfestedCaves.this.blocks.remove(block);
                    } else if (InfestedCaves.this.blocks.contains(block)) {
                        block.setBlockData(InfestedCaves.this.data);
                    }
                    if (InfestedCaves.this.plugin.mcVersion >= 1.19) {
                        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_SCULK_SPREAD, 1.0f, InfestedCaves.this.rand.nextFloat() / 2.0f + 0.5f);
                    }
                }
            }, 20L);
            if (this.rand.nextInt(6) == 0 && !Utils.isPlayerImmune(blockBreakEvent.getPlayer())) {
                this.shriekEvent((LivingEntity)blockBreakEvent.getPlayer(), true);
            }
        }
    }

    @EventHandler
    public void onBlockPlace(final BlockPlaceEvent blockPlaceEvent) {
        if (blockPlaceEvent.getPlayer().getWorld().equals(this.loc.getWorld()) && blockPlaceEvent.getBlock().getLocation().distanceSquared(this.loc) <= this.sizeSquared && blockPlaceEvent.getBlock().getLocation().getBlockY() <= this.maxHeight && !Utils.isBlockImmune(blockPlaceEvent.getBlock().getType())) {
            InfestedDevourer.blockTargets.add(blockPlaceEvent.getBlock().getLocation());
            if (this.rand.nextInt(7) == 0) {
                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        final Block block = Utils.rayCastForBlock(blockPlaceEvent.getPlayer().getLocation().add(0.0, 1.0, 0.0), 6, 10, 30, null, InfestedCaves.this.blocks);
                        if (block == null) {
                            return;
                        }
                        final Vector vector = Utils.getVectorTowards(block.getLocation().add(0.5, 0.5, 0.5), blockPlaceEvent.getPlayer().getLocation().add(0.0, 1.5, 0.0));
                        InfestedCaves.this.plugin.getServer().getScheduler().runTask((Plugin)InfestedCaves.this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                if ((this).InfestedCaves.this.time > 0) {
                                    Mob mob = (Mob)block.getLocation().add(0.5, 0.5, 0.5).getWorld().spawnEntity(InfestedCaves.this.loc, EntityType.ZOMBIE);
                                    InfestedDevourer infestedDevourer = new InfestedDevourer((Zombie)mob, (this).InfestedCaves.this.plugin, (this).InfestedCaves.this.rand);
                                    (this).InfestedCaves.this.plugin.handler.addEntity(infestedDevourer);
                                    mob.setVelocity(vector);
                                    (this).InfestedCaves.this.devourers.add(infestedDevourer);
                                    infestedDevourer.updateTarget();
                                }
                            }
                        });
                    }
                });
            }
            for (InfestedDevourer infestedDevourer : this.devourers) {
                infestedDevourer.updateTarget();
            }
        }
    }

    @EventHandler
    public void onBlockExplode(EntityExplodeEvent entityExplodeEvent) {
        Object object2;
        HashMap<Block, Double> hashMap = new HashMap<Block, Double>();
        Location location = entityExplodeEvent.getEntity().getLocation();
        for (Object object2 : entityExplodeEvent.blockList()) {
            if (!this.blocks.contains(object2)) continue;
            hashMap.put((Block)object2, object2.getLocation().distanceSquared(location));
        }
        if (hashMap.isEmpty()) {
            return;
        }
        object2 = new ArrayDeque(Utils.reverseMap(Utils.sortByValue(hashMap)).keySet());
        new RepeatingTask(this.plugin, 20, 1, (Queue)object2){
            private final /* synthetic */ Queue val$blocksToChange;
            {
                this.val$blocksToChange = queue;
                super(javaPlugin, n, n2);
            }

            @Override
            public void run() {
                int n = 0;
                while (n < 3) {
                    Block block = (Block)this.val$blocksToChange.iterator().next();
                    if (InfestedCaves.this.blocks.contains(block) && !Utils.isBlockImmune(block.getType())) {
                        block.setBlockData(InfestedCaves.this.data);
                    }
                    this.val$blocksToChange.remove(block);
                    if (InfestedCaves.this.rand.nextInt(8) == 0 && InfestedCaves.this.plugin.mcVersion >= 1.19) {
                        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_SCULK_SPREAD, 1.0f, InfestedCaves.this.rand.nextFloat() / 2.0f + 0.5f);
                    }
                    if (this.val$blocksToChange.isEmpty()) {
                        this.cancel();
                        return;
                    }
                    ++n;
                }
            }
        };
        for (Entity entity : entityExplodeEvent.getEntity().getNearbyEntities(12.0, 12.0, 12.0)) {
            if (!(entity instanceof Player) || Utils.isPlayerImmune((Player)entity)) continue;
            this.shriekEvent((LivingEntity)entity, true);
            break;
        }
        if (this.plugin.mcVersion >= 1.19) {
            entityExplodeEvent.getEntity().getWorld().playSound(entityExplodeEvent.getEntity().getLocation(), Sound.ENTITY_WARDEN_TENDRIL_CLICKS, 2.0f, 0.5f);
        }
    }

    public boolean isEarlyBroadcast() {
        return this.earlyBroadcast;
    }

    public void setEarlyBroadcast(boolean bl) {
        this.earlyBroadcast = bl;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public double getSizeSquared() {
        return this.sizeSquared;
    }

    public void setSizeSquared(double d) {
        this.sizeSquared = d;
    }
}

