/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.disasters.MeteorShower;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

class Meteor {
    private int type;
    private int size;
    private int depth;
    private int squared;
    private int offset;
    private BlockData bd;
    private FallingBlock[] blocks;
    private Vector vec;
    private Vector off;
    private MeteorShower classInstance;
    private double version;
    private double volume;
    private double speed;
    private boolean CP;
    private Material material;
    private Particle particle;
    public boolean exists = true;

    public Meteor(Location location, Location location2, int n, World world, MeteorShower meteorShower, Random random, int n2) {
        this.type = n;
        this.size = n2;
        this.speed = meteorShower.speeds[0];
        if (n == 1) {
            this.material = meteorShower.normalMaterial;
            if (this.size <= 0) {
                this.size = random.nextInt(meteorShower.meteorSizes[0][1]) + meteorShower.meteorSizes[0][0];
            }
            this.depth = this.size * 500;
        } else if (n == 2) {
            this.material = meteorShower.explodingMaterial;
            if (this.size <= 0) {
                this.size = random.nextInt(meteorShower.meteorSizes[1][1]) + meteorShower.meteorSizes[1][0];
            }
            this.depth = this.size * 100;
            this.speed = meteorShower.speeds[1];
        } else {
            this.material = meteorShower.splittingMaterial;
            if (this.size <= 0) {
                this.size = random.nextInt(meteorShower.meteorSizes[2][1]) + meteorShower.meteorSizes[2][0];
            }
            this.depth = this.size * 10;
            this.speed = meteorShower.speeds[2];
        }
        this.classInstance = meteorShower;
        this.CP = meteorShower.plugin.CProtect;
        this.version = meteorShower.plugin.mcVersion;
        this.volume = meteorShower.volume;
        this.particle = meteorShower.particle;
        this.bd = meteorShower.customized ? this.material.createBlockData() : (n == 1 ? (this.version >= 1.17 ? Bukkit.createBlockData((Material)Material.DEEPSLATE) : Bukkit.createBlockData((Material)Material.DEAD_BRAIN_CORAL_BLOCK)) : (n == 2 ? Bukkit.createBlockData((Material)this.material) : (this.version >= 1.17 && this.material == Material.CALCITE ? Bukkit.createBlockData((Material)Material.CALCITE) : Bukkit.createBlockData((Material)Material.DIORITE))));
        this.vec = new Vector(location.getX() - location2.getX(), location.getY() - location2.getY(), location.getZ() - location2.getZ()).normalize().multiply(-1).multiply(this.speed);
        this.squared = this.size * this.size;
        this.offset = this.squared / Math.max(1, this.size / 2);
        this.off = new Vector(location.getX() - location2.getX(), location.getY() - location2.getY(), location.getZ() - location2.getZ()).normalize().multiply(-1);
        ArrayList<FallingBlock> arrayList = new ArrayList<FallingBlock>();
        FallingBlock fallingBlock = world.spawnFallingBlock(location.clone().add(0.5, 0.0, 0.5), this.bd);
        fallingBlock.setDropItem(false);
        fallingBlock.setGravity(false);
        fallingBlock.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)meteorShower.plugin, (Object)"protected"));
        fallingBlock.setMetadata("dd-md", (MetadataValue)new FixedMetadataValue((Plugin)meteorShower.plugin, (Object)"protected"));
        arrayList.add(fallingBlock);
        meteorShower.fallingUUID.add(fallingBlock.getUniqueId());
        BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
        double d = this.size;
        while (d > (double)(-this.size)) {
            double d2 = this.size;
            while (d2 > (double)(-this.size)) {
                double d3 = this.size;
                while (d3 > (double)(-this.size)) {
                    Vector vector = blockVector.clone().add(new Vector(d, d2, d3));
                    if (!(blockVector.distanceSquared(vector) > (double)this.squared) && !(blockVector.distanceSquared(vector) < (double)(this.squared - this.offset))) {
                        FallingBlock fallingBlock2 = world.spawnFallingBlock(vector.toLocation(world).add(0.5, 0.0, 0.5), this.bd);
                        fallingBlock2.setDropItem(false);
                        fallingBlock2.setGravity(false);
                        fallingBlock2.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)meteorShower.plugin, (Object)"protected"));
                        fallingBlock2.setMetadata("dd-md", (MetadataValue)new FixedMetadataValue((Plugin)meteorShower.plugin, (Object)"protected"));
                        arrayList.add(fallingBlock2);
                        meteorShower.fallingUUID.add(fallingBlock2.getUniqueId());
                    }
                    d3 -= 1.0;
                }
                d2 -= 1.0;
            }
            d -= 1.0;
        }
        this.blocks = arrayList.toArray(new FallingBlock[arrayList.size()]);
    }

    public void tick(Random random) {
        if (this.blocks[0].isDead()) {
            final Meteor meteor = this;
            this.depth = 0;
            Bukkit.getScheduler().runTaskLater((Plugin)this.classInstance.plugin, new Runnable(){

                @Override
                public void run() {
                    Meteor.this.exists = false;
                    if (Meteor.this.classInstance.list.contains(meteor)) {
                        Meteor.this.classInstance.list.remove(meteor);
                    }
                }
            }, 1L);
        }
        this.blocks[0].getWorld().spawnParticle(this.particle, this.blocks[0].getLocation(), this.size * 2, (double)(this.size / 2), (double)(this.size / 2), (double)(this.size / 2), 0.001, null, true);
        int n = 0;
        while (n < this.blocks.length) {
            this.blocks[n].setVelocity(this.vec);
            int n2 = 1;
            while ((double)n2 < this.speed + 2.0) {
                Object object = this.blocks[n].getLocation().clone().add(this.off.clone().multiply(n2)).getBlock();
                if (object.getType() != Material.AIR && !Utils.passStrengthTest(object.getType()) && !Utils.isZoneProtected(object.getLocation())) {
                    if (this.CP) {
                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", object.getLocation(), object.getType(), object.getBlockData());
                    }
                    this.classInstance.addBlockWithTopToList((Block)object, object.getState());
                    object.setType(Material.AIR);
                    ++this.classInstance.blocksDestroyed;
                    --this.depth;
                }
                if ((object = object.getRelative(BlockFace.DOWN)).getType() != Material.AIR && !Utils.passStrengthTest(object.getType()) && !Utils.isZoneProtected(object.getLocation())) {
                    if (this.CP) {
                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", object.getLocation(), object.getType(), object.getBlockData());
                    }
                    this.classInstance.addBlockWithTopToList((Block)object, object.getState());
                    object.setType(Material.AIR);
                    ++this.classInstance.blocksDestroyed;
                    --this.depth;
                }
                ++n2;
            }
            ++n;
        }
        for (Entity entity : this.blocks[0].getWorld().getNearbyEntities(this.blocks[0].getLocation(), (double)this.size, (double)this.size, (double)this.size)) {
            if (!(entity instanceof LivingEntity) || entity.isDead() || entity instanceof Player && Utils.isPlayerImmune((Player)entity) || Utils.rayTraceForSolidBlock(this.blocks[0].getLocation(), entity.getLocation().clone().add(0.0, 0.5, 0.0))) continue;
            Utils.damageEntity((LivingEntity)entity, 20.0, "dd-meteorcrush", false);
        }
        for (Entity entity : this.blocks[0].getWorld().getNearbyEntities(this.blocks[0].getLocation(), (double)(this.size * 5), (double)(this.size * 5), (double)(this.size * 5))) {
            if (!(entity instanceof Player)) continue;
            ((Player)entity).playSound(this.blocks[0].getLocation(), Sound.BLOCK_FIRE_AMBIENT, (float)(1.0 * this.volume), 2.0f);
        }
        if (this.depth <= 0) {
            Location location = this.blocks[0].getLocation().clone();
            if (this.type == 1) {
                int n3 = 0;
                while (n3 < this.blocks.length) {
                    this.blocks[n3].remove();
                    ++n3;
                }
                BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
                boolean bl = this.classInstance.spawnOres;
                boolean bl2 = true;
                if (this.version < 1.17) {
                    bl2 = false;
                }
                double d = this.size;
                while (d > (double)(-this.size)) {
                    double d2 = this.size;
                    while (d2 > (double)(-this.size)) {
                        double d3 = this.size;
                        while (d3 > (double)(-this.size)) {
                            Block block;
                            Vector vector = blockVector.clone().add(new Vector(d, d2, d3));
                            if (!(blockVector.distanceSquared(vector) > (double)this.squared || Utils.passStrengthTest((block = location.getWorld().getBlockAt(vector.toLocation(location.getWorld()))).getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                if (this.CP) {
                                    Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                }
                                if (blockVector.distanceSquared(vector) > (double)(this.squared - this.offset)) {
                                    this.classInstance.addBlockToList(block, block.getState());
                                    block.setType(this.bd.getMaterial());
                                } else if (!bl) {
                                    this.classInstance.addBlockToList(block, block.getState());
                                    block.setType(this.material);
                                } else {
                                    this.classInstance.addBlockToList(block, block.getState());
                                    int n4 = random.nextInt(100);
                                    if (n4 > 14) {
                                        block.setType(this.material);
                                    } else if (n4 > 10) {
                                        if (bl2) {
                                            block.setType(Material.DEEPSLATE_COPPER_ORE);
                                        } else {
                                            block.setType(Material.COAL_ORE);
                                        }
                                    } else if (n4 > 4) {
                                        if (bl2) {
                                            block.setType(Material.DEEPSLATE_IRON_ORE);
                                        } else {
                                            block.setType(Material.IRON_ORE);
                                        }
                                    } else if (n4 > 0) {
                                        if (bl2) {
                                            block.setType(Material.DEEPSLATE_GOLD_ORE);
                                        } else {
                                            block.setType(Material.GOLD_ORE);
                                        }
                                    } else if (bl2) {
                                        block.setType(Material.DEEPSLATE_DIAMOND_ORE);
                                    } else {
                                        block.setType(Material.DIAMOND_ORE);
                                    }
                                    if (this.CP) {
                                        Utils.getCoreProtect().logPlacement("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                    }
                                }
                            }
                            d3 -= 1.0;
                        }
                        d2 -= 1.0;
                    }
                    d -= 1.0;
                }
                this.classInstance.smoke.put(location.clone(), Arrays.asList(this.classInstance.smokeTime, this.size / 2));
            } else if (this.type == 2) {
                int n5 = 0;
                while (n5 < this.blocks.length) {
                    this.blocks[n5].remove();
                    ++n5;
                }
                for (Entity entity : location.getWorld().getNearbyEntities(location, (double)(this.size * 6), (double)(this.size * 6), (double)(this.size * 6))) {
                    if (!(entity instanceof Player)) continue;
                    ((Player)entity).playSound(entity.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, (float)(1.0 * this.volume), 0.5f);
                }
                int n6 = this.size * 3;
                int n7 = n6 * n6;
                int n8 = n7 / (n6 / 2);
                location.getWorld().spawnParticle(Particle.EXPLOSION_HUGE, location, this.size / 2, (double)this.size * 1.5, (double)this.size * 1.5, (double)this.size * 1.5, 0.01);
                BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
                double d = n6;
                while (d > (double)(-n6)) {
                    double d4 = n6;
                    while (d4 > (double)(-n6)) {
                        double d5 = n6;
                        while (d5 > (double)(-n6)) {
                            Block block;
                            Vector vector = blockVector.clone().add(new Vector(d, d4, d5));
                            double d6 = blockVector.distanceSquared(vector);
                            if (!(d6 > (double)n7 || (block = location.getWorld().getBlockAt(vector.toLocation(location.getWorld()))).getType() == Material.AIR || Utils.passStrengthTest(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                if (this.CP) {
                                    Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                }
                                if (d6 > (double)(n7 - n8) && random.nextInt(3) == 1) {
                                    if (random.nextInt(4) == 1) {
                                        this.classInstance.addBlockWithTopToList(block, block.getState());
                                        block.setType(this.material);
                                        ++this.classInstance.blocksDestroyed;
                                        if (this.CP) {
                                            Utils.getCoreProtect().logPlacement("Deadly-Disasters", block.getLocation(), this.material, this.bd);
                                        }
                                    }
                                } else {
                                    this.classInstance.addBlockWithTopToList(block, block.getState());
                                    block.setType(Material.AIR);
                                    ++this.classInstance.blocksDestroyed;
                                }
                            }
                            d5 -= 1.0;
                        }
                        d4 -= 1.0;
                    }
                    d -= 1.0;
                }
                d = this.classInstance.explosionDamage;
                for (Entity entity : location.getWorld().getNearbyEntities(location, (double)n6, (double)n6, (double)n6)) {
                    if (!(entity instanceof LivingEntity) || entity.isDead() || entity instanceof Player && (((Player)entity).getGameMode() == GameMode.CREATIVE || ((Player)entity).getGameMode() == GameMode.SPECTATOR)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (Utils.rayTraceForSolidBlock(location, entity.getLocation().clone().add(0.0, 0.5, 0.0))) continue;
                    Utils.damageEntity(livingEntity, d, "dd-meteorcrush", false);
                }
                this.classInstance.smoke.put(location.clone().subtract(0.0, (double)n6, 0.0), Arrays.asList(this.classInstance.smokeTime, n6 / 2));
            } else {
                location.subtract(0.25, (double)this.size, 0.25);
                double d = this.classInstance.splitImpact;
                int n9 = 0;
                while (n9 < this.blocks.length) {
                    this.blocks[n9].setGravity(true);
                    Location location2 = this.blocks[n9].getLocation();
                    this.blocks[n9].setVelocity(new Vector(location2.getX() - location.getX(), location2.getY() - location.getY(), location2.getZ() - location.getZ()).normalize().multiply(0.75).multiply(d));
                    this.blocks[n9].removeMetadata("dd-md", (Plugin)this.classInstance.plugin);
                    ++n9;
                }
                location.getWorld().spawnParticle(Particle.CLOUD, location, this.size * 6, (double)this.size, (double)this.size, (double)this.size, 0.1);
                for (Entity entity : location.getWorld().getNearbyEntities(location, (double)(this.size * 6), (double)(this.size * 6), (double)(this.size * 6))) {
                    if (!(entity instanceof Player)) continue;
                    ((Player)entity).playSound(entity.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, (float)(1.0 * this.volume), 1.0f);
                }
                new RepeatingTask(this.classInstance.plugin, 0, 5){

                    @Override
                    public void run() {
                        World world = Meteor.this.blocks[0].getWorld();
                        int n = 0;
                        while (n < Meteor.this.blocks.length) {
                            if (!Meteor.this.blocks[n].isDead()) {
                                for (Entity entity : world.getNearbyEntities(Meteor.this.blocks[n].getLocation(), 0.5, 0.5, 0.5)) {
                                    if (!(entity instanceof LivingEntity) || entity.isDead()) continue;
                                    Utils.pureDamageEntity((LivingEntity)entity, 6.0, "dd-meteorcrush", true, null);
                                }
                            }
                            ++n;
                        }
                        ++Meteor.this.depth;
                        if (Meteor.this.depth >= 20) {
                            this.cancel();
                        }
                    }
                };
            }
            this.exists = false;
            this.classInstance.list.remove(this);
        }
    }

    public void removeBlocks() {
        int n = 0;
        while (n < this.blocks.length) {
            this.blocks[n].remove();
            ++n;
        }
    }
}

