/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.monsoonentities.CursedDiver;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class Monsoon
extends WeatherDisaster {
    private int particleRange;
    private int particleYRange;
    private int airDecrease;
    private int blockDamageRange;
    private double puddleRate;
    private double blockChangeRate;
    private double leakRate;
    private double drownedRate;
    private double particleMultiplier;
    private int blocksDestroyed;
    private Queue<Block> puddles = new ArrayDeque<Block>();
    private Set<UUID> drowned = new HashSet<UUID>();
    private Map<UUID, UUID> targets = new HashMap<UUID, UUID>();
    private Map<Material, Material> blockChanges = new HashMap<Material, Material>();
    public static Queue<Block> globalPuddles = new ArrayDeque<Block>();

    public Monsoon(int n) {
        super(n);
        this.time = this.configFile.getInt("monsoon.time.level " + this.level) * 20;
        this.delay = this.configFile.getInt("monsoon.start_delay") * 20;
        this.volume = this.configFile.getDouble("monsoon.volume");
        this.particleRange = this.configFile.getInt("monsoon.particle_max_distance");
        this.particleYRange = this.configFile.getInt("monsoon.particle_Y_range");
        this.particleMultiplier = 1.0 * (double)this.configFile.getInt("monsoon.particle_multiplier");
        this.puddleRate = 0.075 * this.configFile.getDouble("monsoon.puddle_spawn_rate");
        this.airDecrease = (int)(7.0 * this.configFile.getDouble("monsoon.entity_drowning_rate"));
        this.blockDamageRange = this.configFile.getInt("monsoon.block_damage_range");
        this.blockChangeRate = 0.01 * this.configFile.getDouble("monsoon.block_change_rate");
        this.leakRate = 0.1 * this.configFile.getDouble("monsoon.water_leak_particles");
        this.drownedRate = 0.05 * this.configFile.getDouble("monsoon.drowned_spawn_rate");
        for (String string : this.configFile.getConfigurationSection("monsoon.block_changes").getKeys(false)) {
            if (Material.getMaterial((String)string.toUpperCase()) != null) {
                if (Material.getMaterial((String)this.configFile.getString("monsoon.block_changes." + string).toUpperCase()) != null) {
                    this.blockChanges.putIfAbsent(Material.getMaterial((String)string.toUpperCase()), Material.getMaterial((String)this.configFile.getString("monsoon.block_changes." + string).toUpperCase()));
                    continue;
                }
                if (this.configFile.getString("monsoon.block_changes." + string).toLowerCase().equals("air")) {
                    this.blockChanges.putIfAbsent(Material.getMaterial((String)string), Material.AIR);
                    continue;
                }
                Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: Could not find material &c'" + this.configFile.getString("monsoon.block_changes." + string) + "' &eon line &d'" + string + " : " + this.configFile.getString("monsoon.block_changes." + string) + "' &ein monsoon block changes section in the config!"));
                continue;
            }
            Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: Could not find material &c'" + string + "' &eon line &d'" + string + " : " + this.configFile.getString("monsoon.block_changes." + string) + "' &ein monsoon block changes section in the config!"));
        }
        this.type = Disaster.MONSOON;
    }

    @Override
    public void start(final World world, Player player, boolean bl) {
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        ongoingDisasters.add(this);
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            Utils.broadcastEvent(this.level, "weather", this.type, world);
        }
        DeathMessages.monsoons.add(this);
        final Monsoon monsoon = this;
        final Random random = this.plugin.random;
        final ArrayDeque arrayDeque = new ArrayDeque();
        new RepeatingTask(this.plugin, this.delay, 20){

            @Override
            public void run() {
                if (Monsoon.this.time <= 0) {
                    Monsoon.this.clear();
                    this.cancel();
                    world.setStorm(false);
                    ongoingDisasters.remove(monsoon);
                    Monsoon.this.triggerRegen(true);
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, Monsoon.this.type.getMetricsLabel(), Monsoon.this.blocksDestroyed);
                    return;
                }
                Monsoon monsoon2 = Monsoon.this;
                monsoon2.time = monsoon2.time - 20;
                if (!world.hasStorm()) {
                    world.setStorm(true);
                    world.setThunderDuration(Monsoon.this.time);
                    world.setThundering(true);
                }
                arrayDeque.clear();
                for (Entity entity : world.getEntities()) {
                    LivingEntity livingEntity;
                    Location location;
                    if (Monsoon.this.drowned.contains(entity.getUniqueId()) && ((Mob)entity).getTarget() == null && Bukkit.getEntity((UUID)Monsoon.this.targets.get(entity.getUniqueId())) != null) {
                        ((Mob)entity).setTarget((LivingEntity)Bukkit.getEntity((UUID)Monsoon.this.targets.get(entity.getUniqueId())));
                    }
                    if ((location = entity.getLocation()).getBlock().getTemperature() <= 0.15 || location.getBlock().getTemperature() > 0.95 || Utils.isWeatherDisabled(location, monsoon) || !(entity instanceof LivingEntity)) continue;
                    if (entity instanceof Player) {
                        if (Utils.isPlayerImmune((Player)entity)) continue;
                        if (random.nextDouble() < Monsoon.this.drownedRate && Math.abs((livingEntity = world.getHighestBlockAt(Utils.getSpotInSquareRadius(location, 20)).getRelative(BlockFace.UP).getLocation()).getBlockY() - location.getBlockY()) <= 15) {
                            Drowned drowned = (Drowned)world.spawnEntity((Location)livingEntity, EntityType.DROWNED);
                            if (random.nextInt(10) == 0 && CustomEntityType.CURSEDDIVER.canSpawn()) {
                                Monsoon.this.plugin.handler.addEntity(new CursedDiver((Mob)drowned, Monsoon.this.plugin, random));
                            }
                            drowned.setTarget((LivingEntity)entity);
                            Monsoon.this.drowned.add(drowned.getUniqueId());
                            Monsoon.this.targets.put(drowned.getUniqueId(), entity.getUniqueId());
                            drowned.setMetadata("dd-monsoonmob", (MetadataValue)Monsoon.this.plugin.fixedData);
                        }
                    }
                    if (entity instanceof Drowned || entity.getWorld().getHighestBlockYAt(location) > location.getBlockY() + 1) continue;
                    livingEntity = (LivingEntity)entity;
                    arrayDeque.add(livingEntity);
                    livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 30, 2, true, false, false));
                    if (random.nextInt(3) != 0 || livingEntity.getLocation().getBlock().getType() != Material.WATER) continue;
                    livingEntity.setVelocity(new Vector(random.nextDouble() - 0.5, 0.15, random.nextDouble() - 0.5));
                }
            }
        };
        new RepeatingTask(this.plugin, this.delay, 1){

            @Override
            public void run() {
                if (Monsoon.this.time <= 0) {
                    this.cancel();
                    return;
                }
                for (LivingEntity livingEntity : arrayDeque) {
                    if (livingEntity.getRemainingAir() > -10) {
                        livingEntity.setRemainingAir(livingEntity.getRemainingAir() - Monsoon.this.airDecrease);
                        continue;
                    }
                    if (livingEntity.isDead() || livingEntity.getLocation().add(0.0, livingEntity.getHeight(), 0.0).getBlock().getType() == Material.WATER) continue;
                    Utils.pureDamageEntity(livingEntity, 0.5, "dd-monsoondrown", false, null);
                }
            }
        };
        final ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        final BukkitTask[] bukkitTaskArray = new BukkitTask[2];
        bukkitTaskArray[0] = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (Monsoon.this.time <= 0) {
                    bukkitTaskArray[0].cancel();
                    return;
                }
                final ArrayDeque<Block> arrayDeque = new ArrayDeque<Block>();
                for (Player object : world.getPlayers()) {
                    if (!object.getWorld().equals(world)) continue;
                    if (random.nextDouble() < Monsoon.this.puddleRate) {
                        Location location = object.getLocation().add((double)(random.nextInt(Monsoon.this.blockDamageRange) - Monsoon.this.blockDamageRange / 2), 0.0, (double)(random.nextInt(Monsoon.this.blockDamageRange) - Monsoon.this.blockDamageRange / 2));
                        location.setY((double)(world.getHighestBlockYAt(location) + 1));
                        if (location.getBlockY() < 256 && location.getBlock().getType() == Material.AIR && !globalPuddles.contains(location.getBlock()) && !Utils.isZoneProtected(location) && !Utils.isWeatherDisabled(location, monsoon) && location.getBlock().getTemperature() > 0.15 && location.getBlock().getTemperature() <= 0.95) {
                            if (Monsoon.this.plugin.CProtect) {
                                Utils.getCoreProtect().logPlacement("Deadly-Disasters", location, Material.WATER, location.getBlock().getBlockData());
                            }
                            arrayDeque.add(location.getBlock());
                            Monsoon.this.puddles.add(location.getBlock());
                            globalPuddles.add(location.getBlock());
                        }
                    }
                    int n = -Monsoon.this.particleRange;
                    while (n <= Monsoon.this.particleRange) {
                        int n2 = -Monsoon.this.particleRange;
                        while (n2 <= Monsoon.this.particleRange) {
                            int n3;
                            Location location;
                            Location location2;
                            if (!(random.nextDouble() >= Monsoon.this.particleMultiplier || (location2 = world.getHighestBlockAt(location = object.getLocation().add((double)n, 0.0, (double)n2)).getLocation()).getBlock().getTemperature() <= 0.15 || location2.getBlock().getTemperature() > 0.95 || Utils.isWeatherDisabled(location2, monsoon) || (n3 = location2.getBlockY() - location.getBlockY()) > Monsoon.this.particleYRange)) {
                                if (n3 < 0) {
                                    location2.setY(location2.getY() + (double)(n3 * -1));
                                }
                                object.spawnParticle(Particle.FALLING_WATER, location2.add(0.5, 7.0, 0.5), 3, 0.5, 2.0, 0.5, 1.0);
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
                Monsoon.this.plugin.getServer().getScheduler().runTask((Plugin)Monsoon.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        for (Block block : arrayDeque) {
                            block.setType(Material.WATER);
                            Levelled levelled = (Levelled)block.getBlockData();
                            levelled.setLevel(7);
                            block.setBlockData((BlockData)levelled);
                        }
                    }
                });
                for (Map.Entry entry : concurrentHashMap.entrySet()) {
                    if (random.nextDouble() < Monsoon.this.leakRate) {
                        world.spawnParticle(Particle.DRIP_WATER, (Location)entry.getKey(), 1, 0.2, 0.0, 0.2, 1.0);
                    }
                    entry.setValue((Integer)entry.getValue() - 1);
                    if ((Integer)entry.getValue() > 0) continue;
                    concurrentHashMap.remove(entry.getKey());
                }
            }
        }, (long)this.delay, 1L);
        final HashSet<Material> hashSet = new HashSet<Material>(Arrays.asList(Material.OAK_PLANKS, Material.SPRUCE_PLANKS, Material.BIRCH_PLANKS, Material.DARK_OAK_PLANKS, Material.JUNGLE_PLANKS, Material.ACACIA_PLANKS, Material.OAK_SLAB, Material.SPRUCE_SLAB, Material.BIRCH_SLAB, Material.DARK_OAK_SLAB, Material.JUNGLE_SLAB, Material.ACACIA_SLAB, Material.OAK_STAIRS, Material.SPRUCE_STAIRS, Material.BIRCH_STAIRS, Material.DARK_OAK_STAIRS, Material.JUNGLE_STAIRS, Material.ACACIA_STAIRS));
        if (this.plugin.mcVersion >= 1.19) {
            hashSet.addAll(Arrays.asList(Material.MANGROVE_PLANKS, Material.MANGROVE_SLAB, Material.MANGROVE_STAIRS));
        }
        bukkitTaskArray[1] = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (Monsoon.this.time <= 0) {
                    bukkitTaskArray[1].cancel();
                    return;
                }
                final HashMap<Block, Material> hashMap = new HashMap<Block, Material>();
                for (Player player : world.getPlayers()) {
                    int n = -Monsoon.this.blockDamageRange;
                    while (n < Monsoon.this.blockDamageRange) {
                        int n2 = -Monsoon.this.blockDamageRange;
                        while (n2 < Monsoon.this.blockDamageRange) {
                            Block block = world.getHighestBlockAt(player.getLocation().add((double)n, 0.0, (double)n2));
                            if (!(block.getTemperature() <= 0.15) && !(block.getTemperature() > 0.95)) {
                                if (hashSet.contains(block.getType()) || Tag.LEAVES.getValues().contains(block.getType())) {
                                    if (block.getRelative(BlockFace.DOWN).isPassable()) {
                                        concurrentHashMap.put(block.getLocation().clone().add(0.5, 0.0, 0.5), 40);
                                    }
                                } else if (!(random.nextDouble() >= Monsoon.this.blockChangeRate || !Monsoon.this.blockChanges.containsKey(block.getType()) || Utils.isZoneProtected(block.getLocation()) || Utils.passStrengthTest(block.getType()) || Utils.isWeatherDisabled(block.getLocation(), monsoon))) {
                                    Material material = Monsoon.this.blockChanges.get(block.getType());
                                    if (Monsoon.this.plugin.CProtect) {
                                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                        Utils.getCoreProtect().logPlacement("Deadly-Disasters", block.getLocation(), material, material.createBlockData());
                                    }
                                    Monsoon.this.addBlockWithTopToListAsync(block, block.getState());
                                    hashMap.put(block, material);
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
                Monsoon.this.plugin.getServer().getScheduler().runTask((Plugin)Monsoon.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry entry : hashMap.entrySet()) {
                            ((Block)entry.getKey()).setType((Material)entry.getValue());
                        }
                        (this).Monsoon.this.blocksDestroyed += hashMap.size();
                    }
                });
            }
        }, (long)this.delay, 40L);
    }

    @Override
    public void clear() {
        this.time = 0;
        DeathMessages.monsoons.remove(this);
        this.clearEntities();
        final double d = this.type.getDefaultRegenTickRate() * this.configFile.getDouble("monsoon.puddle_dry_rate");
        final double[] dArray = new double[]{0.0};
        new RepeatingTask(this.plugin, 200, 1){

            @Override
            public void run() {
                dArray[0] = dArray[0] + d;
                while (dArray[0] >= 1.0) {
                    dArray[0] = dArray[0] - 1.0;
                    if (Monsoon.this.puddles.isEmpty()) {
                        this.cancel();
                        return;
                    }
                    Block block = Monsoon.this.puddles.poll();
                    globalPuddles.remove(block);
                    if (block.getType() != Material.WATER) continue;
                    if (Monsoon.this.plugin.CProtect) {
                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                    }
                    block.setType(Material.AIR);
                }
            }
        };
    }

    public void clearEntities() {
        for (UUID uUID : this.drowned) {
            if (Bukkit.getEntity((UUID)uUID) == null) continue;
            Bukkit.getEntity((UUID)uUID).remove();
        }
    }
}

