/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.purgeentities.DarkMage;
import deadlydisasters.entities.purgeentities.PrimedCreeper;
import deadlydisasters.entities.purgeentities.ShadowLeech;
import deadlydisasters.entities.purgeentities.SkeletonKnight;
import deadlydisasters.entities.purgeentities.SwampBeast;
import deadlydisasters.entities.purgeentities.TunnellerZombie;
import deadlydisasters.entities.purgeentities.ZombieKnight;
import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.Disaster;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class Purge
extends DestructionDisaster {
    private boolean custom;
    private boolean showBar;
    private boolean running = true;
    private UUID playerUUID;
    private int max;
    private int spawnDistance;
    private int despawnSpeed;
    private int spawnSpeed;
    private BossBar bar;
    private Random rand;
    private String barTitle;
    private BarColor barColor;
    private String endMessage;
    private int[] mobProbabilities;
    private int sum;
    private World world;
    private Queue<UUID> entities = new ArrayDeque<UUID>();
    public static Set<UUID> targetedPlayers = new HashSet<UUID>();

    public Purge(int n) {
        super(n);
        this.rand = this.plugin.random;
        this.max = this.configFile.getInt("purge.horde_size.level " + this.level);
        this.showBar = this.configFile.getBoolean("purge.boss_bar");
        this.barTitle = this.configFile.getString("purge.bar_title");
        this.barColor = BarColor.RED;
        this.spawnDistance = this.configFile.getInt("purge.spawn_distance");
        this.despawnSpeed = this.configFile.getInt("purge.despawn_speed");
        this.endMessage = Utils.chat(this.configFile.getString("messages.misc.purge.ended"));
        this.volume = this.configFile.getDouble("purge.volume");
        this.spawnSpeed = 60 - 8 * (n - 1);
        this.mobProbabilities = new int[]{5, 3, 5, 3, 4, 3, 3, 4, 3, 4, 5, 4, 8, 6, 2, 3, 3, 4};
        int n2 = 0;
        while (n2 < this.mobProbabilities.length) {
            this.sum += this.mobProbabilities[n2];
            ++n2;
        }
        this.type = Disaster.PURGE;
    }

    @Override
    public void start(Location location, final Player player) {
        this.custom = (Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("custom_mob_spawning");
        this.world = player.getWorld();
        this.playerUUID = player.getUniqueId();
        if (!targetedPlayers.contains(this.playerUUID)) {
            targetedPlayers.add(this.playerUUID);
        }
        if (this.showBar) {
            this.bar = Bukkit.createBossBar((String)Utils.chat(this.barTitle), (BarColor)this.barColor, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[]{BarFlag.DARKEN_SKY, BarFlag.CREATE_FOG});
            this.bar.addPlayer(player);
        }
        player.playSound(player.getLocation(), Sound.EVENT_RAID_HORN, (float)(100.0 * this.volume), 0.1f);
        final double d = 1.0 / (double)this.max;
        DeathMessages.purges.add(this);
        final Purge purge = this;
        final FixedMetadataValue fixedMetadataValue = new FixedMetadataValue((Plugin)this.plugin, (Object)"protected");
        new RepeatingTask(this.plugin, 0, this.spawnSpeed){

            @Override
            public void run() {
                Location location;
                Player player2 = Bukkit.getPlayer((UUID)Purge.this.playerUUID);
                if (player2 == null) {
                    return;
                }
                if (Utils.isPlayerImmune(player2)) {
                    Purge.this.max = 0;
                }
                Iterator iterator = Purge.this.entities.iterator();
                while (iterator.hasNext()) {
                    LivingEntity object2 = (LivingEntity)Bukkit.getEntity((UUID)((UUID)iterator.next()));
                    if (object2 == null) {
                        iterator.remove();
                        continue;
                    }
                    if (!object2.isDead()) continue;
                    --Purge.this.max;
                    Purge.this.bar.setProgress(Math.max(Purge.this.bar.getProgress() - d, 0.0));
                    iterator.remove();
                }
                if (Purge.this.max <= 0 || !targetedPlayers.contains(Purge.this.playerUUID) || !Purge.this.world.equals(player2.getWorld())) {
                    Purge.this.bar.removeAll();
                    targetedPlayers.remove(Purge.this.playerUUID);
                    DeathMessages.purges.remove(purge);
                    player2.sendMessage(Utils.chat(Purge.this.endMessage));
                    for (Entity entity : player2.getNearbyEntities(30.0, 30.0, 30.0)) {
                        if (!(entity instanceof Player)) continue;
                        entity.sendMessage(Purge.this.endMessage);
                    }
                    new RepeatingTask(Purge.this.plugin, 0, Purge.this.despawnSpeed){

                        @Override
                        public void run() {
                            UUID uUID = (this).Purge.this.entities.poll();
                            if (uUID == null) {
                                return;
                            }
                            LivingEntity livingEntity = (LivingEntity)Bukkit.getEntity((UUID)uUID);
                            if (livingEntity != null) {
                                livingEntity.remove();
                            }
                            if ((this).Purge.this.entities.isEmpty()) {
                                this.cancel();
                            }
                        }
                    };
                    for (UUID uUID : Purge.this.entities) {
                        Entity entity = Bukkit.getEntity((UUID)uUID);
                        if (entity == null) continue;
                        entity.removeMetadata("dd-purgemob", (Plugin)Purge.this.plugin);
                    }
                    this.cancel();
                    Purge.this.running = false;
                    return;
                }
                if (Purge.this.showBar) {
                    Purge.this.bar.removeAll();
                    Purge.this.bar.addPlayer(player2);
                    for (Entity entity : player2.getNearbyEntities(30.0, 30.0, 30.0)) {
                        if (!(entity instanceof Player)) continue;
                        Purge.this.bar.addPlayer((Player)entity);
                    }
                }
                if ((location = Utils.findSmartYSpawn(player.getLocation(), Utils.getSpotInSquareRadius(player.getLocation(), Purge.this.spawnDistance), 2, 25)) == null || location.getBlock().getRelative(BlockFace.DOWN).isPassable()) {
                    return;
                }
                int n = Purge.this.rand.nextInt(Purge.this.sum);
                int n2 = 0;
                int n3 = 0;
                while (n3 < Purge.this.mobProbabilities.length) {
                    if (n <= (n2 += Purge.this.mobProbabilities[n3])) {
                        n = n3;
                        break;
                    }
                    ++n3;
                }
                Mob mob = null;
                switch (n) {
                    default: {
                        mob = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
                        mob.getEquipment().setHelmet(new ItemStack(Material.CHAINMAIL_HELMET));
                        break;
                    }
                    case 1: {
                        mob = (Mob)location.getWorld().spawnEntity(location, EntityType.VINDICATOR);
                        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
                        break;
                    }
                    case 2: {
                        mob = (Mob)location.getWorld().spawnEntity(location, EntityType.SLIME);
                        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
                        break;
                    }
                    case 3: {
                        mob = (Mob)location.getWorld().spawnEntity(location, EntityType.PILLAGER);
                        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
                        break;
                    }
                    case 4: {
                        mob = (Mob)location.getWorld().spawnEntity(location, EntityType.SKELETON);
                        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
                        mob.getEquipment().setHelmet(new ItemStack(Material.CHAINMAIL_HELMET));
                        break;
                    }
                    case 5: {
                        mob = (Mob)location.getWorld().spawnEntity(location, EntityType.RAVAGER);
                        mob.addPassenger(location.getWorld().spawnEntity(location, EntityType.PILLAGER));
                        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
                        break;
                    }
                    case 6: {
                        mob = (Mob)player.getWorld().spawnEntity(location.clone().add(0.0, 20.0, 0.0), EntityType.PHANTOM);
                        mob.setMetadata("dd-unburnable", (MetadataValue)fixedMetadataValue);
                        break;
                    }
                    case 7: {
                        mob = (Mob)player.getWorld().spawnEntity(location, EntityType.SPIDER);
                        break;
                    }
                    case 8: {
                        mob = (Mob)player.getWorld().spawnEntity(location, EntityType.CAVE_SPIDER);
                        break;
                    }
                    case 9: {
                        mob = (Mob)player.getWorld().spawnEntity(location, EntityType.ENDERMAN);
                        break;
                    }
                    case 10: {
                        if (!Purge.this.custom || !CustomEntityType.PRIMEDCREEPER.canSpawn()) break;
                        mob = (Creeper)location.getWorld().spawnEntity(location, EntityType.CREEPER);
                        if (Purge.this.rand.nextInt(5) == 0) {
                            ((Creeper)mob).setPowered(true);
                        }
                        Purge.this.plugin.handler.addEntity(new PrimedCreeper(mob, Purge.this.plugin));
                        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
                        break;
                    }
                    case 11: {
                        if (!Purge.this.custom || !CustomEntityType.TUNNELLER.canSpawn()) break;
                        mob = (Mob)player.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        Purge.this.plugin.handler.addEntity(new TunnellerZombie((Zombie)mob, (LivingEntity)player2, Purge.this.plugin));
                        break;
                    }
                    case 12: {
                        if (!Purge.this.custom || !CustomEntityType.SKELETONKNIGHT.canSpawn()) break;
                        mob = (Mob)player.getWorld().spawnEntity(location, EntityType.SKELETON);
                        Purge.this.plugin.handler.addEntity(new SkeletonKnight((Skeleton)mob, Purge.this.plugin));
                        break;
                    }
                    case 13: {
                        if (!Purge.this.custom || !CustomEntityType.DARKMAGE.canSpawn()) break;
                        mob = (Mob)player.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        Purge.this.plugin.handler.addEntity(new DarkMage(mob, Purge.this.plugin));
                        break;
                    }
                    case 14: {
                        if (!Purge.this.custom || !CustomEntityType.SHADOWLEECH.canSpawn()) break;
                        mob = (Mob)player.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        Purge.this.plugin.handler.addEntity(new ShadowLeech((Zombie)mob, Purge.this.plugin, Purge.this.rand));
                        break;
                    }
                    case 15: {
                        if (!Purge.this.custom || !CustomEntityType.SWAMPBEAST.canSpawn()) break;
                        mob = (Mob)player.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        Purge.this.plugin.handler.addEntity(new SwampBeast(mob, Purge.this.plugin));
                        break;
                    }
                    case 16: {
                        if (!Purge.this.custom || !CustomEntityType.ZOMBIEKNIGHT.canSpawn()) break;
                        mob = (Mob)player.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                        Purge.this.plugin.handler.addEntity(new ZombieKnight(mob, Purge.this.plugin));
                    }
                }
                if (mob == null) {
                    return;
                }
                mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(50.0);
                mob.setTarget((LivingEntity)player2);
                mob.setMetadata("dd-purgemob", (MetadataValue)fixedMetadataValue);
                Purge.this.entities.add(mob.getUniqueId());
            }
        };
        new RepeatingTask(this.plugin, 0, 5){

            @Override
            public void run() {
                if (!Purge.this.running) {
                    this.cancel();
                    return;
                }
                Player player = Bukkit.getPlayer((UUID)Purge.this.playerUUID);
                if (player == null) {
                    return;
                }
                for (UUID uUID : Purge.this.entities) {
                    Mob mob = (Mob)Bukkit.getEntity((UUID)uUID);
                    if (mob == null || mob.isDead() || mob.getTarget() != null) continue;
                    mob.setTarget((LivingEntity)player);
                }
            }
        };
    }

    public void clearEntities() {
        for (UUID uUID : this.entities) {
            if (Bukkit.getEntity((UUID)uUID) == null) continue;
            Bukkit.getEntity((UUID)uUID).remove();
        }
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if (location.getBlockY() < this.type.getMinHeight()) {
            return null;
        }
        if (((Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("event_broadcast")).booleanValue()) {
            this.broadcastMessage(player.getLocation(), player);
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(location, player);
    }

    public void clearBar() {
        this.bar.removeAll();
    }

    @Override
    public void broadcastMessage(Location location, Player player) {
        if (((Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("event_broadcast")).booleanValue()) {
            String string = this.configFile.getString("messages.misc.purge.started");
            if (this.level == 1) {
                string = "&a" + string;
            } else if (this.level == 2) {
                string = "&2" + string;
            } else if (this.level == 3) {
                string = "&b" + string;
            } else if (this.level == 4) {
                string = "&e" + string;
            } else if (this.level == 5) {
                string = "&c" + string;
            } else if (this.level == 6) {
                string = "&4" + string;
            }
            string = Utils.chat(string.replace("%level%", String.valueOf(this.level)).replace("%player%", player.getName()));
            if (this.configFile.getBoolean("messages.disaster_tips")) {
                string = String.valueOf(string) + "\n" + this.type.getTip();
            }
            for (Player player2 : location.getWorld().getPlayers()) {
                player2.sendMessage(string);
            }
            Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + string + ChatColor.GREEN + " (" + location.getWorld().getName() + ")");
        }
    }

    public boolean isShowBar() {
        return this.showBar;
    }

    public void setShowBar(boolean bl) {
        this.showBar = bl;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public int getSpawnDistance() {
        return this.spawnDistance;
    }

    public void setSpawnDistance(int n) {
        this.spawnDistance = n;
    }

    public int getDespawnSpeed() {
        return this.despawnSpeed;
    }

    public void setDespawnSpeed(int n) {
        this.despawnSpeed = n;
    }

    public String getBarTitle() {
        return this.barTitle;
    }

    public void setBarTitle(String string) {
        this.barTitle = string;
    }

    public BarColor getBarColor() {
        return this.barColor;
    }

    public void setBarColor(BarColor barColor) {
        this.barColor = barColor;
    }

    public String getEndMessage() {
        return this.endMessage;
    }

    public void setEndMessage(String string) {
        this.endMessage = string;
    }

    public int getSpawnSpeed() {
        return this.spawnSpeed;
    }

    public void setSpawnSpeed(int n) {
        this.spawnSpeed = n;
    }
}

