/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.sandstormentities.AncientMummy;
import deadlydisasters.entities.sandstormentities.AncientSkeleton;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class SandStorm
extends WeatherDisaster {
    private boolean skulls;
    private boolean wither;
    private boolean custom;
    private double version;
    private double spawnRate;
    private double particleMultiplier;
    private int particleRange;
    private int particleYRange;
    private Set<UUID> mobs = new HashSet<UUID>();
    public static Set<Biome> sandStormBiomes = new HashSet<Biome>();
    private Set<Biome> badlands = new HashSet<Biome>();
    private Map<UUID, UUID> targets = new HashMap<UUID, UUID>();

    public SandStorm(int n) {
        super(n);
        this.skulls = this.configFile.getBoolean("sandstorm.mobs_drop_skulls");
        this.wither = this.configFile.getBoolean("sandstorm.wither_effect");
        this.time = this.configFile.getInt("sandstorm.time.level " + this.level) * 20;
        this.delay = this.configFile.getInt("sandstorm.start_delay") * 20;
        this.particleRange = this.configFile.getInt("sandstorm.particle_max_distance");
        this.particleYRange = this.configFile.getInt("sandstorm.particle_Y_range");
        this.particleMultiplier = 0.25 * (double)this.configFile.getInt("sandstorm.particle_multiplier");
        this.spawnRate = this.configFile.getDouble("sandstorm.mob_spawn_rate");
        this.volume = this.configFile.getDouble("sandstorm.volume");
        this.version = this.plugin.mcVersion;
        this.badlands.addAll(Arrays.asList(Biome.BADLANDS, Biome.ERODED_BADLANDS));
        if (this.plugin.mcVersion < 1.18) {
            this.badlands.add(Biome.valueOf((String)"MODIFIED_WOODED_BADLANDS_PLATEAU"));
        }
        this.type = Disaster.SANDSTORM;
    }

    @Override
    public void start(final World world, Player player, boolean bl) {
        this.custom = (Boolean)WorldObject.findWorldObject((World)world).settings.get("custom_mob_spawning");
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            Utils.broadcastEvent(this.level, "weather", this.type, world);
        }
        DeathMessages.sandstorms.add(this);
        final Random random = new Random();
        final SandStorm sandStorm = this;
        final BukkitTask[] bukkitTaskArray = new BukkitTask[1];
        final int[] nArray = new int[1];
        bukkitTaskArray[0] = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (SandStorm.this.time <= 0) {
                    bukkitTaskArray[0].cancel();
                    if (SandStorm.this.version >= 1.16) {
                        for (Player player : world.getPlayers()) {
                            player.stopSound(Sound.AMBIENT_BASALT_DELTAS_ADDITIONS);
                            player.stopSound(Sound.AMBIENT_SOUL_SAND_VALLEY_LOOP);
                        }
                    }
                    return;
                }
                for (Player player : world.getPlayers()) {
                    Location location = null;
                    Location location2 = player.getLocation();
                    player.playSound(location2.clone().add(0.0, 3.0, 0.0), Sound.WEATHER_RAIN_ABOVE, (float)(0.017 * SandStorm.this.volume), 0.5f);
                    BlockData blockData = Material.SAND.createBlockData();
                    Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)255, (int)254, (int)196), 1.0f);
                    if (SandStorm.this.badlands.contains(location2.getBlock().getBiome())) {
                        blockData = Material.RED_SAND.createBlockData();
                        dustOptions = new Particle.DustOptions(Color.fromRGB((int)255, (int)136, (int)77), 1.0f);
                    }
                    int n = -SandStorm.this.particleRange;
                    while (n <= SandStorm.this.particleRange) {
                        int n2 = -SandStorm.this.particleRange;
                        while (n2 <= SandStorm.this.particleRange) {
                            int n3;
                            Location location3;
                            Location location4;
                            if (!(random.nextDouble() >= SandStorm.this.particleMultiplier) && sandStormBiomes.contains((location4 = world.getHighestBlockAt(location3 = player.getLocation().add((double)n, 0.0, (double)n2)).getLocation()).getBlock().getBiome()) && !Utils.isWeatherDisabled(location4, sandStorm) && (n3 = location4.getBlockY() - location3.getBlockY()) <= SandStorm.this.particleYRange) {
                                if (n3 < 0) {
                                    location4.setY(location4.getY() + (double)(n3 * -1));
                                }
                                if (location == null || location4.distanceSquared(player.getLocation()) < location.distanceSquared(player.getLocation())) {
                                    location = location4;
                                }
                                if (n3 > 0) {
                                    player.spawnParticle(Particle.FALLING_DUST, location4.clone().add(0.0, 3.0, 0.0), 1, 0.5, 1.0, 0.5, 1.0, (Object)blockData);
                                } else {
                                    player.spawnParticle(Particle.FALLING_DUST, location4.clone().add(0.0, 3.0, 0.0), 1, 0.5, 2.0, 0.5, 1.0, (Object)blockData);
                                    player.spawnParticle(Particle.REDSTONE, location4.clone().add(0.0, 3.0, 0.0), 1, 0.5, 2.0, 0.5, 1.0, (Object)dustOptions);
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    if (nArray[0] >= 60 && SandStorm.this.plugin.mcVersion >= 1.16 && location != null) {
                        player.playSound(location, Sound.AMBIENT_BASALT_DELTAS_ADDITIONS, SoundCategory.AMBIENT, (float)(1.0 * SandStorm.this.volume), 0.75f);
                        player.playSound(location, Sound.AMBIENT_SOUL_SAND_VALLEY_LOOP, SoundCategory.AMBIENT, (float)(1.0 * SandStorm.this.volume), 0.5f);
                        if (random.nextInt(10) == 0) {
                            player.playSound(location, Sound.ENTITY_EVOKER_PREPARE_WOLOLO, SoundCategory.AMBIENT, (float)(1.0 * SandStorm.this.volume), 0.5f);
                        }
                    }
                    if (!sandStormBiomes.contains(player.getLocation().getBlock().getBiome()) || player.getWorld().getHighestBlockYAt(location2) > location2.getBlockY() + 1) continue;
                    n = 0;
                    while (n < 10) {
                        player.spawnParticle(Particle.SMOKE_NORMAL, location2.getX() + (random.nextDouble() * 4.0 - 2.0), location2.getY() + (random.nextDouble() * 2.5 - 0.5), location2.getZ() + (random.nextDouble() * 4.0 - 2.0), 0, random.nextDouble() * 10.0 - 5.0, random.nextDouble() * 10.0 - 5.0, random.nextDouble() * 10.0 - 5.0, 1.0);
                        ++n;
                    }
                }
                if (nArray[0] > 60) {
                    nArray[0] = 0;
                }
                nArray[0] = nArray[0] + 1;
            }
        }, (long)this.delay, 1L);
        final int[] nArray2 = new int[1];
        new RepeatingTask(this.plugin, this.delay, 5){

            @Override
            public void run() {
                if (SandStorm.this.time <= 0) {
                    SandStorm.this.clear();
                    for (UUID uUID : SandStorm.this.mobs) {
                        Mob mob = (Mob)Bukkit.getEntity((UUID)uUID);
                        if (mob == null) continue;
                        Location location = mob.getLocation().clone();
                        mob.remove();
                        if (!SandStorm.this.skulls || random.nextInt(9) != 0 || location.getBlock().getType() != Material.AIR || !location.clone().subtract(0.0, 1.0, 0.0).getBlock().getType().isSolid() || Utils.isZoneProtected(location)) continue;
                        location.getBlock().setType(Material.SKELETON_SKULL);
                        location.getBlock().setBlockData(Bukkit.createBlockData((String)("minecraft:skeleton_skull[rotation=" + random.nextInt(13) + "]")));
                        if (!SandStorm.this.plugin.CProtect) continue;
                        Utils.getCoreProtect().logPlacement("Deadly-Disasters", location, Material.SKELETON_SKULL, location.getBlock().getBlockData());
                    }
                    this.cancel();
                    world.setStorm(false);
                    return;
                }
                if (!world.hasStorm()) {
                    world.setStorm(true);
                }
                for (LivingEntity livingEntity : world.getLivingEntities()) {
                    Skeleton skeleton;
                    if (SandStorm.this.mobs.contains(livingEntity.getUniqueId()) && ((Mob)livingEntity).getTarget() == null && Bukkit.getEntity((UUID)SandStorm.this.targets.get(livingEntity.getUniqueId())) != null) {
                        ((Mob)livingEntity).setTarget((LivingEntity)Bukkit.getEntity((UUID)SandStorm.this.targets.get(livingEntity.getUniqueId())));
                    }
                    if (livingEntity.getLocation().getY() < 50.0 || !sandStormBiomes.contains(livingEntity.getLocation().getBlock().getBiome()) || Utils.isWeatherDisabled(livingEntity.getLocation(), sandStorm) || livingEntity instanceof Husk || livingEntity instanceof Stray || livingEntity instanceof Skeleton || livingEntity instanceof Zombie) continue;
                    if (SandStorm.this.wither && nArray2[0] >= 60 && random.nextInt(4) == 0 && world.getHighestBlockYAt(livingEntity.getLocation()) <= livingEntity.getLocation().getBlockY() + 1) {
                        Utils.pureDamageEntity(livingEntity, 1.0, "dd-sandstormdeath", false, null);
                    }
                    if (!(livingEntity instanceof Player) || Utils.isPlayerImmune((Player)livingEntity)) continue;
                    if (world.getHighestBlockYAt(livingEntity.getLocation()) <= livingEntity.getLocation().getBlockY() + 1) {
                        if (SandStorm.this.wither) {
                            livingEntity.removePotionEffect(PotionEffectType.WITHER);
                            livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 20, 0, true, false));
                        }
                        livingEntity.removePotionEffect(PotionEffectType.BLINDNESS);
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 1, true, false));
                    }
                    if (nArray2[0] < 60 || !(random.nextDouble() * 100.0 < SandStorm.this.spawnRate)) continue;
                    Location location = Utils.getSpotInSquareRadius(livingEntity.getLocation(), 10);
                    int n = random.nextInt(8);
                    if (!SandStorm.this.custom && n <= 1) {
                        n = 3;
                    }
                    if (n == 0 && CustomEntityType.ANCIENTSKELETON.canSpawn()) {
                        skeleton = (Skeleton)world.spawnEntity(location, EntityType.SKELETON);
                        SandStorm.this.plugin.handler.addEntity(new AncientSkeleton((Mob)skeleton, SandStorm.this.plugin, random));
                        SandStorm.this.mobs.add(skeleton.getUniqueId());
                        skeleton.setTarget(livingEntity);
                        SandStorm.this.targets.put(skeleton.getUniqueId(), livingEntity.getUniqueId());
                        skeleton.setMetadata("dd-sandstormmob", (MetadataValue)SandStorm.this.plugin.fixedData);
                        continue;
                    }
                    if (n == 1 && CustomEntityType.ANCIENTMUMMY.canSpawn()) {
                        skeleton = (Husk)world.spawnEntity(location, EntityType.HUSK);
                        SandStorm.this.plugin.handler.addEntity(new AncientMummy((Mob)skeleton, SandStorm.this.plugin, random));
                        SandStorm.this.mobs.add(skeleton.getUniqueId());
                        skeleton.setTarget(livingEntity);
                        SandStorm.this.targets.put(skeleton.getUniqueId(), livingEntity.getUniqueId());
                        skeleton.setMetadata("dd-sandstormmob", (MetadataValue)SandStorm.this.plugin.fixedData);
                        continue;
                    }
                    if (n <= 3) {
                        skeleton = (Husk)world.spawnEntity(location, EntityType.HUSK);
                        skeleton.setTarget(livingEntity);
                        SandStorm.this.mobs.add(skeleton.getUniqueId());
                        SandStorm.this.targets.put(skeleton.getUniqueId(), livingEntity.getUniqueId());
                        skeleton.setMetadata("dd-sandstormmob", (MetadataValue)SandStorm.this.plugin.fixedData);
                        continue;
                    }
                    skeleton = (Skeleton)world.spawnEntity(location, EntityType.SKELETON);
                    skeleton.setTarget(livingEntity);
                    SandStorm.this.targets.put(skeleton.getUniqueId(), livingEntity.getUniqueId());
                    SandStorm.this.mobs.add(skeleton.getUniqueId());
                    skeleton.setMetadata("dd-sandstormmob", (MetadataValue)SandStorm.this.plugin.fixedData);
                    SandStorm.this.plugin.getServer().getScheduler().runTaskLater((Plugin)SandStorm.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            skeleton.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
                            skeleton.setMetadata("dd-unburnable", (MetadataValue)new FixedMetadataValue((Plugin)(this).SandStorm.this.plugin, (Object)"protected"));
                            skeleton.setMetadata("dd-ancientminion", (MetadataValue)new FixedMetadataValue((Plugin)(this).SandStorm.this.plugin, (Object)"protected"));
                            skeleton.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 200, 1, true, false));
                        }
                    }, 1L);
                }
                if (nArray2[0] > 60) {
                    nArray2[0] = 0;
                }
                nArray2[0] = nArray2[0] + 5;
                SandStorm sandStorm2 = SandStorm.this;
                sandStorm2.time = sandStorm2.time - 5;
            }
        };
    }

    @Override
    public void clear() {
        this.time = 0;
        this.clearEntities();
        DeathMessages.sandstorms.remove(this);
    }

    public void clearEntities() {
        for (UUID uUID : this.mobs) {
            if (Bukkit.getEntity((UUID)uUID) == null) continue;
            Bukkit.getEntity((UUID)uUID).remove();
        }
    }

    public boolean isWitherActive() {
        return this.wither;
    }

    public void setWitherActive(boolean bl) {
        this.wither = bl;
    }

    public boolean canMobsDropSkulls() {
        return this.skulls;
    }

    public void setMobsDropSkulls(boolean bl) {
        this.skulls = bl;
    }

    public Set<UUID> getMobs() {
        return this.mobs;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean bl) {
        this.custom = bl;
    }
}

