/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers;

import deadlydisasters.Main;
import deadlydisasters.commands.Disasters;
import deadlydisasters.events.disasters.CustomDisaster;
import deadlydisasters.handlers.InventoryItem;
import deadlydisasters.handlers.Languages;
import deadlydisasters.listeners.CoreListener;
import deadlydisasters.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Catalog
implements Listener {
    private Main plugin;
    private YamlConfiguration catalogFile;
    public Inventory featuredPage;
    private Inventory[] pages;
    private Inventory[] installed;
    private Map<Integer, InventoryItem> itemMap = new HashMap<Integer, InventoryItem>();
    private Map<Integer, InventoryItem> featuredList = new HashMap<Integer, InventoryItem>();
    private Map<Integer, Integer> installedList = new HashMap<Integer, Integer>();
    public static Map<Integer, File> downloadedDisasters = new HashMap<Integer, File>();
    public static List<String> catalogFileNames = new ArrayList<String>();
    public static int catalogDownloadTimer;

    public Catalog(Main main) {
        this.plugin = main;
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
        if (main.dataFile.contains("data.catalogFetchCooldown")) {
            catalogDownloadTimer = main.dataFile.getInt("data.catalogFetchCooldown");
        }
        this.initCatalog();
        this.initInventory();
        CustomDisaster.loadFiles(main);
        main.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)main, new Runnable(){

            @Override
            public void run() {
                if (catalogDownloadTimer > 0) {
                    --catalogDownloadTimer;
                    return;
                }
                Catalog.this.pullCatalog();
                Catalog.this.initInventory();
                catalogDownloadTimer = 144000;
            }
        }, 0L, 20L);
    }

    public void pullCatalog() {
        File file = new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/catalog.yml");
        try {
            Utils.copyUrlToFile(new URL("https://docs.google.com/uc?export=download&id=12yxVcLOBpkwiELjWPDAvDn5aUmCCtBfz"), file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initCatalog();
    }

    public void initCatalog() {
        File file = new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/catalog.yml");
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            this.catalogFile = YamlConfiguration.loadConfiguration((File)file);
            if (!this.catalogFile.contains("version")) {
                FileUtils.copyInputStreamToFile(this.plugin.getResource("files/catalog.yml"), file);
                this.catalogFile = YamlConfiguration.loadConfiguration((File)file);
            }
            catalogFileNames.clear();
            for (String string : this.catalogFile.getConfigurationSection("disasters").getKeys(false)) {
                catalogFileNames.add(string);
            }
            if ((!this.plugin.dataFile.contains("data.catalogVersion") || this.plugin.dataFile.getInt("data.catalogVersion") < this.catalogFile.getInt("version")) && this.plugin.getConfig().getBoolean("general.catalog_notify")) {
                for (String string : Bukkit.getOnlinePlayers()) {
                    if (!string.isOp()) continue;
                    string.sendMessage(String.valueOf(Languages.prefix) + ChatColor.GREEN + Languages.getString("internal.catalogUpdate") + Utils.chat(" &3(/disasters catalog)"));
                }
                this.plugin.dataFile.set("data.catalogVersion", (Object)this.catalogFile.getInt("version"));
                this.plugin.saveDataFile();
                CoreListener.catalogNotifyBool = true;
                CoreListener.catalogNotify.clear();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void initInventory() {
        int n = 0;
        this.itemMap.clear();
        this.featuredPage = Bukkit.createInventory(null, (int)54, (String)Utils.chat("&3&lDeadlyDisasters Catalog"));
        for (String string : this.catalogFile.getConfigurationSection("disasters").getKeys(false)) {
            String string2 = "disasters." + string + '.';
            this.itemMap.put(n, new InventoryItem(string2, this.catalogFile, this.plugin));
            ++n;
        }
        this.featuredPage.setItem(4, this.createItem(Material.NETHER_STAR, "&6&lFeatured Disasters", Arrays.asList(Utils.chat("&bFeatured disasters made by the community!"))));
        this.featuredPage.setItem(47, this.createItem(Material.CHEST_MINECART, "&b&lInstalled Disasters", Arrays.asList(Utils.chat("&a-View and &cdelete &ainstalled disasters"))));
        this.featuredPage.setItem(49, this.createItem(Material.ENDER_CHEST, "&f&l[COMING SOON]", Arrays.asList(Utils.chat("&d&lChallenge Packs"), Utils.chat("&a-Play challenging packs of custom"), Utils.chat("&adisasters made by the community"))));
        this.featuredPage.setItem(51, this.createItem(Material.BOOK, "&6&lDisaster Browser", Arrays.asList(Utils.chat("&a-Browse community made custom disasters"), Utils.chat("&a-Install new custom disasters"))));
        this.refreshBrowserItems();
        this.refreshInstalled();
    }

    @EventHandler
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        block19: {
            block18: {
                if (inventoryClickEvent.getCurrentItem() == null) {
                    return;
                }
                if (!inventoryClickEvent.getInventory().equals(this.featuredPage)) break block18;
                String string = inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName();
                inventoryClickEvent.setCancelled(true);
                if (string.contains("Disaster Browser")) {
                    inventoryClickEvent.getWhoClicked().openInventory(this.pages[0]);
                    return;
                }
                if (string.contains("Installed Disasters")) {
                    inventoryClickEvent.getWhoClicked().openInventory(this.installed[0]);
                    return;
                }
                if (string.contains("Featured Disasters") || string.contains("[COMING SOON]")) {
                    return;
                }
                int n = inventoryClickEvent.getRawSlot();
                n = n >= 10 && n <= 16 ? (n -= 10) : (n >= 19 && n <= 25 ? (n -= 12) : (n -= 14));
                n = this.featuredList.get((Object)Integer.valueOf((int)n)).id;
                if (downloadedDisasters.containsKey(n)) break block19;
                InventoryItem inventoryItem = this.itemMap.get(n);
                File file = new File(this.plugin.getDataFolder().getAbsolutePath(), "custom disasters/" + inventoryItem.fileName + ".yml");
                this.downloadItem(inventoryItem, file);
                downloadedDisasters.put(n, file);
                inventoryItem.installItem();
                this.refreshBrowserItems();
                this.refreshInstalled();
                inventoryClickEvent.getWhoClicked().openInventory(this.featuredPage);
                break block19;
            }
            if (Arrays.stream(this.pages).anyMatch(inventoryClickEvent.getInventory()::equals)) {
                String string = inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName();
                inventoryClickEvent.setCancelled(true);
                if (string.contains("Page ") && inventoryClickEvent.getCurrentItem().getType() == Material.ARROW) {
                    inventoryClickEvent.getWhoClicked().openInventory(this.pages[Integer.parseInt(string.substring(5)) - 1]);
                    return;
                }
                if (string.contains("Featured Page")) {
                    inventoryClickEvent.getWhoClicked().openInventory(this.featuredPage);
                    return;
                }
                int n = 0;
                while (n < this.pages.length) {
                    int n2;
                    if (inventoryClickEvent.getInventory().equals(this.pages[n]) && !downloadedDisasters.containsKey(n2 = n * 36 + (inventoryClickEvent.getRawSlot() - 9))) {
                        InventoryItem inventoryItem = this.itemMap.get(n2);
                        File file = new File(this.plugin.getDataFolder().getAbsolutePath(), "custom disasters/" + inventoryItem.fileName + ".yml");
                        this.downloadItem(inventoryItem, file);
                        downloadedDisasters.put(n2, file);
                        inventoryItem.installItem();
                        this.refreshBrowserItems();
                        this.refreshInstalled();
                        inventoryClickEvent.getWhoClicked().openInventory(this.pages[n]);
                    }
                    ++n;
                }
            } else if (Arrays.stream(this.installed).anyMatch(inventoryClickEvent.getInventory()::equals)) {
                String string = inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName();
                inventoryClickEvent.setCancelled(true);
                if (string.contains("Featured Page")) {
                    inventoryClickEvent.getWhoClicked().openInventory(this.featuredPage);
                    return;
                }
                if (string.contains("Page ") && inventoryClickEvent.getCurrentItem().getType() == Material.ARROW) {
                    inventoryClickEvent.getWhoClicked().openInventory(this.installed[Integer.parseInt(string.substring(5)) - 1]);
                    return;
                }
                int n = 0;
                while (n < this.installed.length) {
                    if (inventoryClickEvent.getInventory().equals(this.installed[n])) {
                        int n3 = n * 36 + (inventoryClickEvent.getRawSlot() - 9);
                        InventoryItem inventoryItem = this.itemMap.get(this.installedList.get(n3));
                        inventoryItem.uninstallItem();
                        if (downloadedDisasters.get(inventoryItem.id).exists()) {
                            downloadedDisasters.get(inventoryItem.id).delete();
                        }
                        downloadedDisasters.remove(inventoryItem.id);
                        Disasters.removeDisaster(inventoryItem.fileName);
                        CustomDisaster.disasterFiles.remove(inventoryItem.fileName);
                        this.refreshBrowserItems();
                        this.refreshInstalled();
                        if (n <= this.installed.length - 1) {
                            inventoryClickEvent.getWhoClicked().openInventory(this.installed[n]);
                        } else {
                            inventoryClickEvent.getWhoClicked().openInventory(this.installed[n - 1]);
                        }
                        return;
                    }
                    ++n;
                }
            }
        }
    }

    public void downloadItem(final InventoryItem inventoryItem, final File file) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    Utils.copyUrlToFile(new URL(inventoryItem.url), file);
                    CustomDisaster.loadDisaster(file);
                    Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&bDownloaded and installed &e'" + inventoryItem.name + "&e'"));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public void refreshBrowserItems() {
        this.featuredList.clear();
        List list = this.catalogFile.getIntegerList("featured");
        int n = 0;
        while (n < Math.min(list.size(), 7)) {
            this.featuredPage.setItem(10 + n, this.itemMap.get(list.get(n)).getItem());
            this.featuredList.put(n, this.itemMap.get(list.get(n)));
            ++n;
        }
        if (list.size() > 7) {
            n = 7;
            while (n < Math.min(list.size(), 14)) {
                this.featuredPage.setItem(19 + (n - 7), this.itemMap.get(list.get(n)).getItem());
                this.featuredList.put(n, this.itemMap.get(list.get(n)));
                ++n;
            }
        }
        if (list.size() > 14) {
            n = 14;
            while (n < Math.min(list.size(), 21)) {
                this.featuredPage.setItem(28 + (n - 14), this.itemMap.get(list.get(n)).getItem());
                this.featuredList.put(n, this.itemMap.get(list.get(n)));
                ++n;
            }
        }
        this.pages = new Inventory[Math.max((int)Math.ceil((double)this.itemMap.size() / 36.0), 1)];
        n = 0;
        while (n < this.pages.length) {
            this.pages[n] = Bukkit.createInventory(null, (int)54, (String)Utils.chat("&9&lDisaster Browser: Page " + (n + 1)));
            int n2 = 9;
            int n3 = n * 36;
            while (n3 < Math.min(this.itemMap.size(), n * 36 + 36)) {
                this.pages[n].setItem(n2, this.itemMap.get(n3).getItem());
                ++n2;
                ++n3;
            }
            if (n > 0) {
                this.pages[n].setItem(45, this.createItem(Material.ARROW, "&aPage " + n, Arrays.asList("")));
            }
            if (this.pages.length < n + 1) {
                this.pages[n].setItem(54, this.createItem(Material.ARROW, "&aPage " + n + 2, Arrays.asList("")));
            }
            this.pages[n].setItem(4, this.createItem(Material.NETHER_STAR, "&6&lFeatured Page", Arrays.asList(Utils.chat("&bCLICK to return to the featured page"))));
            ++n;
        }
    }

    public void refreshInstalled() {
        this.installedList.clear();
        this.installed = new Inventory[Math.max((int)Math.ceil((double)downloadedDisasters.size() / 36.0), 1)];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(downloadedDisasters.keySet());
        int n = 0;
        while (n < this.installed.length) {
            this.installed[n] = Bukkit.createInventory(null, (int)54, (String)Utils.chat("&9&lInstalled Page : " + (n + 1)));
            int n2 = 9;
            int n3 = n * 36;
            while (n3 < Math.min(downloadedDisasters.size(), n * 36 + 36)) {
                this.installed[n].setItem(n2, this.itemMap.get(arrayList.get(n3)).getInstalledItem());
                this.installedList.put(n3, (Integer)arrayList.get(n3));
                ++n2;
                ++n3;
            }
            if (n > 0) {
                this.installed[n].setItem(45, this.createItem(Material.ARROW, "&aPage " + n, Arrays.asList("")));
            }
            if (this.installed.length < n + 1) {
                this.installed[n].setItem(54, this.createItem(Material.ARROW, "&aPage " + n + 2, Arrays.asList("")));
            }
            this.installed[n].setItem(4, this.createItem(Material.NETHER_STAR, "&6&lFeatured Page", Arrays.asList(Utils.chat("&bCLICK to return to the featured page"))));
            ++n;
        }
    }

    public ItemStack createItem(Material material, String string, List<String> list) {
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(Utils.chat(string));
        itemMeta.setLore(list);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static void saveTimer(Main main) {
        main.dataFile.set("data.catalogFetchCooldown", (Object)catalogDownloadTimer);
    }
}

