/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers;

import deadlydisasters.Main;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.ConfigUpdater;
import deadlydisasters.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigSwapper {
    private Main plugin;
    public String currentConfig;
    public Set<String> configTemplates = new HashSet<String>();

    public ConfigSwapper(Main main) {
        this.plugin = main;
        File file = new File(main.getDataFolder().getAbsolutePath(), "pluginData/configs");
        file.mkdirs();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            this.configTemplates.add(file2.getName().substring(0, file2.getName().indexOf(46)));
            ++n2;
        }
        this.configTemplates.addAll(Arrays.asList("DEFAULT", "PERFORMANCE"));
        this.currentConfig = main.dataFile.contains("data.currentConfig") && this.configTemplates.contains(main.dataFile.getString("data.currentConfig")) ? main.dataFile.getString("data.currentConfig") : "DEFAULT";
    }

    public void saveConfig(String string) {
        File file = new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/configs/" + string + ".yml");
        file.getParentFile().mkdirs();
        try {
            FileUtils.copyFile(new File(this.plugin.getDataFolder().getAbsolutePath(), "config.yml"), file);
        }
        catch (IOException iOException) {
            if (this.plugin.debug) {
                iOException.printStackTrace();
                Utils.sendDebugMessage();
            }
            return;
        }
        this.configTemplates.add(string);
    }

    public boolean swapConfigs(String string) {
        Object object;
        InputStream inputStream = null;
        try {
            switch (string) {
                case "DEFAULT": {
                    inputStream = this.plugin.getResource("config.yml");
                    break;
                }
                case "PERFORMANCE": {
                    inputStream = this.plugin.getResource("files/configs/performanceConfig.yml");
                    break;
                }
                default: {
                    inputStream = new FileInputStream(new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/configs/" + string + ".yml"));
                    break;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.consoleSender.sendMessage(Utils.chat("&c[DeadlyDisasters]: File '" + string + "' does not exist in configs folder!"));
            return false;
        }
        if (this.currentConfig != null && new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/configs/" + this.currentConfig + ".yml").exists()) {
            object = new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/configs/" + this.currentConfig + ".yml");
            try {
                FileUtils.copyFile(new File(this.plugin.getDataFolder().getAbsolutePath(), "config.yml"), (File)object);
            }
            catch (IOException iOException) {
                if (this.plugin.debug) {
                    iOException.printStackTrace();
                    Utils.sendDebugMessage();
                }
                return false;
            }
        }
        object = new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/configs/backupConfig.yml");
        try {
            FileUtils.copyFile(new File(this.plugin.getDataFolder().getAbsolutePath(), "config.yml"), (File)object);
        }
        catch (IOException iOException) {
            if (this.plugin.debug) {
                iOException.printStackTrace();
                Utils.sendDebugMessage();
            }
            return false;
        }
        try {
            FileUtils.copyInputStreamToFile(inputStream, new File(this.plugin.getDataFolder().getAbsolutePath(), "config.yml"));
            this.plugin.reloadConfig();
            Utils.reloadPlugin(this.plugin);
        }
        catch (IOException iOException) {
            if (this.plugin.debug) {
                iOException.printStackTrace();
                Utils.sendDebugMessage();
            }
            return false;
        }
        this.currentConfig = string;
        this.plugin.dataFile.set("data.currentConfig", (Object)this.currentConfig);
        return true;
    }

    public boolean deleteConfig(String string) {
        File file = new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/configs/" + string + ".yml");
        if (!file.exists()) {
            return false;
        }
        file.delete();
        if (this.currentConfig.equals(string)) {
            this.currentConfig = null;
        }
        this.configTemplates.remove(string);
        return true;
    }

    public void updateConfigFolder() {
        File file = new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/configs");
        file.mkdirs();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                File file2 = fileArray[n2];
                try {
                    ConfigUpdater.update((Plugin)this.plugin, Languages.fetchNewConfig(this.plugin, null), file2, Arrays.asList(""));
                }
                catch (IOException iOException) {
                    if (!this.plugin.debug) break block3;
                    iOException.printStackTrace();
                    Main.consoleSender.sendMessage(Utils.chat("&c[DeadlyDisasters]: Could not update config template '" + file2.getName() + "' please report this bug to the discord!"));
                }
            }
            ++n2;
        }
    }

    public FileConfiguration getConfiguration(String string) {
        switch (string) {
            case "DEFAULT": {
                return this.plugin.getConfig();
            }
            case "PERFORMANCE": {
                File file = new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/configs/performanceConfig.yml");
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    try {
                        file.createNewFile();
                        FileUtils.copyInputStreamToFile(this.plugin.getResource("files/configs/performanceConfig.yml"), file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                return YamlConfiguration.loadConfiguration((File)file);
            }
        }
        File file = new File(this.plugin.getDataFolder().getAbsolutePath(), "pluginData/configs/" + string + ".yml");
        if (!file.exists()) {
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }
}

