/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.handlers.DifficultyLevel;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.utils.ConfigUpdater;
import deadlydisasters.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Languages {
    private static int langID;
    public static YamlConfiguration langFile;
    public static YamlConfiguration defaultLang;
    private static InputStream cfgFile;
    public static String prefix;
    public static String firstStart;
    public static String upgradeProMessage;
    public static String joinAfterUpdate;

    static {
        prefix = Utils.chat("&6&l[DeadlyDisasters]: ");
        upgradeProMessage = Utils.chat("&bThank you for upgrading to &4&lPRO &bThis introduces lots of new content (disasters, custom mobs, items, etc.) And worlds can naturally regenerate after disasters! To enable this feature the worlds disaster difficulty level must be set to &f&lCUSTOM &band the following field &dregenDelay &bin the &aworlds.yml &bfile must be greater then 0 (default value 120 = 2 minutes). The regenDelay is how many seconds after a disaster occurs should the regenerating begin, the rate of regeneration is different for each disaster and can be configured in the config. &ePlease note that this feature is in a &4&lBETA &estate and will be prone to bugs such as blocks missing and possibly some duplication glitches! Please use this feature at your own risk and report any bugs to the discord! (https://discord.com/invite/MhXFj72VeN)");
        joinAfterUpdate = Utils.chat("&bUpdate log for &4&lV14.3 \n&3- Small bug fixes\n- Limited time halloween event");
    }

    public static String getString(String string) {
        return langFile.contains(string) ? langFile.getString(string) : defaultLang.getString(string);
    }

    public static void updateLang(int n, Main main, Player player) {
        langID = n;
        if (langID == 0) {
            if (player != null) {
                player.sendMessage(Utils.chat("&bInstalling language files..."));
            }
            langFile = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(main.getResource("lang/langEnglish.yml")));
            cfgFile = main.getResource("config.yml");
            if (player != null) {
                player.sendMessage(Utils.chat("&aSuccessfully installed!"));
            }
        } else if (langID == 1) {
            try {
                Languages.fetchNewConfig(main, player);
                if (player != null) {
                    player.sendMessage(Utils.chat("&bInstalling language files..."));
                }
                langFile = YamlConfiguration.loadConfiguration((File)new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langChinesePRO.yml"));
                cfgFile = FileUtils.openInputStream(new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langChineseCfgPRO.yml"));
                if (player != null) {
                    player.sendMessage(Utils.chat("&aSuccessfully installed!"));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Main.consoleSender.sendMessage(Utils.chat(String.valueOf(prefix) + "&cUnable to update language! Please report the full error above to the discord!"));
            }
        } else if (langID == 2) {
            try {
                Languages.fetchNewConfig(main, player);
                if (player != null) {
                    player.sendMessage(Utils.chat("&bInstalling language files..."));
                }
                langFile = YamlConfiguration.loadConfiguration((File)new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langRussian.yml"));
                cfgFile = FileUtils.openInputStream(new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langRussianCfg.yml"));
                if (player != null) {
                    player.sendMessage(Utils.chat("&aSuccessfully installed!"));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Main.consoleSender.sendMessage(Utils.chat(String.valueOf(prefix) + "&cUnable to update language! Please report the full error above to the discord!"));
            }
        } else if (langID == 3) {
            try {
                Languages.fetchNewConfig(main, player);
                if (player != null) {
                    player.sendMessage(Utils.chat("&bInstalling language files..."));
                }
                langFile = YamlConfiguration.loadConfiguration((File)new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langCzech.yml"));
                cfgFile = FileUtils.openInputStream(new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langCzechCfg.yml"));
                if (player != null) {
                    player.sendMessage(Utils.chat("&aSuccessfully installed!"));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Main.consoleSender.sendMessage(Utils.chat(String.valueOf(prefix) + "&cUnable to update language! Please report the full error above to the discord!"));
            }
        } else if (langID == 4) {
            try {
                Languages.fetchNewConfig(main, player);
                if (player != null) {
                    player.sendMessage(Utils.chat("&bInstalling language files..."));
                }
                langFile = YamlConfiguration.loadConfiguration((File)new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langFrench.yml"));
                cfgFile = FileUtils.openInputStream(new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langFrenchCfg.yml"));
                if (player != null) {
                    player.sendMessage(Utils.chat("&aSuccessfully installed!"));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Main.consoleSender.sendMessage(Utils.chat(String.valueOf(prefix) + "&cUnable to update language! Please report the full error above to the discord!"));
            }
        }
        prefix = Utils.chat("&6&l[" + langFile.getString("misc.prefix") + "]: ");
        firstStart = Utils.chat("&b" + langFile.getString("internal.firstStart.line 1") + "\n&a/disasters disable randomdisasters" + "\n&b" + langFile.getString("internal.firstStart.line 2") + " &a/disasters difficulty <world> <difficulty>" + "\n&b" + langFile.getString("internal.firstStart.line 3") + "\n&b" + langFile.getString("internal.firstStart.line 4") + " &e/disasters help");
        DifficultyLevel.reloadNames();
        ItemsHandler.refreshMetas(main);
    }

    public static void changeConfigLang(Main main) {
        main.reloadConfig();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : main.getConfig().getValues(true).entrySet()) {
            if (!(entry.getValue() instanceof String) || entry.getValue().toString().contains("MemorySection[path=")) continue;
            hashMap.put(String.valueOf((String)entry.getKey()) + "_delete", "This should not be here!");
            entry.setValue(null);
            hashMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            main.getConfig().set((String)entry.getKey(), entry.getValue());
        }
        main.saveConfig();
        try {
            ConfigUpdater.update((Plugin)main, cfgFile, new File(main.getDataFolder().getAbsolutePath(), "config.yml"), Arrays.asList(""));
            main.reloadConfig();
            Disaster.reload(main);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Main.consoleSender.sendMessage(Utils.chat(String.valueOf(prefix) + "&cUnable to change config language! Please report the full error above to the discord."));
        }
    }

    public static InputStream fetchNewConfig(Main main, Player player) {
        if (langID == 0) {
            return main.getResource("config.yml");
        }
        if (langID == 1) {
            File file = new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langChinesePRO.yml");
            file.getParentFile().mkdirs();
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            File file2 = new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langChineseCfgPRO.yml");
            if (!file2.exists() || !yamlConfiguration.contains("version") || yamlConfiguration.getDouble("version") < Double.parseDouble(main.getDescription().getVersion())) {
                try {
                    main.getLogger().info("Downloading config translation file...");
                    if (player != null) {
                        player.sendMessage(Utils.chat("&eDownloading files..."));
                    }
                    file.createNewFile();
                    FileUtils.copyInputStreamToFile(main.getResource("lang/langChinesePRO.yml"), file);
                    if (!file2.exists()) {
                        file2.createNewFile();
                    }
                    FileUtils.copyInputStreamToFile(main.getResource("lang/langChineseCfgPRO.yml"), file2);
                    main.getLogger().info("Download Successful!");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return new FileInputStream(file2);
        }
        if (langID == 2) {
            File file = new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langRussian.yml");
            file.getParentFile().mkdirs();
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            File file3 = new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langRussianCfg.yml");
            if (!file3.exists() || !yamlConfiguration.contains("version") || yamlConfiguration.getDouble("version") < Double.parseDouble(main.getDescription().getVersion())) {
                try {
                    main.getLogger().info("Downloading config translation file...");
                    if (player != null) {
                        player.sendMessage(Utils.chat("&eDownloading files..."));
                    }
                    file.createNewFile();
                    Utils.copyUrlToFile(langFileLink.RUSSIANLANG.getLink(), file);
                    if (!file3.exists()) {
                        file3.createNewFile();
                    }
                    Utils.copyUrlToFile(langFileLink.RUSSIANCONFIG.getLink(), file3);
                    main.getLogger().info("Download Successful!");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return new FileInputStream(file3);
        }
        if (langID == 3) {
            File file = new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langCzech.yml");
            file.getParentFile().mkdirs();
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            File file4 = new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langCzechCfg.yml");
            if (!file4.exists() || !yamlConfiguration.contains("version") || yamlConfiguration.getDouble("version") < Double.parseDouble(main.getDescription().getVersion())) {
                try {
                    main.getLogger().info("Downloading config translation file...");
                    if (player != null) {
                        player.sendMessage(Utils.chat("&eDownloading files..."));
                    }
                    file.createNewFile();
                    Utils.copyUrlToFile(langFileLink.CZECHLANG.getLink(), file);
                    if (!file4.exists()) {
                        file4.createNewFile();
                    }
                    Utils.copyUrlToFile(langFileLink.CZECHCONFIG.getLink(), file4);
                    main.getLogger().info("Download Successful!");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return new FileInputStream(file4);
        }
        if (langID == 4) {
            File file = new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langFrench.yml");
            file.getParentFile().mkdirs();
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            File file5 = new File(String.valueOf(main.getDataFolder().getAbsolutePath()) + File.separator + "languages", "langFrenchCfg.yml");
            if (!file5.exists() || !yamlConfiguration.contains("version") || yamlConfiguration.getDouble("version") < Double.parseDouble(main.getDescription().getVersion())) {
                try {
                    main.getLogger().info("Downloading config translation file...");
                    if (player != null) {
                        player.sendMessage(Utils.chat("&eDownloading files..."));
                    }
                    file.createNewFile();
                    Utils.copyUrlToFile(langFileLink.FRENCHLANG.getLink(), file);
                    if (!file5.exists()) {
                        file5.createNewFile();
                    }
                    Utils.copyUrlToFile(langFileLink.FRENCHCONFIG.getLink(), file5);
                    main.getLogger().info("Download Successful!");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return new FileInputStream(file5);
        }
        return null;
    }

    public static enum langFileLink {
        CHINESELANG("https://docs.google.com/uc?export=download&id=1Sw9qmw-lT2L6dazy25aVyBolsrasuV4D"),
        CHINESECONFIG("https://docs.google.com/uc?export=download&id=14CcSJ636YbJl3Wr-KhnNX1bZFf1zNvp6"),
        CHINESETRADLANG(""),
        CHINESETRADCONFIG(""),
        RUSSIANLANG("https://docs.google.com/uc?export=download&id=1V-SSOqGJZSNA4bUv0Wi-dJzVuqDFNB1D"),
        RUSSIANCONFIG("https://docs.google.com/uc?export=download&id=1-Sgu3CZkeMiY97Tjs8rN8GK9VGMQfOM_"),
        CZECHLANG("https://docs.google.com/uc?export=download&id=1qQZo-cnUJO-Ikdi1-fIQwtBnMz0Ex-ii"),
        CZECHCONFIG("https://docs.google.com/uc?export=download&id=1QJlGncTIyjLcDDOUAhKgMJ9lGGEZKHuo"),
        FRENCHLANG("https://docs.google.com/uc?export=download&id=1RMkZ9lzBpHNsDblMXOneIeQrCZfIZLK9"),
        FRENCHCONFIG("https://docs.google.com/uc?export=download&id=1s-o6g7rExS5U_-KkrYm955VeHqanoDMu");

        private URL source;

        private langFileLink(String string2) {
            try {
                this.source = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }

        public URL getLink() {
            return this.source;
        }
    }
}

