/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.disasters.AcidStorm;
import deadlydisasters.events.disasters.BlackPlague;
import deadlydisasters.events.disasters.Blizzard;
import deadlydisasters.events.disasters.CaveIn;
import deadlydisasters.events.disasters.CustomDisaster;
import deadlydisasters.events.disasters.Earthquake;
import deadlydisasters.events.disasters.EndStorm;
import deadlydisasters.events.disasters.ExtremeWinds;
import deadlydisasters.events.disasters.Geyser;
import deadlydisasters.events.disasters.Hurricane;
import deadlydisasters.events.disasters.InfestedCaves;
import deadlydisasters.events.disasters.LandSlide;
import deadlydisasters.events.disasters.MeteorShower;
import deadlydisasters.events.disasters.Monsoon;
import deadlydisasters.events.disasters.Purge;
import deadlydisasters.events.disasters.SandStorm;
import deadlydisasters.events.disasters.Sinkhole;
import deadlydisasters.events.disasters.SolarStorm;
import deadlydisasters.events.disasters.SoulStorm;
import deadlydisasters.events.disasters.Supernova;
import deadlydisasters.events.disasters.Tornado;
import deadlydisasters.events.disasters.Tsunami;
import deadlydisasters.handlers.SeasonsHandler;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TimerCheck {
    public Map<UUID, Map<UUID, Integer>> timer = new ConcurrentHashMap<UUID, Map<UUID, Integer>>();
    private FileConfiguration dataFile;
    private Main plugin;
    private Random rand;
    private Set<Biome> oceanBiomes = new HashSet<Biome>();
    private SeasonsHandler seasonsHandler;
    private boolean seasonsActive;

    public TimerCheck(final Main main, FileConfiguration fileConfiguration, Random random) {
        this.dataFile = fileConfiguration;
        this.plugin = main;
        this.rand = random;
        for (World world : Bukkit.getWorlds()) {
            if (this.timer.containsKey(world.getUID())) continue;
            this.timer.put(world.getUID(), new HashMap());
        }
        if (!this.dataFile.contains("timers")) {
            this.dataFile.createSection("timers");
        }
        this.refreshTimerList();
        this.oceanBiomes.addAll(Arrays.asList(Biome.OCEAN, Biome.COLD_OCEAN, Biome.DEEP_COLD_OCEAN, Biome.DEEP_FROZEN_OCEAN, Biome.DEEP_LUKEWARM_OCEAN, Biome.DEEP_OCEAN, Biome.FROZEN_OCEAN, Biome.LUKEWARM_OCEAN, Biome.WARM_OCEAN, Biome.RIVER, Biome.FROZEN_RIVER));
        main.getServer().getScheduler().runTaskLater((Plugin)main, new Runnable(){

            @Override
            public void run() {
                TimerCheck.this.seasonsHandler = main.seasonsHandler;
                TimerCheck.this.seasonsActive = TimerCheck.this.seasonsHandler.isActive;
                TimerCheck.this.startTimer(main);
            }
        }, 20L);
    }

    public void startTimer(final Main main) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)main, new Runnable(){

            @Override
            public void run() {
                for (final Player player : Bukkit.getServer().getOnlinePlayers()) {
                    Object object;
                    Object object2;
                    ArrayList<Disaster> arrayList;
                    if (Utils.isPlayerImmune(player) || player.isDead()) continue;
                    UUID uUID = player.getUniqueId();
                    World world = player.getWorld();
                    final WorldObject worldObject = WorldObject.findWorldObject(world);
                    if (worldObject.whitelist.contains(uUID) || !worldObject.naturalAllowed || !TimerCheck.this.timer.containsKey(world.getUID()) || !TimerCheck.this.timer.get(world.getUID()).containsKey(uUID)) continue;
                    int n = TimerCheck.this.timer.get(world.getUID()).get(uUID);
                    if (n > 0) {
                        TimerCheck.this.timer.get(world.getUID()).replace(uUID, n - 1);
                        continue;
                    }
                    final int n2 = worldObject.timer;
                    int[] nArray = new int[]{worldObject.offset};
                    if (nArray[0] <= 0) {
                        nArray[0] = 1;
                    }
                    final Vector vector = new Vector(TimerCheck.this.rand.nextInt(nArray[0] * 2) - nArray[0], 0, TimerCheck.this.rand.nextInt(nArray[0] * 2) - nArray[0]);
                    final int[] nArray2 = new int[]{worldObject.simulateLevel(TimerCheck.this.rand)};
                    if (nArray2[0] == 6 && !((Boolean)worldObject.settings.get("level_six")).booleanValue()) {
                        nArray2[0] = 5;
                    }
                    if (worldObject.allowed.contains((Object)Disaster.CUSTOM) && main.getConfig().getDouble("custom.frequency") > TimerCheck.this.rand.nextDouble()) {
                        Object object3;
                        arrayList = new ArrayList<YamlConfiguration>(CustomDisaster.disasterFiles.values());
                        object2 = player.getWorld().getEnvironment().toString().toLowerCase();
                        int n3 = player.getLocation().getBlockY();
                        object = arrayList.iterator();
                        while (object.hasNext()) {
                            object3 = (YamlConfiguration)object.next();
                            if (!(!object3.getBoolean("settings.natural") || object3.contains("settings.frequency") && object3.getDouble("settings.frequency") < TimerCheck.this.rand.nextDouble() || !object3.getStringList("settings.environments").contains(object2) || object3.contains("settings.min_height") && object3.getInt("settings.min_height") > n3) && (!object3.contains("settings.max_height") || object3.getInt("settings.max_height") >= n3)) continue;
                            object.remove();
                        }
                        if (!arrayList.isEmpty()) {
                            Object object42;
                            object = (YamlConfiguration)arrayList.get(TimerCheck.this.rand.nextInt(arrayList.size()));
                            object3 = new boolean[6];
                            for (Object object42 : object.getConfigurationSection("core").getKeys(false)) {
                                object3[Integer.parseInt((String)((String)object42).substring((int)6)) - 1] = (YamlConfiguration)true;
                            }
                            if (object3[nArray2[0] - 1] == false) {
                                int n4 = 0;
                                while (n4 < 6) {
                                    if (object3[n4] != false) {
                                        nArray2[0] = n4 + 1;
                                    }
                                    ++n4;
                                }
                            }
                            object42 = new CustomDisaster(nArray2[0], main, (YamlConfiguration)object);
                            ((CustomDisaster)object42).createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                            TimerCheck.this.timer.get(world.getUID()).replace(uUID, TimerCheck.this.rand.nextInt(n2 / 2) + n2);
                            main.getServer().getScheduler().runTask((Plugin)main, new Runnable(){

                                @Override
                                public void run() {
                                    TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                }
                            });
                            continue;
                        }
                    }
                    arrayList = new ArrayList<Disaster>(Arrays.asList(Disaster.values()));
                    arrayList.remove((Object)Disaster.CUSTOM);
                    if (TimerCheck.this.seasonsActive) {
                        try {
                            object2 = SeasonsHandler.getSeasonsAPI().getSeason(player.getWorld());
                            Iterator iterator = arrayList.iterator();
                            while (iterator.hasNext()) {
                                object = (Disaster)((Object)iterator.next());
                                if (!TimerCheck.this.seasonsHandler.seasonMap.containsKey(object) || TimerCheck.this.seasonsHandler.seasonMap.get(object).contains(object2)) continue;
                                iterator.remove();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        if (!(((Disaster)((Object)object2.next())).getFrequency() < TimerCheck.this.rand.nextDouble())) continue;
                        object2.remove();
                    }
                    Collections.shuffle(arrayList);
                    Bukkit.getScheduler().runTask((Plugin)main, new Runnable(){

                        /*
                         * Enabled aggressive block sorting
                         */
                        @Override
                        public void run() {
                            if (main.RegionProtection && ((Boolean)worldObject.settings.get("region_protection")).booleanValue() && Utils.isZoneProtected(player.getLocation())) {
                                return;
                            }
                            int n = nArray2[0];
                            Location location = player.getLocation();
                            World world = player.getWorld();
                            Biome biome = location.getBlock().getBiome();
                            if (biome == null) {
                                return;
                            }
                            for (Disaster disaster : arrayList) {
                                switch (disaster) {
                                    case SINKHOLE: {
                                        if (!worldObject.allowed.contains((Object)Disaster.SINKHOLE) || location.getBlockY() < Disaster.SINKHOLE.getMinHeight() || (this).TimerCheck.this.oceanBiomes.contains(biome)) break;
                                        if (n > Disaster.SINKHOLE.getMaxLevel()) {
                                            n = Disaster.SINKHOLE.getMaxLevel();
                                        }
                                        Sinkhole sinkhole = new Sinkhole(n);
                                        sinkhole.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case CAVEIN: {
                                        if (!worldObject.allowed.contains((Object)Disaster.CAVEIN) || location.getBlockY() > Disaster.CAVEIN.getMinHeight() && world.getEnvironment() != World.Environment.NETHER || world.getHighestBlockYAt(location) <= location.getBlockY() + 1) break;
                                        if (n > Disaster.CAVEIN.getMaxLevel()) {
                                            n = Disaster.CAVEIN.getMaxLevel();
                                        }
                                        CaveIn caveIn = new CaveIn(n);
                                        caveIn.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case TORNADO: {
                                        if (!worldObject.allowed.contains((Object)Disaster.TORNADO) || location.getBlockY() < Disaster.TORNADO.getMinHeight() || (this).TimerCheck.this.oceanBiomes.contains(biome)) break;
                                        if (n > Disaster.TORNADO.getMaxLevel()) {
                                            n = Disaster.TORNADO.getMaxLevel();
                                        }
                                        Tornado tornado = new Tornado(n);
                                        tornado.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case GEYSER: {
                                        if (!worldObject.allowed.contains((Object)Disaster.GEYSER) || location.getBlockY() < Disaster.GEYSER.getMinHeight() || world.getEnvironment() == World.Environment.THE_END) break;
                                        if (n > Disaster.GEYSER.getMaxLevel()) {
                                            n = Disaster.GEYSER.getMaxLevel();
                                        }
                                        Geyser geyser = new Geyser(n);
                                        geyser.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case PLAGUE: {
                                        BlackPlague blackPlague;
                                        if (!worldObject.allowed.contains((Object)Disaster.PLAGUE)) break;
                                        if (n > Disaster.PLAGUE.getMaxLevel()) {
                                            n = Disaster.PLAGUE.getMaxLevel();
                                        }
                                        if (!(blackPlague = new BlackPlague(n)).isMobAvailable(player.getWorld())) break;
                                        blackPlague.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case ACIDSTORM: {
                                        if (!worldObject.allowed.contains((Object)Disaster.ACIDSTORM) || location.getBlockY() < Disaster.ACIDSTORM.getMinHeight() || !Utils.isEnvironment(world, World.Environment.NORMAL) || world.hasStorm() || location.getBlock().getTemperature() <= 0.15 || location.getBlock().getTemperature() > 0.95 || DeathMessages.acidstorms.stream().anyMatch(acidStorm -> acidStorm.getWorld() == world)) break;
                                        if (n > Disaster.ACIDSTORM.getMaxLevel()) {
                                            n = Disaster.ACIDSTORM.getMaxLevel();
                                        }
                                        AcidStorm acidStorm2 = new AcidStorm(n);
                                        acidStorm2.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case EXTREMEWINDS: {
                                        if (!worldObject.allowed.contains((Object)Disaster.EXTREMEWINDS) || location.getBlockY() < Disaster.EXTREMEWINDS.getMinHeight() || !Utils.isEnvironment(world, World.Environment.NORMAL) || DeathMessages.extremewinds.stream().anyMatch(extremeWinds -> extremeWinds.getWorld() == world)) break;
                                        if (n > Disaster.EXTREMEWINDS.getMaxLevel()) {
                                            n = Disaster.EXTREMEWINDS.getMaxLevel();
                                        }
                                        ExtremeWinds extremeWinds2 = new ExtremeWinds(n);
                                        extremeWinds2.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case SOULSTORM: {
                                        if (!worldObject.allowed.contains((Object)Disaster.SOULSTORM) || location.getBlockY() < Disaster.SOULSTORM.getMinHeight() || !Utils.isEnvironment(world, World.Environment.NETHER) || DeathMessages.soulstorms.stream().anyMatch(soulStorm -> soulStorm.getWorld() == world)) break;
                                        if (n > Disaster.SOULSTORM.getMaxLevel()) {
                                            n = Disaster.SOULSTORM.getMaxLevel();
                                        }
                                        SoulStorm soulStorm2 = new SoulStorm(n);
                                        soulStorm2.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case BLIZZARD: {
                                        if (!worldObject.allowed.contains((Object)Disaster.BLIZZARD) || !Utils.isEnvironment(world, World.Environment.NORMAL) || location.getBlockY() < Disaster.BLIZZARD.getMinHeight() || DeathMessages.blizzards.stream().anyMatch(blizzard -> blizzard.getWorld() == world) || !(this).TimerCheck.this.seasonsActive && location.getBlock().getTemperature() > 0.15) break;
                                        if (n > Disaster.BLIZZARD.getMaxLevel()) {
                                            n = Disaster.BLIZZARD.getMaxLevel();
                                        }
                                        Blizzard blizzard2 = new Blizzard(n);
                                        blizzard2.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case SANDSTORM: {
                                        if (!worldObject.allowed.contains((Object)Disaster.SANDSTORM) || !Utils.isEnvironment(world, World.Environment.NORMAL) || !SandStorm.sandStormBiomes.contains(location.getBlock().getBiome()) || location.getBlockY() < Disaster.SANDSTORM.getMinHeight() || DeathMessages.sandstorms.stream().anyMatch(sandStorm -> sandStorm.getWorld() == world)) break;
                                        if (n > Disaster.SANDSTORM.getMaxLevel()) {
                                            n = Disaster.SANDSTORM.getMaxLevel();
                                        }
                                        SandStorm sandStorm2 = new SandStorm(n);
                                        sandStorm2.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case EARTHQUAKE: {
                                        if (!worldObject.allowed.contains((Object)Disaster.EARTHQUAKE) || location.getBlockY() < Disaster.EARTHQUAKE.getMinHeight() || (this).TimerCheck.this.oceanBiomes.contains(biome)) break;
                                        if (n > Disaster.EARTHQUAKE.getMaxLevel()) {
                                            n = Disaster.EARTHQUAKE.getMaxLevel();
                                        }
                                        Earthquake earthquake = new Earthquake(n);
                                        earthquake.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case TSUNAMI: {
                                        Tsunami tsunami;
                                        if (!worldObject.allowed.contains((Object)Disaster.TSUNAMI) || location.getBlockY() < Disaster.TSUNAMI.getMinHeight()) break;
                                        if (n > Disaster.TSUNAMI.getMaxLevel()) {
                                            n = Disaster.TSUNAMI.getMaxLevel();
                                        }
                                        if ((tsunami = new Tsunami(n)).findAvailabePool(location) == null) break;
                                        tsunami.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case METEORSHOWERS: {
                                        if (!worldObject.allowed.contains((Object)Disaster.METEORSHOWERS) || location.getBlockY() < Disaster.METEORSHOWERS.getMinHeight() || !Utils.isEnvironment(world, World.Environment.NORMAL) || DeathMessages.meteorshowers.stream().anyMatch(meteorShower -> meteorShower.getWorld() == world)) break;
                                        if (n > Disaster.METEORSHOWERS.getMaxLevel()) {
                                            n = Disaster.METEORSHOWERS.getMaxLevel();
                                        }
                                        MeteorShower meteorShower2 = new MeteorShower(n);
                                        meteorShower2.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case ENDSTORM: {
                                        if (!worldObject.allowed.contains((Object)Disaster.ENDSTORM) || location.getBlockY() < Disaster.ENDSTORM.getMinHeight() || !Utils.isEnvironment(world, World.Environment.THE_END) || main.mcVersion < 1.16 || DeathMessages.endstorms.stream().anyMatch(endStorm -> endStorm.getWorld() == world)) break;
                                        if (n > Disaster.ENDSTORM.getMaxLevel()) {
                                            n = Disaster.ENDSTORM.getMaxLevel();
                                        }
                                        EndStorm endStorm2 = new EndStorm(n);
                                        endStorm2.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case SUPERNOVA: {
                                        if (!worldObject.allowed.contains((Object)Disaster.SUPERNOVA) || !Utils.isEnvironment(world, World.Environment.NORMAL) || location.getBlockY() < Disaster.SUPERNOVA.getMinHeight() || (this).TimerCheck.this.oceanBiomes.contains(biome)) break;
                                        if (n > Disaster.SUPERNOVA.getMaxLevel()) {
                                            n = Disaster.SUPERNOVA.getMaxLevel();
                                        }
                                        Supernova supernova = new Supernova(n);
                                        supernova.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case HURRICANE: {
                                        if (!worldObject.allowed.contains((Object)Disaster.HURRICANE) || !Utils.isEnvironment(world, World.Environment.NORMAL) || location.getBlockY() < Disaster.HURRICANE.getMinHeight() || !Hurricane.oceans.contains(biome) && (location.getBlock().getTemperature() <= 0.85 || location.getBlock().getTemperature() >= 1.0)) break;
                                        if (n > Disaster.HURRICANE.getMaxLevel()) {
                                            n = Disaster.HURRICANE.getMaxLevel();
                                        }
                                        Hurricane hurricane = new Hurricane(n);
                                        hurricane.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case PURGE: {
                                        if (!worldObject.allowed.contains((Object)Disaster.PURGE) || Purge.targetedPlayers.contains(player.getUniqueId())) break;
                                        if (n > Disaster.PURGE.getMaxLevel()) {
                                            n = Disaster.PURGE.getMaxLevel();
                                        }
                                        Purge purge = new Purge(n);
                                        purge.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case SOLARSTORM: {
                                        if (!worldObject.allowed.contains((Object)Disaster.SOLARSTORM) || location.getBlockY() < Disaster.SOLARSTORM.getMinHeight() || !Utils.isEnvironment(world, World.Environment.NORMAL) || DeathMessages.solarstorms.stream().anyMatch(solarStorm -> solarStorm.getWorld() == world)) break;
                                        if (n > Disaster.SOLARSTORM.getMaxLevel()) {
                                            n = Disaster.SOLARSTORM.getMaxLevel();
                                        }
                                        SolarStorm solarStorm2 = new SolarStorm(n);
                                        solarStorm2.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case MONSOON: {
                                        if (!worldObject.allowed.contains((Object)Disaster.MONSOON) || location.getBlockY() < Disaster.MONSOON.getMinHeight() || !Utils.isEnvironment(world, World.Environment.NORMAL) || DeathMessages.monsoons.stream().anyMatch(monsoon -> monsoon.getWorld() == world)) break;
                                        if (n > Disaster.MONSOON.getMaxLevel()) {
                                            n = Disaster.MONSOON.getMaxLevel();
                                        }
                                        Monsoon monsoon2 = new Monsoon(n);
                                        monsoon2.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), player.getWorld(), player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case INFESTEDCAVES: {
                                        if (!worldObject.allowed.contains((Object)Disaster.INFESTEDCAVES) || location.getBlockY() + 15 > main.getConfig().getInt("infestedcaves.max_height") || !Utils.isEnvironment(world, World.Environment.NORMAL) || main.mcVersion < 1.19 || location.getBlock().getBiome() == Biome.DEEP_DARK) break;
                                        if (n > Disaster.INFESTEDCAVES.getMaxLevel()) {
                                            n = Disaster.INFESTEDCAVES.getMaxLevel();
                                        }
                                        InfestedCaves infestedCaves = new InfestedCaves(n);
                                        infestedCaves.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                    case LANDSLIDE: {
                                        LandSlide landSlide;
                                        Location location2;
                                        if (!worldObject.allowed.contains((Object)Disaster.LANDSLIDE) || location.getBlockY() < Disaster.LANDSLIDE.getMinHeight()) break;
                                        if (n > Disaster.LANDSLIDE.getMaxLevel()) {
                                            n = Disaster.LANDSLIDE.getMaxLevel();
                                        }
                                        if ((location2 = (landSlide = new LandSlide(n)).findApplicableLocation(location, player)) == null) break;
                                        landSlide.createTimedStart((Integer)worldObject.settings.get("pet_warning_time"), vector, player);
                                        TimerCheck.this.resetNearbyPlayers(player, worldObject.maxRadius, n2);
                                        return;
                                    }
                                }
                            }
                        }
                    });
                    TimerCheck.this.timer.get(world.getUID()).replace(uUID, TimerCheck.this.rand.nextInt(n2 / 2) + n2);
                }
            }
        }, 0L, 20L);
    }

    public void refreshTimerList() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (String string : this.dataFile.getConfigurationSection("timers").getKeys(false)) {
                if (!this.timer.containsKey(UUID.fromString(string))) continue;
                if (this.dataFile.contains("timers." + string + "." + player.getUniqueId().toString())) {
                    this.timer.get(UUID.fromString(string)).put(player.getUniqueId(), this.dataFile.getInt("timers." + string + "." + player.getUniqueId().toString()));
                    continue;
                }
                this.timer.get(UUID.fromString(string)).put(player.getUniqueId(), WorldObject.findWorldObject(Bukkit.getWorld((UUID)UUID.fromString(string))).generateTimerValue(this.rand));
            }
        }
    }

    public void updateTimerList(World world) {
        WorldObject worldObject = WorldObject.findWorldObject(world);
        for (Object object : world.getPlayers()) {
            this.timer.get(world.getUID()).put(object.getUniqueId(), this.rand.nextInt(worldObject.timer / 2) + worldObject.timer);
        }
        if (this.dataFile.contains("timers." + world.getUID())) {
            for (Object object : this.dataFile.getConfigurationSection("timers." + world.getUID()).getKeys(false)) {
                this.dataFile.set("timers." + world.getUID() + "." + (String)object, (Object)(this.rand.nextInt(worldObject.timer / 2) + worldObject.timer));
            }
        }
        this.plugin.saveDataFile();
    }

    public void saveTimerValues() {
        for (Map.Entry<UUID, Map<UUID, Integer>> entry : this.timer.entrySet()) {
            for (Map.Entry<UUID, Integer> entry2 : entry.getValue().entrySet()) {
                this.dataFile.set("timers." + entry.getKey() + "." + entry2.getKey(), (Object)entry2.getValue());
            }
        }
    }

    public void resetNearbyPlayers(Player player, int n, int n2) {
        for (Entity entity : player.getNearbyEntities((double)n, (double)n, (double)n)) {
            if (!(entity instanceof Player) || Utils.isPlayerImmune((Player)entity)) continue;
            this.timer.get(entity.getWorld().getUID()).replace(entity.getUniqueId(), this.rand.nextInt(n2 / 2) + n2);
        }
    }
}

