/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers.specialevents;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.halloweenentities.Ghoul;
import deadlydisasters.entities.halloweenentities.Psyco;
import deadlydisasters.entities.halloweenentities.Scarecrow;
import deadlydisasters.entities.halloweenentities.Vampire;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.specialevents.SpecialEvent;
import deadlydisasters.listeners.spawners.GlobalSpawner;
import deadlydisasters.utils.Utils;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HalloweenEventHandler
extends SpecialEvent
implements Listener {
    private Main plugin;
    private Random rand;
    private Set<Inventory> invs = new HashSet<Inventory>();
    private boolean notify;

    public HalloweenEventHandler(Main main) {
        this.plugin = main;
        this.rand = main.random;
        if (main.mcVersion < 1.16 || !main.getConfig().getBoolean("general.special_events")) {
            return;
        }
        LocalDate localDate = LocalDate.now();
        if (localDate.getMonth() == Month.OCTOBER) {
            this.isEnabled = true;
        } else if (localDate.getYear() == 2023 && localDate.getMonth() == Month.NOVEMBER && localDate.getDayOfMonth() <= 18) {
            this.isEnabled = true;
        }
        if (this.isEnabled) {
            this.notify = main.getConfig().getBoolean("messages.event_notifications");
            main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
        }
    }

    @Override
    public void openGUI(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)Utils.chat("&9DeadlyDisasters Halloween Event"));
        ItemStack itemStack = Utils.createItem(Material.GRAY_STAINED_GLASS_PANE, 1, " ", null, false, true);
        int n = 0;
        while (n < 27) {
            inventory.setItem(n, itemStack);
            ++n;
        }
        inventory.setItem(4, Utils.createItem(Material.NETHER_STAR, 1, Utils.chat("&6" + Languages.getString("halloween.infoItem")), Arrays.asList(Utils.chat("&a" + Languages.getString("halloween.infoItemLore"))), false, true));
        inventory.setItem(10, ItemsHandler.cursedFlesh);
        inventory.setItem(11, ItemsHandler.vampireFang);
        inventory.setItem(12, ItemsHandler.candyCorn);
        inventory.setItem(13, ItemsHandler.spookyPumpkin);
        ItemStack itemStack2 = Utils.createItem(Material.LIME_STAINED_GLASS_PANE, 1, " ", null, false, true);
        inventory.setItem(14, itemStack2);
        inventory.setItem(15, itemStack2);
        inventory.setItem(16, ItemsHandler.pumpkinBasket);
        this.invs.add(inventory);
        player.openInventory(inventory);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        if (this.notify) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> playerJoinEvent.getPlayer().sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&a" + Languages.getString("halloween.eventMessage"))), 20L);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (this.invs.contains(inventoryClickEvent.getInventory())) {
            inventoryClickEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent inventoryCloseEvent) {
        this.invs.remove(inventoryCloseEvent.getInventory());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCreatureSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (creatureSpawnEvent.isCancelled() || creatureSpawnEvent.getSpawnReason() != CreatureSpawnEvent.SpawnReason.NATURAL || !Utils.isEnvironment(creatureSpawnEvent.getLocation().getWorld(), World.Environment.NORMAL) || GlobalSpawner.noSpawnWorlds.contains(creatureSpawnEvent.getLocation().getWorld()) || !(creatureSpawnEvent.getEntity() instanceof Monster) || !creatureSpawnEvent.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
            return;
        }
        Location location = creatureSpawnEvent.getLocation();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4));
        Collections.shuffle(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            switch (n) {
                case 1: {
                    if (!(this.rand.nextDouble() * 100.0 < CustomEntityType.GHOUL.getSpawnRate())) break;
                    Block block = location.getBlock().getRelative(BlockFace.DOWN);
                    Mob mob = (Mob)location.getWorld().spawnEntity(block.getRelative(BlockFace.DOWN).getLocation(), EntityType.ZOMBIE, false);
                    this.plugin.handler.addEntity(new Ghoul((Zombie)mob, block, this.plugin, true));
                    creatureSpawnEvent.setCancelled(true);
                    break;
                }
                case 2: {
                    if (!(this.rand.nextDouble() * 100.0 < CustomEntityType.SCARECROW.getSpawnRate())) break;
                    Block block = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE, false);
                    this.plugin.handler.addEntity(new Scarecrow((Zombie)block, this.plugin, this.rand));
                    creatureSpawnEvent.setCancelled(true);
                    break;
                }
                case 3: {
                    if (!(this.rand.nextDouble() * 100.0 < CustomEntityType.VAMPIRE.getSpawnRate())) break;
                    Block block = (Mob)location.getWorld().spawnEntity(location, EntityType.EVOKER, false);
                    this.plugin.handler.addEntity(new Vampire((Mob)block, this.plugin));
                    creatureSpawnEvent.setCancelled(true);
                    break;
                }
                case 4: {
                    if (!(this.rand.nextDouble() * 100.0 < CustomEntityType.PSYCO.getSpawnRate())) break;
                    Block block = (Mob)location.getWorld().spawnEntity(location, EntityType.SKELETON, false);
                    this.plugin.handler.addEntity(new Psyco((Mob)block, this.plugin, this.rand));
                    creatureSpawnEvent.setCancelled(true);
                }
            }
        }
    }
}

