/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.listeners;

import com.mojang.datafixers.util.Pair;
import deadlydisasters.Main;
import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.DisasterEvent;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.utils.BlockStateParser;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.plugin.Plugin;

public class BlockRegenHandler
implements Listener {
    public Map<UUID, Block> uuidToBlock = new HashMap<UUID, Block>();
    public static Set<Block> gravityHold = ConcurrentHashMap.newKeySet();
    private boolean fireSpread;

    public BlockRegenHandler(Main main) {
        BlockRegenHandler.reload(main);
        this.fireSpread = main.getConfig().getBoolean("regeneration.fire_spread");
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
    }

    public static void reload(Main main) {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void preBlockChange(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (entityChangeBlockEvent.isCancelled() || !(entityChangeBlockEvent.getEntity() instanceof FallingBlock)) {
            return;
        }
        if (gravityHold.contains(entityChangeBlockEvent.getBlock())) {
            entityChangeBlockEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockChange(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (entityChangeBlockEvent.isCancelled() || !(entityChangeBlockEvent.getEntity() instanceof FallingBlock)) {
            return;
        }
        UUID uUID = entityChangeBlockEvent.getEntity().getUniqueId();
        Block block = entityChangeBlockEvent.getBlock();
        if (entityChangeBlockEvent.getTo() == Material.AIR) {
            Block block2 = block.getRelative(BlockFace.DOWN);
            for (DisasterEvent disasterEvent : DisasterEvent.ongoingDisasters) {
                if (disasterEvent.damagedBlocks.containsKey(block)) {
                    if (disasterEvent.blockToBlock.containsValue(block)) {
                        Block block3 = null;
                        for (Map.Entry<Block, Block> entry : disasterEvent.blockToBlock.entrySet()) {
                            if (!entry.getValue().equals(block)) continue;
                            block3 = entry.getKey();
                            break;
                        }
                        disasterEvent.blockToBlock.remove(block3);
                        disasterEvent.UUIDToFalling.put(uUID, block3);
                        return;
                    }
                    disasterEvent.UUIDToFalling.put(uUID, block);
                    return;
                }
                if (!Utils.isMaterialGravity(block.getType()) || !disasterEvent.damagedBlocks.containsKey(block2) || DisasterEvent.disasterBlocks.containsKey(block)) continue;
                disasterEvent.addBlockToList(block, entityChangeBlockEvent.getBlock().getState());
                disasterEvent.UUIDToFalling.put(uUID, block);
                return;
            }
            for (DisasterEvent disasterEvent : DisasterEvent.regeneratingDisasters) {
                if (disasterEvent.damagedBlocks.containsKey(block)) {
                    if (disasterEvent.blockToBlock.containsValue(block)) {
                        Block block4 = null;
                        for (Map.Entry<Block, Block> entry : disasterEvent.blockToBlock.entrySet()) {
                            if (!entry.getValue().equals(block)) continue;
                            block4 = entry.getKey();
                            break;
                        }
                        disasterEvent.blockToBlock.remove(block4);
                        disasterEvent.UUIDToFalling.put(uUID, block4);
                        return;
                    }
                    disasterEvent.UUIDToFalling.put(uUID, block);
                    return;
                }
                if (!Utils.isMaterialGravity(block.getType()) || !disasterEvent.damagedBlocks.containsKey(block2) || DisasterEvent.disasterBlocks.containsKey(block)) continue;
                disasterEvent.addBlockToList(block, entityChangeBlockEvent.getBlock().getState());
                disasterEvent.UUIDToFalling.put(uUID, block);
                return;
            }
        } else {
            for (DisasterEvent disasterEvent : DisasterEvent.ongoingDisasters) {
                if (disasterEvent.fallingUUID.remove(uUID)) {
                    disasterEvent.addBlockWithTopToList(block, block.getState());
                    return;
                }
                if (!disasterEvent.UUIDToFalling.containsKey(uUID)) continue;
                disasterEvent.blockToBlock.put(disasterEvent.UUIDToFalling.get(uUID), entityChangeBlockEvent.getBlock());
                disasterEvent.UUIDToFalling.remove(uUID);
                return;
            }
            for (DisasterEvent disasterEvent : DisasterEvent.regeneratingDisasters) {
                if (disasterEvent.fallingUUID.remove(uUID)) {
                    disasterEvent.addBlockWithTopToList(block, block.getState());
                    return;
                }
                if (!disasterEvent.UUIDToFalling.containsKey(uUID)) continue;
                disasterEvent.blockToBlock.put(disasterEvent.UUIDToFalling.get(uUID), entityChangeBlockEvent.getBlock());
                disasterEvent.UUIDToFalling.remove(uUID);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerPlace(BlockPlaceEvent blockPlaceEvent) {
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        for (DisasterEvent disasterEvent : DisasterEvent.ongoingDisasters) {
            disasterEvent.damagedBlocks.remove(blockPlaceEvent.getBlock());
        }
        for (DisasterEvent disasterEvent : DisasterEvent.regeneratingDisasters) {
            disasterEvent.damagedBlocks.remove(blockPlaceEvent.getBlock());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBreak(BlockBreakEvent blockBreakEvent) {
        Iterator<Map.Entry<Block, Block>> iterator;
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        for (DisasterEvent disasterEvent : DisasterEvent.ongoingDisasters) {
            if (!disasterEvent.blockToBlock.containsValue(blockBreakEvent.getBlock())) continue;
            iterator = disasterEvent.blockToBlock.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().equals(blockBreakEvent.getBlock())) continue;
                iterator.remove();
                return;
            }
        }
        for (DisasterEvent disasterEvent : DisasterEvent.regeneratingDisasters) {
            if (!disasterEvent.blockToBlock.containsValue(blockBreakEvent.getBlock())) continue;
            iterator = disasterEvent.blockToBlock.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().equals(blockBreakEvent.getBlock())) continue;
                iterator.remove();
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockSpread(BlockSpreadEvent blockSpreadEvent) {
        if (blockSpreadEvent.isCancelled()) {
            return;
        }
        for (DisasterEvent disasterEvent : DisasterEvent.ongoingDisasters) {
            if (!disasterEvent.damagedBlocks.containsKey(blockSpreadEvent.getSource())) continue;
            if (!this.fireSpread) {
                blockSpreadEvent.setCancelled(true);
                return;
            }
            disasterEvent.addBlockToList(blockSpreadEvent.getBlock(), blockSpreadEvent.getBlock().getState());
            return;
        }
        for (DisasterEvent disasterEvent : DisasterEvent.regeneratingDisasters) {
            if (!disasterEvent.damagedBlocks.containsKey(blockSpreadEvent.getSource())) continue;
            if (!this.fireSpread) {
                blockSpreadEvent.setCancelled(true);
                return;
            }
            disasterEvent.addBlockToList(blockSpreadEvent.getBlock(), blockSpreadEvent.getBlock().getState());
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBurn(BlockBurnEvent blockBurnEvent) {
        if (blockBurnEvent.isCancelled()) {
            return;
        }
        for (DisasterEvent disasterEvent : DisasterEvent.ongoingDisasters) {
            if (!disasterEvent.damagedBlocks.containsKey(blockBurnEvent.getIgnitingBlock())) continue;
            disasterEvent.addBlockToList(blockBurnEvent.getBlock(), blockBurnEvent.getBlock().getState());
            return;
        }
        for (DisasterEvent disasterEvent : DisasterEvent.regeneratingDisasters) {
            if (!disasterEvent.damagedBlocks.containsKey(blockBurnEvent.getIgnitingBlock())) continue;
            disasterEvent.addBlockToList(blockBurnEvent.getBlock(), blockBurnEvent.getBlock().getState());
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockIgnite(BlockIgniteEvent blockIgniteEvent) {
        if (blockIgniteEvent.isCancelled()) {
            return;
        }
        for (DisasterEvent disasterEvent : DisasterEvent.ongoingDisasters) {
            if (!disasterEvent.damagedBlocks.containsKey(blockIgniteEvent.getBlock())) continue;
            if (!this.fireSpread) {
                blockIgniteEvent.setCancelled(true);
                return;
            }
            disasterEvent.addBlockToList(blockIgniteEvent.getBlock(), blockIgniteEvent.getBlock().getState());
            return;
        }
        for (DisasterEvent disasterEvent : DisasterEvent.regeneratingDisasters) {
            if (!disasterEvent.damagedBlocks.containsKey(blockIgniteEvent.getBlock())) continue;
            if (!this.fireSpread) {
                blockIgniteEvent.setCancelled(true);
                return;
            }
            disasterEvent.addBlockToList(blockIgniteEvent.getBlock(), blockIgniteEvent.getBlock().getState());
            return;
        }
    }

    public void saveRegenBlocks(Main main) {
        File file = new File(main.getDataFolder().getAbsolutePath(), "pluginData/regenData.yml");
        file.getParentFile().mkdirs();
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        main.getLogger().info("Saving regen data DO NOT CLOSE! Or regen data will be lost!");
        for (Map.Entry<RepeatingTask, DisasterEvent> object2 : DisasterEvent.regeneratingTasks.entrySet()) {
            object2.getKey().cancel();
        }
        ArrayDeque<DisasterEvent> arrayDeque = new ArrayDeque<DisasterEvent>(DisasterEvent.ongoingDisasters);
        arrayDeque.forEach(disasterEvent -> {
            disasterEvent.reverseList();
            disasterEvent.damagedBlocks.putAll(disasterEvent.physicBlocks);
        });
        arrayDeque.addAll(DisasterEvent.regeneratingDisasters);
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        int n = 1;
        for (DisasterEvent iOException : arrayDeque) {
            Location location;
            String string = "d" + n;
            yamlConfiguration.createSection(string);
            if (iOException instanceof DestructionDisaster) {
                yamlConfiguration.set(String.valueOf(string) + ".world", (Object)((DestructionDisaster)iOException).getLocation().getWorld().getUID().toString());
            } else {
                yamlConfiguration.set(String.valueOf(string) + ".world", (Object)((WeatherDisaster)iOException).getWorld().getUID().toString());
            }
            yamlConfiguration.set(String.valueOf(string) + ".type", (Object)iOException.type.toString());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<Block, BlockState> entry : iOException.damagedBlocks.entrySet()) {
                Location location2 = entry.getKey().getLocation();
                arrayList.add(String.valueOf(location2.getBlockX()) + "|" + location2.getBlockY() + "|" + location2.getBlockZ() + "|" + entry.getValue().getBlockData().getAsString(true) + (entry.getValue() instanceof TileState ? "|" + BlockStateParser.serialize((BlockState)((TileState)entry.getValue())) : ""));
            }
            yamlConfiguration.set(String.valueOf(string) + ".s", arrayList);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Map.Entry<Block, Block> entry : iOException.blockToBlock.entrySet()) {
                Location location3 = entry.getKey().getLocation();
                location = entry.getValue().getLocation();
                arrayList2.add(String.valueOf(location3.getBlockX()) + "|" + location3.getBlockY() + "|" + location3.getBlockZ() + "|" + location.getBlockX() + "|" + location.getBlockY() + "|" + location.getBlockZ());
            }
            yamlConfiguration.set(String.valueOf(string) + ".b", arrayList2);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Map.Entry entry : iOException.UUIDToFalling.entrySet()) {
                location = iOException.UUIDToFalling.get(entry.getKey()).getLocation();
                arrayList3.add(String.valueOf(((UUID)entry.getKey()).toString()) + "|" + location.getBlockX() + "|" + location.getBlockY() + "|" + location.getBlockZ());
            }
            yamlConfiguration.set(String.valueOf(string) + ".e", arrayList3);
            ++n;
        }
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        main.getLogger().info("Sucessfully finished and saved all regen data!");
    }

    public void readRegenData(Main main) {
        File file = new File(main.getDataFolder().getAbsolutePath(), "pluginData/regenData.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        main.getLogger().info("Loading block regen data...");
        int[] nArray = new int[1];
        if (yamlConfiguration.getKeys(false).isEmpty()) {
            main.getLogger().info("Successfully loaded all regen data.");
        }
        for (String string : yamlConfiguration.getKeys(false)) {
            World world;
            DisasterEvent disasterEvent = new DisasterEvent();
            DisasterEvent.regeneratingDisasters.add(disasterEvent);
            disasterEvent.world = world = Bukkit.getWorld((UUID)UUID.fromString(yamlConfiguration.getString(String.valueOf(string) + ".world")));
            disasterEvent.configFile = WorldObject.findWorldObject((World)world).configFile;
            disasterEvent.type = Disaster.forName(yamlConfiguration.getString(String.valueOf(string) + ".type"));
            if (world == null || disasterEvent.type == null) continue;
            nArray[0] = nArray[0] + 1;
            for (String string2 : yamlConfiguration.getStringList(String.valueOf(string) + ".e")) {
                String[] stringArray = string2.split("\\|");
                UUID uUID = UUID.fromString(stringArray[0]);
                disasterEvent.UUIDToFalling.put(uUID, new Location(world, (double)Integer.parseInt(stringArray[1]), (double)Integer.parseInt(stringArray[2]), (double)Integer.parseInt(stringArray[3])).getBlock());
            }
            main.getServer().getScheduler().runTaskAsynchronously((Plugin)main, () -> {
                String[] stringArray;
                LinkedHashMap<Location, Pair> linkedHashMap = new LinkedHashMap<Location, Pair>();
                HashMap<Location, Location> hashMap = new HashMap<Location, Location>();
                for (String string2 : yamlConfiguration.getStringList(String.valueOf(string) + ".s")) {
                    try {
                        stringArray = string2.split("\\|");
                        Location location = new Location(world, (double)Integer.parseInt(stringArray[0]), (double)Integer.parseInt(stringArray[1]), (double)Integer.parseInt(stringArray[2]));
                        linkedHashMap.put(location, Pair.of((Object)Bukkit.createBlockData((String)stringArray[3]), stringArray.length >= 5 ? stringArray[4] : null));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Utils.sendDebugMessage();
                    }
                }
                for (String string2 : yamlConfiguration.getStringList(String.valueOf(string) + ".b")) {
                    try {
                        stringArray = string2.split("\\|");
                        hashMap.put(new Location(world, (double)Integer.parseInt(stringArray[0]), (double)Integer.parseInt(stringArray[1]), (double)Integer.parseInt(stringArray[2])), new Location(world, (double)Integer.parseInt(stringArray[3]), (double)Integer.parseInt(stringArray[4]), (double)Integer.parseInt(stringArray[5])));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Utils.sendDebugMessage();
                    }
                }
                main.getServer().getScheduler().runTask((Plugin)main, () -> {
                    linkedHashMap.forEach((location, pair) -> {
                        Block block = location.getBlock();
                        disasterEvent.threadSafeRegen.put(block, (Pair<BlockData, String>)pair);
                        DisasterEvent.disasterBlocks.put(block, disasterEvent);
                    });
                    hashMap.forEach((location, location2) -> {
                        Block block = disasterEvent.blockToBlock.put(location.getBlock(), location2.getBlock());
                    });
                    disasterEvent.continueRegen(main);
                    nArray[0] = nArray[0] - 1;
                    if (nArray[0] <= 0) {
                        main.getLogger().info("Successfully loaded all regen data.");
                    }
                });
            });
        }
    }
}

