/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.listeners;

import deadlydisasters.Main;
import deadlydisasters.entities.christmasentities.Santa;
import deadlydisasters.entities.easterentities.EasterBunny;
import deadlydisasters.entities.halloweenentities.PumpkinKing;
import deadlydisasters.entities.infestedcavesentities.InfestedWorm;
import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DisasterEvent;
import deadlydisasters.events.disasters.AcidStorm;
import deadlydisasters.events.disasters.BlackPlague;
import deadlydisasters.events.disasters.Blizzard;
import deadlydisasters.events.disasters.EndStorm;
import deadlydisasters.events.disasters.Monsoon;
import deadlydisasters.events.disasters.SolarStorm;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.TimerCheck;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Rotatable;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class CoreListener
implements Listener {
    private Main plugin;
    private Queue<UUID> notified = new ArrayDeque<UUID>();
    private Queue<UUID> warnForKick = new ArrayDeque<UUID>();
    private FileConfiguration dataFile;
    private Random rand;
    private NamespacedKey key;
    private boolean favoredDisaster;
    private boolean dislikedDisaster;
    private static boolean worldSwap;
    private static boolean nonOpMsg;
    public static String worldMessage;
    private static Map<Entity, ItemStack[]> blockInventories;
    private TimerCheck tc;
    private FixedMetadataValue fixdata;
    private Map<UUID, Integer> mageWandCooldownMap = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> voidBowCooldownMap = new HashMap<UUID, Integer>();
    public static Set<UUID> joinedServer;
    public static Set<UUID> catalogNotify;
    public static boolean catalogNotifyBool;
    public static Map<UUID, DisasterEvent> fallingBlocks;
    public static Map<Fireball, DisasterEvent> fireBalls;

    static {
        blockInventories = new HashMap<Entity, ItemStack[]>();
        joinedServer = new HashSet<UUID>();
        catalogNotify = new HashSet<UUID>();
        fallingBlocks = new HashMap<UUID, DisasterEvent>();
        fireBalls = new HashMap<Fireball, DisasterEvent>();
    }

    public CoreListener(Main main, TimerCheck timerCheck, FileConfiguration fileConfiguration, Random random) {
        this.plugin = main;
        this.tc = timerCheck;
        this.dataFile = fileConfiguration;
        this.rand = random;
        this.key = new NamespacedKey((Plugin)main, "dd-frozen-mob");
        this.fixdata = new FixedMetadataValue((Plugin)main, (Object)"protected");
        CoreListener.reload(main);
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
        main.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)main, new Runnable(){

            @Override
            public void run() {
                Map.Entry<UUID, Integer> entry;
                Iterator<Map.Entry<UUID, Integer>> iterator = CoreListener.this.mageWandCooldownMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    entry.setValue(entry.getValue() - 1);
                    if (entry.getValue() > 0) continue;
                    iterator.remove();
                }
                iterator = CoreListener.this.voidBowCooldownMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    entry.setValue(entry.getValue() - 1);
                    if (entry.getValue() > 0) continue;
                    iterator.remove();
                }
            }
        }, 0L, 20L);
        if (main.dataFile.contains("data.favored") && !main.dataFile.getString("data.favored").equals("null")) {
            this.favoredDisaster = true;
        }
        if (main.dataFile.contains("data.disliked") && !main.dataFile.getString("data.disliked").equals("null")) {
            this.dislikedDisaster = true;
        }
    }

    @EventHandler
    public void onJoin(final PlayerJoinEvent playerJoinEvent) {
        final UUID uUID = playerJoinEvent.getPlayer().getUniqueId();
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Object object;
                if (worldSwap && (nonOpMsg || playerJoinEvent.getPlayer().isOp())) {
                    object = WorldObject.findWorldObject(playerJoinEvent.getPlayer().getWorld());
                    String string = Utils.chat("&c&l" + Languages.getString("internal.offWord"));
                    if (((WorldObject)object).naturalAllowed) {
                        string = Utils.chat("&a&l" + Languages.getString("internal.onWord"));
                    }
                    playerJoinEvent.getPlayer().sendMessage(Utils.chat(String.valueOf(worldMessage.replace("%difficulty%", ((WorldObject)object).difficulty.getLabel()).replace("%world%", ((WorldObject)object).getWorld().getName())) + "\n&3- " + Languages.getString("internal.random_disasters") + ": " + string + "\n&3- " + Languages.getString("internal.min_timer") + ": &6" + ((WorldObject)object).timer + " &7/ &3" + Languages.getString("internal.offset") + ": &6" + ((WorldObject)object).offset + "\n&3- " + Languages.getString("internal.levelWord") + ": &a" + ((WorldObject)object).table[0] + "% &2" + ((WorldObject)object).table[1] + "% &b" + ((WorldObject)object).table[2] + "% &e" + ((WorldObject)object).table[3] + "% &c" + ((WorldObject)object).table[4] + "% &4" + ((WorldObject)object).table[5] + "%"));
                    playerJoinEvent.getPlayer().playSound(playerJoinEvent.getPlayer().getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.3f, 1.0f);
                }
                if (playerJoinEvent.getPlayer().hasPermission("deadlydisasters.updatenotify") && CoreListener.this.dataFile.getBoolean("data.firstStart")) {
                    playerJoinEvent.getPlayer().sendMessage(Utils.chat(String.valueOf(Languages.prefix) + Languages.firstStart + "\n&c" + Languages.getString("internal.allowFlight")));
                    if (CoreListener.this.plugin.mcVersion < 1.16) {
                        playerJoinEvent.getPlayer().sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&c" + Languages.getString("internal.olderVersion")));
                    }
                }
                if (!CoreListener.this.notified.contains(uUID) && playerJoinEvent.getPlayer().hasPermission("deadlydisasters.updatenotify")) {
                    if (CoreListener.this.plugin.firstAfterUpdate) {
                        playerJoinEvent.getPlayer().sendMessage(String.valueOf(Languages.prefix) + Languages.joinAfterUpdate);
                    }
                    if (CoreListener.this.plugin.upgradeToPro) {
                        playerJoinEvent.getPlayer().sendMessage(String.valueOf(Languages.prefix) + Languages.upgradeProMessage);
                    }
                    if (CoreListener.this.plugin.updateNotify) {
                        object = Languages.getString("internal.playerUpdate");
                        playerJoinEvent.getPlayer().sendMessage(Utils.chat(String.valueOf(Languages.prefix) + "&a" + ((String)object).substring(0, ((String)object).indexOf(94)) + CoreListener.this.plugin.latestVersion + ((String)object).substring(((String)object).indexOf(94) + 1) + "&c" + CoreListener.this.plugin.getDescription().getVersion()));
                    }
                    CoreListener.this.notified.add(uUID);
                }
                if (CoreListener.this.warnForKick.contains(uUID)) {
                    playerJoinEvent.getPlayer().sendMessage(Utils.chat(String.valueOf(Languages.prefix) + "&c" + Languages.getString("internal.allowFlight")));
                    CoreListener.this.warnForKick.remove(uUID);
                }
                if (catalogNotifyBool && !catalogNotify.contains(uUID)) {
                    playerJoinEvent.getPlayer().sendMessage(String.valueOf(Languages.prefix) + ChatColor.GREEN + Languages.getString("internal.catalogUpdate") + Utils.chat(" &3(/disasters catalog)"));
                    catalogNotify.add(uUID);
                }
                if (playerJoinEvent.getPlayer().isOp() && !joinedServer.contains(uUID)) {
                    if (!CoreListener.this.favoredDisaster) {
                        playerJoinEvent.getPlayer().sendMessage(String.valueOf(Languages.prefix) + ChatColor.AQUA + Languages.getString("internal.favorDisaster") + Utils.chat(" &3(/disasters favor <disaster>)"));
                    }
                    if (!CoreListener.this.dislikedDisaster) {
                        playerJoinEvent.getPlayer().sendMessage(String.valueOf(Languages.prefix) + ChatColor.AQUA + Languages.getString("internal.dislikeDisaster") + Utils.chat(" &3(/disasters dislike <disaster>)"));
                    }
                    joinedServer.add(uUID);
                }
            }
        }, 10L);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (UUID uUID2 : CoreListener.this.tc.timer.keySet()) {
                    WorldObject worldObject = WorldObject.findWorldObject(Bukkit.getWorld((UUID)uUID2));
                    if (worldObject == null) continue;
                    if (CoreListener.this.dataFile.contains("timers." + uUID2 + "." + uUID)) {
                        CoreListener.this.tc.timer.get(uUID2).put(uUID, CoreListener.this.dataFile.getInt("timers." + uUID2 + "." + uUID));
                        continue;
                    }
                    CoreListener.this.tc.timer.get(uUID2).put(uUID, CoreListener.this.rand.nextInt(worldObject.timer / 2) + worldObject.timer);
                }
            }
        });
    }

    @EventHandler
    public void onLeave(final PlayerQuitEvent playerQuitEvent) {
        final UUID uUID = playerQuitEvent.getPlayer().getUniqueId();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                UUID uUID2;
                for (UUID uUID2 : CoreListener.this.tc.timer.keySet()) {
                    CoreListener.this.dataFile.set("timers." + uUID2 + "." + uUID, (Object)CoreListener.this.tc.timer.get(uUID2).get(uUID));
                    CoreListener.this.tc.timer.get(uUID2).remove(uUID);
                }
                CoreListener.this.plugin.saveDataFile();
                uUID2 = playerQuitEvent.getPlayer().getWorld();
                if (DestructionDisaster.currentLocations.containsKey(uUID2) && DestructionDisaster.currentLocations.get(uUID2).contains(playerQuitEvent.getPlayer())) {
                    DestructionDisaster.currentLocations.get(uUID2).remove(playerQuitEvent.getPlayer());
                    if (DestructionDisaster.currentLocations.get(uUID2).isEmpty()) {
                        DestructionDisaster.currentLocations.remove(uUID2);
                    }
                }
            }
        });
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        if (playerCommandPreprocessEvent.getMessage().equalsIgnoreCase("/weather clear")) {
            if (!playerCommandPreprocessEvent.getPlayer().hasPermission("deadlydisasters.clearweather")) {
                return;
            }
            Player player = playerCommandPreprocessEvent.getPlayer();
            DeathMessages.acidstorms.stream().forEach(acidStorm -> {
                if (acidStorm.getWorld().equals(player.getWorld())) {
                    acidStorm.clear();
                }
            });
            DeathMessages.extremewinds.stream().forEach(extremeWinds -> {
                if (extremeWinds.getWorld().equals(player.getWorld())) {
                    extremeWinds.clear();
                }
            });
            DeathMessages.soulstorms.stream().forEach(soulStorm -> {
                if (soulStorm.getWorld().equals(player.getWorld())) {
                    soulStorm.clear();
                }
            });
            DeathMessages.blizzards.stream().forEach(blizzard -> {
                if (blizzard.getWorld().equals(player.getWorld())) {
                    blizzard.clear();
                }
            });
            DeathMessages.sandstorms.stream().forEach(sandStorm -> {
                if (sandStorm.getWorld().equals(player.getWorld())) {
                    sandStorm.clear();
                }
            });
            DeathMessages.meteorshowers.stream().forEach(meteorShower -> {
                if (meteorShower.getWorld().equals(player.getWorld())) {
                    meteorShower.clear();
                }
            });
            DeathMessages.endstorms.stream().forEach(endStorm -> {
                if (endStorm.getWorld().equals(player.getWorld())) {
                    endStorm.clear();
                }
            });
            DeathMessages.hurricanes.stream().forEach(hurricane -> {
                if (hurricane.world.equals(player.getWorld())) {
                    hurricane.clear();
                }
            });
            DeathMessages.solarstorms.stream().forEach(solarStorm -> {
                if (solarStorm.getWorld().equals(player.getWorld())) {
                    solarStorm.clear();
                }
            });
            DeathMessages.monsoons.stream().forEach(monsoon -> {
                if (monsoon.getWorld().equals(player.getWorld())) {
                    monsoon.clear();
                }
            });
        }
    }

    @EventHandler
    public void onBlockMelt(BlockFadeEvent blockFadeEvent) {
        if (blockFadeEvent.getBlock().getType().equals((Object)Material.ICE)) {
            for (Entity entity : blockFadeEvent.getBlock().getWorld().getNearbyEntities(blockFadeEvent.getBlock().getLocation().clone().add(0.5, 0.5, 0.5), 0.5, 1.25, 0.5)) {
                if (!(entity instanceof LivingEntity) || !entity.getPersistentDataContainer().has(this.key, PersistentDataType.BYTE) || entity.getHeight() > 1.0 && entity.getLocation().add(0.0, 1.0, 0.0).getBlock().getType().equals((Object)Material.ICE) && !entity.getLocation().add(0.0, 1.0, 0.0).getBlock().equals(blockFadeEvent.getBlock())) continue;
                entity.setInvulnerable(false);
                ((LivingEntity)entity).setAI(true);
                if ((Byte)entity.getPersistentDataContainer().get(this.key, PersistentDataType.BYTE) == 0) {
                    ((LivingEntity)entity).setRemoveWhenFarAway(true);
                }
                entity.getPersistentDataContainer().remove(this.key);
                entity.setSilent(false);
                return;
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        if (InfestedWorm.immuneBlocks.contains(blockBreakEvent.getBlock()) || Santa.snowGlobeBlocks.contains(blockBreakEvent.getBlock()) || EasterBunny.easterBasketBlocks.contains(blockBreakEvent.getBlock()) || PumpkinKing.pumpkinBasketBlocks.contains(blockBreakEvent.getBlock())) {
            blockBreakEvent.setCancelled(true);
            return;
        }
        if (blockBreakEvent.getBlock().getType() == Material.ICE) {
            Blizzard.breakIce(blockBreakEvent.getBlock(), this.plugin);
        } else if (AcidStorm.poisonedCrops.contains(blockBreakEvent.getBlock())) {
            AcidStorm.poisonedCrops.remove(blockBreakEvent.getBlock());
            blockBreakEvent.setDropItems(false);
            blockBreakEvent.setExpToDrop(0);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        if (!blockPlaceEvent.getItemInHand().hasItemMeta()) {
            return;
        }
        if (blockPlaceEvent.getItemInHand().getItemMeta().getPersistentDataContainer().has(ItemsHandler.brokenSnowGlobeKey, PersistentDataType.BYTE) || blockPlaceEvent.getItemInHand().getItemMeta().getPersistentDataContainer().has(ItemsHandler.spookyPumpkinKey, PersistentDataType.BYTE) || blockPlaceEvent.getItemInHand().getItemMeta().getPersistentDataContainer().has(ItemsHandler.etherealLanternKey, PersistentDataType.BYTE)) {
            blockPlaceEvent.setCancelled(true);
        } else if (blockPlaceEvent.getItemInHand().getItemMeta().getPersistentDataContainer().has(ItemsHandler.snowGlobeKey, PersistentDataType.BYTE)) {
            if (!(blockPlaceEvent.getBlockPlaced().getBlockData() instanceof Rotatable)) {
                blockPlaceEvent.getPlayer().sendMessage(Utils.chat("&c" + Languages.getString("internal.placeGlobeError")));
                blockPlaceEvent.setCancelled(true);
                return;
            }
            Santa.summonSanta(this.plugin, blockPlaceEvent.getBlock());
        } else if (blockPlaceEvent.getItemInHand().getItemMeta().getPersistentDataContainer().has(ItemsHandler.easterBasketKey, PersistentDataType.BYTE)) {
            if (!(blockPlaceEvent.getBlockPlaced().getBlockData() instanceof Rotatable)) {
                blockPlaceEvent.getPlayer().sendMessage(Utils.chat("&c" + Languages.getString("internal.placeGlobeError")));
                blockPlaceEvent.setCancelled(true);
                return;
            }
            if (!EasterBunny.summonEasterBunny(this.plugin, blockPlaceEvent.getBlock())) {
                blockPlaceEvent.setCancelled(true);
                blockPlaceEvent.getPlayer().sendMessage(Utils.chat("&cCould not find possible spawn nearby!"));
                return;
            }
        } else if (blockPlaceEvent.getItemInHand().getItemMeta().getPersistentDataContainer().has(ItemsHandler.pumpkinBasketKey, PersistentDataType.BYTE)) {
            if (!(blockPlaceEvent.getBlockPlaced().getBlockData() instanceof Rotatable)) {
                blockPlaceEvent.getPlayer().sendMessage(Utils.chat("&c" + Languages.getString("internal.placeGlobeError")));
                blockPlaceEvent.setCancelled(true);
                return;
            }
            if (!PumpkinKing.summonPumpkinKing(this.plugin, blockPlaceEvent.getBlock())) {
                blockPlaceEvent.setCancelled(true);
                blockPlaceEvent.getPlayer().sendMessage(Utils.chat("&cCould not find possible spawn nearby!"));
                return;
            }
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent blockPistonExtendEvent) {
        for (Block block : blockPistonExtendEvent.getBlocks()) {
            if (!Santa.snowGlobeBlocks.contains(block) && !EasterBunny.easterBasketBlocks.contains(block) && !PumpkinKing.pumpkinBasketBlocks.contains(block)) continue;
            blockPistonExtendEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent blockPistonRetractEvent) {
        for (Block block : blockPistonRetractEvent.getBlocks()) {
            if (!Santa.snowGlobeBlocks.contains(block) && !EasterBunny.easterBasketBlocks.contains(block) && !PumpkinKing.pumpkinBasketBlocks.contains(block)) continue;
            blockPistonRetractEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onBlockForm(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (entityChangeBlockEvent.isCancelled() || !(entityChangeBlockEvent.getEntity() instanceof FallingBlock)) {
            return;
        }
        final FallingBlock fallingBlock = (FallingBlock)entityChangeBlockEvent.getEntity();
        final Block block = entityChangeBlockEvent.getBlock();
        if (fallingBlock.hasMetadata("dd-fb")) {
            if (Utils.isZoneProtected(fallingBlock.getLocation())) {
                entityChangeBlockEvent.setCancelled(true);
                return;
            }
            if (this.plugin.CProtect) {
                Utils.getCoreProtect().logPlacement("Deadly-Disasters", block.getLocation(), entityChangeBlockEvent.getTo(), entityChangeBlockEvent.getBlockData());
            }
            if (blockInventories.containsKey(fallingBlock)) {
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        ((InventoryHolder)block.getState()).getInventory().setContents(blockInventories.get(fallingBlock));
                        blockInventories.remove(fallingBlock);
                    }
                }, 1L);
            }
            if (fallingBlocks.containsKey(fallingBlock.getUniqueId())) {
                DisasterEvent disasterEvent = fallingBlocks.get(fallingBlock.getUniqueId());
                if (disasterEvent instanceof SolarStorm) {
                    disasterEvent.addBlockToList(entityChangeBlockEvent.getBlock(), entityChangeBlockEvent.getBlock().getState());
                    Material material = block.getRelative(BlockFace.DOWN).getType();
                    if (material == Material.DIRT || material == Material.GRASS_BLOCK || material == Material.PODZOL) {
                        Block block2 = block.getRelative(BlockFace.DOWN);
                        if (this.plugin.CProtect) {
                            Utils.getCoreProtect().logPlacement("Deadly-Disasters", block2.getLocation(), Material.COARSE_DIRT, block2.getBlockData());
                        }
                        disasterEvent.addBlockWithTopToList(block2, block2.getState());
                        block2.setType(Material.COARSE_DIRT);
                        ++((SolarStorm)disasterEvent).blocksDestroyed;
                        fallingBlock.getWorld().playSound(fallingBlock.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
                fallingBlocks.remove(fallingBlock.getUniqueId());
            }
            return;
        }
        if (fallingBlock.hasMetadata("dd-fbcancel")) {
            entityChangeBlockEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onFlow(FluidLevelChangeEvent fluidLevelChangeEvent) {
        if (Monsoon.globalPuddles.contains(fluidLevelChangeEvent.getBlock())) {
            fluidLevelChangeEvent.setCancelled(true);
        }
    }

    public static void addBlockInventory(Entity entity, ItemStack[] itemStackArray) {
        blockInventories.put(entity, itemStackArray);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getItem() == null || !playerInteractEvent.getItem().hasItemMeta()) {
            return;
        }
        Material material = playerInteractEvent.getItem().getType();
        if (material == Material.GHAST_TEAR && (this.plugin.customNameSupport && playerInteractEvent.getItem().getItemMeta().getDisplayName().equals(ItemsHandler.voidShardName) || playerInteractEvent.getItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.voidShardKey, PersistentDataType.BYTE))) {
            Location location = playerInteractEvent.getPlayer().getEyeLocation().clone().add(playerInteractEvent.getPlayer().getLocation().getDirection().multiply(6));
            if (location.getBlock().getType() != Material.AIR) {
                return;
            }
            EndStorm endStorm = new EndStorm(1);
            endStorm.createCustomRift(location);
            playerInteractEvent.getItem().setAmount(playerInteractEvent.getItem().getAmount() - 1);
        } else if (material == Material.BLAZE_ROD && (playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR || playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) && !this.mageWandCooldownMap.containsKey(playerInteractEvent.getPlayer().getUniqueId()) && playerInteractEvent.getItem().getItemMeta().hasLore() && (this.plugin.customNameSupport && ((String)playerInteractEvent.getItem().getItemMeta().getLore().get(0)).equals(ItemsHandler.mageWandLore) || playerInteractEvent.getItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.mageWandKey, PersistentDataType.BYTE))) {
            this.mageWandCooldownMap.put(playerInteractEvent.getPlayer().getUniqueId(), ItemsHandler.mageWandCooldown);
            final ShulkerBullet[] shulkerBulletArray = new ShulkerBullet[12];
            final double[] dArray = new double[]{0.05, 0.0};
            final Player player = playerInteractEvent.getPlayer();
            World world = player.getWorld();
            int n = 0;
            while (n < 6) {
                shulkerBulletArray[n] = (ShulkerBullet)world.spawnEntity(player.getLocation().clone().add(new Vector(1.0, 1.6, 0.0).rotateAroundY((double)n).normalize()), EntityType.SHULKER_BULLET);
                shulkerBulletArray[n].setShooter((ProjectileSource)player);
                shulkerBulletArray[n].setMetadata("dd-magebullet", (MetadataValue)this.fixdata);
                ++n;
            }
            n = 6;
            while (n < 12) {
                shulkerBulletArray[n] = (ShulkerBullet)world.spawnEntity(player.getLocation().clone().add(new Vector(1, 1, 0).rotateAroundY((double)n + 0.5).normalize()), EntityType.SHULKER_BULLET);
                shulkerBulletArray[n].setShooter((ProjectileSource)player);
                shulkerBulletArray[n].setMetadata("dd-magebullet", (MetadataValue)this.fixdata);
                ++n;
            }
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_CURSE, SoundCategory.PLAYERS, 0.75f, 0.5f);
            new RepeatingTask(this.plugin, 0, 1){

                @Override
                public void run() {
                    Location location;
                    dArray[0] = dArray[0] + 0.09;
                    double d = player.getLocation().getY() + 1.0;
                    Location location2 = player.getLocation();
                    int n = 0;
                    while (n < 6) {
                        location = shulkerBulletArray[n].getLocation();
                        location.setY(d + 0.3);
                        shulkerBulletArray[n].teleport(location);
                        shulkerBulletArray[n].setVelocity(new Vector(location.getX() - location2.getX(), 0.0, location.getZ() - location2.getZ()).rotateAroundY(1.2).normalize().multiply(dArray[0]).setY(0.04));
                        ++n;
                    }
                    n = 6;
                    while (n < 12) {
                        location = shulkerBulletArray[n].getLocation();
                        location.setY(d - 0.3);
                        shulkerBulletArray[n].teleport(location);
                        shulkerBulletArray[n].setVelocity(new Vector(location.getX() - location2.getX(), 0.0, location.getZ() - location2.getZ()).rotateAroundY(-1.2).normalize().multiply(dArray[0]).setY(0.04));
                        ++n;
                    }
                    dArray[1] = dArray[1] + 1.0;
                    if (dArray[1] > 20.0) {
                        n = 0;
                        while (n < 12) {
                            location = shulkerBulletArray[n].getLocation();
                            shulkerBulletArray[n].setVelocity(new Vector(location.getX() - location2.getX(), 0.0, location.getZ() - location2.getZ()).normalize().setY(0.05));
                            ++n;
                        }
                        this.cancel();
                    }
                }
            };
        }
    }

    @EventHandler
    public void bowShoot(EntityShootBowEvent entityShootBowEvent) {
        if (entityShootBowEvent.getBow() == null || (double)entityShootBowEvent.getForce() < 0.8 || !entityShootBowEvent.getBow().hasItemMeta()) {
            return;
        }
        ItemMeta itemMeta = entityShootBowEvent.getBow().getItemMeta();
        if (!this.voidBowCooldownMap.containsKey(entityShootBowEvent.getEntity().getUniqueId()) && (this.plugin.customNameSupport && itemMeta.getDisplayName().equals(ItemsHandler.voidBowName) || itemMeta.getPersistentDataContainer().has(ItemsHandler.voidBowKey, PersistentDataType.BYTE))) {
            this.voidBowCooldownMap.put(entityShootBowEvent.getEntity().getUniqueId(), ItemsHandler.voidBowCooldown);
            final Arrow arrow = (Arrow)entityShootBowEvent.getProjectile();
            arrow.setMetadata("dd-voidarrow", (MetadataValue)this.fixdata);
            arrow.setColor(Color.BLACK);
            new RepeatingTask(this.plugin, 0, 10){

                @Override
                public void run() {
                    if (arrow.isInBlock()) {
                        if (!Utils.isZoneProtected(arrow.getLocation()) || CoreListener.this.plugin.getConfig().getBoolean("customitems.items.void_wrath.allow_in_regions")) {
                            EndStorm.createUnstableRift(arrow.getLocation().clone(), ItemsHandler.voidBowPortalTicks, arrow.getShooter());
                        }
                        this.cancel();
                    } else if (arrow.isDead()) {
                        this.cancel();
                    }
                }
            };
        }
    }

    @EventHandler
    public void onConsume(PlayerItemConsumeEvent playerItemConsumeEvent) {
        if (playerItemConsumeEvent.getItem().getType() != Material.POTION || !BlackPlague.time.containsKey(playerItemConsumeEvent.getPlayer().getUniqueId())) {
            return;
        }
        if (playerItemConsumeEvent.getItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.plagueCureKey, PersistentDataType.BYTE)) {
            BlackPlague.cureEntity((LivingEntity)playerItemConsumeEvent.getPlayer());
            playerItemConsumeEvent.getPlayer().sendMessage(ChatColor.GREEN + Languages.getString("misc.cureMessage"));
            return;
        }
    }

    @EventHandler
    public void onPotionSplash(PotionSplashEvent potionSplashEvent) {
        if (potionSplashEvent.getPotion().getItem().hasItemMeta() && potionSplashEvent.getPotion().getItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.plagueCureKey, PersistentDataType.BYTE)) {
            for (LivingEntity livingEntity : potionSplashEvent.getAffectedEntities()) {
                if (!BlackPlague.time.containsKey(livingEntity.getUniqueId())) continue;
                BlackPlague.cureEntity(livingEntity);
                if (!(livingEntity instanceof Player)) continue;
                livingEntity.sendMessage(ChatColor.GREEN + Languages.getString("misc.cureMessage"));
            }
        }
    }

    @EventHandler
    public void onTradeAquire(VillagerAcquireTradeEvent villagerAcquireTradeEvent) {
        if (villagerAcquireTradeEvent.getEntity() instanceof WanderingTrader) {
            return;
        }
        if (((Villager)villagerAcquireTradeEvent.getEntity()).getProfession() == Villager.Profession.LIBRARIAN && ((Villager)villagerAcquireTradeEvent.getEntity()).getVillagerLevel() >= 3 && this.rand.nextDouble() * 100.0 < this.plugin.getConfig().getDouble("customitems.items.basic_coating_book.librarian_trade_chance")) {
            MerchantRecipe merchantRecipe = new MerchantRecipe(ItemsHandler.basicBook, this.rand.nextInt(3) + 1);
            merchantRecipe.addIngredient(new ItemStack(Material.EMERALD, this.rand.nextInt(60) + 5));
            merchantRecipe.addIngredient(new ItemStack(Material.BOOK, 1));
            merchantRecipe.setVillagerExperience(20);
            villagerAcquireTradeEvent.setRecipe(merchantRecipe);
            return;
        }
        if (((Villager)villagerAcquireTradeEvent.getEntity()).getProfession() == Villager.Profession.CLERIC && this.rand.nextDouble() * 100.0 < this.plugin.getConfig().getDouble("customitems.items.plague_cure.cleric_trade_chance")) {
            MerchantRecipe merchantRecipe = new MerchantRecipe(ItemsHandler.plagueCure, this.rand.nextInt(5) + 8);
            if (this.rand.nextInt(5) == 0) {
                merchantRecipe = new MerchantRecipe(ItemsHandler.plagueCureSplash, this.rand.nextInt(5) + 8);
            }
            merchantRecipe.addIngredient(new ItemStack(Material.EMERALD, this.rand.nextInt(6) + 3));
            if (this.rand.nextInt(3) == 0) {
                merchantRecipe.addIngredient(new ItemStack(Material.INK_SAC, this.rand.nextInt(3) + 1));
            }
            merchantRecipe.setVillagerExperience(10);
            villagerAcquireTradeEvent.setRecipe(merchantRecipe);
            return;
        }
    }

    @EventHandler
    public void onPortal(EntityPortalEnterEvent entityPortalEnterEvent) {
        if (entityPortalEnterEvent.getEntity().hasMetadata("dd-endstormentity")) {
            entityPortalEnterEvent.getEntity().remove();
        }
    }

    @EventHandler
    public void onBurn(EntityCombustEvent entityCombustEvent) {
        if (entityCombustEvent.getEntity().hasMetadata("dd-unburnable")) {
            entityCombustEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onExplode(EntityExplodeEvent entityExplodeEvent) {
        Object object2;
        for (Object object2 : entityExplodeEvent.blockList()) {
            if (!Santa.snowGlobeBlocks.contains(object2) && !EasterBunny.easterBasketBlocks.contains(object2) && !PumpkinKing.pumpkinBasketBlocks.contains(object2)) continue;
            entityExplodeEvent.blockList().remove(object2);
        }
        if (!fireBalls.containsKey(entityExplodeEvent.getEntity())) {
            return;
        }
        object2 = fireBalls.get(entityExplodeEvent.getEntity());
        for (Block block : entityExplodeEvent.blockList()) {
            if (Utils.isZoneProtected(block.getLocation()) || Utils.passStrengthTest(block.getType())) continue;
            ((DisasterEvent)object2).addBlockWithTopToList(block, block.getState());
            if (this.plugin.CProtect) {
                Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
            }
            block.setType(Material.AIR);
        }
        entityExplodeEvent.blockList().clear();
    }

    @EventHandler
    public void worldInit(WorldInitEvent worldInitEvent) {
        if (!WorldObject.yamlFile.getKeys(false).contains(worldInitEvent.getWorld().getName())) {
            this.plugin.createWorldSection(worldInitEvent.getWorld().getName(), WorldObject.yamlFile);
            WorldObject.saveYamlFile(this.plugin);
        }
        WorldObject.worlds.add(new WorldObject(worldInitEvent.getWorld(), this.plugin));
        if (!this.plugin.dataFile.contains("timers." + worldInitEvent.getWorld().getUID())) {
            this.plugin.dataFile.createSection("timers." + worldInitEvent.getWorld().getUID());
        }
        this.plugin.saveDataFile();
        if (!this.tc.timer.containsKey(worldInitEvent.getWorld().getUID())) {
            this.tc.timer.put(worldInitEvent.getWorld().getUID(), new HashMap());
        }
    }

    @EventHandler
    public void onTeleport(final PlayerTeleportEvent playerTeleportEvent) {
        if (playerTeleportEvent.getFrom().getWorld().equals(playerTeleportEvent.getTo().getWorld())) {
            return;
        }
        final WorldObject worldObject = WorldObject.findWorldObject(playerTeleportEvent.getTo().getWorld());
        if (worldSwap && (nonOpMsg || playerTeleportEvent.getPlayer().isOp())) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    String string = Utils.chat("&c&l" + Languages.getString("internal.offWord"));
                    if (worldObject.naturalAllowed) {
                        string = Utils.chat("&a&l" + Languages.getString("internal.onWord"));
                    }
                    playerTeleportEvent.getPlayer().sendMessage(Utils.chat(String.valueOf(worldMessage.replace("%difficulty%", worldObject.difficulty.getLabel()).replace("%world%", playerTeleportEvent.getTo().getWorld().getName())) + "\n&3- " + Languages.getString("internal.random_disasters") + ": " + string + "\n&3- " + Languages.getString("internal.min_timer") + ": &6" + worldObject.timer + " &7/ &3" + Languages.getString("internal.offset") + ": &6" + worldObject.offset + "\n&3- " + Languages.getString("internal.levelWord") + ": &a" + worldObject.table[0] + "% &2" + worldObject.table[1] + "% &b" + worldObject.table[2] + "% &e" + worldObject.table[3] + "% &c" + worldObject.table[4] + "% &4" + worldObject.table[5] + "%"));
                    playerTeleportEvent.getPlayer().playSound(playerTeleportEvent.getPlayer().getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.3f, 1.0f);
                }
            }, 10L);
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent playerKickEvent) {
        if (playerKickEvent.getReason().equals("Flying is not enabled on this server") && playerKickEvent.getPlayer().isOp()) {
            this.warnForKick.add(playerKickEvent.getPlayer().getUniqueId());
        }
    }

    public static void reload(Main main) {
        worldSwap = main.getConfig().getBoolean("messages.misc.world_messages.allow_world_messages");
        nonOpMsg = main.getConfig().getBoolean("messages.misc.world_messages.show_world_messages_to_not_opped");
        worldMessage = Utils.chat(String.valueOf(Languages.prefix) + main.getConfig().getString("messages.misc.world_messages.message"));
    }
}

