/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.listeners;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.entities.christmasentities.ElfPet;
import deadlydisasters.entities.halloweenentities.Ghoul;
import deadlydisasters.entities.soulstormentities.TamedLostSoul;
import deadlydisasters.events.DisasterEvent;
import deadlydisasters.events.disasters.Monsoon;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.listeners.ArmorListener;
import deadlydisasters.listeners.customevents.ArmorEquipEvent;
import deadlydisasters.listeners.customevents.ArmorUnequipEvent;
import deadlydisasters.utils.AsyncRepeatingTask;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Trident;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockVector;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class CustomEnchantHandler
implements Listener {
    private Main plugin;
    private Random rand;
    private Map<UUID, Integer> ancientBladeCooldownMap = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> soulRipperCooldownMap = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> poseidonsTridentCooldown = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> bloodPactCooldown = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> etheralLanternCooldown = new HashMap<UUID, Integer>();
    private Map<UUID, Object[]> bloodPactFangMap = new HashMap<UUID, Object[]>();
    private int ancientCurseFireTicks;
    private int ancientCurseLifeTicks;
    private int ancientCurseParticleCount;
    private int[] yetisBlessingRange;
    private int[] yetisBlessingChance;
    private int[] poseidonsTridentRange;
    private double bunnyHopMultiplier;
    private boolean bunnyHopParticles;
    private int etherealLanternLifeTicks;
    private int etherealLanternGhoulCount;
    private String yetisBlessing;
    private String bloodSacrifice;
    public static Map<UUID, ElfPet[]> santaHatPlayers = new HashMap<UUID, ElfPet[]>();
    private Set<UUID> bunnyHopPlayers = new HashSet<UUID>();
    private Set<UUID> hoppingPlayers = new HashSet<UUID>();

    public CustomEnchantHandler(final Main main) {
        this.plugin = main;
        this.rand = main.random;
        this.reload();
        for (Player player : main.getServer().getOnlinePlayers()) {
            ItemStack itemStack = player.getEquipment().getHelmet();
            if (itemStack != null && itemStack.hasItemMeta() && itemStack.getItemMeta().getPersistentDataContainer().has(ItemsHandler.santaHatKey, PersistentDataType.INTEGER)) {
                santaHatPlayers.put(player.getUniqueId(), null);
            }
            if ((itemStack = player.getEquipment().getBoots()) == null || !itemStack.hasItemMeta() || !itemStack.getItemMeta().getPersistentDataContainer().has(ItemsHandler.bunnyHopKey, PersistentDataType.BYTE)) continue;
            this.bunnyHopPlayers.add(player.getUniqueId());
        }
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
        main.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)main, new Runnable(){

            @Override
            public void run() {
                Map.Entry<UUID, Integer> entry;
                Iterator<Map.Entry<UUID, Integer>> iterator = CustomEnchantHandler.this.ancientBladeCooldownMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    entry.setValue(entry.getValue() - 1);
                    if (entry.getValue() > 0) continue;
                    iterator.remove();
                }
                iterator = CustomEnchantHandler.this.soulRipperCooldownMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    entry.setValue(entry.getValue() - 1);
                    if (entry.getValue() > 0) continue;
                    iterator.remove();
                }
                iterator = CustomEnchantHandler.this.poseidonsTridentCooldown.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    entry.setValue(entry.getValue() - 1);
                    if (entry.getValue() > 0) continue;
                    iterator.remove();
                }
                iterator = CustomEnchantHandler.this.bloodPactCooldown.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    entry.setValue(entry.getValue() - 1);
                    if (entry.getValue() > 0) continue;
                    iterator.remove();
                }
                iterator = CustomEnchantHandler.this.etheralLanternCooldown.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    entry.setValue(entry.getValue() - 1);
                    if (entry.getValue() > 0) continue;
                    iterator.remove();
                }
                entry = DisasterEvent.countdownMap.entrySet().iterator();
                while (entry.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)entry.next();
                    Iterator iterator2 = ((Map)entry2.getValue()).entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry3 = iterator2.next();
                        entry3.setValue((Integer)entry3.getValue() - 1);
                        if ((Integer)entry3.getValue() > 0) continue;
                        iterator2.remove();
                        if (!((Map)entry2.getValue()).isEmpty()) continue;
                        entry.remove();
                    }
                }
            }
        }, 0L, 20L);
        new RepeatingTask(main, 0, 20){

            @Override
            public void run() {
                Object object;
                Player player;
                Object object2;
                Iterator<Map.Entry<UUID, ElfPet[]>> iterator = santaHatPlayers.entrySet().iterator();
                block0: while (iterator.hasNext()) {
                    int n;
                    Object object3;
                    int n2;
                    Object object4;
                    object2 = iterator.next();
                    player = main.getServer().getPlayer((UUID)object2.getKey());
                    if (player == null || !player.isOnline()) {
                        if (object2.getValue() != null) {
                            object4 = (ElfPet[])object2.getValue();
                            n2 = ((ElfPet[])object4).length;
                            int n3 = 0;
                            while (n3 < n2) {
                                object = object4[n3];
                                if (object != null && ((CustomEntity)object).getEntity() != null) {
                                    ((CustomEntity)object).getEntity().remove();
                                }
                                ++n3;
                            }
                        }
                        iterator.remove();
                        continue;
                    }
                    object = player.getEquipment().getHelmet();
                    if (object == null || !object.hasItemMeta() || !object.getItemMeta().getPersistentDataContainer().has(ItemsHandler.santaHatKey, PersistentDataType.INTEGER)) {
                        if (object2.getValue() != null) {
                            ElfPet[] elfPetArray = (ElfPet[])object2.getValue();
                            int n4 = elfPetArray.length;
                            n2 = 0;
                            while (n2 < n4) {
                                ElfPet elfPet = elfPetArray[n2];
                                if (elfPet != null && elfPet.getEntity() != null) {
                                    elfPet.getEntity().remove();
                                }
                                ++n2;
                            }
                        }
                        iterator.remove();
                        continue;
                    }
                    ItemMeta itemMeta = object.getItemMeta();
                    n2 = (Integer)itemMeta.getPersistentDataContainer().get(ItemsHandler.santaHatKey, PersistentDataType.INTEGER);
                    if (object2.getValue() == null) {
                        if (n2 <= 0) {
                            n2 = ItemsHandler.santaHatCooldown;
                        } else if (n2 == 1) {
                            itemMeta.getPersistentDataContainer().set(ItemsHandler.santaHatKey, PersistentDataType.INTEGER, (Object)0);
                            object.setItemMeta(itemMeta);
                            object4 = new ElfPet[]{main.handler.addEntity(new ElfPet((Zombie)player.getWorld().spawnEntity(player.getLocation(), EntityType.ZOMBIE), main, CustomEnchantHandler.this.rand, player.getUniqueId(), false)), main.handler.addEntity(new ElfPet((Zombie)player.getWorld().spawnEntity(player.getLocation(), EntityType.ZOMBIE), main, CustomEnchantHandler.this.rand, player.getUniqueId(), false)), main.handler.addEntity(new ElfPet((Zombie)player.getWorld().spawnEntity(player.getLocation(), EntityType.ZOMBIE), main, CustomEnchantHandler.this.rand, player.getUniqueId(), true))};
                            object3 = object4;
                            int n5 = ((Object)object3).length;
                            n = 0;
                            while (n < n5) {
                                ElfPet elfPet = object3[n];
                                main.handler.addEntity(elfPet);
                                ++n;
                            }
                            object2.setValue(object4);
                            continue;
                        }
                        itemMeta.getPersistentDataContainer().set(ItemsHandler.santaHatKey, PersistentDataType.INTEGER, (Object)(n2 - 1));
                        object.setItemMeta(itemMeta);
                        continue;
                    }
                    ElfPet[] elfPetArray = (ElfPet[])object2.getValue();
                    n = elfPetArray.length;
                    int n6 = 0;
                    while (n6 < n) {
                        object4 = elfPetArray[n6];
                        if (((CustomEntity)object4).getEntity() == null || ((CustomEntity)object4).getEntity().isDead()) {
                            if (n2 <= 0) {
                                n2 = ItemsHandler.santaHatCooldown;
                            } else if (n2 == 1) {
                                object3 = (ElfPet[])object2.getValue();
                                int n7 = 0;
                                while (n7 < 3) {
                                    if (object3[n7].getEntity() == null || object3[n7].getEntity().isDead()) {
                                        object3[n7] = n7 == 2 ? main.handler.addEntity(new ElfPet((Zombie)player.getWorld().spawnEntity(player.getLocation(), EntityType.ZOMBIE), main, CustomEnchantHandler.this.rand, player.getUniqueId(), true)) : main.handler.addEntity(new ElfPet((Zombie)player.getWorld().spawnEntity(player.getLocation(), EntityType.ZOMBIE), main, CustomEnchantHandler.this.rand, player.getUniqueId(), false));
                                    }
                                    ++n7;
                                }
                            }
                            itemMeta.getPersistentDataContainer().set(ItemsHandler.santaHatKey, PersistentDataType.INTEGER, (Object)(n2 - 1));
                            object.setItemMeta(itemMeta);
                            continue block0;
                        }
                        ++n6;
                    }
                }
                object2 = CustomEnchantHandler.this.bunnyHopPlayers.iterator();
                while (object2.hasNext()) {
                    player = Bukkit.getPlayer((UUID)((UUID)object2.next()));
                    if (player == null || !player.isOnline()) {
                        object2.remove();
                        continue;
                    }
                    object = player.getEquipment().getBoots();
                    if (object == null || !object.hasItemMeta() || !object.getItemMeta().getPersistentDataContainer().has(ItemsHandler.bunnyHopKey, PersistentDataType.BYTE)) {
                        if (!Utils.isPlayerImmune(player)) {
                            player.setAllowFlight(false);
                        }
                        object2.remove();
                        continue;
                    }
                    if (CustomEnchantHandler.this.hoppingPlayers.contains(player.getUniqueId())) continue;
                    player.setAllowFlight(true);
                }
            }
        };
        new RepeatingTask(main, 0, 1){

            @Override
            public void run() {
                if (!CustomEnchantHandler.this.bunnyHopParticles) {
                    return;
                }
                for (UUID uUID : CustomEnchantHandler.this.bunnyHopPlayers) {
                    Player player = (Player)Bukkit.getEntity((UUID)uUID);
                    if (player == null || player.isDead()) continue;
                    int n = 0;
                    while (n < 2) {
                        Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)(CustomEnchantHandler.this.rand.nextInt(125) + 25), (int)255, (int)(CustomEnchantHandler.this.rand.nextInt(55) + 25)), Color.fromRGB((int)25, (int)(CustomEnchantHandler.this.rand.nextInt(155) + 100), (int)255), CustomEnchantHandler.this.rand.nextFloat());
                        if (CustomEnchantHandler.this.rand.nextInt(2) == 0) {
                            dustTransition = new Particle.DustTransition(Color.fromRGB((int)(CustomEnchantHandler.this.rand.nextInt(105) + 150), (int)25, (int)255), Color.fromRGB((int)25, (int)(CustomEnchantHandler.this.rand.nextInt(155) + 100), (int)255), CustomEnchantHandler.this.rand.nextFloat());
                        }
                        player.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, player.getLocation().add(CustomEnchantHandler.this.rand.nextDouble() / 1.2 - 0.4, 0.1 + (CustomEnchantHandler.this.rand.nextDouble() / 3.0 - 0.15), CustomEnchantHandler.this.rand.nextDouble() / 1.2 - 0.4), 1, 0.0, 0.0, 0.0, 0.001, (Object)dustTransition);
                        ++n;
                    }
                }
            }
        };
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        ItemStack itemStack = player.getEquipment().getHelmet();
        if (itemStack != null && itemStack.hasItemMeta() && itemStack.getItemMeta().getPersistentDataContainer().has(ItemsHandler.santaHatKey, PersistentDataType.INTEGER)) {
            santaHatPlayers.put(player.getUniqueId(), null);
        }
        if ((itemStack = player.getEquipment().getBoots()) != null && itemStack.hasItemMeta() && itemStack.getItemMeta().getPersistentDataContainer().has(ItemsHandler.bunnyHopKey, PersistentDataType.BYTE)) {
            this.bunnyHopPlayers.add(player.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent playerQuitEvent) {
        UUID uUID = playerQuitEvent.getPlayer().getUniqueId();
        if (santaHatPlayers.containsKey(uUID)) {
            if (santaHatPlayers.get(uUID) != null) {
                ElfPet[] elfPetArray = santaHatPlayers.get(uUID);
                int n = elfPetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ElfPet elfPet = elfPetArray[n2];
                    if (elfPet != null && elfPet.getEntity() != null) {
                        elfPet.getEntity().remove();
                    }
                    ++n2;
                }
            }
            santaHatPlayers.remove(uUID);
        }
        this.bunnyHopPlayers.remove(uUID);
        this.hoppingPlayers.remove(uUID);
    }

    @EventHandler
    public void onArmorEquip(ArmorEquipEvent armorEquipEvent) {
        if (armorEquipEvent.getSlot() == ArmorListener.ArmorSlot.HEAD && armorEquipEvent.getItem().hasItemMeta() && armorEquipEvent.getItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.santaHatKey, PersistentDataType.INTEGER)) {
            santaHatPlayers.put(armorEquipEvent.getPlayer().getUniqueId(), null);
        }
        if (armorEquipEvent.getSlot() == ArmorListener.ArmorSlot.FEET && armorEquipEvent.getItem().hasItemMeta() && armorEquipEvent.getItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.bunnyHopKey, PersistentDataType.BYTE)) {
            this.bunnyHopPlayers.add(armorEquipEvent.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onArmorUnequip(ArmorUnequipEvent armorUnequipEvent) {
        if (armorUnequipEvent.getSlot() == ArmorListener.ArmorSlot.FEET && armorUnequipEvent.getItem().hasItemMeta() && armorUnequipEvent.getItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.bunnyHopKey, PersistentDataType.BYTE)) {
            this.bunnyHopPlayers.remove(armorUnequipEvent.getPlayer().getUniqueId());
            this.hoppingPlayers.remove(armorUnequipEvent.getPlayer().getUniqueId());
            if (!Utils.isPlayerImmune(armorUnequipEvent.getPlayer())) {
                armorUnequipEvent.getPlayer().setAllowFlight(false);
            }
        }
    }

    @EventHandler
    public void onAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        ItemMeta itemMeta;
        Object object;
        Object object2;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        if (this.bloodPactFangMap.containsKey(entityDamageByEntityEvent.getDamager().getUniqueId())) {
            entityDamageByEntityEvent.setDamage(0.0);
            LivingEntity livingEntity = (LivingEntity)Bukkit.getEntity((UUID)((UUID)this.bloodPactFangMap.get(entityDamageByEntityEvent.getDamager().getUniqueId())[0]));
            if (livingEntity != null && !livingEntity.isDead()) {
                ItemStack itemStack = (ItemStack)this.bloodPactFangMap.get(entityDamageByEntityEvent.getDamager().getUniqueId())[2];
                int n = Utils.levelOfEnchant(ChatColor.RED + this.bloodSacrifice, itemStack);
                double d = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 100.0 * this.plugin.getConfig().getDouble("customitems.enchants.blood_sacrifice.level " + n + ".lifeTake") / 100.0 * (Double)this.bloodPactFangMap.get(entityDamageByEntityEvent.getDamager().getUniqueId())[1];
                if (!(livingEntity instanceof Player) || !Utils.isPlayerImmune((Player)livingEntity)) {
                    if (d >= livingEntity.getHealth()) {
                        d = livingEntity.getHealth();
                    }
                    Utils.pureDamageEntity(livingEntity, d, "dd-bloodsacrificesuicide", n >= 3, null);
                    livingEntity.getWorld().spawnParticle(Particle.BLOCK_CRACK, livingEntity.getLocation().add(0.0, livingEntity.getHeight() / 2.0, 0.0), 50, 0.2, livingEntity.getHeight() / 2.0, 0.2, 1.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
                    Utils.damageItem(itemStack, 20);
                }
                if (!(entityDamageByEntityEvent.getEntity() instanceof Player) || !Utils.isPlayerImmune((Player)entityDamageByEntityEvent.getEntity())) {
                    entityDamageByEntityEvent.getEntity().getWorld().spawnParticle(Particle.BLOCK_CRACK, entityDamageByEntityEvent.getEntity().getLocation().add(0.0, entityDamageByEntityEvent.getEntity().getHeight() / 2.0, 0.0), 50, 0.2, entityDamageByEntityEvent.getEntity().getHeight() / 2.0, 0.2, 1.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
                    Utils.damageEntity((LivingEntity)entityDamageByEntityEvent.getEntity(), d * this.plugin.getConfig().getDouble("customitems.enchants.blood_sacrifice.level " + n + ".damage"), "dd-bloodsacrifice", n >= 3);
                }
                if (entityDamageByEntityEvent.getEntity().isDead() && n < 3) {
                    ItemMeta itemMeta2;
                    int n2 = (Integer)itemStack.getItemMeta().getPersistentDataContainer().get(ItemsHandler.bloodPactKey, PersistentDataType.INTEGER) + 1;
                    if (n2 == 25) {
                        Utils.upgradeEnchantLevel(itemStack, ChatColor.RED + this.bloodSacrifice, 3);
                        itemMeta2 = itemStack.getItemMeta();
                        itemMeta2.setCustomModelData(Integer.valueOf(100018));
                        itemStack.setItemMeta(itemMeta2);
                    } else if (n2 == 50) {
                        itemMeta2 = itemStack.getItemMeta();
                        itemMeta2.setDisplayName(ChatColor.DARK_RED + Languages.getString("items.awakenedBloodPact"));
                        itemMeta2.setLore(Utils.chopLore(Arrays.asList(ChatColor.RED + Languages.getString("misc.bloodSacrifice") + " III", " ", ChatColor.YELLOW + Languages.getString("items.awakenedBloodPactLore"))));
                        itemMeta2.addEnchant(Enchantment.DAMAGE_ALL, 2, false);
                        itemMeta2.setCustomModelData(Integer.valueOf(100019));
                        itemStack.setItemMeta(itemMeta2);
                    }
                    itemMeta2 = itemStack.getItemMeta();
                    itemMeta2.getPersistentDataContainer().set(ItemsHandler.bloodPactKey, PersistentDataType.INTEGER, (Object)n2);
                    itemStack.setItemMeta(itemMeta2);
                }
            }
            this.bloodPactFangMap.remove(entityDamageByEntityEvent.getDamager().getUniqueId());
            return;
        }
        if (entityDamageByEntityEvent.getDamager().hasMetadata("dd-elfarrow") && entityDamageByEntityEvent.getEntity().hasMetadata("dd-christmasmob")) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        if (entityDamageByEntityEvent.getDamager().hasMetadata("dd-petelfarrow") && (object2 = this.plugin.handler.findEntity((LivingEntity)((Arrow)entityDamageByEntityEvent.getDamager()).getShooter())) != null && (((UUID)(object = ((ElfPet)object2).owner)).equals(entityDamageByEntityEvent.getEntity().getUniqueId()) || santaHatPlayers.containsKey(object) && Stream.of(santaHatPlayers.get(object)).anyMatch(elfPet -> elfPet != null && elfPet.getEntity().getUniqueId().equals(entityDamageByEntityEvent.getEntity().getUniqueId())))) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        if (entityDamageByEntityEvent.getDamager().hasMetadata("dd-easterbunny") && entityDamageByEntityEvent.getEntity().hasMetadata("dd-eastermobs")) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        object2 = entityDamageByEntityEvent.getDamager();
        if (object2 instanceof Projectile && ((Projectile)object2).getShooter() instanceof LivingEntity) {
            object2 = (Entity)((Projectile)object2).getShooter();
        }
        if (object2 instanceof LivingEntity && entityDamageByEntityEvent.getEntity() instanceof LivingEntity && !entityDamageByEntityEvent.getEntity().equals(object2)) {
            int n;
            int n3;
            if (!(!santaHatPlayers.containsKey(object2.getUniqueId()) || santaHatPlayers.get(object2.getUniqueId()) == null || entityDamageByEntityEvent.getEntity() instanceof Tameable && ((Tameable)entityDamageByEntityEvent.getEntity()).getOwner().equals((Player)object2) || Stream.of(santaHatPlayers.get(object2.getUniqueId())).anyMatch(elfPet -> elfPet.getEntity() != null && elfPet.getEntity().getUniqueId().equals(entityDamageByEntityEvent.getEntity().getUniqueId())))) {
                itemMeta = santaHatPlayers.get(object2.getUniqueId());
                n3 = ((ElfPet[])itemMeta).length;
                n = 0;
                while (n < n3) {
                    object = itemMeta[n];
                    ((ElfPet)object).target = (LivingEntity)entityDamageByEntityEvent.getEntity();
                    ++n;
                }
            } else if (santaHatPlayers.containsKey(entityDamageByEntityEvent.getEntity().getUniqueId()) && santaHatPlayers.get(entityDamageByEntityEvent.getEntity().getUniqueId()) != null && !Stream.of(santaHatPlayers.get(entityDamageByEntityEvent.getEntity().getUniqueId())).anyMatch(elfPet -> elfPet != null && elfPet.getEntity().equals(entityDamageByEntityEvent.getDamager()))) {
                itemMeta = santaHatPlayers.get(entityDamageByEntityEvent.getEntity().getUniqueId());
                n3 = ((ElfPet[])itemMeta).length;
                n = 0;
                while (n < n3) {
                    object = itemMeta[n];
                    ((ElfPet)object).target = (LivingEntity)object2;
                    ++n;
                }
            }
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity) || !(entityDamageByEntityEvent.getDamager() instanceof LivingEntity)) {
            return;
        }
        object = (LivingEntity)entityDamageByEntityEvent.getEntity();
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getDamager();
        ItemStack itemStack = livingEntity.getEquipment().getItemInMainHand();
        if (itemStack.hasItemMeta()) {
            if (itemStack.getType() == Material.IRON_HOE) {
                if (CustomEntityType.TAMEDLOSTSOUL.canSpawn() && !this.soulRipperCooldownMap.containsKey(livingEntity.getUniqueId()) && itemStack.getItemMeta().hasLore() && (this.plugin.customNameSupport && ((String)itemStack.getItemMeta().getLore().get(0)).equals(ItemsHandler.soulRipperLore) || itemStack.getItemMeta().getPersistentDataContainer().has(ItemsHandler.soulRipperKey, PersistentDataType.BYTE))) {
                    if (!(livingEntity instanceof Player) || !Utils.isPlayerImmune((Player)livingEntity)) {
                        this.soulRipperCooldownMap.put(livingEntity.getUniqueId(), ItemsHandler.soulRipperCooldown);
                    }
                    this.spawnSouls(livingEntity.getLocation(), (LivingEntity)object);
                    if (livingEntity instanceof Player && !Utils.isPlayerImmune((Player)livingEntity)) {
                        itemMeta = itemStack.getItemMeta();
                        ((Damageable)itemMeta).setDamage(((Damageable)itemMeta).getDamage() + 10);
                        if (((Damageable)itemMeta).getDamage() >= itemStack.getType().getMaxDurability()) {
                            itemStack.setAmount(0);
                        } else {
                            itemStack.setItemMeta(itemMeta);
                        }
                    }
                }
            } else if (!this.bloodPactCooldown.containsKey(livingEntity.getUniqueId()) && itemStack.getItemMeta().getPersistentDataContainer().has(ItemsHandler.bloodPactKey, PersistentDataType.INTEGER) && object.getHealth() > entityDamageByEntityEvent.getFinalDamage() && Utils.getBlockBelow(object.getLocation()).getLocation().distanceSquared(object.getLocation()) <= 900.0) {
                if (!(livingEntity instanceof Player) || !Utils.isPlayerImmune((Player)livingEntity)) {
                    this.bloodPactCooldown.put(livingEntity.getUniqueId(), ItemsHandler.bloodPactCooldown);
                }
                this.createBloodWorm(Utils.getBlockBelow(object.getLocation()).getLocation().add(0.5, 0.5, 0.5), (LivingEntity)object, itemStack, livingEntity);
            }
        }
        if (CustomEntityType.GHOUL.canSpawn() && !this.etheralLanternCooldown.containsKey(livingEntity.getUniqueId()) && this.rand.nextDouble() < ItemsHandler.etherealLanternChance && livingEntity.getEquipment().getItemInOffHand().hasItemMeta() && livingEntity.getEquipment().getItemInOffHand().getItemMeta().getPersistentDataContainer().has(ItemsHandler.etherealLanternKey, PersistentDataType.BYTE)) {
            this.etheralLanternCooldown.put(livingEntity.getUniqueId(), ItemsHandler.etherealLanternCooldown);
            this.spawnGhouls(livingEntity, (LivingEntity)object);
        }
        if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && object.getEquipment().getChestplate() != null && Utils.levelOfEnchant(this.yetisBlessing, object.getEquipment().getChestplate()) > 0) {
            int n = Utils.levelOfEnchant(this.yetisBlessing, object.getEquipment().getChestplate());
            double[] dArray = new double[]{this.yetisBlessingChance[0], this.yetisBlessingRange[0]};
            if (n == 2) {
                dArray[0] = this.yetisBlessingChance[1];
                dArray[1] = this.yetisBlessingRange[1];
            } else if (n == 3) {
                dArray[0] = this.yetisBlessingChance[2];
                dArray[1] = this.yetisBlessingRange[2];
            }
            if ((double)this.rand.nextInt(100) < dArray[0]) {
                this.yetiRoar((LivingEntity)object, n, dArray);
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL && this.bunnyHopPlayers.contains(entityDamageEvent.getEntity().getUniqueId())) {
            if (entityDamageEvent.getEntity().getFallDistance() < 15.0f) {
                entityDamageEvent.setCancelled(true);
            } else {
                entityDamageEvent.setDamage(entityDamageEvent.getFinalDamage() / 2.5);
            }
            this.hoppingPlayers.remove(entityDamageEvent.getEntity().getUniqueId());
            ((Player)entityDamageEvent.getEntity()).setAllowFlight(true);
            return;
        }
    }

    @EventHandler
    public void onInteract(final PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getItem() == null || !playerInteractEvent.getItem().hasItemMeta()) {
            return;
        }
        if ((playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR || playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) && !this.ancientBladeCooldownMap.containsKey(playerInteractEvent.getPlayer().getUniqueId()) && playerInteractEvent.getItem().getItemMeta().hasLore() && (this.plugin.customNameSupport && ((String)playerInteractEvent.getItem().getItemMeta().getLore().get(0)).equals(ItemsHandler.ancientCurseName) || playerInteractEvent.getItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.ancientBladeKey, PersistentDataType.BYTE))) {
            if (playerInteractEvent.getPlayer() instanceof Player && !Utils.isPlayerImmune(playerInteractEvent.getPlayer())) {
                this.ancientBladeCooldownMap.put(playerInteractEvent.getPlayer().getUniqueId(), ItemsHandler.ancientBladeCooldown);
            }
            final int[] nArray = new int[]{this.ancientCurseLifeTicks};
            final Vector vector = playerInteractEvent.getPlayer().getEyeLocation().getDirection().clone();
            final Location location = playerInteractEvent.getPlayer().getEyeLocation().clone().add(vector.clone().multiply(2));
            playerInteractEvent.getPlayer().getWorld().playSound(location, Sound.ITEM_FIRECHARGE_USE, SoundCategory.PLAYERS, 1.0f, 0.6f);
            final World world = location.getWorld();
            final BlockData blockData = Material.SAND.createBlockData();
            new RepeatingTask(this.plugin, 0, 1){

                @Override
                public void run() {
                    if (nArray[0] <= 0) {
                        this.cancel();
                        return;
                    }
                    nArray[0] = nArray[0] - 1;
                    location.add(vector);
                    world.spawnParticle(Particle.FLAME, location, CustomEnchantHandler.this.ancientCurseParticleCount, 1.0, 1.0, 1.0, 0.05);
                    world.spawnParticle(Particle.BLOCK_DUST, location, CustomEnchantHandler.this.ancientCurseParticleCount, 1.0, 1.0, 1.0, 0.1, (Object)blockData);
                    for (Entity entity : location.getWorld().getNearbyEntities(location, 1.5, 1.5, 1.5)) {
                        if (!(entity instanceof LivingEntity) || entity.equals(playerInteractEvent.getPlayer())) continue;
                        entity.setFireTicks(CustomEnchantHandler.this.ancientCurseFireTicks);
                        entity.setVelocity(vector.clone().multiply(0.5));
                    }
                }
            };
        }
    }

    @EventHandler
    public void onShoot(ProjectileLaunchEvent projectileLaunchEvent) {
        if (projectileLaunchEvent.isCancelled()) {
            return;
        }
        if (projectileLaunchEvent.getEntityType() == EntityType.TRIDENT && projectileLaunchEvent.getEntity().getShooter() instanceof LivingEntity && ((Trident)projectileLaunchEvent.getEntity()).getItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.poseidonsTridentKey, PersistentDataType.BYTE) && !this.poseidonsTridentCooldown.containsKey(((LivingEntity)projectileLaunchEvent.getEntity().getShooter()).getUniqueId())) {
            LivingEntity livingEntity = (LivingEntity)projectileLaunchEvent.getEntity().getShooter();
            if (livingEntity instanceof Player && !Utils.isPlayerImmune((Player)livingEntity)) {
                this.poseidonsTridentCooldown.put(livingEntity.getUniqueId(), ItemsHandler.poseidonsTridentCooldown);
            }
            this.castWaveSpell(livingEntity.getLocation(), projectileLaunchEvent.getEntity().getVelocity().normalize(), this.poseidonsTridentRange[0], this.rand, livingEntity);
        }
    }

    @EventHandler
    public void onToggleFlight(PlayerToggleFlightEvent playerToggleFlightEvent) {
        if (this.bunnyHopPlayers.contains(playerToggleFlightEvent.getPlayer().getUniqueId()) && !this.hoppingPlayers.contains(playerToggleFlightEvent.getPlayer().getUniqueId()) && !Utils.isPlayerImmune(playerToggleFlightEvent.getPlayer())) {
            final Player player = playerToggleFlightEvent.getPlayer();
            playerToggleFlightEvent.setCancelled(true);
            player.setAllowFlight(false);
            player.setFlying(false);
            player.setVelocity(playerToggleFlightEvent.getPlayer().getLocation().getDirection().multiply(1.25).setY(0.8).multiply(this.bunnyHopMultiplier));
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_RABBIT_JUMP, SoundCategory.PLAYERS, 20.0f, 0.8f);
            player.setFallDistance(10.0f);
            this.hoppingPlayers.add(player.getUniqueId());
            new RepeatingTask(this.plugin, 5, 1){

                @Override
                public void run() {
                    if (player == null || !player.isOnline() || player.isDead() || Utils.isPlayerImmune(player) || !CustomEnchantHandler.this.hoppingPlayers.contains(player.getUniqueId()) || player.isOnGround()) {
                        this.cancel();
                        CustomEnchantHandler.this.hoppingPlayers.remove(player.getUniqueId());
                        return;
                    }
                }
            };
            return;
        }
    }

    public void reload() {
        this.ancientCurseFireTicks = this.plugin.getConfig().getInt("customitems.enchants.ancient_curse.fire_ticks");
        this.ancientCurseLifeTicks = this.plugin.getConfig().getInt("customitems.enchants.ancient_curse.spell_life_ticks");
        this.ancientCurseParticleCount = this.plugin.getConfig().getInt("customitems.enchants.ancient_curse.particle_count");
        this.yetisBlessing = Languages.getString("misc.yetiBlessing");
        this.yetisBlessingRange = new int[]{this.plugin.getConfig().getInt("customitems.enchants.yetis_blessing.level 1.range"), this.plugin.getConfig().getInt("customitems.enchants.yetis_blessing.level 2.range"), this.plugin.getConfig().getInt("customitems.enchants.yetis_blessing.level 3.range")};
        this.yetisBlessingChance = new int[]{this.plugin.getConfig().getInt("customitems.enchants.yetis_blessing.level 1.chance") - 1, this.plugin.getConfig().getInt("customitems.enchants.yetis_blessing.level 2.chance") - 1, this.plugin.getConfig().getInt("customitems.enchants.yetis_blessing.level 3.chance") - 1};
        this.poseidonsTridentRange = new int[]{this.plugin.getConfig().getInt("customitems.enchants.tidal_wave.level 1.range")};
        this.bloodSacrifice = Languages.getString("misc.bloodSacrifice");
        this.bunnyHopMultiplier = this.plugin.getConfig().getDouble("customitems.enchants.bunny_hop.level 1.jump_multiplier");
        this.bunnyHopParticles = this.plugin.getConfig().getBoolean("customitems.enchants.bunny_hop.level 1.particles");
        this.etherealLanternLifeTicks = this.plugin.getConfig().getInt("customitems.items.ethereal_lantern.ghoul_life_ticks");
        this.etherealLanternGhoulCount = this.plugin.getConfig().getInt("customitems.items.ethereal_lantern.amount_of_ghouls");
    }

    private void spawnSouls(Location location, LivingEntity livingEntity) {
        final LivingEntity[] livingEntityArray = new LivingEntity[ItemsHandler.soulRipperNumberOfSouls];
        int n = 0;
        while (n < ItemsHandler.soulRipperNumberOfSouls) {
            Location location2 = location.clone().add((double)(this.rand.nextInt(10) - 5), 0.0, (double)(this.rand.nextInt(10) - 5));
            location2 = location2.getBlock().isPassable() ? Utils.getBlockBelow(location2).getLocation().clone().add(0.5, 0.5, 0.5) : Utils.getBlockAbove(location2).getLocation().clone().add(0.5, 0.5, 0.5);
            Mob mob = (Mob)location.getWorld().spawnEntity(location2, EntityType.VEX);
            this.plugin.handler.addEntity(new TamedLostSoul(mob, this.plugin, this.rand, livingEntity));
            livingEntityArray[n] = mob;
            location2.getWorld().spawnParticle(Particle.SQUID_INK, location2.clone().add(0.0, 0.75, 0.0), 20, 0.4, 0.4, 0.4, 1.0E-4);
            location2.getWorld().playSound(location2, Sound.ENTITY_ELDER_GUARDIAN_AMBIENT, SoundCategory.PLAYERS, 1.0f, 0.8f);
            location2.getWorld().playSound(location2, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, SoundCategory.PLAYERS, 0.3f, 1.5f);
            ++n;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                LivingEntity[] livingEntityArray2 = livingEntityArray;
                int n = livingEntityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LivingEntity livingEntity = livingEntityArray2[n2];
                    if (livingEntity != null) {
                        livingEntity.remove();
                    }
                    ++n2;
                }
            }
        }, (long)ItemsHandler.soulRipperSoulLifeTicks);
    }

    private void yetiRoar(final LivingEntity livingEntity, int n, final double[] dArray) {
        final Location location = livingEntity.getLocation().clone();
        final World world = location.getWorld();
        final BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
        final BlockData blockData = Material.PACKED_ICE.createBlockData();
        if (this.plugin.mcVersion >= 1.16) {
            world.playSound(location, Sound.BLOCK_RESPAWN_ANCHOR_SET_SPAWN, SoundCategory.HOSTILE, 0.33333334f * (float)n, 0.6f);
        }
        world.playSound(location, Sound.ENTITY_RAVAGER_ROAR, SoundCategory.HOSTILE, 0.6666667f * (float)n, 0.5f);
        final int[] nArray = new int[]{1};
        new RepeatingTask(this.plugin, 0, 5){

            @Override
            public void run() {
                nArray[0] = nArray[0] + 1;
                int n = -nArray[0];
                while (n < nArray[0]) {
                    int n2 = -nArray[0];
                    while (n2 < nArray[0]) {
                        block12: {
                            Block block;
                            block14: {
                                int n3;
                                block13: {
                                    Vector vector = blockVector.clone().add(new Vector(n, 0, n2));
                                    block = world.getBlockAt(vector.toLocation(world));
                                    if (!(blockVector.distance(vector) >= (double)(nArray[0] - 1)) || !(blockVector.distance(vector) <= (double)nArray[0])) break block12;
                                    if (!block.isPassable()) break block13;
                                    n3 = 0;
                                    while (n3 < 3) {
                                        if (!(block = block.getRelative(BlockFace.DOWN)).isPassable()) break;
                                        ++n3;
                                    }
                                    if (block.isPassable()) break block12;
                                    block = block.getRelative(BlockFace.UP);
                                    break block14;
                                }
                                n3 = 0;
                                while (n3 < 3) {
                                    if ((block = block.getRelative(BlockFace.UP)).isPassable()) break;
                                    ++n3;
                                }
                                if (!block.isPassable()) break block12;
                            }
                            world.spawnParticle(Particle.SNOW_SHOVEL, block.getLocation().clone().add(0.5, 0.5, 0.5), 20, 0.3, 0.5, 0.3, 0.001);
                            world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().clone().add(0.5, 0.5, 0.5), 3, 0.3, 0.5, 0.3, 0.001, (Object)blockData);
                            if (block.getType() == Material.FIRE) {
                                block.setType(Material.AIR);
                                world.playSound(block.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                world.spawnParticle(Particle.SMOKE_LARGE, block.getLocation().clone().add(0.5, 0.2, 0.5), 5, 0.3, 0.5, 0.3, 0.001, (Object)blockData);
                            }
                            if (CustomEnchantHandler.this.plugin.mcVersion >= 1.17) {
                                world.playSound(block.getLocation(), Sound.ENTITY_PLAYER_HURT_FREEZE, SoundCategory.HOSTILE, 0.5f, 0.5f);
                            } else {
                                world.playSound(block.getLocation(), Sound.BLOCK_GLASS_BREAK, SoundCategory.HOSTILE, 0.5f, 1.0f);
                            }
                            for (Entity entity : world.getNearbyEntities(block.getLocation().clone().add(0.5, 0.5, 0.5), 0.5, 1.0, 0.5)) {
                                if (entity.equals(livingEntity)) continue;
                                entity.setVelocity(new Vector(entity.getLocation().getX() - location.getX(), 0.0, entity.getLocation().getZ() - location.getZ()).normalize().multiply(0.2).setY(0.8));
                                if (!(entity instanceof LivingEntity) || entity instanceof Player && Utils.isPlayerImmune((Player)entity)) continue;
                                ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 7, true, false));
                                if (!(CustomEnchantHandler.this.plugin.mcVersion >= 1.17)) continue;
                                entity.setFreezeTicks(500);
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
                if ((double)nArray[0] >= dArray[1]) {
                    this.cancel();
                }
            }
        };
    }

    private void castWaveSpell(Location location, final Vector vector, int n, final Random random, final LivingEntity livingEntity) {
        final World world = location.getWorld();
        final int[] nArray = new int[]{n};
        final Vector vector2 = new Vector(vector.getZ(), 0.0, -vector.getX());
        final Location location2 = location.clone().add(vector.clone().multiply(2)).add(vector2.clone().multiply(-2));
        final Block[] blockArray = new Block[15];
        final ArrayDeque arrayDeque = new ArrayDeque();
        final ArrayDeque arrayDeque2 = new ArrayDeque();
        new RepeatingTask(this.plugin, 0, 2){

            @Override
            public void run() {
                Block block = blockArray;
                int n = ((Block[])block).length;
                int n2 = 0;
                while (n2 < n) {
                    Block block2 = block[n2];
                    if (block2 != null && block2.getType() == Material.WATER) {
                        world.spawnParticle(Particle.FALLING_WATER, block2.getLocation().add(0.5, 0.5, 0.5), 30, 0.5, 0.5, 0.5, 1.0E-4);
                        if (random.nextInt(4) == 0 && block2.getRelative(BlockFace.DOWN).getType().isSolid()) {
                            arrayDeque2.add(block2);
                            arrayDeque.remove(block2);
                            Levelled levelled = (Levelled)block2.getBlockData();
                            levelled.setLevel(7);
                            block2.setBlockData((BlockData)levelled);
                            Monsoon.globalPuddles.add(block2);
                        } else {
                            block2.setType(Material.AIR);
                        }
                    }
                    ++n2;
                }
                if (nArray[0] <= 0) {
                    for (Block block2 : arrayDeque) {
                        if (block2 == null) continue;
                        block2.setType(Material.AIR);
                    }
                    if (nArray[0] <= -10) {
                        this.cancel();
                        new RepeatingTask(CustomEnchantHandler.this.plugin, 60, 1){

                            @Override
                            public void run() {
                                Block block;
                                if (arrayDeque2.isEmpty()) {
                                    this.cancel();
                                }
                                if ((block = (Block)arrayDeque2.poll()) != null && block.getType() == Material.WATER) {
                                    block.setType(Material.AIR);
                                }
                                Monsoon.globalPuddles.remove(block);
                            }
                        };
                    }
                    nArray[0] = nArray[0] - 1;
                    return;
                }
                nArray[0] = nArray[0] - 1;
                int n3 = 0;
                while (n3 < 3) {
                    Location location = location2.clone().add(vector.clone().multiply(n3)).add(0.0, (double)n3, 0.0);
                    n = 0;
                    while (n < 5) {
                        block = location.clone().add(vector2.clone().multiply(n)).getBlock();
                        if (block.getType() == Material.AIR && !Utils.isZoneProtected(block.getLocation())) {
                            arrayDeque.add(block);
                            world.spawnParticle(Particle.BUBBLE_POP, block.getLocation().add(0.5, 0.5, 0.5), 10, 0.5, 0.5, 0.5, 1.0E-4);
                            block.setType(Material.WATER);
                            blockArray[n + n3 * 5] = block;
                            for (Levelled levelled : world.getNearbyEntities(block.getLocation(), 0.5, 0.5, 0.5)) {
                                if (levelled.equals(livingEntity)) continue;
                                levelled.setVelocity(vector);
                                if (!(levelled instanceof LivingEntity) || levelled instanceof Player && Utils.isPlayerImmune((Player)levelled)) continue;
                                ((LivingEntity)levelled).damage(4.0);
                            }
                        }
                        ++n;
                    }
                    ++n3;
                }
                location2.add(vector);
                world.playSound(location2, Sound.WEATHER_RAIN, SoundCategory.HOSTILE, 1.0f, 0.75f);
            }
        };
    }

    public void createBloodWorm(Location location, final LivingEntity livingEntity, final ItemStack itemStack, final LivingEntity livingEntity2) {
        final FallingBlock[] fallingBlockArray = new FallingBlock[30];
        final ArmorStand[] armorStandArray = new ArmorStand[16];
        final int[] nArray = new int[3];
        final double[] dArray = new double[]{0.0};
        final Location location2 = location.clone();
        final BlockData blockData = Material.REDSTONE_BLOCK.createBlockData();
        final World world = location2.getWorld();
        final EvokerFangs[] evokerFangsArray = new EvokerFangs[]{(EvokerFangs)world.spawnEntity(livingEntity.getLocation().subtract(0.0, 0.5, 0.0), EntityType.EVOKER_FANGS)};
        final Vector[] vectorArray = new Vector[60];
        final boolean[] blArray = new boolean[]{true};
        int n = 0;
        while (n < 30) {
            vectorArray[n] = new Vector(0.005, 0.0, 0.005);
            vectorArray[n + 30] = vectorArray[n].clone().multiply(10);
            ++n;
        }
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                int n;
                int n2;
                FallingBlock[] fallingBlockArray2;
                if (livingEntity.isDead()) {
                    blArray[0] = false;
                }
                int n3 = 0;
                while (n3 < 30) {
                    if (fallingBlockArray[n3] != null) {
                        fallingBlockArray[n3].setVelocity(fallingBlockArray[n3].getVelocity().add(vectorArray[n3]));
                        if (vectorArray[n3 + 30].getX() > 0.0 && fallingBlockArray[n3].getVelocity().getX() >= vectorArray[n3 + 30].getX() || vectorArray[n3 + 30].getX() < 0.0 && fallingBlockArray[n3].getVelocity().getX() <= vectorArray[n3 + 30].getX()) {
                            vectorArray[n3].multiply(-1);
                            vectorArray[n3 + 30].multiply(-1);
                        }
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < 16) {
                    if (armorStandArray[n3] != null) {
                        armorStandArray[n3].teleport(fallingBlockArray[Math.max(0, n3 * 2 - 1)].getLocation());
                        armorStandArray[n3].setHeadPose(armorStandArray[n3].getHeadPose().add(Math.toRadians(CustomEnchantHandler.this.rand.nextInt(6) - 3), 0.0, 0.0));
                    }
                    ++n3;
                }
                if (nArray[1] <= 0) {
                    n3 = 0;
                    while (n3 < 30) {
                        if (fallingBlockArray[n3] != null) {
                            fallingBlockArray[n3].setVelocity(fallingBlockArray[n3].getVelocity().setY(0.32));
                        }
                        ++n3;
                    }
                    if (nArray[0] % 2 == 0) {
                        fallingBlockArray[nArray[0] / 2] = CustomEnchantHandler.this.createBlockForBloodWorm(location2.clone().subtract((CustomEnchantHandler.this.rand.nextDouble() - 0.5) / 4.0, 0.0, (CustomEnchantHandler.this.rand.nextDouble() - 0.5) / 4.0));
                    }
                    if (nArray[0] > 4 && nArray[0] % 4 == 0 && CustomEnchantHandler.this.rand.nextInt(2) == 0) {
                        armorStandArray[nArray[0] / 4] = CustomEnchantHandler.this.createStandForBloodWorm(fallingBlockArray[nArray[0] / 2].getLocation());
                    }
                    nArray[0] = nArray[0] + 1;
                    evokerFangsArray[0].remove();
                    evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(fallingBlockArray[0].getLocation().clone().add(0.0, 1.5, 0.0), EntityType.EVOKER_FANGS);
                    evokerFangsArray[0].setSilent(true);
                    dArray[0] = dArray[0] + 1.6666666666666667;
                    if (fallingBlockArray[29] != null || !blArray[0] || livingEntity2.isDead() || livingEntity.getLocation().add(0.0, 2.0, 0.0).getBlock().getType().isSolid()) {
                        nArray[1] = 1;
                        evokerFangsArray[0].setSilent(false);
                        fallingBlockArray2 = fallingBlockArray;
                        n2 = fallingBlockArray.length;
                        n = 0;
                        while (n < n2) {
                            FallingBlock fallingBlock = fallingBlockArray2[n];
                            if (fallingBlock != null) {
                                fallingBlock.setVelocity(fallingBlock.getVelocity().setY(0));
                            }
                            ++n;
                        }
                        if (livingEntity2.isDead()) {
                            nArray[1] = 40;
                        }
                    }
                    if (!(!blArray[0] || livingEntity.isDead() || evokerFangsArray[0].isDead() || livingEntity instanceof Player && Utils.isPlayerImmune((Player)livingEntity))) {
                        if (!livingEntity.getWorld().equals(world) || livingEntity.getLocation().distanceSquared(evokerFangsArray[0].getLocation()) >= 3.0) {
                            livingEntity.teleport(evokerFangsArray[0].getLocation());
                        }
                        livingEntity.setVelocity(Utils.getVectorTowards(livingEntity.getLocation(), evokerFangsArray[0].getLocation()).multiply(0.3).setY(evokerFangsArray[0].getLocation().getY() - livingEntity.getLocation().getY()));
                    }
                } else {
                    if (nArray[0] <= 0) {
                        if (nArray[0] == -2) {
                            evokerFangsArray[0].remove();
                            this.cancel();
                            nArray[2] = 1;
                            return;
                        }
                        Location location = evokerFangsArray[0].getLocation().subtract(0.0, 0.4, 0.0);
                        evokerFangsArray[0].remove();
                        evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(location, EntityType.EVOKER_FANGS);
                        nArray[0] = nArray[0] - 1;
                    } else if (nArray[1] >= 40) {
                        n3 = 0;
                        while (n3 < 30) {
                            if (fallingBlockArray[n3] != null) {
                                fallingBlockArray[n3].setVelocity(fallingBlockArray[n3].getVelocity().setY(-0.4));
                            }
                            ++n3;
                        }
                        if (fallingBlockArray[0] != null) {
                            evokerFangsArray[0].remove();
                            evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(fallingBlockArray[0].getLocation().clone().add(0.0, 1.5, 0.0), EntityType.EVOKER_FANGS);
                            evokerFangsArray[0].setSilent(true);
                        } else {
                            Location location = evokerFangsArray[0].getLocation().subtract(0.0, 0.4, 0.0);
                            evokerFangsArray[0].remove();
                            evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(location, EntityType.EVOKER_FANGS);
                        }
                        nArray[0] = nArray[0] - 1;
                        if (nArray[0] % 2 == 0 && fallingBlockArray[nArray[0] / 2] != null) {
                            fallingBlockArray[nArray[0] / 2].remove();
                            fallingBlockArray[nArray[0] / 2] = null;
                        }
                        if (nArray[0] % 4 == 0 && armorStandArray[nArray[0] / 4] != null) {
                            armorStandArray[nArray[0] / 4].remove();
                            armorStandArray[nArray[0] / 4] = null;
                        }
                        if (!(!blArray[0] || livingEntity.isDead() || evokerFangsArray[0].isDead() || livingEntity instanceof Player && Utils.isPlayerImmune((Player)livingEntity))) {
                            if (!livingEntity.getWorld().equals(world) || livingEntity.getLocation().distanceSquared(evokerFangsArray[0].getLocation()) >= 3.0) {
                                livingEntity.teleport(evokerFangsArray[0].getLocation());
                            }
                            livingEntity.setVelocity(Utils.getVectorTowards(livingEntity.getLocation(), evokerFangsArray[0].getLocation().subtract(0.0, 2.0, 0.0)).multiply(0.3).setY(evokerFangsArray[0].getLocation().getY() - 0.5 - livingEntity.getLocation().getY()));
                            livingEntity.setFallDistance(0.0f);
                        }
                    } else if (nArray[1] <= 25) {
                        evokerFangsArray[0].remove();
                        if (nArray[1] != 25) {
                            evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(fallingBlockArray[0].getLocation().clone().add(0.0, 1.5, 0.0), EntityType.EVOKER_FANGS);
                            evokerFangsArray[0].setSilent(true);
                        } else {
                            evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(fallingBlockArray[0].getLocation().clone().add(0.0, 1.0, 0.0), EntityType.EVOKER_FANGS);
                            CustomEnchantHandler.this.bloodPactFangMap.put(evokerFangsArray[0].getUniqueId(), new Object[]{livingEntity2.getUniqueId(), dArray[0], itemStack});
                        }
                        if (!(!blArray[0] || livingEntity.isDead() || evokerFangsArray[0].isDead() || livingEntity instanceof Player && Utils.isPlayerImmune((Player)livingEntity))) {
                            if (!livingEntity.getWorld().equals(world) || livingEntity.getLocation().distanceSquared(evokerFangsArray[0].getLocation()) >= 3.0) {
                                livingEntity.teleport(evokerFangsArray[0].getLocation());
                            }
                            livingEntity.setVelocity(Utils.getVectorTowards(livingEntity.getLocation(), evokerFangsArray[0].getLocation().subtract(0.0, 2.0, 0.0)).multiply(0.3).setY(evokerFangsArray[0].getLocation().getY() - livingEntity.getLocation().getY()));
                        }
                    } else if (!(!blArray[0] || livingEntity.isDead() || evokerFangsArray[0].isDead() || livingEntity instanceof Player && Utils.isPlayerImmune((Player)livingEntity))) {
                        if (!livingEntity.getWorld().equals(world) || livingEntity.getLocation().distanceSquared(evokerFangsArray[0].getLocation()) >= 3.0) {
                            livingEntity.teleport(evokerFangsArray[0].getLocation());
                        }
                        livingEntity.setVelocity(Utils.getVectorTowards(livingEntity.getLocation(), evokerFangsArray[0].getLocation().subtract(0.0, 2.0, 0.0)).multiply(0.3).setY(evokerFangsArray[0].getLocation().getY() - livingEntity.getLocation().getY()));
                    }
                    nArray[1] = nArray[1] + 1;
                }
                fallingBlockArray2 = fallingBlockArray;
                n2 = fallingBlockArray.length;
                n = 0;
                while (n < n2) {
                    FallingBlock fallingBlock = fallingBlockArray2[n];
                    if (fallingBlock != null) {
                        world.spawnParticle(Particle.BLOCK_DUST, fallingBlock.getLocation().clone().add(0.0, 1.5, 0.0), 1, 0.1, 0.1, 0.1, 0.1, (Object)blockData);
                    }
                    ++n;
                }
            }
        };
        final Location location3 = location.clone().add(0.0, 0.5, 0.0);
        new AsyncRepeatingTask(this.plugin, 1, 1){

            @Override
            public void run() {
                double d;
                if (nArray[2] == 1) {
                    this.cancel();
                    return;
                }
                int n = 0;
                while (n < 50) {
                    d = Math.toRadians(7.2 * (double)n);
                    world.spawnParticle(Particle.FLAME, location3.clone().add(Math.cos(d) * 2.0, 0.0, Math.sin(d) * 2.0), 1, 0.0, 0.0, 0.0, 1.0E-4);
                    ++n;
                }
                world.spawnParticle(Particle.LAVA, location3, 4, 0.5, 0.05, 0.5, 0.1);
                n = 0;
                while (n < 5) {
                    d = Math.toRadians(72.0 * (double)n);
                    double d2 = Math.toRadians(72.0 * (double)(n + 2));
                    double d3 = Math.cos(d) * 2.5;
                    double d4 = Math.sin(d) * 2.5;
                    double d5 = Math.cos(d2) * 2.5 - d3;
                    double d6 = Math.sin(d2) * 2.5 - d4;
                    double d7 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * d6);
                    double d8 = 0.0;
                    while (d8 < d7 / 6.7) {
                        world.spawnParticle(Particle.FLAME, location3.clone().add(d3 + d5 * d8, 0.0, d4 + d6 * d8), 1, 0.0, 0.0, 0.0, 1.0E-4);
                        d8 += 0.05;
                    }
                    ++n;
                }
            }
        };
    }

    private FallingBlock createBlockForBloodWorm(Location location) {
        FallingBlock fallingBlock = location.getWorld().spawnFallingBlock(location, Material.CHAIN.createBlockData());
        fallingBlock.setGravity(false);
        fallingBlock.setDropItem(false);
        fallingBlock.setMetadata("dd-fbcancel", (MetadataValue)this.plugin.fixedData);
        return fallingBlock;
    }

    private ArmorStand createStandForBloodWorm(Location location) {
        location.setYaw((float)this.rand.nextInt(360));
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setGravity(false);
        armorStand.setMarker(true);
        armorStand.setSmall(true);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        armorStand.getEquipment().setHelmet(CustomHead.BLOODWORMEYE.getHead());
        armorStand.setHeadPose(new EulerAngle(Math.toRadians(this.rand.nextInt(180)), 0.0, 0.0));
        armorStand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        return armorStand;
    }

    private void spawnGhouls(final LivingEntity livingEntity, final LivingEntity livingEntity2) {
        int n = 0;
        HashSet<Block> hashSet = new HashSet<Block>();
        final ArrayDeque arrayDeque = new ArrayDeque();
        int n2 = 0;
        while (n2 < 20) {
            Location location = Utils.findSmartYSpawn(livingEntity2.getLocation(), Utils.getSpotInSquareRadius(livingEntity2.getLocation(), this.rand.nextInt(this.etherealLanternGhoulCount * 2) + 3), 2, 5);
            if (location != null && !hashSet.contains(location.getBlock())) {
                location.subtract(0.0, 1.0, 0.0);
                hashSet.add(location.getBlock());
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    Zombie zombie2 = (Zombie)location.getWorld().spawn(location, Zombie.class, false, zombie -> zombie.setRotation(this.plugin.random.nextFloat() * 360.0f, 0.0f));
                    Ghoul ghoul = this.plugin.handler.addEntity(new Ghoul(zombie2, location.getBlock(), this.plugin, true));
                    arrayDeque.add(ghoul);
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        ghoul.setWalking(true);
                        ghoul.getEntity().setVelocity(new Vector(0.0, 0.4, 0.0));
                        ghoul.grabAnimation.stop();
                    }, 60L);
                }, (long)this.rand.nextInt(80));
                if (++n >= this.etherealLanternGhoulCount) break;
            }
            ++n2;
        }
        if (n > 0) {
            final int[] nArray = new int[]{this.etherealLanternLifeTicks};
            final boolean bl = livingEntity instanceof Player;
            final Particle.DustTransition dustTransition = new Particle.DustTransition(Color.BLUE, Color.BLACK, 0.5f);
            new RepeatingTask(this.plugin, 60, 1){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    var1_1 = arrayDeque.iterator();
                    v0 = nArray[0];
                    nArray[0] = v0 - 1;
                    if (v0 > 0) ** GOTO lbl23
                    while (var1_1.hasNext()) {
                        var2_2 = (Ghoul)var1_1.next();
                        if (var2_2.getEntity() == null || var2_2.getEntity().isDead()) continue;
                        var2_2.dig();
                    }
                    this.cancel();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        var2_3 = (Ghoul)var1_1.next();
                        if (var2_3.getEntity() == null || var2_3.getEntity().isDead()) {
                            var1_1.remove();
                            return;
                        }
                        if (livingEntity2 == null || livingEntity2.isDead()) {
                            var2_3.dig();
                            var1_1.remove();
                            return;
                        }
                        ((Mob)var2_3.getEntity()).setTarget(livingEntity2);
                        if (!bl || livingEntity == null) continue;
                        ((Player)livingEntity).spawnParticle(Particle.DUST_COLOR_TRANSITION, var2_3.getEntity().getLocation().add(0.0, 1.0, 0.0), 4, 0.4, 0.6, 0.4, 0.001, (Object)dustTransition);
lbl23:
                        // 3 sources

                        ** while (var1_1.hasNext())
                    }
lbl24:
                    // 1 sources

                    if (arrayDeque.isEmpty()) {
                        this.cancel();
                    }
                }
            };
        }
    }
}

