/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.listeners;

import deadlydisasters.Main;
import deadlydisasters.entities.halloweenentities.Psyco;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.DisasterEvent;
import deadlydisasters.events.disasters.AcidStorm;
import deadlydisasters.events.disasters.Blizzard;
import deadlydisasters.events.disasters.CaveIn;
import deadlydisasters.events.disasters.DeathParade;
import deadlydisasters.events.disasters.Earthquake;
import deadlydisasters.events.disasters.EndStorm;
import deadlydisasters.events.disasters.ExtremeWinds;
import deadlydisasters.events.disasters.Geyser;
import deadlydisasters.events.disasters.Hurricane;
import deadlydisasters.events.disasters.InfestedCaves;
import deadlydisasters.events.disasters.LandSlide;
import deadlydisasters.events.disasters.MeteorShower;
import deadlydisasters.events.disasters.Monsoon;
import deadlydisasters.events.disasters.Purge;
import deadlydisasters.events.disasters.SandStorm;
import deadlydisasters.events.disasters.Sinkhole;
import deadlydisasters.events.disasters.SolarStorm;
import deadlydisasters.events.disasters.SoulStorm;
import deadlydisasters.events.disasters.Supernova;
import deadlydisasters.events.disasters.Tornado;
import deadlydisasters.events.disasters.Tsunami;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Metrics;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class DeathMessages
implements Listener {
    public static Set<Sinkhole> sinkholes = new HashSet<Sinkhole>();
    public static Set<Geyser> geysers = new HashSet<Geyser>();
    public static Set<CaveIn> caveins = new HashSet<CaveIn>();
    public static Set<Tornado> tornados = new HashSet<Tornado>();
    public static Set<Earthquake> earthquakes = new HashSet<Earthquake>();
    public static Set<AcidStorm> acidstorms = new HashSet<AcidStorm>();
    public static Set<ExtremeWinds> extremewinds = new HashSet<ExtremeWinds>();
    public static Set<Blizzard> blizzards = new HashSet<Blizzard>();
    public static Set<SoulStorm> soulstorms = new HashSet<SoulStorm>();
    public static Set<SandStorm> sandstorms = new HashSet<SandStorm>();
    public static Set<Tsunami> tsunamis = new HashSet<Tsunami>();
    public static Set<MeteorShower> meteorshowers = new HashSet<MeteorShower>();
    public static Set<EndStorm> endstorms = new HashSet<EndStorm>();
    public static Set<Hurricane> hurricanes = new HashSet<Hurricane>();
    public static Set<Purge> purges = new HashSet<Purge>();
    public static Set<SolarStorm> solarstorms = new HashSet<SolarStorm>();
    public static Set<Monsoon> monsoons = new HashSet<Monsoon>();
    public static Set<InfestedCaves> infestedcaves = new HashSet<InfestedCaves>();
    public static Set<Supernova> supernovas = new HashSet<Supernova>();
    public static Set<LandSlide> landslides = new HashSet<LandSlide>();
    public static Set<DeathParade> deathparades = new HashSet<DeathParade>();
    private Main plugin;

    public DeathMessages(Main main) {
        this.plugin = main;
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        Player player = playerDeathEvent.getEntity();
        World world = player.getWorld();
        if (Purge.targetedPlayers.contains(player.getUniqueId())) {
            Purge.targetedPlayers.remove(player.getUniqueId());
        }
        if (!((Boolean)world.getGameRuleValue(GameRule.SHOW_DEATH_MESSAGES)).booleanValue() || player.getLastDamageCause() == null) {
            return;
        }
        EntityDamageEvent.DamageCause damageCause = player.getLastDamageCause().getCause();
        if (damageCause == null || playerDeathEvent.getDeathMessage() == null) {
            return;
        }
        if (damageCause != EntityDamageEvent.DamageCause.VOID && damageCause != EntityDamageEvent.DamageCause.SUICIDE) {
            for (SoulStorm disasterEvent2 : soulstorms) {
                if (!disasterEvent2.getWorld().equals(world)) continue;
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.SOULSTORM.getMetricsLabel());
                break;
            }
            for (EndStorm endStorm : endstorms) {
                if (!endStorm.getWorld().equals(world)) continue;
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.ENDSTORM.getMetricsLabel());
                break;
            }
            if ((damageCause == EntityDamageEvent.DamageCause.FIRE || damageCause == EntityDamageEvent.DamageCause.FIRE_TICK) && solarstorms.stream().anyMatch(solarStorm -> solarStorm.getWorld().equals(world))) {
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.SOLARSTORM.getMetricsLabel());
            }
            for (InfestedCaves infestedCaves : infestedcaves) {
                if (!player.getWorld().equals(infestedCaves.getLocation().getWorld()) || !(player.getLocation().distance(infestedCaves.getLocation()) <= (double)infestedCaves.getSize())) continue;
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.INFESTEDCAVES.getMetricsLabel());
                break;
            }
        }
        if (player.hasMetadata("dd-plague")) {
            player.removeMetadata("dd-plague", (Plugin)this.plugin);
            if (player.hasMetadata("dd-plaguedeath")) {
                playerDeathEvent.setDeathMessage(String.valueOf(playerDeathEvent.getEntity().getName()) + " " + Languages.getString("deaths.plague"));
                player.removeMetadata("dd-plaguedeath", (Plugin)this.plugin);
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.PLAGUE.getMetricsLabel());
                return;
            }
            if (damageCause == EntityDamageEvent.DamageCause.WITHER) {
                playerDeathEvent.setDeathMessage(String.valueOf(playerDeathEvent.getEntity().getName()) + " " + Languages.getString("deaths.plague"));
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.PLAGUE.getMetricsLabel());
                return;
            }
        }
        if (player.hasMetadata("dd-lostsouldeath")) {
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.soulDeath"));
            player.removeMetadata("dd-lostsouldeath", (Plugin)this.plugin);
            LivingEntity livingEntity = (LivingEntity)player.getWorld().spawnEntity(player.getLocation(), EntityType.VILLAGER);
            livingEntity.setCustomName(String.valueOf(player.getName()) + "'" + Languages.getString("deaths.corpse"));
            return;
        }
        if (player.hasMetadata("dd-unstablerift")) {
            player.removeMetadata("dd-unstablerift", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.rift"));
            return;
        }
        if (player.hasMetadata("dd-supernova")) {
            player.removeMetadata("dd-supernova", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.supernova"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.SUPERNOVA.getMetricsLabel());
            return;
        }
        if (player.hasMetadata("dd-meteorcrush")) {
            player.removeMetadata("dd-meteorcrush", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.meteor"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.METEORSHOWERS.getMetricsLabel());
            return;
        }
        if (player.hasMetadata("dd-monsoondrown")) {
            player.removeMetadata("dd-monsoondrown", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.monsoon"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.MONSOON.getMetricsLabel());
            return;
        }
        if (player.hasMetadata("dd-caveincrush")) {
            player.removeMetadata("dd-caveincrush", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.cavein"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.CAVEIN.getMetricsLabel());
            return;
        }
        if (player.hasMetadata("dd-endwormfangs")) {
            player.removeMetadata("dd-endwormfangs", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.worm"));
            return;
        }
        if (player.hasMetadata("dd-purgedeath")) {
            player.removeMetadata("dd-purgedeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.purge"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.PURGE.getMetricsLabel());
            return;
        }
        if (player.hasMetadata("dd-leechdeath")) {
            player.removeMetadata("dd-leechdeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.genericMob") + ' ' + Languages.getString("entities.shadowLeech"));
            return;
        }
        if (player.hasMetadata("dd-bloodleechdeath")) {
            player.removeMetadata("dd-bloodleechdeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.genericMob") + ' ' + Languages.getString("entities.bloodyLeech"));
            return;
        }
        if (player.hasMetadata("dd-devourdeath")) {
            player.removeMetadata("dd-devourdeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.genericMob") + ' ' + Languages.getString("entities.infestedDevourer"));
            return;
        }
        if (player.hasMetadata("dd-infestedwormdeath")) {
            player.removeMetadata("dd-infestedwormdeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.infestedWormDeath"));
            return;
        }
        if (player.hasMetadata("dd-sandstormdeath")) {
            player.removeMetadata("dd-sandstormdeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.sandstorm"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.SANDSTORM.getMetricsLabel());
            return;
        }
        if (player.hasMetadata("dd-acidstormdeath")) {
            player.removeMetadata("dd-acidstormdeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.acidstorm"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.ACIDSTORM.getMetricsLabel());
            return;
        }
        if (player.hasMetadata("dd-blizzarddeath")) {
            player.removeMetadata("dd-blizzarddeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.blizzard"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.BLIZZARD.getMetricsLabel());
            Location location = new Location(player.getWorld(), (double)player.getLocation().getBlockX() + 0.5, (double)player.getLocation().getBlockY(), (double)player.getLocation().getBlockZ() + 0.5, player.getLocation().getYaw(), player.getLocation().getPitch());
            Iterator<DisasterEvent> iterator = (Skeleton)player.getWorld().spawnEntity(location, EntityType.SKELETON);
            iterator.setInvulnerable(true);
            iterator.setSilent(true);
            iterator.setAI(false);
            iterator.getEquipment().setItemInMainHand(null);
            if (player.getLocation().getBlock().isPassable()) {
                player.getLocation().getBlock().setType(Material.ICE);
            }
            if (player.getLocation().add(0.0, 1.0, 0.0).getBlock().isPassable()) {
                player.getLocation().add(0.0, 1.0, 0.0).getBlock().setType(Material.ICE);
            }
            return;
        }
        if (player.hasMetadata("dd-geyserdeath")) {
            player.removeMetadata("dd-geyserdeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.waterGeyser"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.GEYSER.getMetricsLabel());
            return;
        }
        if (player.hasMetadata("dd-tsunamideath")) {
            player.removeMetadata("dd-tsunamideath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.tsunami"));
            Metrics.incrementValue(Metrics.disasterKillMap, Disaster.TSUNAMI.getMetricsLabel());
            return;
        }
        if (player.hasMetadata("dd-bloodsacrifice")) {
            player.removeMetadata("dd-bloodsacrifice", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.bloodSacrifice"));
            return;
        }
        if (player.hasMetadata("dd-bloodsacrificesuicide")) {
            player.removeMetadata("dd-bloodsacrificesuicide", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.bloodSacrificeSuicide"));
            return;
        }
        if (player.hasMetadata("dd-frostydeath")) {
            player.removeMetadata("dd-frostydeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.frostyDeath"));
            return;
        }
        if (player.hasMetadata("dd-candycane")) {
            player.removeMetadata("dd-candycane", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.candyCanePierce"));
            return;
        }
        if (player.hasMetadata("dd-avalanche")) {
            player.removeMetadata("dd-avalanche", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.avalancheDeath"));
            return;
        }
        if (player.hasMetadata("dd-landslide")) {
            player.removeMetadata("dd-landslide", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.landslideDeath"));
            return;
        }
        if (player.hasMetadata("dd-soulbombdeath")) {
            player.removeMetadata("dd-soulbombdeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.soulBombDeath"));
            Skeleton skeleton2 = (Skeleton)player.getWorld().spawn(player.getLocation(), Skeleton.class, false, skeleton -> skeleton.setCustomName(player.getName()));
            this.plugin.handler.addEntity(new Psyco((Mob)skeleton2, this.plugin, this.plugin.random));
            skeleton2.getEquipment().setItemInMainHand(player.getEquipment().getItemInMainHand());
            return;
        }
        if (player.hasMetadata("dd-pumpkinkingblooddeath")) {
            player.removeMetadata("dd-pumpkinkingblooddeath", (Plugin)this.plugin);
            playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("halloween.pumpkinWormDeath"));
            return;
        }
        if (damageCause == EntityDamageEvent.DamageCause.FALL || damageCause == EntityDamageEvent.DamageCause.LAVA) {
            for (Sinkhole sinkhole : sinkholes) {
                n4 = sinkhole.getX();
                n3 = sinkhole.getY();
                n2 = sinkhole.getZ();
                n = (int)sinkhole.getRadius();
                if (!sinkhole.getLocation().getWorld().equals(world) || player.getLocation().getBlockX() < n4 - n || player.getLocation().getBlockX() > n4 + n || player.getLocation().getBlockZ() < n2 - n || player.getLocation().getBlockZ() > n2 + n || player.getLocation().getBlockY() > n3) continue;
                playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.sinkhole"));
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.SINKHOLE.getMetricsLabel());
                return;
            }
            for (Earthquake earthquake : earthquakes) {
                n4 = earthquake.getX();
                n3 = earthquake.getY();
                n2 = earthquake.getZ();
                n = earthquake.getRadius();
                Location location = player.getLocation();
                if (!earthquake.getLocation().getWorld().equals(world) || location.getBlockX() < n4 - n || location.getBlockX() > n4 + n || location.getBlockZ() < n2 - n || location.getBlockZ() > n2 + n || location.getBlockY() >= n3) continue;
                playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.earthquake"));
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.EARTHQUAKE.getMetricsLabel());
                return;
            }
        }
        if (damageCause == EntityDamageEvent.DamageCause.FALL) {
            for (Tornado tornado : tornados) {
                if (!tornado.isEntityInvolved(player.getUniqueId())) continue;
                playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.tornado"));
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.TORNADO.getMetricsLabel());
                return;
            }
            for (ExtremeWinds extremeWinds : extremewinds) {
                if (!extremeWinds.getWorld().equals(world) || !extremeWinds.isEntityInvolved(player.getUniqueId())) continue;
                playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.extremewinds"));
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.EXTREMEWINDS.getMetricsLabel());
                return;
            }
        }
        if (damageCause == EntityDamageEvent.DamageCause.LAVA && world.getEnvironment() == World.Environment.NETHER) {
            for (Geyser geyser : geysers) {
                n4 = geyser.getX();
                n3 = geyser.getZ();
                n2 = geyser.getY();
                n = geyser.getMemory();
                if (!geyser.getLocation().getWorld().equals(world) || player.getLocation().getBlockX() < n4 - 2 || player.getLocation().getBlockX() > n4 + 1 || player.getLocation().getBlockZ() < n3 - 2 || player.getLocation().getBlockZ() > n3 + 1 || player.getLocation().getBlockY() < n || player.getLocation().getBlockY() > n2) continue;
                playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.lavaGeyser"));
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.GEYSER.getMetricsLabel());
                return;
            }
        }
        if (damageCause == EntityDamageEvent.DamageCause.SUFFOCATION) {
            for (InfestedCaves infestedCaves : infestedcaves) {
                if (!player.getWorld().equals(infestedCaves.getLocation().getWorld()) || !(player.getLocation().distance(infestedCaves.getLocation()) <= (double)infestedCaves.getSize()) || player.getLocation().add(0.0, 1.0, 0.0).getBlock().getType() != infestedCaves.getMaterial()) continue;
                playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.infestedCave"));
                return;
            }
        }
        if (damageCause == EntityDamageEvent.DamageCause.FALL || damageCause == EntityDamageEvent.DamageCause.LIGHTNING) {
            for (Hurricane hurricane : hurricanes) {
                if (!(player.getLocation().distance(hurricane.getLocation()) <= (double)hurricane.getSize())) continue;
                playerDeathEvent.setDeathMessage(String.valueOf(player.getName()) + " " + Languages.getString("deaths.hurricane"));
                Metrics.incrementValue(Metrics.disasterKillMap, Disaster.HURRICANE.getMetricsLabel());
                return;
            }
        }
    }
}

