/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.listeners.unloaders;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Loader_ver_14
implements Listener {
    private Main plugin;
    private EntityHandler handler;
    private Set<Chunk> chunks = new HashSet<Chunk>();

    public Loader_ver_14(Main main, EntityHandler entityHandler) {
        this.plugin = main;
        this.handler = entityHandler;
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
    }

    @EventHandler
    public void onEntitiesLoad(ChunkLoadEvent chunkLoadEvent) {
        if (this.chunks.contains(chunkLoadEvent.getChunk())) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Entity[] entityArray = chunkLoadEvent.getChunk().getEntities();
            int n = entityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Entity entity = entityArray[n2];
                if (entity.isValid() && entity.getPersistentDataContainer().has(this.handler.globalKey, PersistentDataType.BYTE)) {
                    CustomEntityType[] customEntityTypeArray = CustomEntityType.values();
                    int n3 = customEntityTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = customEntityTypeArray[n4];
                        if (entity.getPersistentDataContainer().has(object.nameKey, PersistentDataType.BYTE)) {
                            this.handler.addEntityBySpecies(object.species, entity);
                            break;
                        }
                        ++n4;
                    }
                } else if (entity.getPersistentDataContainer().has(EntityHandler.removalKey, PersistentDataType.BYTE)) {
                    for (Object object : entity.getPassengers()) {
                        object.remove();
                    }
                    entity.remove();
                }
                ++n2;
            }
        }, 40L);
    }

    @EventHandler
    public void onEntitiesUnload(ChunkUnloadEvent chunkUnloadEvent) {
        this.chunks.add(chunkUnloadEvent.getChunk());
        Entity[] entityArray = chunkUnloadEvent.getChunk().getEntities();
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (entity.getPersistentDataContainer().has(this.handler.globalKey, PersistentDataType.BYTE)) {
                CustomEntity customEntity = this.handler.findEntity((LivingEntity)entity);
                if (customEntity == null) {
                    return;
                }
                customEntity.clean();
                this.handler.removeEntity(customEntity);
            }
            ++n2;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            boolean bl = this.chunks.remove(chunkUnloadEvent.getChunk());
        }, 60L);
    }
}

