/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.utils;

import org.bukkit.entity.ArmorStand;
import org.bukkit.util.EulerAngle;

public class AnimationHandler {
    private Animation[] animations;
    private int currentPoint = 0;
    private int continueFrame = 0;
    private int frameRate = 1;
    public boolean shouldStop = true;
    public boolean resetOnStop;
    public boolean adjustOnStop;
    public boolean isDone;
    public boolean continous;

    public AnimationHandler(boolean bl, boolean bl2, boolean bl3) {
        this.resetOnStop = bl;
        this.adjustOnStop = bl2;
        this.continous = bl3;
    }

    public void tick(ArmorStand armorStand) {
        if (this.shouldStop) {
            if (!this.continous && this.isDone) {
                return;
            }
            if (!this.animations[this.currentPoint].isFinished) {
                this.animations[this.currentPoint].tick(armorStand);
                if (this.animations[this.currentPoint].isFinished) {
                    if (this.adjustOnStop) {
                        AnimationCheckpoint[] animationCheckpointArray = this.animations[0].points;
                        int n = this.animations[0].points.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AnimationCheckpoint animationCheckpoint = animationCheckpointArray[n2];
                            animationCheckpoint.adjustToFrame(armorStand, 0);
                            ++n2;
                        }
                    }
                    if (this.resetOnStop) {
                        this.currentPoint = 0;
                        this.animations[this.currentPoint].isFinished = false;
                    }
                    this.isDone = true;
                }
            } else {
                this.isDone = true;
            }
            return;
        }
        if (!this.animations[this.currentPoint].isFinished) {
            this.animations[this.currentPoint].tick(armorStand);
        } else {
            ++this.currentPoint;
            if (this.currentPoint >= this.animations.length) {
                this.currentPoint = this.continueFrame;
            }
            this.animations[this.currentPoint].tick(armorStand);
        }
    }

    public void setAnimations(Animation ... animationArray) {
        this.animations = animationArray;
    }

    public void go() {
        this.shouldStop = false;
        this.isDone = false;
    }

    public void stop() {
        this.shouldStop = true;
    }

    public void startAnimation(ArmorStand armorStand) {
        this.go();
        this.tick(armorStand);
        this.stop();
    }

    public void forceStop(ArmorStand armorStand) {
        Animation[] animationArray = this.animations;
        int n = this.animations.length;
        int n2 = 0;
        while (n2 < n) {
            Animation animation = animationArray[n2];
            animation.forceStop(armorStand);
            ++n2;
        }
        this.shouldStop = true;
    }

    public boolean isFinished() {
        return this.isDone;
    }

    public int getContinueFrame() {
        return this.continueFrame;
    }

    public void setContinueFrame(int n) {
        this.continueFrame = n;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int n) {
        this.frameRate = n;
    }

    public class Animation {
        private AnimationCheckpoint[] points;
        private boolean isFinished;

        public Animation(AnimationCheckpoint ... animationCheckpointArray) {
            this.points = animationCheckpointArray;
        }

        public void tick(ArmorStand armorStand) {
            AnimationCheckpoint animationCheckpoint;
            this.isFinished = false;
            boolean bl = false;
            AnimationCheckpoint[] animationCheckpointArray = this.points;
            int n = this.points.length;
            int n2 = 0;
            while (n2 < n) {
                animationCheckpoint = animationCheckpointArray[n2];
                if (!animationCheckpoint.isFinished) {
                    animationCheckpoint.tick(armorStand);
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                this.isFinished = true;
                animationCheckpointArray = this.points;
                n = this.points.length;
                n2 = 0;
                while (n2 < n) {
                    animationCheckpoint = animationCheckpointArray[n2];
                    animationCheckpoint.reset();
                    ++n2;
                }
            }
        }

        public void forceStop(ArmorStand armorStand) {
            AnimationCheckpoint[] animationCheckpointArray = this.points;
            int n = this.points.length;
            int n2 = 0;
            while (n2 < n) {
                AnimationCheckpoint animationCheckpoint = animationCheckpointArray[n2];
                animationCheckpoint.forceStop(armorStand);
                ++n2;
            }
            this.isFinished = true;
        }
    }

    public class AnimationCheckpoint {
        private BodyPart part;
        private int frame = 1;
        private boolean reverse;
        private boolean flipped;
        private boolean isFinished;
        private boolean overrideValues;
        private double[][] frames;

        public AnimationCheckpoint(BodyPart bodyPart, double d, double d2, double d3, double d4, double d5, double d6, int n, boolean bl, double d7, double d8, boolean bl2) {
            this.part = bodyPart;
            this.reverse = bl;
            this.overrideValues = bl2;
            this.frames = new double[n + 1][];
            this.frames[0] = new double[]{d, d2, d3};
            double d9 = (d4 - d) / (double)n;
            double d10 = (d5 - d2) / (double)n;
            double d11 = (d6 - d3) / (double)n;
            int n2 = n / 2;
            int n3 = n2 / 2;
            if (d7 > 0.0 && d8 == 0.0) {
                n3 = n2;
                n2 = n;
            } else if (d8 > 0.0 && d7 == 0.0) {
                n3 = n2;
                n2 = 0;
            }
            double d12 = d7 / (double)n3;
            double d13 = d8 / (double)n3;
            int n4 = 0;
            while (n4 < this.frames.length - 1) {
                double[] dArray;
                double[] dArray2;
                if (this.frames[n4 + 1] == null) {
                    this.frames[n4 + 1] = new double[]{d9, d10, d11};
                }
                if (n4 < n3 && n3 < n2) {
                    dArray2 = new double[]{d9 * (1.0 - d12 * (double)(n3 - n4)), d10 * (1.0 - d12 * (double)(n3 - n4)), d11 * (1.0 - d12 * (double)(n3 - n4))};
                    this.frames[n4 + 1] = dArray2;
                    dArray = new double[]{d9 * (1.0 + d12 * (double)(n3 - n4)), d10 * (1.0 + d12 * (double)(n3 - n4)), d11 * (1.0 + d12 * (double)(n3 - n4))};
                    this.frames[n2 - (n4 + 1) + 1] = dArray;
                } else if (n4 >= n2 && n4 < n2 + n3) {
                    dArray2 = new double[]{d9 * (1.0 + d13 * (double)(n3 - (n4 - n2))), d10 * (1.0 + d13 * (double)(n3 - (n4 - n2))), d11 * (1.0 + d13 * (double)(n3 - (n4 - n2)))};
                    this.frames[n4 + 1] = dArray2;
                    dArray = new double[]{d9 * (1.0 - d13 * (double)(n3 - (n4 - n2))), d10 * (1.0 - d13 * (double)(n3 - (n4 - n2))), d11 * (1.0 - d13 * (double)(n3 - (n4 - n2)))};
                    this.frames[n - (n4 - n2 + 1) + 1] = dArray;
                }
                ++n4;
            }
            n4 = 1;
            while (n4 < this.frames.length) {
                this.frames[n4] = new double[]{d += this.frames[n4][0], d2 += this.frames[n4][1], d3 += this.frames[n4][2]};
                ++n4;
            }
        }

        public AnimationCheckpoint(BodyPart bodyPart, double d, double d2, double d3, double d4, double d5, double d6, int n, boolean bl, double d7, double d8) {
            this(bodyPart, d, d2, d3, d4, d5, d6, n, bl, d7, d8, false);
        }

        public AnimationCheckpoint(BodyPart bodyPart, double d, double d2, double d3, double d4, double d5, double d6, int n, boolean bl) {
            this(bodyPart, d, d2, d3, d4, d5, d6, n, bl, 0.0, 0.0, false);
        }

        public void tick(ArmorStand armorStand) {
            if (this.isFinished) {
                this.reset();
            }
            this.adjustToFrame(armorStand, this.frame);
            this.frame = !this.flipped ? (this.frame += AnimationHandler.this.frameRate) : (this.frame -= AnimationHandler.this.frameRate);
            if (this.frame >= this.frames.length || this.frame < 0) {
                if (this.flipped || !this.reverse) {
                    this.isFinished = true;
                    return;
                }
                this.frame = this.frames.length - 1;
                this.flipped = true;
            }
        }

        public void adjustToFrame(ArmorStand armorStand, int n) {
            EulerAngle eulerAngle = new EulerAngle(Math.toRadians(this.frames[n][0]), Math.toRadians(this.frames[n][1]), Math.toRadians(this.frames[n][2]));
            switch (this.part) {
                case BODY: {
                    EulerAngle eulerAngle2 = armorStand.getBodyPose();
                    armorStand.setBodyPose(this.overrideValues ? eulerAngle : new EulerAngle(eulerAngle.getX() != 0.0 ? eulerAngle.getX() : eulerAngle2.getX(), eulerAngle.getY() != 0.0 ? eulerAngle.getY() : eulerAngle2.getY(), eulerAngle.getZ() != 0.0 ? eulerAngle.getZ() : eulerAngle2.getZ()));
                    break;
                }
                case HEAD: {
                    EulerAngle eulerAngle3 = armorStand.getHeadPose();
                    armorStand.setHeadPose(this.overrideValues ? eulerAngle : new EulerAngle(eulerAngle.getX() != 0.0 ? eulerAngle.getX() : eulerAngle3.getX(), eulerAngle.getY() != 0.0 ? eulerAngle.getY() : eulerAngle3.getY(), eulerAngle.getZ() != 0.0 ? eulerAngle.getZ() : eulerAngle3.getZ()));
                    break;
                }
                case RIGHT_ARM: {
                    EulerAngle eulerAngle4 = armorStand.getRightArmPose();
                    armorStand.setRightArmPose(this.overrideValues ? eulerAngle : new EulerAngle(eulerAngle.getX() != 0.0 ? eulerAngle.getX() : eulerAngle4.getX(), eulerAngle.getY() != 0.0 ? eulerAngle.getY() : eulerAngle4.getY(), eulerAngle.getZ() != 0.0 ? eulerAngle.getZ() : eulerAngle4.getZ()));
                    break;
                }
                case LEFT_ARM: {
                    EulerAngle eulerAngle5 = armorStand.getLeftArmPose();
                    armorStand.setLeftArmPose(this.overrideValues ? eulerAngle : new EulerAngle(eulerAngle.getX() != 0.0 ? eulerAngle.getX() : eulerAngle5.getX(), eulerAngle.getY() != 0.0 ? eulerAngle.getY() : eulerAngle5.getY(), eulerAngle.getZ() != 0.0 ? eulerAngle.getZ() : eulerAngle5.getZ()));
                    break;
                }
                case RIGHT_LEG: {
                    EulerAngle eulerAngle6 = armorStand.getRightLegPose();
                    armorStand.setRightLegPose(this.overrideValues ? eulerAngle : new EulerAngle(eulerAngle.getX() != 0.0 ? eulerAngle.getX() : eulerAngle6.getX(), eulerAngle.getY() != 0.0 ? eulerAngle.getY() : eulerAngle6.getY(), eulerAngle.getZ() != 0.0 ? eulerAngle.getZ() : eulerAngle6.getZ()));
                    break;
                }
                case LEFT_LEG: {
                    EulerAngle eulerAngle7 = armorStand.getLeftLegPose();
                    armorStand.setLeftLegPose(this.overrideValues ? eulerAngle : new EulerAngle(eulerAngle.getX() != 0.0 ? eulerAngle.getX() : eulerAngle7.getX(), eulerAngle.getY() != 0.0 ? eulerAngle.getY() : eulerAngle7.getY(), eulerAngle.getZ() != 0.0 ? eulerAngle.getZ() : eulerAngle7.getZ()));
                }
            }
        }

        public void reset() {
            this.frame = 1;
            this.isFinished = false;
            this.flipped = false;
        }

        public void forceStop(ArmorStand armorStand) {
            this.adjustToFrame(armorStand, 0);
            this.isFinished = true;
        }
    }

    public static enum BodyPart {
        HEAD,
        BODY,
        RIGHT_ARM,
        LEFT_ARM,
        RIGHT_LEG,
        LEFT_LEG;

    }
}

