/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.utils;

import com.google.common.base.Preconditions;
import deadlydisasters.utils.KeyBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigUpdater {
    private static final char SEPARATOR = '.';

    public static void update(Plugin plugin, InputStream inputStream, File file, List<String> list) {
        Preconditions.checkArgument((boolean)file.exists(), (Object)"The toUpdate file doesn't exist!");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        inputStream.transferTo(byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)byteArrayInputStream, StandardCharsets.UTF_8));
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)FileUtils.openInputStream(file), StandardCharsets.UTF_8));
        Map<String, String> map = ConfigUpdater.parseComments(plugin, byteArrayInputStream2, (FileConfiguration)yamlConfiguration);
        Map<String, String> map2 = ConfigUpdater.parseIgnoredSections(file, (FileConfiguration)yamlConfiguration2, map, list == null ? Collections.emptyList() : list);
        StringWriter stringWriter = new StringWriter();
        ConfigUpdater.write((FileConfiguration)yamlConfiguration, (FileConfiguration)yamlConfiguration2, new BufferedWriter(stringWriter), map, map2);
        String string = stringWriter.toString();
        Path path = file.toPath();
        if (!string.equals(new String(Files.readAllBytes(path), StandardCharsets.UTF_8))) {
            Files.write(path, string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    private static void write(FileConfiguration fileConfiguration, FileConfiguration fileConfiguration2, BufferedWriter bufferedWriter, Map<String, String> map, Map<String, String> map2) {
        String string2;
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        block0: for (String string2 : fileConfiguration.getKeys(true)) {
            Map.Entry<String, String> entry2;
            String string3 = KeyBuilder.getIndents(string2, '.');
            if (map2.isEmpty()) {
                ConfigUpdater.writeCommentIfExists(map, bufferedWriter, string2, string3);
            } else {
                for (Map.Entry<String, String> entry2 : map2.entrySet()) {
                    if (entry2.getKey().equals(string2)) {
                        bufferedWriter.write(String.valueOf((String)entry2.getValue()) + "\n");
                        continue block0;
                    }
                    if (KeyBuilder.isSubKeyOf((String)entry2.getKey(), string2, '.')) continue block0;
                    ConfigUpdater.writeCommentIfExists(map, bufferedWriter, string2, string3);
                }
            }
            entry2 = fileConfiguration2.get(string2);
            if (entry2 == null) {
                entry2 = fileConfiguration.get(string2);
            }
            String[] stringArray = string2.split("[.]");
            String string4 = stringArray[stringArray.length - 1];
            if (entry2 instanceof ConfigurationSection) {
                bufferedWriter.write(String.valueOf(string3) + string4 + ":");
                if (!((ConfigurationSection)entry2).getKeys(false).isEmpty()) {
                    bufferedWriter.write("\n");
                    continue;
                }
                bufferedWriter.write(" {}\n");
                continue;
            }
            yamlConfiguration.set(string4, (Object)entry2);
            String string5 = yamlConfiguration.saveToString();
            string5 = string5.substring(0, string5.length() - 1).replace("\n", "\n" + string3);
            String string6 = String.valueOf(string3) + string5 + "\n";
            yamlConfiguration.set(string4, null);
            bufferedWriter.write(string6);
        }
        string2 = map.get(null);
        if (string2 != null) {
            bufferedWriter.write(string2);
        }
        bufferedWriter.close();
    }

    private static Map<String, String> parseComments(Plugin plugin, InputStream inputStream, FileConfiguration fileConfiguration) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        KeyBuilder keyBuilder = new KeyBuilder(fileConfiguration, '.');
        while ((string = bufferedReader.readLine()) != null) {
            String string2 = string.trim();
            if (string2.startsWith("-")) continue;
            if (string2.isEmpty() || string2.startsWith("#")) {
                stringBuilder.append(string2).append("\n");
                continue;
            }
            keyBuilder.parseLine(string2);
            String string3 = keyBuilder.toString();
            if (stringBuilder.length() > 0) {
                linkedHashMap.put(string3, stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            if (keyBuilder.isConfigSectionWithKeys()) continue;
            keyBuilder.removeLastKey();
        }
        bufferedReader.close();
        if (stringBuilder.length() > 0) {
            linkedHashMap.put(null, stringBuilder.toString());
        }
        return linkedHashMap;
    }

    private static Map<String, String> parseIgnoredSections(File file, FileConfiguration fileConfiguration, Map<String, String> map, List<String> list) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(list.size());
        KeyBuilder keyBuilder = new KeyBuilder(fileConfiguration, '.');
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        block0: while ((string = bufferedReader.readLine()) != null) {
            String string322;
            String string4 = string.trim();
            if (string4.isEmpty() || string4.startsWith("#")) continue;
            if (string4.startsWith("-")) {
                for (String string322 : list) {
                    boolean bl = string322.equals(keyBuilder.toString());
                    if (!bl && !keyBuilder.isSubKeyOf(string322)) continue;
                    stringBuilder.append("\n").append(string);
                    continue block0;
                }
            }
            keyBuilder.parseLine(string4);
            string322 = keyBuilder.toString();
            if (string2 != null && !KeyBuilder.isSubKeyOf(string2, string322, '.')) {
                linkedHashMap.put(string2, stringBuilder.toString());
                stringBuilder.setLength(0);
                string2 = null;
            }
            for (String string3 : list) {
                String string5;
                boolean bl = string3.equals(string322);
                if (!bl && !keyBuilder.isSubKeyOf(string3)) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                if ((string5 = map.get(string322)) != null) {
                    String string6 = KeyBuilder.getIndents(string322, '.');
                    stringBuilder.append(string6).append(string5.replace("\n", "\n" + string6));
                    stringBuilder.setLength(stringBuilder.length() - string6.length());
                }
                stringBuilder.append(string);
                if (!bl) continue block0;
                string2 = string322;
                continue block0;
            }
        }
        bufferedReader.close();
        if (stringBuilder.length() > 0) {
            linkedHashMap.put(string2, stringBuilder.toString());
        }
        return linkedHashMap;
    }

    private static void writeCommentIfExists(Map<String, String> map, BufferedWriter bufferedWriter, String string, String string2) {
        String string3 = map.get(string);
        if (string3 != null) {
            bufferedWriter.write(String.valueOf(string2) + string3.substring(0, string3.length() - 1).replace("\n", "\n" + string2) + "\n");
        }
    }
}

