/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.utils;

import org.bukkit.configuration.file.FileConfiguration;

public class KeyBuilder
implements Cloneable {
    private final FileConfiguration config;
    private final char separator;
    private final StringBuilder builder;

    public KeyBuilder(FileConfiguration fileConfiguration, char c) {
        this.config = fileConfiguration;
        this.separator = c;
        this.builder = new StringBuilder();
    }

    private KeyBuilder(KeyBuilder keyBuilder) {
        this.config = keyBuilder.config;
        this.separator = keyBuilder.separator;
        this.builder = new StringBuilder(keyBuilder.toString());
    }

    public void parseLine(String string) {
        string = string.trim();
        String[] stringArray = string.split(":");
        while (this.builder.length() > 0 && !this.config.contains(String.valueOf(this.builder.toString()) + this.separator + stringArray[0])) {
            this.removeLastKey();
        }
        if (this.builder.length() > 0) {
            this.builder.append(this.separator);
        }
        this.builder.append(stringArray[0]);
    }

    public String getLastKey() {
        if (this.builder.length() == 0) {
            return "";
        }
        return this.builder.toString().split("[" + this.separator + "]")[0];
    }

    public boolean isEmpty() {
        return this.builder.length() == 0;
    }

    public boolean isSubKeyOf(String string) {
        return KeyBuilder.isSubKeyOf(string, this.builder.toString(), this.separator);
    }

    public boolean isSubKey(String string) {
        return KeyBuilder.isSubKeyOf(this.builder.toString(), string, this.separator);
    }

    public static boolean isSubKeyOf(String string, String string2, char c) {
        if (string.isEmpty()) {
            return false;
        }
        return string2.startsWith(string) && string2.substring(string.length()).startsWith(String.valueOf(c));
    }

    public static String getIndents(String string, char c) {
        String[] stringArray = string.split("[" + c + "]");
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        while (n < stringArray.length) {
            stringBuilder.append("  ");
            ++n;
        }
        return stringBuilder.toString();
    }

    public boolean isConfigSection() {
        String string = this.builder.toString();
        return this.config.isConfigurationSection(string);
    }

    public boolean isConfigSectionWithKeys() {
        String string = this.builder.toString();
        return this.config.isConfigurationSection(string) && !this.config.getConfigurationSection(string).getKeys(false).isEmpty();
    }

    public void removeLastKey() {
        if (this.builder.length() == 0) {
            return;
        }
        String string = this.builder.toString();
        String[] stringArray = string.split("[" + this.separator + "]");
        int n = Math.max(0, this.builder.length() - stringArray[stringArray.length - 1].length() - 1);
        this.builder.replace(n, this.builder.length(), "");
    }

    public String toString() {
        return this.builder.toString();
    }

    protected KeyBuilder clone() {
        return new KeyBuilder(this);
    }
}

