/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.utils;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.handlers.WorldObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class Metrics {
    private final Plugin plugin;
    private final MetricsBase metricsBase;
    public static Map<String, Integer> disasterOccurredMap = new LinkedHashMap<String, Integer>();
    public static Map<String, Integer> disasterSpawnedMap = new LinkedHashMap<String, Integer>();
    public static Map<String, Integer> disasterDestroyedMap = new LinkedHashMap<String, Integer>();
    public static Map<String, Integer> disasterKillMap = new LinkedHashMap<String, Integer>();

    public static void configureMetrics(final Main main) {
        int n;
        int n2;
        int n3;
        Metrics metrics = new Metrics(main, 16366);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!main.dataFile.contains("metrics.occurred")) {
            int n4 = 0;
            while (n4 < 22) {
                arrayList.add(0);
                ++n4;
            }
            main.dataFile.set("metrics.occurred", arrayList);
            main.saveDataFile();
        } else {
            List list = main.dataFile.getIntegerList("metrics.occurred");
            n3 = 0;
            while (n3 < 22) {
                if (n3 < list.size()) {
                    arrayList.add((Integer)list.get(n3));
                } else {
                    arrayList.add(0);
                }
                ++n3;
            }
        }
        disasterOccurredMap.put(Disaster.CUSTOM.getMetricsLabel(), (Integer)arrayList.get(0));
        disasterOccurredMap.put(Disaster.SINKHOLE.getMetricsLabel(), (Integer)arrayList.get(1));
        disasterOccurredMap.put(Disaster.CAVEIN.getMetricsLabel(), (Integer)arrayList.get(2));
        disasterOccurredMap.put(Disaster.TORNADO.getMetricsLabel(), (Integer)arrayList.get(3));
        disasterOccurredMap.put(Disaster.GEYSER.getMetricsLabel(), (Integer)arrayList.get(4));
        disasterOccurredMap.put(Disaster.PLAGUE.getMetricsLabel(), (Integer)arrayList.get(5));
        disasterOccurredMap.put(Disaster.ACIDSTORM.getMetricsLabel(), (Integer)arrayList.get(6));
        disasterOccurredMap.put(Disaster.EXTREMEWINDS.getMetricsLabel(), (Integer)arrayList.get(7));
        disasterOccurredMap.put(Disaster.SOULSTORM.getMetricsLabel(), (Integer)arrayList.get(8));
        disasterOccurredMap.put(Disaster.BLIZZARD.getMetricsLabel(), (Integer)arrayList.get(9));
        disasterOccurredMap.put(Disaster.SANDSTORM.getMetricsLabel(), (Integer)arrayList.get(10));
        disasterOccurredMap.put(Disaster.EARTHQUAKE.getMetricsLabel(), (Integer)arrayList.get(11));
        disasterOccurredMap.put(Disaster.TSUNAMI.getMetricsLabel(), (Integer)arrayList.get(12));
        disasterOccurredMap.put(Disaster.METEORSHOWERS.getMetricsLabel(), (Integer)arrayList.get(13));
        disasterOccurredMap.put(Disaster.ENDSTORM.getMetricsLabel(), (Integer)arrayList.get(14));
        disasterOccurredMap.put(Disaster.SUPERNOVA.getMetricsLabel(), (Integer)arrayList.get(15));
        disasterOccurredMap.put(Disaster.HURRICANE.getMetricsLabel(), (Integer)arrayList.get(16));
        disasterOccurredMap.put(Disaster.PURGE.getMetricsLabel(), (Integer)arrayList.get(17));
        disasterOccurredMap.put(Disaster.SOLARSTORM.getMetricsLabel(), (Integer)arrayList.get(18));
        disasterOccurredMap.put(Disaster.MONSOON.getMetricsLabel(), (Integer)arrayList.get(19));
        disasterOccurredMap.put(Disaster.INFESTEDCAVES.getMetricsLabel(), (Integer)arrayList.get(20));
        disasterOccurredMap.put(Disaster.LANDSLIDE.getMetricsLabel(), (Integer)arrayList.get(21));
        metrics.addCustomChart(new AdvancedPie("disasters_occurred", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (Map.Entry<String, Integer> entry : disasterOccurredMap.entrySet()) {
                    if (entry.getValue() <= 0) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                return hashMap;
            }
        }));
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (!main.dataFile.contains("metrics.spawned")) {
            n3 = 0;
            while (n3 < 22) {
                arrayList2.add(0);
                ++n3;
            }
            main.dataFile.set("metrics.spawned", arrayList2);
            main.saveDataFile();
        } else {
            List list = main.dataFile.getIntegerList("metrics.spawned");
            n2 = 0;
            while (n2 < 22) {
                if (n2 < list.size()) {
                    arrayList2.add((Integer)list.get(n2));
                } else {
                    arrayList2.add(0);
                }
                ++n2;
            }
        }
        disasterSpawnedMap.put(Disaster.CUSTOM.getMetricsLabel(), (Integer)arrayList2.get(0));
        disasterSpawnedMap.put(Disaster.SINKHOLE.getMetricsLabel(), (Integer)arrayList2.get(1));
        disasterSpawnedMap.put(Disaster.CAVEIN.getMetricsLabel(), (Integer)arrayList2.get(2));
        disasterSpawnedMap.put(Disaster.TORNADO.getMetricsLabel(), (Integer)arrayList2.get(3));
        disasterSpawnedMap.put(Disaster.GEYSER.getMetricsLabel(), (Integer)arrayList2.get(4));
        disasterSpawnedMap.put(Disaster.PLAGUE.getMetricsLabel(), (Integer)arrayList2.get(5));
        disasterSpawnedMap.put(Disaster.ACIDSTORM.getMetricsLabel(), (Integer)arrayList2.get(6));
        disasterSpawnedMap.put(Disaster.EXTREMEWINDS.getMetricsLabel(), (Integer)arrayList2.get(7));
        disasterSpawnedMap.put(Disaster.SOULSTORM.getMetricsLabel(), (Integer)arrayList2.get(8));
        disasterSpawnedMap.put(Disaster.BLIZZARD.getMetricsLabel(), (Integer)arrayList2.get(9));
        disasterSpawnedMap.put(Disaster.SANDSTORM.getMetricsLabel(), (Integer)arrayList2.get(10));
        disasterSpawnedMap.put(Disaster.EARTHQUAKE.getMetricsLabel(), (Integer)arrayList2.get(11));
        disasterSpawnedMap.put(Disaster.TSUNAMI.getMetricsLabel(), (Integer)arrayList2.get(12));
        disasterSpawnedMap.put(Disaster.METEORSHOWERS.getMetricsLabel(), (Integer)arrayList2.get(13));
        disasterSpawnedMap.put(Disaster.ENDSTORM.getMetricsLabel(), (Integer)arrayList2.get(14));
        disasterSpawnedMap.put(Disaster.SUPERNOVA.getMetricsLabel(), (Integer)arrayList2.get(15));
        disasterSpawnedMap.put(Disaster.HURRICANE.getMetricsLabel(), (Integer)arrayList2.get(16));
        disasterSpawnedMap.put(Disaster.PURGE.getMetricsLabel(), (Integer)arrayList2.get(17));
        disasterSpawnedMap.put(Disaster.SOLARSTORM.getMetricsLabel(), (Integer)arrayList2.get(18));
        disasterSpawnedMap.put(Disaster.MONSOON.getMetricsLabel(), (Integer)arrayList2.get(19));
        disasterSpawnedMap.put(Disaster.INFESTEDCAVES.getMetricsLabel(), (Integer)arrayList2.get(20));
        disasterSpawnedMap.put(Disaster.LANDSLIDE.getMetricsLabel(), (Integer)arrayList2.get(21));
        metrics.addCustomChart(new AdvancedPie("disasters_spawned", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (Map.Entry<String, Integer> entry : disasterSpawnedMap.entrySet()) {
                    if (entry.getValue() <= 0) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                return hashMap;
            }
        }));
        metrics.addCustomChart(new AdvancedPie("favored_disaster", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                String string = "Not Submitted";
                if (main.dataFile.contains("data.favored") && !main.dataFile.getString("data.favored").equals("null")) {
                    string = main.dataFile.getString("data.favored");
                }
                hashMap.put(string, 1);
                return hashMap;
            }
        }));
        metrics.addCustomChart(new AdvancedPie("disliked_disaster", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                String string = "Not Submitted";
                if (main.dataFile.contains("data.disliked") && !main.dataFile.getString("data.disliked").equals("null")) {
                    string = main.dataFile.getString("data.disliked");
                }
                hashMap.put(string, 1);
                return hashMap;
            }
        }));
        metrics.addCustomChart(new AdvancedPie("disaster_difficulty_level", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                hashMap.put(WorldObject.findWorldObject((World)Bukkit.getWorld((String)"world")).difficulty.toString(), 1);
                return hashMap;
            }
        }));
        metrics.addCustomChart(new AdvancedPie("custom_disasters_installed", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                int n = new File(main.getDataFolder().getAbsolutePath(), "custom disasters").listFiles().length;
                if (n <= 1) {
                    hashMap.put("1", 1);
                } else if (n == 2) {
                    hashMap.put("2", 1);
                } else if (n == 3) {
                    hashMap.put("3", 1);
                } else if (n == 4) {
                    hashMap.put("4", 1);
                } else if (n == 5) {
                    hashMap.put("5", 1);
                } else if (n > 5) {
                    hashMap.put("More Than 5", 1);
                } else if (n > 10) {
                    hashMap.put("More Than 10", 1);
                }
                return hashMap;
            }
        }));
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        if (!main.dataFile.contains("metrics.destroyed")) {
            n2 = 0;
            while (n2 < 14) {
                arrayList3.add(0);
                ++n2;
            }
            main.dataFile.set("metrics.destroyed", arrayList3);
            main.saveDataFile();
        } else {
            List list = main.dataFile.getIntegerList("metrics.destroyed");
            n = 0;
            while (n < 14) {
                if (n < list.size()) {
                    arrayList3.add((Integer)list.get(n));
                } else {
                    arrayList3.add(0);
                }
                ++n;
            }
        }
        disasterDestroyedMap.put(Disaster.SINKHOLE.getMetricsLabel(), (Integer)arrayList3.get(0));
        disasterDestroyedMap.put(Disaster.CAVEIN.getMetricsLabel(), (Integer)arrayList3.get(1));
        disasterDestroyedMap.put(Disaster.TORNADO.getMetricsLabel(), (Integer)arrayList3.get(2));
        disasterDestroyedMap.put(Disaster.GEYSER.getMetricsLabel(), (Integer)arrayList3.get(3));
        disasterDestroyedMap.put(Disaster.ACIDSTORM.getMetricsLabel(), (Integer)arrayList3.get(4));
        disasterDestroyedMap.put(Disaster.EXTREMEWINDS.getMetricsLabel(), (Integer)arrayList3.get(5));
        disasterDestroyedMap.put(Disaster.EARTHQUAKE.getMetricsLabel(), (Integer)arrayList3.get(6));
        disasterDestroyedMap.put(Disaster.TSUNAMI.getMetricsLabel(), (Integer)arrayList3.get(7));
        disasterDestroyedMap.put(Disaster.METEORSHOWERS.getMetricsLabel(), (Integer)arrayList3.get(8));
        disasterDestroyedMap.put(Disaster.SUPERNOVA.getMetricsLabel(), (Integer)arrayList3.get(9));
        disasterDestroyedMap.put(Disaster.HURRICANE.getMetricsLabel(), (Integer)arrayList3.get(10));
        disasterDestroyedMap.put(Disaster.SOLARSTORM.getMetricsLabel(), (Integer)arrayList3.get(11));
        disasterDestroyedMap.put(Disaster.MONSOON.getMetricsLabel(), (Integer)arrayList3.get(12));
        disasterDestroyedMap.put(Disaster.LANDSLIDE.getMetricsLabel(), (Integer)arrayList3.get(13));
        metrics.addCustomChart(new AdvancedPie("blocks_destroyed", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (Map.Entry<String, Integer> entry : disasterDestroyedMap.entrySet()) {
                    if (entry.getValue() <= 0) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                return hashMap;
            }
        }));
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        if (!main.dataFile.contains("metrics.killed")) {
            n = 0;
            while (n < 21) {
                arrayList4.add(0);
                ++n;
            }
            main.dataFile.set("metrics.killed", arrayList4);
            main.saveDataFile();
        } else {
            List list = main.dataFile.getIntegerList("metrics.killed");
            int n5 = 0;
            while (n5 < 21) {
                if (n5 < list.size()) {
                    arrayList4.add((Integer)list.get(n5));
                } else {
                    arrayList4.add(0);
                }
                ++n5;
            }
        }
        disasterKillMap.put(Disaster.SINKHOLE.getMetricsLabel(), (Integer)arrayList4.get(0));
        disasterKillMap.put(Disaster.CAVEIN.getMetricsLabel(), (Integer)arrayList4.get(1));
        disasterKillMap.put(Disaster.TORNADO.getMetricsLabel(), (Integer)arrayList4.get(2));
        disasterKillMap.put(Disaster.GEYSER.getMetricsLabel(), (Integer)arrayList4.get(3));
        disasterKillMap.put(Disaster.PLAGUE.getMetricsLabel(), (Integer)arrayList4.get(4));
        disasterKillMap.put(Disaster.ACIDSTORM.getMetricsLabel(), (Integer)arrayList4.get(5));
        disasterKillMap.put(Disaster.EXTREMEWINDS.getMetricsLabel(), (Integer)arrayList4.get(6));
        disasterKillMap.put(Disaster.SOULSTORM.getMetricsLabel(), (Integer)arrayList4.get(7));
        disasterKillMap.put(Disaster.BLIZZARD.getMetricsLabel(), (Integer)arrayList4.get(8));
        disasterKillMap.put(Disaster.SANDSTORM.getMetricsLabel(), (Integer)arrayList4.get(9));
        disasterKillMap.put(Disaster.EARTHQUAKE.getMetricsLabel(), (Integer)arrayList4.get(10));
        disasterKillMap.put(Disaster.TSUNAMI.getMetricsLabel(), (Integer)arrayList4.get(11));
        disasterKillMap.put(Disaster.METEORSHOWERS.getMetricsLabel(), (Integer)arrayList4.get(12));
        disasterKillMap.put(Disaster.ENDSTORM.getMetricsLabel(), (Integer)arrayList4.get(13));
        disasterKillMap.put(Disaster.SUPERNOVA.getMetricsLabel(), (Integer)arrayList4.get(14));
        disasterKillMap.put(Disaster.HURRICANE.getMetricsLabel(), (Integer)arrayList4.get(15));
        disasterKillMap.put(Disaster.PURGE.getMetricsLabel(), (Integer)arrayList4.get(16));
        disasterKillMap.put(Disaster.SOLARSTORM.getMetricsLabel(), (Integer)arrayList4.get(17));
        disasterKillMap.put(Disaster.MONSOON.getMetricsLabel(), (Integer)arrayList4.get(18));
        disasterKillMap.put(Disaster.INFESTEDCAVES.getMetricsLabel(), (Integer)arrayList4.get(19));
        disasterKillMap.put(Disaster.LANDSLIDE.getMetricsLabel(), (Integer)arrayList4.get(20));
        metrics.addCustomChart(new AdvancedPie("players_killed", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (Map.Entry<String, Integer> entry : disasterKillMap.entrySet()) {
                    if (entry.getValue() <= 0) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                return hashMap;
            }
        }));
    }

    public static void saveMetricsData(Main main) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<String, Integer> entry : disasterOccurredMap.entrySet()) {
            arrayList.add(entry.getValue());
        }
        main.dataFile.set("metrics.occurred", arrayList);
        arrayList.clear();
        for (Map.Entry<String, Integer> entry : disasterSpawnedMap.entrySet()) {
            arrayList.add(entry.getValue());
        }
        main.dataFile.set("metrics.spawned", arrayList);
        arrayList.clear();
        for (Map.Entry<String, Integer> entry : disasterDestroyedMap.entrySet()) {
            arrayList.add(entry.getValue());
        }
        main.dataFile.set("metrics.destroyed", arrayList);
        arrayList.clear();
        for (Map.Entry<String, Integer> entry : disasterKillMap.entrySet()) {
            arrayList.add(entry.getValue());
        }
        main.dataFile.set("metrics.killed", arrayList);
    }

    public static void incrementValue(Map<String, Integer> map, String string) {
        map.replace(string, map.get(string) + 1);
    }

    public static void incrementValue(Map<String, Integer> map, String string, int n) {
        map.replace(string, map.get(string) + n);
    }

    public Metrics(JavaPlugin javaPlugin, int n) {
        this.plugin = javaPlugin;
        File file = new File(javaPlugin.getDataFolder().getParentFile(), "bStats");
        File file2 = new File(file, "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
        if (!yamlConfiguration.isSet("serverUuid")) {
            yamlConfiguration.addDefault("enabled", (Object)true);
            yamlConfiguration.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            yamlConfiguration.addDefault("logFailedRequests", (Object)false);
            yamlConfiguration.addDefault("logSentData", (Object)false);
            yamlConfiguration.addDefault("logResponseStatusText", (Object)false);
            yamlConfiguration.options().header("bStats (https://bStats.org) collects some basic information for plugin authors, like how\nmany people use their plugin and their total player count. It's recommended to keep bStats\nenabled, but if you're not comfortable with this, you can turn this setting off. There is no\nperformance penalty associated with having metrics enabled, and data sent to bStats is fully\nanonymous.").copyDefaults(true);
            try {
                yamlConfiguration.save(file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean bl = yamlConfiguration.getBoolean("enabled", true);
        String string2 = yamlConfiguration.getString("serverUuid");
        boolean bl2 = yamlConfiguration.getBoolean("logFailedRequests", false);
        boolean bl3 = yamlConfiguration.getBoolean("logSentData", false);
        boolean bl4 = yamlConfiguration.getBoolean("logResponseStatusText", false);
        this.metricsBase = new MetricsBase("bukkit", string2, n, bl, this::appendPlatformData, this::appendServiceData, runnable -> {
            BukkitTask bukkitTask = Bukkit.getScheduler().runTask((Plugin)javaPlugin, runnable);
        }, () -> ((JavaPlugin)javaPlugin).isEnabled(), (string, throwable) -> this.plugin.getLogger().log(Level.WARNING, (String)string, (Throwable)throwable), string -> this.plugin.getLogger().log(Level.INFO, (String)string), bl2, bl3, bl4);
    }

    public void addCustomChart(CustomChart customChart) {
        this.metricsBase.addCustomChart(customChart);
    }

    private void appendPlatformData(JsonObjectBuilder jsonObjectBuilder) {
        jsonObjectBuilder.appendField("playerAmount", this.getPlayerAmount());
        jsonObjectBuilder.appendField("onlineMode", Bukkit.getOnlineMode() ? 1 : 0);
        jsonObjectBuilder.appendField("bukkitVersion", Bukkit.getVersion());
        jsonObjectBuilder.appendField("bukkitName", Bukkit.getName());
        jsonObjectBuilder.appendField("javaVersion", System.getProperty("java.version"));
        jsonObjectBuilder.appendField("osName", System.getProperty("os.name"));
        jsonObjectBuilder.appendField("osArch", System.getProperty("os.arch"));
        jsonObjectBuilder.appendField("osVersion", System.getProperty("os.version"));
        jsonObjectBuilder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private void appendServiceData(JsonObjectBuilder jsonObjectBuilder) {
        jsonObjectBuilder.appendField("pluginVersion", this.plugin.getDescription().getVersion());
    }

    private int getPlayerAmount() {
        try {
            Method method = Class.forName("org.bukkit.Server").getMethod("getOnlinePlayers", new Class[0]);
            return method.getReturnType().equals(Collection.class) ? ((Collection)method.invoke((Object)Bukkit.getServer(), new Object[0])).size() : ((Player[])method.invoke((Object)Bukkit.getServer(), new Object[0])).length;
        }
        catch (Exception exception) {
            return Bukkit.getOnlinePlayers().size();
        }
    }

    public static class AdvancedBarChart
    extends CustomChart {
        private final Callable<Map<String, int[]>> callable;

        public AdvancedBarChart(String string, Callable<Map<String, int[]>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObjectBuilder.JsonObject getChartData() {
            JsonObjectBuilder jsonObjectBuilder = new JsonObjectBuilder();
            Map<String, int[]> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, int[]> entry : map.entrySet()) {
                if (entry.getValue().length == 0) continue;
                bl = false;
                jsonObjectBuilder.appendField(entry.getKey(), entry.getValue());
            }
            if (bl) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", jsonObjectBuilder.build()).build();
        }
    }

    public static class AdvancedPie
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public AdvancedPie(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObjectBuilder.JsonObject getChartData() {
            JsonObjectBuilder jsonObjectBuilder = new JsonObjectBuilder();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                bl = false;
                jsonObjectBuilder.appendField(entry.getKey(), entry.getValue());
            }
            if (bl) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", jsonObjectBuilder.build()).build();
        }
    }

    public static abstract class CustomChart {
        private final String chartId;

        protected CustomChart(String string) {
            if (string == null) {
                throw new IllegalArgumentException("chartId must not be null");
            }
            this.chartId = string;
        }

        public JsonObjectBuilder.JsonObject getRequestJsonObject(BiConsumer<String, Throwable> biConsumer, boolean bl) {
            JsonObjectBuilder.JsonObject jsonObject;
            JsonObjectBuilder jsonObjectBuilder;
            block4: {
                jsonObjectBuilder = new JsonObjectBuilder();
                jsonObjectBuilder.appendField("chartId", this.chartId);
                try {
                    jsonObject = this.getChartData();
                    if (jsonObject != null) break block4;
                    return null;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        biConsumer.accept("Failed to get data for custom chart with id " + this.chartId, throwable);
                    }
                    return null;
                }
            }
            jsonObjectBuilder.appendField("data", jsonObject);
            return jsonObjectBuilder.build();
        }

        protected abstract JsonObjectBuilder.JsonObject getChartData();
    }

    public static class DrilldownPie
    extends CustomChart {
        private final Callable<Map<String, Map<String, Integer>>> callable;

        public DrilldownPie(String string, Callable<Map<String, Map<String, Integer>>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        public JsonObjectBuilder.JsonObject getChartData() {
            JsonObjectBuilder jsonObjectBuilder = new JsonObjectBuilder();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Map<String, Integer>> entry : map.entrySet()) {
                JsonObjectBuilder jsonObjectBuilder2 = new JsonObjectBuilder();
                boolean bl2 = true;
                for (Map.Entry<String, Integer> entry2 : map.get(entry.getKey()).entrySet()) {
                    jsonObjectBuilder2.appendField(entry2.getKey(), entry2.getValue());
                    bl2 = false;
                }
                if (bl2) continue;
                bl = false;
                jsonObjectBuilder.appendField(entry.getKey(), jsonObjectBuilder2.build());
            }
            if (bl) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", jsonObjectBuilder.build()).build();
        }
    }

    public static class JsonObjectBuilder {
        private StringBuilder builder = new StringBuilder();
        private boolean hasAtLeastOneField = false;

        public JsonObjectBuilder() {
            this.builder.append("{");
        }

        public JsonObjectBuilder appendNull(String string) {
            this.appendFieldUnescaped(string, "null");
            return this;
        }

        public JsonObjectBuilder appendField(String string, String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("JSON value must not be null");
            }
            this.appendFieldUnescaped(string, "\"" + JsonObjectBuilder.escape(string2) + "\"");
            return this;
        }

        public JsonObjectBuilder appendField(String string, int n) {
            this.appendFieldUnescaped(string, String.valueOf(n));
            return this;
        }

        public JsonObjectBuilder appendField(String string, JsonObject jsonObject) {
            if (jsonObject == null) {
                throw new IllegalArgumentException("JSON object must not be null");
            }
            this.appendFieldUnescaped(string, jsonObject.toString());
            return this;
        }

        public JsonObjectBuilder appendField(String string2, String[] stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException("JSON values must not be null");
            }
            String string3 = Arrays.stream(stringArray).map(string -> "\"" + JsonObjectBuilder.escape(string) + "\"").collect(Collectors.joining(","));
            this.appendFieldUnescaped(string2, "[" + string3 + "]");
            return this;
        }

        public JsonObjectBuilder appendField(String string, int[] nArray) {
            if (nArray == null) {
                throw new IllegalArgumentException("JSON values must not be null");
            }
            String string2 = Arrays.stream(nArray).mapToObj(String::valueOf).collect(Collectors.joining(","));
            this.appendFieldUnescaped(string, "[" + string2 + "]");
            return this;
        }

        public JsonObjectBuilder appendField(String string, JsonObject[] jsonObjectArray) {
            if (jsonObjectArray == null) {
                throw new IllegalArgumentException("JSON values must not be null");
            }
            String string2 = Arrays.stream(jsonObjectArray).map(JsonObject::toString).collect(Collectors.joining(","));
            this.appendFieldUnescaped(string, "[" + string2 + "]");
            return this;
        }

        private void appendFieldUnescaped(String string, String string2) {
            if (this.builder == null) {
                throw new IllegalStateException("JSON has already been built");
            }
            if (string == null) {
                throw new IllegalArgumentException("JSON key must not be null");
            }
            if (this.hasAtLeastOneField) {
                this.builder.append(",");
            }
            this.builder.append("\"").append(JsonObjectBuilder.escape(string)).append("\":").append(string2);
            this.hasAtLeastOneField = true;
        }

        public JsonObject build() {
            if (this.builder == null) {
                throw new IllegalStateException("JSON has already been built");
            }
            JsonObject jsonObject = new JsonObject(this.builder.append("}").toString());
            this.builder = null;
            return jsonObject;
        }

        private static String escape(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\"') {
                    stringBuilder.append("\\\"");
                } else if (c == '\\') {
                    stringBuilder.append("\\\\");
                } else if (c <= '\u000f') {
                    stringBuilder.append("\\u000").append(Integer.toHexString(c));
                } else if (c <= '\u001f') {
                    stringBuilder.append("\\u00").append(Integer.toHexString(c));
                } else {
                    stringBuilder.append(c);
                }
                ++n;
            }
            return stringBuilder.toString();
        }

        public static class JsonObject {
            private final String value;

            private JsonObject(String string) {
                this.value = string;
            }

            public String toString() {
                return this.value;
            }
        }
    }

    public static class MetricsBase {
        public static final String METRICS_VERSION = "3.0.0";
        private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, runnable -> new Thread(runnable, "bStats-Metrics"));
        private static final String REPORT_URL = "https://bStats.org/api/v2/data/%s";
        private final String platform;
        private final String serverUuid;
        private final int serviceId;
        private final Consumer<JsonObjectBuilder> appendPlatformDataConsumer;
        private final Consumer<JsonObjectBuilder> appendServiceDataConsumer;
        private final Consumer<Runnable> submitTaskConsumer;
        private final Supplier<Boolean> checkServiceEnabledSupplier;
        private final BiConsumer<String, Throwable> errorLogger;
        private final Consumer<String> infoLogger;
        private final boolean logErrors;
        private final boolean logSentData;
        private final boolean logResponseStatusText;
        private final Set<CustomChart> customCharts = new HashSet<CustomChart>();
        private final boolean enabled;

        public MetricsBase(String string, String string2, int n, boolean bl, Consumer<JsonObjectBuilder> consumer, Consumer<JsonObjectBuilder> consumer2, Consumer<Runnable> consumer3, Supplier<Boolean> supplier, BiConsumer<String, Throwable> biConsumer, Consumer<String> consumer4, boolean bl2, boolean bl3, boolean bl4) {
            this.platform = string;
            this.serverUuid = string2;
            this.serviceId = n;
            this.enabled = bl;
            this.appendPlatformDataConsumer = consumer;
            this.appendServiceDataConsumer = consumer2;
            this.submitTaskConsumer = consumer3;
            this.checkServiceEnabledSupplier = supplier;
            this.errorLogger = biConsumer;
            this.infoLogger = consumer4;
            this.logErrors = bl2;
            this.logSentData = bl3;
            this.logResponseStatusText = bl4;
            this.checkRelocation();
            if (bl) {
                this.startSubmitting();
            }
        }

        public void addCustomChart(CustomChart customChart) {
            this.customCharts.add(customChart);
        }

        private void startSubmitting() {
            Runnable runnable = () -> {
                if (!this.enabled || !this.checkServiceEnabledSupplier.get().booleanValue()) {
                    scheduler.shutdown();
                    return;
                }
                if (this.submitTaskConsumer != null) {
                    this.submitTaskConsumer.accept(this::submitData);
                } else {
                    this.submitData();
                }
            };
            long l = (long)(60000.0 * (3.0 + Math.random() * 3.0));
            long l2 = (long)(60000.0 * (Math.random() * 30.0));
            scheduler.schedule(runnable, l, TimeUnit.MILLISECONDS);
            scheduler.scheduleAtFixedRate(runnable, l + l2, 1800000L, TimeUnit.MILLISECONDS);
        }

        private void submitData() {
            JsonObjectBuilder jsonObjectBuilder = new JsonObjectBuilder();
            this.appendPlatformDataConsumer.accept(jsonObjectBuilder);
            JsonObjectBuilder jsonObjectBuilder2 = new JsonObjectBuilder();
            this.appendServiceDataConsumer.accept(jsonObjectBuilder2);
            JsonObjectBuilder.JsonObject[] jsonObjectArray = (JsonObjectBuilder.JsonObject[])this.customCharts.stream().map(customChart -> customChart.getRequestJsonObject(this.errorLogger, this.logErrors)).filter(Objects::nonNull).toArray(JsonObjectBuilder.JsonObject[]::new);
            jsonObjectBuilder2.appendField("id", this.serviceId);
            jsonObjectBuilder2.appendField("customCharts", jsonObjectArray);
            jsonObjectBuilder.appendField("service", jsonObjectBuilder2.build());
            jsonObjectBuilder.appendField("serverUUID", this.serverUuid);
            jsonObjectBuilder.appendField("metricsVersion", METRICS_VERSION);
            JsonObjectBuilder.JsonObject jsonObject = jsonObjectBuilder.build();
            scheduler.execute(() -> {
                block2: {
                    try {
                        this.sendData(jsonObject);
                    }
                    catch (Exception exception) {
                        if (!this.logErrors) break block2;
                        this.errorLogger.accept("Could not submit bStats metrics data", exception);
                    }
                }
            });
        }

        private void sendData(JsonObjectBuilder.JsonObject jsonObject) {
            DataOutputStream dataOutputStream;
            if (this.logSentData) {
                this.infoLogger.accept("Sent bStats metrics data: " + jsonObject.toString());
            }
            String string = String.format(REPORT_URL, this.platform);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL(string).openConnection();
            byte[] byArray = MetricsBase.compress(jsonObject.toString());
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.addRequestProperty("Accept", "application/json");
            httpsURLConnection.addRequestProperty("Connection", "close");
            httpsURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpsURLConnection.addRequestProperty("Content-Length", String.valueOf(byArray.length));
            httpsURLConnection.setRequestProperty("Content-Type", "application/json");
            httpsURLConnection.setRequestProperty("User-Agent", "Metrics-Service/1");
            httpsURLConnection.setDoOutput(true);
            Serializable serializable = null;
            Throwable throwable = null;
            try {
                dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
                try {
                    dataOutputStream.write(byArray);
                }
                finally {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (serializable == null) {
                    serializable = throwable2;
                } else if (serializable != throwable2) {
                    ((Throwable)serializable).addSuppressed(throwable2);
                }
                throw serializable;
            }
            serializable = new StringBuilder();
            throwable = null;
            dataOutputStream = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    ((StringBuilder)serializable).append(string2);
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            if (this.logResponseStatusText) {
                this.infoLogger.accept("Sent data to bStats and received response: " + serializable);
            }
        }

        private void checkRelocation() {
            if (System.getProperty("bstats.relocatecheck") == null || !System.getProperty("bstats.relocatecheck").equals("false")) {
                String string = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115});
                String string2 = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
                if (MetricsBase.class.getPackage().getName().startsWith(string) || MetricsBase.class.getPackage().getName().startsWith(string2)) {
                    throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
                }
            }
        }

        private static byte[] compress(String string) {
            if (string == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var3_4 = null;
            try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gZIPOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static class MultiLineChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public MultiLineChart(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObjectBuilder.JsonObject getChartData() {
            JsonObjectBuilder jsonObjectBuilder = new JsonObjectBuilder();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                bl = false;
                jsonObjectBuilder.appendField(entry.getKey(), entry.getValue());
            }
            if (bl) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", jsonObjectBuilder.build()).build();
        }
    }

    public static class SimpleBarChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public SimpleBarChart(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObjectBuilder.JsonObject getChartData() {
            JsonObjectBuilder jsonObjectBuilder = new JsonObjectBuilder();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                jsonObjectBuilder.appendField(entry.getKey(), new int[]{entry.getValue()});
            }
            return new JsonObjectBuilder().appendField("values", jsonObjectBuilder.build()).build();
        }
    }

    public static class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        public SimplePie(String string, Callable<String> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObjectBuilder.JsonObject getChartData() {
            String string = this.callable.call();
            if (string == null || string.isEmpty()) {
                return null;
            }
            return new JsonObjectBuilder().appendField("value", string).build();
        }
    }

    public static class SingleLineChart
    extends CustomChart {
        private final Callable<Integer> callable;

        public SingleLineChart(String string, Callable<Integer> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObjectBuilder.JsonObject getChartData() {
            int n = this.callable.call();
            if (n == 0) {
                return null;
            }
            return new JsonObjectBuilder().appendField("value", n).build();
        }
    }
}

