/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.StreamIterator;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.filefilter.FileEqualsFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;

public class FileUtils {
    public static final long ONE_KB = 1024L;
    public static final BigInteger ONE_KB_BI = BigInteger.valueOf(1024L);
    public static final long ONE_MB = 0x100000L;
    public static final BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);
    public static final long ONE_GB = 0x40000000L;
    public static final BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);
    public static final long ONE_TB = 0x10000000000L;
    public static final BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);
    public static final long ONE_PB = 0x4000000000000L;
    public static final BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);
    public static final long ONE_EB = 0x1000000000000000L;
    public static final BigInteger ONE_EB_BI = ONE_KB_BI.multiply(ONE_PB_BI);
    public static final BigInteger ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
    public static final BigInteger ONE_YB = ONE_KB_BI.multiply(ONE_ZB);
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    private static CopyOption[] addCopyAttributes(CopyOption ... copyOptionArray) {
        Object[] objectArray = Arrays.copyOf(copyOptionArray, copyOptionArray.length + 1);
        Arrays.sort(objectArray, 0, copyOptionArray.length);
        if (Arrays.binarySearch(copyOptionArray, 0, copyOptionArray.length, StandardCopyOption.COPY_ATTRIBUTES) >= 0) {
            return copyOptionArray;
        }
        objectArray[objectArray.length - 1] = StandardCopyOption.COPY_ATTRIBUTES;
        return objectArray;
    }

    public static String byteCountToDisplaySize(BigInteger bigInteger) {
        Objects.requireNonNull(bigInteger, "size");
        String string = bigInteger.divide(ONE_EB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_EB_BI) + " EB" : (bigInteger.divide(ONE_PB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_PB_BI) + " PB" : (bigInteger.divide(ONE_TB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_TB_BI) + " TB" : (bigInteger.divide(ONE_GB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_GB_BI) + " GB" : (bigInteger.divide(ONE_MB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_MB_BI) + " MB" : (bigInteger.divide(ONE_KB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_KB_BI) + " KB" : bigInteger + " bytes")))));
        return string;
    }

    public static String byteCountToDisplaySize(long l) {
        return FileUtils.byteCountToDisplaySize(BigInteger.valueOf(l));
    }

    public static Checksum checksum(File file, Checksum checksum) {
        FileUtils.requireExistsChecked(file, "file");
        FileUtils.requireFile(file, "file");
        Objects.requireNonNull(checksum, "checksum");
        try (CheckedInputStream checkedInputStream = new CheckedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), checksum);){
            IOUtils.consume(checkedInputStream);
        }
        return checksum;
    }

    public static long checksumCRC32(File file) {
        return FileUtils.checksum(file, new CRC32()).getValue();
    }

    public static void cleanDirectory(File file) {
        File[] fileArray = FileUtils.listFiles(file, null);
        ArrayList<IOException> arrayList = new ArrayList<IOException>();
        for (File file2 : fileArray) {
            try {
                FileUtils.forceDelete(file2);
            }
            catch (IOException iOException) {
                arrayList.add(iOException);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new IOExceptionList(file.toString(), arrayList);
        }
    }

    private static void cleanDirectoryOnExit(File file) {
        File[] fileArray = FileUtils.listFiles(file, null);
        ArrayList<IOException> arrayList = new ArrayList<IOException>();
        for (File file2 : fileArray) {
            try {
                FileUtils.forceDeleteOnExit(file2);
            }
            catch (IOException iOException) {
                arrayList.add(iOException);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new IOExceptionList(arrayList);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEquals(File var0, File var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEqualsIgnoreEOL(File var0, File var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File[] convertFileCollectionToFileArray(Collection<File> collection) {
        return collection.toArray(EMPTY_FILE_ARRAY);
    }

    public static void copyDirectory(File file, File file2) {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl) {
        FileUtils.copyDirectory(file, file2, null, bl);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) {
        FileUtils.copyDirectory(file, file2, fileFilter, true);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl) {
        FileUtils.copyDirectory(file, file2, fileFilter, bl, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl, CopyOption ... copyOptionArray) {
        File[] fileArray;
        FileUtils.requireFileCopy(file, file2);
        FileUtils.requireDirectory(file, "srcDir");
        FileUtils.requireCanonicalPathsNotEquals(file, file2);
        ArrayList<String> arrayList = null;
        String string = file.getCanonicalPath();
        String string2 = file2.getCanonicalPath();
        if (string2.startsWith(string) && (fileArray = FileUtils.listFiles(file, fileFilter)).length > 0) {
            arrayList = new ArrayList<String>(fileArray.length);
            for (File file3 : fileArray) {
                File file4 = new File(file2, file3.getName());
                arrayList.add(file4.getCanonicalPath());
            }
        }
        FileUtils.doCopyDirectory(file, file2, fileFilter, arrayList, bl, bl ? FileUtils.addCopyAttributes(copyOptionArray) : copyOptionArray);
    }

    public static void copyDirectoryToDirectory(File file, File file2) {
        FileUtils.requireDirectoryIfExists(file, "sourceDir");
        FileUtils.requireDirectoryIfExists(file2, "destinationDir");
        FileUtils.copyDirectory(file, new File(file2, file.getName()), true);
    }

    public static void copyFile(File file, File file2) {
        FileUtils.copyFile(file, file2, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File file, File file2, boolean bl) {
        CopyOption[] copyOptionArray;
        if (bl) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
        }
        FileUtils.copyFile(file, file2, copyOptionArray);
    }

    public static void copyFile(File file, File file2, boolean bl, CopyOption ... copyOptionArray) {
        FileUtils.copyFile(file, file2, bl ? FileUtils.addCopyAttributes(copyOptionArray) : copyOptionArray);
    }

    public static void copyFile(File file, File file2, CopyOption ... copyOptionArray) {
        FileUtils.requireFileCopy(file, file2);
        FileUtils.requireFile(file, "srcFile");
        FileUtils.requireCanonicalPathsNotEquals(file, file2);
        FileUtils.createParentDirectories(file2);
        FileUtils.requireFileIfExists(file2, "destFile");
        if (file2.exists()) {
            FileUtils.requireCanWrite(file2, "destFile");
        }
        Files.copy(file.toPath(), file2.toPath(), copyOptionArray);
        FileUtils.requireEqualSizes(file, file2, file.length(), file2.length());
    }

    public static long copyFile(File file, OutputStream outputStream) {
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            long l = IOUtils.copyLarge(inputStream, outputStream);
            return l;
        }
    }

    public static void copyFileToDirectory(File file, File file2) {
        FileUtils.copyFileToDirectory(file, file2, true);
    }

    public static void copyFileToDirectory(File file, File file2, boolean bl) {
        Objects.requireNonNull(file, "sourceFile");
        FileUtils.requireDirectoryIfExists(file2, "destinationDir");
        FileUtils.copyFile(file, new File(file2, file.getName()), bl);
    }

    public static void copyInputStreamToFile(InputStream inputStream, File file) {
        try (InputStream inputStream2 = inputStream;){
            FileUtils.copyToFile(inputStream2, file);
        }
    }

    public static void copyToDirectory(File file, File file2) {
        Objects.requireNonNull(file, "sourceFile");
        if (file.isFile()) {
            FileUtils.copyFileToDirectory(file, file2);
        } else if (file.isDirectory()) {
            FileUtils.copyDirectoryToDirectory(file, file2);
        } else {
            throw new FileNotFoundException("The source " + file + " does not exist");
        }
    }

    public static void copyToDirectory(Iterable<File> iterable, File file) {
        Objects.requireNonNull(iterable, "sourceIterable");
        for (File file2 : iterable) {
            FileUtils.copyFileToDirectory(file2, file);
        }
    }

    public static void copyToFile(InputStream inputStream, File file) {
        try (FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);){
            IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
        }
    }

    public static void copyURLToFile(URL uRL, File file) {
        try (InputStream inputStream = uRL.openStream();){
            FileUtils.copyInputStreamToFile(inputStream, file);
        }
    }

    public static void copyURLToFile(URL uRL, File file, int n, int n2) {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(n);
        uRLConnection.setReadTimeout(n2);
        try (InputStream inputStream = uRLConnection.getInputStream();){
            FileUtils.copyInputStreamToFile(inputStream, file);
        }
    }

    public static File createParentDirectories(File file) {
        return FileUtils.mkdirs(FileUtils.getParentFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decodeUrl(String string) {
        String string2 = string;
        if (string != null && string.indexOf(37) >= 0) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            int n2 = 0;
            while (n2 < n) {
                if (string.charAt(n2) == '%') {
                    try {
                        do {
                            byte by = (byte)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                            byteBuffer.put(by);
                        } while ((n2 += 3) < n && string.charAt(n2) == '%');
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        if (byteBuffer.position() <= 0) continue;
                        byteBuffer.flip();
                        stringBuilder.append(StandardCharsets.UTF_8.decode(byteBuffer).toString());
                        byteBuffer.clear();
                        continue;
                    }
                }
                stringBuilder.append(string.charAt(n2++));
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public static File delete(File file) {
        Objects.requireNonNull(file, "file");
        Files.delete(file.toPath());
        return file;
    }

    public static void deleteDirectory(File file) {
        Objects.requireNonNull(file, "directory");
        if (!file.exists()) {
            return;
        }
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectory(file);
        }
        FileUtils.delete(file);
    }

    private static void deleteDirectoryOnExit(File file) {
        if (!file.exists()) {
            return;
        }
        file.deleteOnExit();
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectoryOnExit(file);
        }
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtils.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean directoryContains(File file, File file2) {
        FileUtils.requireDirectoryExists(file, "directory");
        if (file2 == null) {
            return false;
        }
        if (!file.exists() || !file2.exists()) {
            return false;
        }
        return FilenameUtils.directoryContains(file.getCanonicalPath(), file2.getCanonicalPath());
    }

    private static void doCopyDirectory(File file, File file2, FileFilter fileFilter, List<String> list, boolean bl, CopyOption ... copyOptionArray) {
        File[] fileArray = FileUtils.listFiles(file, fileFilter);
        FileUtils.requireDirectoryIfExists(file2, "destDir");
        FileUtils.mkdirs(file2);
        FileUtils.requireCanWrite(file2, "destDir");
        for (File file3 : fileArray) {
            File file4 = new File(file2, file3.getName());
            if (list != null && list.contains(file3.getCanonicalPath())) continue;
            if (file3.isDirectory()) {
                FileUtils.doCopyDirectory(file3, file4, fileFilter, list, bl, copyOptionArray);
                continue;
            }
            FileUtils.copyFile(file3, file4, copyOptionArray);
        }
        if (bl) {
            FileUtils.setLastModified(file, file2);
        }
    }

    public static void forceDelete(File file) {
        Counters.PathCounters pathCounters;
        Objects.requireNonNull(file, "file");
        try {
            pathCounters = PathUtils.delete(file.toPath(), PathUtils.EMPTY_LINK_OPTION_ARRAY, StandardDeleteOption.OVERRIDE_READ_ONLY);
        }
        catch (IOException iOException) {
            throw new IOException("Cannot delete file: " + file, iOException);
        }
        if (pathCounters.getFileCounter().get() < 1L && pathCounters.getDirectoryCounter().get() < 1L) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
    }

    public static void forceDeleteOnExit(File file) {
        Objects.requireNonNull(file, "file");
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    public static void forceMkdir(File file) {
        FileUtils.mkdirs(file);
    }

    public static void forceMkdirParent(File file) {
        Objects.requireNonNull(file, "file");
        File file2 = FileUtils.getParentFile(file);
        if (file2 == null) {
            return;
        }
        FileUtils.forceMkdir(file2);
    }

    public static File getFile(File file, String ... stringArray) {
        Objects.requireNonNull(file, "directory");
        Objects.requireNonNull(stringArray, "names");
        File file2 = file;
        for (String string : stringArray) {
            file2 = new File(file2, string);
        }
        return file2;
    }

    public static File getFile(String ... stringArray) {
        Objects.requireNonNull(stringArray, "names");
        File file = null;
        for (String string : stringArray) {
            file = file == null ? new File(string) : new File(file, string);
        }
        return file;
    }

    private static File getParentFile(File file) {
        return file == null ? null : file.getParentFile();
    }

    public static File getTempDirectory() {
        return new File(FileUtils.getTempDirectoryPath());
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getUserDirectory() {
        return new File(FileUtils.getUserDirectoryPath());
    }

    public static String getUserDirectoryPath() {
        return System.getProperty("user.home");
    }

    public static boolean isDirectory(File file, LinkOption ... linkOptionArray) {
        return file != null && Files.isDirectory(file.toPath(), linkOptionArray);
    }

    public static boolean isEmptyDirectory(File file) {
        return PathUtils.isEmptyDirectory(file.toPath());
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate) {
        return FileUtils.isFileNewer(file, chronoLocalDate, LocalTime.now());
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(localTime, "localTime");
        return FileUtils.isFileNewer(file, chronoLocalDate.atTime(localTime));
    }

    public static boolean isFileNewer(File file, ChronoLocalDateTime<?> chronoLocalDateTime) {
        return FileUtils.isFileNewer(file, chronoLocalDateTime, ZoneId.systemDefault());
    }

    public static boolean isFileNewer(File file, ChronoLocalDateTime<?> chronoLocalDateTime, ZoneId zoneId) {
        Objects.requireNonNull(chronoLocalDateTime, "chronoLocalDateTime");
        Objects.requireNonNull(zoneId, "zoneId");
        return FileUtils.isFileNewer(file, chronoLocalDateTime.atZone(zoneId));
    }

    public static boolean isFileNewer(File file, ChronoZonedDateTime<?> chronoZonedDateTime) {
        Objects.requireNonNull(chronoZonedDateTime, "chronoZonedDateTime");
        return FileUtils.isFileNewer(file, chronoZonedDateTime.toInstant());
    }

    public static boolean isFileNewer(File file, Date date) {
        Objects.requireNonNull(date, "date");
        return FileUtils.isFileNewer(file, date.getTime());
    }

    public static boolean isFileNewer(File file, File file2) {
        FileUtils.requireExists(file2, "reference");
        return FileUtils.isFileNewer(file, FileUtils.lastModifiedUnchecked(file2));
    }

    public static boolean isFileNewer(File file, Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return FileUtils.isFileNewer(file, instant.toEpochMilli());
    }

    public static boolean isFileNewer(File file, long l) {
        Objects.requireNonNull(file, "file");
        return file.exists() && FileUtils.lastModifiedUnchecked(file) > l;
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate) {
        return FileUtils.isFileOlder(file, chronoLocalDate, LocalTime.now());
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(localTime, "localTime");
        return FileUtils.isFileOlder(file, chronoLocalDate.atTime(localTime));
    }

    public static boolean isFileOlder(File file, ChronoLocalDateTime<?> chronoLocalDateTime) {
        return FileUtils.isFileOlder(file, chronoLocalDateTime, ZoneId.systemDefault());
    }

    public static boolean isFileOlder(File file, ChronoLocalDateTime<?> chronoLocalDateTime, ZoneId zoneId) {
        Objects.requireNonNull(chronoLocalDateTime, "chronoLocalDateTime");
        Objects.requireNonNull(zoneId, "zoneId");
        return FileUtils.isFileOlder(file, chronoLocalDateTime.atZone(zoneId));
    }

    public static boolean isFileOlder(File file, ChronoZonedDateTime<?> chronoZonedDateTime) {
        Objects.requireNonNull(chronoZonedDateTime, "chronoZonedDateTime");
        return FileUtils.isFileOlder(file, chronoZonedDateTime.toInstant());
    }

    public static boolean isFileOlder(File file, Date date) {
        Objects.requireNonNull(date, "date");
        return FileUtils.isFileOlder(file, date.getTime());
    }

    public static boolean isFileOlder(File file, File file2) {
        FileUtils.requireExists(file2, "reference");
        return FileUtils.isFileOlder(file, FileUtils.lastModifiedUnchecked(file2));
    }

    public static boolean isFileOlder(File file, Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return FileUtils.isFileOlder(file, instant.toEpochMilli());
    }

    public static boolean isFileOlder(File file, long l) {
        Objects.requireNonNull(file, "file");
        return file.exists() && FileUtils.lastModifiedUnchecked(file) < l;
    }

    public static boolean isRegularFile(File file, LinkOption ... linkOptionArray) {
        return file != null && Files.isRegularFile(file.toPath(), linkOptionArray);
    }

    public static boolean isSymlink(File file) {
        return file != null && Files.isSymbolicLink(file.toPath());
    }

    public static Iterator<File> iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static Iterator<File> iterateFiles(File file, String[] stringArray, boolean bl) {
        try {
            return StreamIterator.iterator(FileUtils.streamFiles(file, bl, stringArray));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(file.toString(), iOException);
        }
    }

    public static Iterator<File> iterateFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFilesAndDirs(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static long lastModified(File file) {
        return Files.getLastModifiedTime(Objects.requireNonNull(file.toPath(), "file"), new LinkOption[0]).toMillis();
    }

    public static long lastModifiedUnchecked(File file) {
        try {
            return FileUtils.lastModified(file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(file.toString(), iOException);
        }
    }

    public static LineIterator lineIterator(File file) {
        return FileUtils.lineIterator(file, null);
    }

    public static LineIterator lineIterator(File file, String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            return IOUtils.lineIterator((InputStream)fileInputStream, string);
        }
        catch (IOException | RuntimeException exception) {
            IOUtils.closeQuietly((Closeable)fileInputStream, exception::addSuppressed);
            throw exception;
        }
    }

    private static AccumulatorPathVisitor listAccumulate(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        boolean bl = iOFileFilter2 != null;
        FileEqualsFileFilter fileEqualsFileFilter = new FileEqualsFileFilter(file);
        FileEqualsFileFilter fileEqualsFileFilter2 = bl ? fileEqualsFileFilter.or(iOFileFilter2) : fileEqualsFileFilter;
        AccumulatorPathVisitor accumulatorPathVisitor = new AccumulatorPathVisitor(Counters.noopPathCounters(), iOFileFilter, fileEqualsFileFilter2);
        Files.walkFileTree(file.toPath(), Collections.emptySet(), FileUtils.toMaxDepth(bl), accumulatorPathVisitor);
        return accumulatorPathVisitor;
    }

    private static File[] listFiles(File file, FileFilter fileFilter) {
        File[] fileArray;
        FileUtils.requireDirectoryExists(file, "directory");
        File[] fileArray2 = fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        if (fileArray == null) {
            throw new IOException("Unknown I/O error listing contents of directory: " + file);
        }
        return fileArray;
    }

    public static Collection<File> listFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        try {
            AccumulatorPathVisitor accumulatorPathVisitor = FileUtils.listAccumulate(file, iOFileFilter, iOFileFilter2);
            return accumulatorPathVisitor.getFileList().stream().map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(file.toString(), iOException);
        }
    }

    public static Collection<File> listFiles(File file, String[] stringArray, boolean bl) {
        try {
            return FileUtils.toList(FileUtils.streamFiles(file, bl, stringArray));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(file.toString(), iOException);
        }
    }

    public static Collection<File> listFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        try {
            AccumulatorPathVisitor accumulatorPathVisitor = FileUtils.listAccumulate(file, iOFileFilter, iOFileFilter2);
            List<Path> list = accumulatorPathVisitor.getFileList();
            list.addAll(accumulatorPathVisitor.getDirList());
            return list.stream().map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(file.toString(), iOException);
        }
    }

    private static File mkdirs(File file) {
        if (file != null && !file.mkdirs() && !file.isDirectory()) {
            throw new IOException("Cannot create directory '" + file + "'.");
        }
        return file;
    }

    public static void moveDirectory(File file, File file2) {
        FileUtils.validateMoveParameters(file, file2);
        FileUtils.requireDirectory(file, "srcDir");
        FileUtils.requireAbsent(file2, "destDir");
        if (!file.renameTo(file2)) {
            if (file2.getCanonicalPath().startsWith(file.getCanonicalPath() + File.separator)) {
                throw new IOException("Cannot move directory: " + file + " to a subdirectory of itself: " + file2);
            }
            FileUtils.copyDirectory(file, file2);
            FileUtils.deleteDirectory(file);
            if (file.exists()) {
                throw new IOException("Failed to delete original directory '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveDirectoryToDirectory(File file, File file2, boolean bl) {
        FileUtils.validateMoveParameters(file, file2);
        if (!file2.isDirectory()) {
            if (file2.exists()) {
                throw new IOException("Destination '" + file2 + "' is not a directory");
            }
            if (!bl) {
                throw new FileNotFoundException("Destination directory '" + file2 + "' does not exist [createDestDir=" + false + "]");
            }
            FileUtils.mkdirs(file2);
        }
        FileUtils.moveDirectory(file, new File(file2, file.getName()));
    }

    public static void moveFile(File file, File file2) {
        FileUtils.moveFile(file, file2, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static void moveFile(File file, File file2, CopyOption ... copyOptionArray) {
        FileUtils.validateMoveParameters(file, file2);
        FileUtils.requireFile(file, "srcFile");
        FileUtils.requireAbsent(file2, null);
        boolean bl = file.renameTo(file2);
        if (!bl) {
            FileUtils.copyFile(file, file2, copyOptionArray);
            if (!file.delete()) {
                FileUtils.deleteQuietly(file2);
                throw new IOException("Failed to delete original file '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveFileToDirectory(File file, File file2, boolean bl) {
        FileUtils.validateMoveParameters(file, file2);
        if (!file2.exists() && bl) {
            FileUtils.mkdirs(file2);
        }
        FileUtils.requireExistsChecked(file2, "destDir");
        FileUtils.requireDirectory(file2, "destDir");
        FileUtils.moveFile(file, new File(file2, file.getName()));
    }

    public static void moveToDirectory(File file, File file2, boolean bl) {
        FileUtils.validateMoveParameters(file, file2);
        if (file.isDirectory()) {
            FileUtils.moveDirectoryToDirectory(file, file2, bl);
        } else {
            FileUtils.moveFileToDirectory(file, file2, bl);
        }
    }

    public static FileInputStream openInputStream(File file) {
        Objects.requireNonNull(file, "file");
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) {
        return FileUtils.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean bl) {
        Objects.requireNonNull(file, "file");
        if (file.exists()) {
            FileUtils.requireFile(file, "file");
            FileUtils.requireCanWrite(file, "file");
        } else {
            FileUtils.createParentDirectories(file);
        }
        return new FileOutputStream(file, bl);
    }

    public static byte[] readFileToByteArray(File file) {
        try (FileInputStream fileInputStream = FileUtils.openInputStream(file);){
            long l = file.length();
            byte[] byArray = l > 0L ? IOUtils.toByteArray((InputStream)fileInputStream, l) : IOUtils.toByteArray(fileInputStream);
            return byArray;
        }
    }

    @Deprecated
    public static String readFileToString(File file) {
        return FileUtils.readFileToString(file, Charset.defaultCharset());
    }

    public static String readFileToString(File file, Charset charset) {
        try (FileInputStream fileInputStream = FileUtils.openInputStream(file);){
            String string = IOUtils.toString((InputStream)fileInputStream, Charsets.toCharset(charset));
            return string;
        }
    }

    public static String readFileToString(File file, String string) {
        return FileUtils.readFileToString(file, Charsets.toCharset(string));
    }

    @Deprecated
    public static List<String> readLines(File file) {
        return FileUtils.readLines(file, Charset.defaultCharset());
    }

    public static List<String> readLines(File file, Charset charset) {
        try (FileInputStream fileInputStream = FileUtils.openInputStream(file);){
            List<String> list = IOUtils.readLines((InputStream)fileInputStream, Charsets.toCharset(charset));
            return list;
        }
    }

    public static List<String> readLines(File file, String string) {
        return FileUtils.readLines(file, Charsets.toCharset(string));
    }

    private static void requireAbsent(File file, String string) {
        if (file.exists()) {
            throw new FileExistsException(String.format("File element in parameter '%s' already exists: '%s'", string, file));
        }
    }

    private static void requireCanonicalPathsNotEquals(File file, File file2) {
        String string = file.getCanonicalPath();
        if (string.equals(file2.getCanonicalPath())) {
            throw new IllegalArgumentException(String.format("File canonical paths are equal: '%s' (file1='%s', file2='%s')", string, file, file2));
        }
    }

    private static void requireCanWrite(File file, String string) {
        Objects.requireNonNull(file, "file");
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File parameter '" + string + " is not writable: '" + file + "'");
        }
    }

    private static File requireDirectory(File file, String string) {
        Objects.requireNonNull(file, string);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Parameter '" + string + "' is not a directory: '" + file + "'");
        }
        return file;
    }

    private static File requireDirectoryExists(File file, String string) {
        FileUtils.requireExists(file, string);
        FileUtils.requireDirectory(file, string);
        return file;
    }

    private static File requireDirectoryIfExists(File file, String string) {
        Objects.requireNonNull(file, string);
        if (file.exists()) {
            FileUtils.requireDirectory(file, string);
        }
        return file;
    }

    private static void requireEqualSizes(File file, File file2, long l, long l2) {
        if (l != l2) {
            throw new IOException("Failed to copy full contents from '" + file + "' to '" + file2 + "' Expected length: " + l + " Actual: " + l2);
        }
    }

    private static File requireExists(File file, String string) {
        Objects.requireNonNull(file, string);
        if (!file.exists()) {
            throw new IllegalArgumentException("File system element for parameter '" + string + "' does not exist: '" + file + "'");
        }
        return file;
    }

    private static File requireExistsChecked(File file, String string) {
        Objects.requireNonNull(file, string);
        if (!file.exists()) {
            throw new FileNotFoundException("File system element for parameter '" + string + "' does not exist: '" + file + "'");
        }
        return file;
    }

    private static File requireFile(File file, String string) {
        Objects.requireNonNull(file, string);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Parameter '" + string + "' is not a file: " + file);
        }
        return file;
    }

    private static void requireFileCopy(File file, File file2) {
        FileUtils.requireExistsChecked(file, "source");
        Objects.requireNonNull(file2, "destination");
    }

    private static File requireFileIfExists(File file, String string) {
        Objects.requireNonNull(file, string);
        return file.exists() ? FileUtils.requireFile(file, string) : file;
    }

    private static void setLastModified(File file, File file2) {
        Objects.requireNonNull(file, "sourceFile");
        FileUtils.setLastModified(file2, FileUtils.lastModified(file));
    }

    private static void setLastModified(File file, long l) {
        Objects.requireNonNull(file, "file");
        if (!file.setLastModified(l)) {
            throw new IOException(String.format("Failed setLastModified(%s) on '%s'", l, file));
        }
    }

    public static long sizeOf(File file) {
        FileUtils.requireExists(file, "file");
        return file.isDirectory() ? FileUtils.sizeOfDirectory0(file) : file.length();
    }

    private static long sizeOf0(File file) {
        Objects.requireNonNull(file, "file");
        if (file.isDirectory()) {
            return FileUtils.sizeOfDirectory0(file);
        }
        return file.length();
    }

    public static BigInteger sizeOfAsBigInteger(File file) {
        FileUtils.requireExists(file, "file");
        return file.isDirectory() ? FileUtils.sizeOfDirectoryBig0(file) : BigInteger.valueOf(file.length());
    }

    private static BigInteger sizeOfBig0(File file) {
        Objects.requireNonNull(file, "fileOrDir");
        return file.isDirectory() ? FileUtils.sizeOfDirectoryBig0(file) : BigInteger.valueOf(file.length());
    }

    public static long sizeOfDirectory(File file) {
        return FileUtils.sizeOfDirectory0(FileUtils.requireDirectoryExists(file, "directory"));
    }

    private static long sizeOfDirectory0(File file) {
        Objects.requireNonNull(file, "directory");
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        long l = 0L;
        for (File file2 : fileArray) {
            if (!FileUtils.isSymlink(file2) && (l += FileUtils.sizeOf0(file2)) < 0L) break;
        }
        return l;
    }

    public static BigInteger sizeOfDirectoryAsBigInteger(File file) {
        return FileUtils.sizeOfDirectoryBig0(FileUtils.requireDirectoryExists(file, "directory"));
    }

    private static BigInteger sizeOfDirectoryBig0(File file) {
        Objects.requireNonNull(file, "directory");
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return BigInteger.ZERO;
        }
        BigInteger bigInteger = BigInteger.ZERO;
        for (File file2 : fileArray) {
            if (FileUtils.isSymlink(file2)) continue;
            bigInteger = bigInteger.add(FileUtils.sizeOfBig0(file2));
        }
        return bigInteger;
    }

    public static Stream<File> streamFiles(File file, boolean bl, String ... stringArray) {
        IOFileFilter iOFileFilter = stringArray == null ? FileFileFilter.INSTANCE : FileFileFilter.INSTANCE.and(new SuffixFileFilter(FileUtils.toSuffixes(stringArray)));
        return PathUtils.walk(file.toPath(), iOFileFilter, FileUtils.toMaxDepth(bl), false, FileVisitOption.FOLLOW_LINKS).map(Path::toFile);
    }

    public static File toFile(URL uRL) {
        if (uRL == null || !"file".equalsIgnoreCase(uRL.getProtocol())) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        return new File(FileUtils.decodeUrl(string));
    }

    public static File[] toFiles(URL ... uRLArray) {
        if (IOUtils.length(uRLArray) == 0) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = new File[uRLArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = uRLArray[i];
            if (uRL == null) continue;
            if (!"file".equalsIgnoreCase(uRL.getProtocol())) {
                throw new IllegalArgumentException("Can only convert file URL to a File: " + uRL);
            }
            fileArray[i] = FileUtils.toFile(uRL);
        }
        return fileArray;
    }

    private static List<File> toList(Stream<File> stream) {
        return stream.collect(Collectors.toList());
    }

    private static int toMaxDepth(boolean bl) {
        return bl ? Integer.MAX_VALUE : 1;
    }

    private static String[] toSuffixes(String ... stringArray) {
        Objects.requireNonNull(stringArray, "extensions");
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "." + stringArray[i];
        }
        return stringArray2;
    }

    public static void touch(File file) {
        Objects.requireNonNull(file, "file");
        if (!file.exists()) {
            FileUtils.openOutputStream(file).close();
        }
        FileUtils.setLastModified(file, System.currentTimeMillis());
    }

    public static URL[] toURLs(File ... fileArray) {
        Objects.requireNonNull(fileArray, "files");
        URL[] uRLArray = new URL[fileArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            uRLArray[i] = fileArray[i].toURI().toURL();
        }
        return uRLArray;
    }

    private static void validateMoveParameters(File file, File file2) {
        Objects.requireNonNull(file, "source");
        Objects.requireNonNull(file2, "destination");
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitFor(File file, int n) {
        Objects.requireNonNull(file, "file");
        long l = System.currentTimeMillis() + (long)n * 1000L;
        boolean bl = false;
        try {
            while (!file.exists()) {
                long l2 = l - System.currentTimeMillis();
                if (l2 < 0L) {
                    boolean bl2 = false;
                    return bl2;
                }
                try {
                    Thread.sleep(Math.min(100L, l2));
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence) {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence, boolean bl) {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), bl);
    }

    public static void write(File file, CharSequence charSequence, Charset charset) {
        FileUtils.write(file, charSequence, charset, false);
    }

    public static void write(File file, CharSequence charSequence, Charset charset, boolean bl) {
        FileUtils.writeStringToFile(file, Objects.toString(charSequence, null), charset, bl);
    }

    public static void write(File file, CharSequence charSequence, String string) {
        FileUtils.write(file, charSequence, string, false);
    }

    public static void write(File file, CharSequence charSequence, String string, boolean bl) {
        FileUtils.write(file, charSequence, Charsets.toCharset(string), bl);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) {
        FileUtils.writeByteArrayToFile(file, byArray, false);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, boolean bl) {
        FileUtils.writeByteArrayToFile(file, byArray, 0, byArray.length, bl);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, int n, int n2) {
        FileUtils.writeByteArrayToFile(file, byArray, n, n2, false);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, int n, int n2, boolean bl) {
        try (FileOutputStream fileOutputStream = FileUtils.openOutputStream(file, bl);){
            ((OutputStream)fileOutputStream).write(byArray, n, n2);
        }
    }

    public static void writeLines(File file, Collection<?> collection) {
        FileUtils.writeLines(file, null, collection, null, false);
    }

    public static void writeLines(File file, Collection<?> collection, boolean bl) {
        FileUtils.writeLines(file, null, collection, null, bl);
    }

    public static void writeLines(File file, Collection<?> collection, String string) {
        FileUtils.writeLines(file, null, collection, string, false);
    }

    public static void writeLines(File file, Collection<?> collection, String string, boolean bl) {
        FileUtils.writeLines(file, null, collection, string, bl);
    }

    public static void writeLines(File file, String string, Collection<?> collection) {
        FileUtils.writeLines(file, string, collection, null, false);
    }

    public static void writeLines(File file, String string, Collection<?> collection, boolean bl) {
        FileUtils.writeLines(file, string, collection, null, bl);
    }

    public static void writeLines(File file, String string, Collection<?> collection, String string2) {
        FileUtils.writeLines(file, string, collection, string2, false);
    }

    public static void writeLines(File file, String string, Collection<?> collection, String string2, boolean bl) {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(FileUtils.openOutputStream(file, bl));){
            IOUtils.writeLines(collection, string2, (OutputStream)bufferedOutputStream, string);
        }
    }

    @Deprecated
    public static void writeStringToFile(File file, String string) {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void writeStringToFile(File file, String string, boolean bl) {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), bl);
    }

    public static void writeStringToFile(File file, String string, Charset charset) {
        FileUtils.writeStringToFile(file, string, charset, false);
    }

    public static void writeStringToFile(File file, String string, Charset charset, boolean bl) {
        try (FileOutputStream fileOutputStream = FileUtils.openOutputStream(file, bl);){
            IOUtils.write(string, (OutputStream)fileOutputStream, charset);
        }
    }

    public static void writeStringToFile(File file, String string, String string2) {
        FileUtils.writeStringToFile(file, string, string2, false);
    }

    public static void writeStringToFile(File file, String string, String string2, boolean bl) {
        FileUtils.writeStringToFile(file, string, Charsets.toCharset(string2), bl);
    }

    @Deprecated
    public FileUtils() {
    }
}

