/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class AndFileFilter
extends AbstractFileFilter
implements ConditionalFileFilter,
Serializable {
    private static final long serialVersionUID = 7215974688563965257L;
    private final List<IOFileFilter> fileFilters;

    public AndFileFilter() {
        this(0);
    }

    private AndFileFilter(ArrayList<IOFileFilter> arrayList) {
        this.fileFilters = Objects.requireNonNull(arrayList, "initialList");
    }

    private AndFileFilter(int n) {
        this(new ArrayList<IOFileFilter>(n));
    }

    public AndFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        this(2);
        this.addFileFilter(iOFileFilter);
        this.addFileFilter(iOFileFilter2);
    }

    public AndFileFilter(IOFileFilter ... iOFileFilterArray) {
        this(Objects.requireNonNull(iOFileFilterArray, "fileFilters").length);
        this.addFileFilter(iOFileFilterArray);
    }

    public AndFileFilter(List<IOFileFilter> list) {
        this(new ArrayList<IOFileFilter>((Collection)Objects.requireNonNull(list, "fileFilters")));
    }

    @Override
    public boolean accept(File file) {
        if (this.isEmpty()) {
            return false;
        }
        for (IOFileFilter iOFileFilter : this.fileFilters) {
            if (iOFileFilter.accept(file)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(File file, String string) {
        if (this.isEmpty()) {
            return false;
        }
        for (IOFileFilter iOFileFilter : this.fileFilters) {
            if (iOFileFilter.accept(file, string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        if (this.isEmpty()) {
            return FileVisitResult.TERMINATE;
        }
        for (IOFileFilter iOFileFilter : this.fileFilters) {
            if (iOFileFilter.accept(path, basicFileAttributes) == FileVisitResult.CONTINUE) continue;
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public void addFileFilter(IOFileFilter iOFileFilter) {
        this.fileFilters.add(Objects.requireNonNull(iOFileFilter, "fileFilter"));
    }

    public void addFileFilter(IOFileFilter ... iOFileFilterArray) {
        for (IOFileFilter iOFileFilter : Objects.requireNonNull(iOFileFilterArray, "fileFilters")) {
            this.addFileFilter(iOFileFilter);
        }
    }

    @Override
    public List<IOFileFilter> getFileFilters() {
        return Collections.unmodifiableList(this.fileFilters);
    }

    private boolean isEmpty() {
        return this.fileFilters.isEmpty();
    }

    @Override
    public boolean removeFileFilter(IOFileFilter iOFileFilter) {
        return this.fileFilters.remove(iOFileFilter);
    }

    @Override
    public void setFileFilters(List<IOFileFilter> list) {
        this.fileFilters.clear();
        this.fileFilters.addAll(list);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        for (int i = 0; i < this.fileFilters.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.fileFilters.get(i));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

