/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.MagicNumberFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SizeFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FileFilterUtils {
    private static final IOFileFilter cvsFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter("CVS")));
    private static final IOFileFilter svnFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter(".svn")));

    public static IOFileFilter ageFileFilter(Date date) {
        return new AgeFileFilter(date);
    }

    public static IOFileFilter ageFileFilter(Date date, boolean bl) {
        return new AgeFileFilter(date, bl);
    }

    public static IOFileFilter ageFileFilter(File file) {
        return new AgeFileFilter(file);
    }

    public static IOFileFilter ageFileFilter(File file, boolean bl) {
        return new AgeFileFilter(file, bl);
    }

    public static IOFileFilter ageFileFilter(long l) {
        return new AgeFileFilter(l);
    }

    public static IOFileFilter ageFileFilter(long l, boolean bl) {
        return new AgeFileFilter(l, bl);
    }

    public static IOFileFilter and(IOFileFilter ... iOFileFilterArray) {
        return new AndFileFilter(FileFilterUtils.toList(iOFileFilterArray));
    }

    @Deprecated
    public static IOFileFilter andFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return new AndFileFilter(iOFileFilter, iOFileFilter2);
    }

    public static IOFileFilter asFileFilter(FileFilter fileFilter) {
        return new DelegateFileFilter(fileFilter);
    }

    public static IOFileFilter asFileFilter(FilenameFilter filenameFilter) {
        return new DelegateFileFilter(filenameFilter);
    }

    public static IOFileFilter directoryFileFilter() {
        return DirectoryFileFilter.DIRECTORY;
    }

    public static IOFileFilter falseFileFilter() {
        return FalseFileFilter.FALSE;
    }

    public static IOFileFilter fileFileFilter() {
        return FileFileFilter.INSTANCE;
    }

    public static File[] filter(IOFileFilter iOFileFilter, File ... fileArray) {
        if (iOFileFilter == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (fileArray == null) {
            return FileUtils.EMPTY_FILE_ARRAY;
        }
        return FileFilterUtils.filterFiles(iOFileFilter, Stream.of(fileArray), Collectors.toList()).toArray(FileUtils.EMPTY_FILE_ARRAY);
    }

    private static <R, A> R filterFiles(IOFileFilter iOFileFilter, Stream<File> stream, Collector<? super File, A, R> collector) {
        Objects.requireNonNull(collector, "collector");
        if (iOFileFilter == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (stream == null) {
            return Stream.empty().collect(collector);
        }
        return stream.filter(iOFileFilter::accept).collect(collector);
    }

    public static File[] filter(IOFileFilter iOFileFilter, Iterable<File> iterable) {
        return FileFilterUtils.filterList(iOFileFilter, iterable).toArray(FileUtils.EMPTY_FILE_ARRAY);
    }

    public static List<File> filterList(IOFileFilter iOFileFilter, File ... fileArray) {
        return Arrays.asList(FileFilterUtils.filter(iOFileFilter, fileArray));
    }

    public static List<File> filterList(IOFileFilter iOFileFilter, Iterable<File> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return FileFilterUtils.filterFiles(iOFileFilter, StreamSupport.stream(iterable.spliterator(), false), Collectors.toList());
    }

    public static Set<File> filterSet(IOFileFilter iOFileFilter, File ... fileArray) {
        return new HashSet<File>(Arrays.asList(FileFilterUtils.filter(iOFileFilter, fileArray)));
    }

    public static Set<File> filterSet(IOFileFilter iOFileFilter, Iterable<File> iterable) {
        if (iterable == null) {
            return Collections.emptySet();
        }
        return FileFilterUtils.filterFiles(iOFileFilter, StreamSupport.stream(iterable.spliterator(), false), Collectors.toSet());
    }

    public static IOFileFilter magicNumberFileFilter(byte[] byArray) {
        return new MagicNumberFileFilter(byArray);
    }

    public static IOFileFilter magicNumberFileFilter(byte[] byArray, long l) {
        return new MagicNumberFileFilter(byArray, l);
    }

    public static IOFileFilter magicNumberFileFilter(String string) {
        return new MagicNumberFileFilter(string);
    }

    public static IOFileFilter magicNumberFileFilter(String string, long l) {
        return new MagicNumberFileFilter(string, l);
    }

    public static IOFileFilter makeCVSAware(IOFileFilter iOFileFilter) {
        return iOFileFilter == null ? cvsFilter : FileFilterUtils.and(iOFileFilter, cvsFilter);
    }

    public static IOFileFilter makeDirectoryOnly(IOFileFilter iOFileFilter) {
        if (iOFileFilter == null) {
            return DirectoryFileFilter.DIRECTORY;
        }
        return DirectoryFileFilter.DIRECTORY.and(iOFileFilter);
    }

    public static IOFileFilter makeFileOnly(IOFileFilter iOFileFilter) {
        if (iOFileFilter == null) {
            return FileFileFilter.INSTANCE;
        }
        return FileFileFilter.INSTANCE.and(iOFileFilter);
    }

    public static IOFileFilter makeSVNAware(IOFileFilter iOFileFilter) {
        return iOFileFilter == null ? svnFilter : FileFilterUtils.and(iOFileFilter, svnFilter);
    }

    public static IOFileFilter nameFileFilter(String string) {
        return new NameFileFilter(string);
    }

    public static IOFileFilter nameFileFilter(String string, IOCase iOCase) {
        return new NameFileFilter(string, iOCase);
    }

    public static IOFileFilter notFileFilter(IOFileFilter iOFileFilter) {
        return iOFileFilter.negate();
    }

    public static IOFileFilter or(IOFileFilter ... iOFileFilterArray) {
        return new OrFileFilter(FileFilterUtils.toList(iOFileFilterArray));
    }

    @Deprecated
    public static IOFileFilter orFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return new OrFileFilter(iOFileFilter, iOFileFilter2);
    }

    public static IOFileFilter prefixFileFilter(String string) {
        return new PrefixFileFilter(string);
    }

    public static IOFileFilter prefixFileFilter(String string, IOCase iOCase) {
        return new PrefixFileFilter(string, iOCase);
    }

    public static IOFileFilter sizeFileFilter(long l) {
        return new SizeFileFilter(l);
    }

    public static IOFileFilter sizeFileFilter(long l, boolean bl) {
        return new SizeFileFilter(l, bl);
    }

    public static IOFileFilter sizeRangeFileFilter(long l, long l2) {
        SizeFileFilter sizeFileFilter = new SizeFileFilter(l, true);
        SizeFileFilter sizeFileFilter2 = new SizeFileFilter(l2 + 1L, false);
        return sizeFileFilter.and(sizeFileFilter2);
    }

    public static IOFileFilter suffixFileFilter(String string) {
        return new SuffixFileFilter(string);
    }

    public static IOFileFilter suffixFileFilter(String string, IOCase iOCase) {
        return new SuffixFileFilter(string, iOCase);
    }

    public static List<IOFileFilter> toList(IOFileFilter ... iOFileFilterArray) {
        if (iOFileFilterArray == null) {
            throw new IllegalArgumentException("The filters must not be null");
        }
        ArrayList<IOFileFilter> arrayList = new ArrayList<IOFileFilter>(iOFileFilterArray.length);
        for (int i = 0; i < iOFileFilterArray.length; ++i) {
            if (iOFileFilterArray[i] == null) {
                throw new IllegalArgumentException("The filter[" + i + "] is null");
            }
            arrayList.add(iOFileFilterArray[i]);
        }
        return arrayList;
    }

    public static IOFileFilter trueFileFilter() {
        return TrueFileFilter.TRUE;
    }
}

