/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;

public final class UnsynchronizedByteArrayOutputStream
extends AbstractByteArrayOutputStream {
    public UnsynchronizedByteArrayOutputStream() {
        this(1024);
    }

    public UnsynchronizedByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.needNewBuffer(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("offset=%,d, length=%,d", n, n2));
        }
        if (n2 == 0) {
            return;
        }
        this.writeImpl(byArray, n, n2);
    }

    @Override
    public void write(int n) {
        this.writeImpl(n);
    }

    @Override
    public int write(InputStream inputStream) {
        return this.writeImpl(inputStream);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void reset() {
        this.resetImpl();
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        this.writeToImpl(outputStream);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) {
        return UnsynchronizedByteArrayOutputStream.toBufferedInputStream(inputStream, 1024);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n) {
        try (UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream = new UnsynchronizedByteArrayOutputStream(n);){
            unsynchronizedByteArrayOutputStream.write(inputStream);
            InputStream inputStream2 = unsynchronizedByteArrayOutputStream.toInputStream();
            return inputStream2;
        }
    }

    @Override
    public InputStream toInputStream() {
        return this.toInputStream(UnsynchronizedByteArrayInputStream::new);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArrayImpl();
    }
}

