/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.filter;

import ia.sh.com.jayway.jsonpath.Configuration;
import ia.sh.com.jayway.jsonpath.JsonPathException;
import ia.sh.com.jayway.jsonpath.Option;
import ia.sh.com.jayway.jsonpath.PathNotFoundException;
import ia.sh.com.jayway.jsonpath.Predicate;
import ia.sh.com.jayway.jsonpath.Predicate$PredicateContext;
import ia.sh.com.jayway.jsonpath.internal.Path;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes;
import ia.sh.com.jayway.jsonpath.internal.path.PathCompiler;
import ia.sh.com.jayway.jsonpath.internal.path.PredicateContextImpl;
import ia.sh.com.jayway.jsonpath.spi.json.JsonProvider;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueNodes$PathNode
extends ValueNode {
    private static final Logger logger = LoggerFactory.getLogger(ValueNodes$PathNode.class);
    private final Path path;
    private final boolean existsCheck;
    private final boolean shouldExist;

    ValueNodes$PathNode(Path path) {
        this(path, false, false);
    }

    ValueNodes$PathNode(CharSequence charSequence, boolean bl2, boolean bl3) {
        this(PathCompiler.compile(charSequence.toString(), new Predicate[0]), bl2, bl3);
    }

    ValueNodes$PathNode(Path path, boolean bl2, boolean bl3) {
        this.path = path;
        this.existsCheck = bl2;
        this.shouldExist = bl3;
        logger.trace("PathNode {} existsCheck: {}", (Object)path, (Object)bl2);
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isExistsCheck() {
        return this.existsCheck;
    }

    public boolean shouldExists() {
        return this.shouldExist;
    }

    @Override
    public Class type(Predicate$PredicateContext predicate$PredicateContext) {
        return Void.class;
    }

    @Override
    public boolean isPathNode() {
        return true;
    }

    @Override
    public ValueNodes$PathNode asPathNode() {
        return this;
    }

    public ValueNodes$PathNode asExistsCheck(boolean bl2) {
        return new ValueNodes$PathNode(this.path, true, bl2);
    }

    public String toString() {
        return this.existsCheck && !this.shouldExist ? Utils.concat("!", this.path.toString()) : this.path.toString();
    }

    public ValueNode evaluate(Predicate$PredicateContext predicate$PredicateContext) {
        if (this.isExistsCheck()) {
            try {
                Configuration configuration = Configuration.builder().jsonProvider(predicate$PredicateContext.configuration().jsonProvider()).options(Option.REQUIRE_PROPERTIES).build();
                Object object = this.path.evaluate(predicate$PredicateContext.item(), predicate$PredicateContext.root(), configuration).getValue(false);
                return object == JsonProvider.UNDEFINED ? ValueNodes.FALSE : ValueNodes.TRUE;
            }
            catch (PathNotFoundException pathNotFoundException) {
                return ValueNodes.FALSE;
            }
        }
        try {
            Object object;
            if (predicate$PredicateContext instanceof PredicateContextImpl) {
                PredicateContextImpl predicateContextImpl = (PredicateContextImpl)predicate$PredicateContext;
                object = predicateContextImpl.evaluate(this.path);
            } else {
                Object object2 = this.path.isRootPath() ? predicate$PredicateContext.root() : predicate$PredicateContext.item();
                object = this.path.evaluate(object2, predicate$PredicateContext.root(), predicate$PredicateContext.configuration()).getValue();
            }
            object = predicate$PredicateContext.configuration().jsonProvider().unwrap(object);
            if (object instanceof Number) {
                return ValueNode.createNumberNode(object.toString());
            }
            if (object instanceof String) {
                return ValueNode.createStringNode(object.toString(), false);
            }
            if (object instanceof Boolean) {
                return ValueNode.createBooleanNode(object.toString());
            }
            if (object instanceof OffsetDateTime) {
                return ValueNode.createOffsetDateTimeNode(object.toString());
            }
            if (object == null) {
                return ValueNodes.NULL_NODE;
            }
            if (predicate$PredicateContext.configuration().jsonProvider().isArray(object)) {
                return ValueNode.createJsonNode(predicate$PredicateContext.configuration().mappingProvider().map(object, List.class, predicate$PredicateContext.configuration()));
            }
            if (predicate$PredicateContext.configuration().jsonProvider().isMap(object)) {
                return ValueNode.createJsonNode(predicate$PredicateContext.configuration().mappingProvider().map(object, Map.class, predicate$PredicateContext.configuration()));
            }
            throw new JsonPathException("Could not convert " + object.getClass().toString() + ":" + object.toString() + " to a ValueNode");
        }
        catch (PathNotFoundException pathNotFoundException) {
            return ValueNodes.UNDEFINED;
        }
    }
}

