/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.spi.mapper;

import ia.sh.com.jayway.jsonpath.Configuration;
import ia.sh.com.jayway.jsonpath.TypeRef;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$1;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$BigDecimalReader;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$BigIntegerReader;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$BooleanReader;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$DateReader;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$DoubleReader;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$FloatReader;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$IntegerReader;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$LongReader;
import ia.sh.com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider$StringReader;
import ia.sh.com.jayway.jsonpath.spi.mapper.MappingException;
import ia.sh.com.jayway.jsonpath.spi.mapper.MappingProvider;
import ia.sh.net.minidev.json.JSONValue;
import ia.sh.net.minidev.json.writer.JsonReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.concurrent.Callable;

public class JsonSmartMappingProvider
implements MappingProvider {
    private static JsonReader DEFAULT = new JsonReader();
    private final Callable factory;

    public JsonSmartMappingProvider(JsonReader jsonReader) {
        this(new JsonSmartMappingProvider$1(jsonReader));
    }

    public JsonSmartMappingProvider(Callable callable) {
        this.factory = callable;
    }

    public JsonSmartMappingProvider() {
        this(DEFAULT);
    }

    @Override
    public Object map(Object object, Class clazz, Configuration configuration) {
        if (object == null) {
            return null;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        try {
            if (!configuration.jsonProvider().isMap(object) && !configuration.jsonProvider().isArray(object)) {
                return ((JsonReader)this.factory.call()).getMapper(clazz).convert(object);
            }
            String string = configuration.jsonProvider().toJson(object);
            return JSONValue.parse(string, clazz);
        }
        catch (Exception exception) {
            throw new MappingException(exception);
        }
    }

    @Override
    public Object map(Object object, TypeRef typeRef, Configuration configuration) {
        throw new UnsupportedOperationException("Json-smart provider does not support TypeRef! Use a Jackson or Gson based provider");
    }

    static {
        DEFAULT.registerReader(Long.class, new JsonSmartMappingProvider$LongReader());
        DEFAULT.registerReader(Long.TYPE, new JsonSmartMappingProvider$LongReader());
        DEFAULT.registerReader(Integer.class, new JsonSmartMappingProvider$IntegerReader());
        DEFAULT.registerReader(Integer.TYPE, new JsonSmartMappingProvider$IntegerReader());
        DEFAULT.registerReader(Double.class, new JsonSmartMappingProvider$DoubleReader());
        DEFAULT.registerReader(Double.TYPE, new JsonSmartMappingProvider$DoubleReader());
        DEFAULT.registerReader(Float.class, new JsonSmartMappingProvider$FloatReader());
        DEFAULT.registerReader(Float.TYPE, new JsonSmartMappingProvider$FloatReader());
        DEFAULT.registerReader(BigDecimal.class, new JsonSmartMappingProvider$BigDecimalReader());
        DEFAULT.registerReader(String.class, new JsonSmartMappingProvider$StringReader());
        DEFAULT.registerReader(Date.class, new JsonSmartMappingProvider$DateReader());
        DEFAULT.registerReader(BigInteger.class, new JsonSmartMappingProvider$BigIntegerReader());
        DEFAULT.registerReader(Boolean.TYPE, new JsonSmartMappingProvider$BooleanReader());
    }
}

