/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.io.protostuff;

import ia.sh.io.protostuff.LinkedBuffer;
import ia.sh.io.protostuff.WriteSession;

public final class StringSerializer {
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final byte[] INT_MIN_VALUE = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
    static final byte[] LONG_MIN_VALUE = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    static final int TWO_BYTE_LOWER_LIMIT = 128;
    static final int ONE_BYTE_EXCLUSIVE = 43;
    static final int THREE_BYTE_LOWER_LIMIT = 16384;
    static final int TWO_BYTE_EXCLUSIVE = 5462;
    static final int FOUR_BYTE_LOWER_LIMIT = 0x200000;
    static final int THREE_BYTE_EXCLUSIVE = 699051;
    static final int FIVE_BYTE_LOWER_LIMIT = 0x10000000;
    static final int FOUR_BYTE_EXCLUSIVE = 0x5555556;

    private StringSerializer() {
    }

    static void putBytesFromInt(int n2, int n3, int n4, byte[] byArray) {
        int n5;
        int n6;
        int n7 = n3 + n4;
        int n8 = 0;
        if (n2 < 0) {
            n8 = 45;
            n2 = -n2;
        }
        while (n2 >= 65536) {
            n6 = n2 / 100;
            n5 = n2 - ((n6 << 6) + (n6 << 5) + (n6 << 2));
            n2 = n6;
            byArray[--n7] = (byte)DigitOnes[n5];
            byArray[--n7] = (byte)DigitTens[n5];
        }
        do {
            n6 = n2 * 52429 >>> 19;
            n5 = n2 - ((n6 << 3) + (n6 << 1));
            byArray[--n7] = (byte)digits[n5];
        } while ((n2 = n6) != 0);
        if (n8 != 0) {
            byArray[--n7] = (byte)n8;
        }
    }

    static void putBytesFromLong(long l2, int n2, int n3, byte[] byArray) {
        int n4;
        int n5;
        int n6 = n2 + n3;
        int n7 = 0;
        if (l2 < 0L) {
            n7 = 45;
            l2 = -l2;
        }
        while (l2 > Integer.MAX_VALUE) {
            long l3 = l2 / 100L;
            n5 = (int)(l2 - ((l3 << 6) + (l3 << 5) + (l3 << 2)));
            l2 = l3;
            byArray[--n6] = (byte)DigitOnes[n5];
            byArray[--n6] = (byte)DigitTens[n5];
        }
        int n8 = (int)l2;
        while (n8 >= 65536) {
            n4 = n8 / 100;
            n5 = n8 - ((n4 << 6) + (n4 << 5) + (n4 << 2));
            n8 = n4;
            byArray[--n6] = (byte)DigitOnes[n5];
            byArray[--n6] = (byte)DigitTens[n5];
        }
        do {
            n4 = n8 * 52429 >>> 19;
            n5 = n8 - ((n4 << 3) + (n4 << 1));
            byArray[--n6] = (byte)digits[n5];
        } while ((n8 = n4) != 0);
        if (n7 != 0) {
            byArray[--n6] = (byte)n7;
        }
    }

    static int stringSize(int n2) {
        int n3 = 0;
        while (n2 > sizeTable[n3]) {
            ++n3;
        }
        return n3 + 1;
    }

    static int stringSize(long l2) {
        long l3 = 10L;
        for (int i2 = 1; i2 < 19; ++i2) {
            if (l2 < l3) {
                return i2;
            }
            l3 = 10L * l3;
        }
        return 19;
    }

    public static LinkedBuffer writeInt(int n2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n3;
        if (n2 == Integer.MIN_VALUE) {
            int n4 = INT_MIN_VALUE.length;
            if (linkedBuffer.offset + n4 > linkedBuffer.buffer.length) {
                linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
            }
            System.arraycopy(INT_MIN_VALUE, 0, linkedBuffer.buffer, linkedBuffer.offset, n4);
            linkedBuffer.offset += n4;
            writeSession.size += n4;
            return linkedBuffer;
        }
        int n5 = n3 = n2 < 0 ? StringSerializer.stringSize(-n2) + 1 : StringSerializer.stringSize(n2);
        if (linkedBuffer.offset + n3 > linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
        }
        StringSerializer.putBytesFromInt(n2, linkedBuffer.offset, n3, linkedBuffer.buffer);
        linkedBuffer.offset += n3;
        writeSession.size += n3;
        return linkedBuffer;
    }

    public static LinkedBuffer writeLong(long l2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n2;
        if (l2 == Long.MIN_VALUE) {
            int n3 = LONG_MIN_VALUE.length;
            if (linkedBuffer.offset + n3 > linkedBuffer.buffer.length) {
                linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
            }
            System.arraycopy(LONG_MIN_VALUE, 0, linkedBuffer.buffer, linkedBuffer.offset, n3);
            linkedBuffer.offset += n3;
            writeSession.size += n3;
            return linkedBuffer;
        }
        int n4 = n2 = l2 < 0L ? StringSerializer.stringSize(-l2) + 1 : StringSerializer.stringSize(l2);
        if (linkedBuffer.offset + n2 > linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
        }
        StringSerializer.putBytesFromLong(l2, linkedBuffer.offset, n2, linkedBuffer.buffer);
        linkedBuffer.offset += n2;
        writeSession.size += n2;
        return linkedBuffer;
    }

    public static LinkedBuffer writeFloat(float f2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        return StringSerializer.writeAscii(Float.toString(f2), writeSession, linkedBuffer);
    }

    public static LinkedBuffer writeDouble(double d2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        return StringSerializer.writeAscii(Double.toString(d2), writeSession, linkedBuffer);
    }

    public static int computeUTF8Size(CharSequence charSequence, int n2, int n3) {
        int n4 = n3;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0080') continue;
            if (c2 < '\u0800') {
                ++n4;
                continue;
            }
            n4 += 2;
        }
        return n4;
    }

    static LinkedBuffer writeUTF8(CharSequence charSequence, int n2, int n3, byte[] byArray, int n4, int n5, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        char c2 = '\u0000';
        while (true) {
            if (n2 != n3 && n4 != n5) {
                char c3 = charSequence.charAt(n2++);
                c2 = c3;
                if (c3 < '\u0080') {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
            }
            if (n2 == n3 && c2 < '\u0080') {
                writeSession.size += n4 - linkedBuffer.offset;
                linkedBuffer.offset = n4;
                return linkedBuffer;
            }
            if (n4 == n5) {
                writeSession.size += n4 - linkedBuffer.offset;
                linkedBuffer.offset = n4;
                if (linkedBuffer.next == null) {
                    n4 = 0;
                    n5 = writeSession.nextBufferSize;
                    byArray = new byte[n5];
                    linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                } else {
                    linkedBuffer = linkedBuffer.next;
                    linkedBuffer.offset = n4 = linkedBuffer.start;
                    byArray = linkedBuffer.buffer;
                    n5 = byArray.length;
                }
            } else if (c2 < '\u0800') {
                if (n4 == n5) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    if (linkedBuffer.next == null) {
                        n4 = 0;
                        n5 = writeSession.nextBufferSize;
                        byArray = new byte[n5];
                        linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                    } else {
                        linkedBuffer = linkedBuffer.next;
                        linkedBuffer.offset = n4 = linkedBuffer.start;
                        byArray = linkedBuffer.buffer;
                        n5 = byArray.length;
                    }
                }
                byArray[n4++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                if (n4 == n5) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    if (linkedBuffer.next == null) {
                        n4 = 0;
                        n5 = writeSession.nextBufferSize;
                        byArray = new byte[n5];
                        linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                    } else {
                        linkedBuffer = linkedBuffer.next;
                        linkedBuffer.offset = n4 = linkedBuffer.start;
                        byArray = linkedBuffer.buffer;
                        n5 = byArray.length;
                    }
                }
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            } else if (Character.isHighSurrogate(c2) && n2 < n3 && Character.isLowSurrogate(charSequence.charAt(n2))) {
                if (n4 == n5) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    if (linkedBuffer.next == null) {
                        n4 = 0;
                        n5 = writeSession.nextBufferSize;
                        byArray = new byte[n5];
                        linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                    } else {
                        linkedBuffer = linkedBuffer.next;
                        linkedBuffer.offset = n4 = linkedBuffer.start;
                        byArray = linkedBuffer.buffer;
                        n5 = byArray.length;
                    }
                }
                int n6 = Character.toCodePoint(c2, charSequence.charAt(n2));
                byArray[n4++] = (byte)(0xF0 | n6 >> 18 & 7);
                if (n4 == n5) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    if (linkedBuffer.next == null) {
                        n4 = 0;
                        n5 = writeSession.nextBufferSize;
                        byArray = new byte[n5];
                        linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                    } else {
                        linkedBuffer = linkedBuffer.next;
                        linkedBuffer.offset = n4 = linkedBuffer.start;
                        byArray = linkedBuffer.buffer;
                        n5 = byArray.length;
                    }
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                if (n4 == n5) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    if (linkedBuffer.next == null) {
                        n4 = 0;
                        n5 = writeSession.nextBufferSize;
                        byArray = new byte[n5];
                        linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                    } else {
                        linkedBuffer = linkedBuffer.next;
                        linkedBuffer.offset = n4 = linkedBuffer.start;
                        byArray = linkedBuffer.buffer;
                        n5 = byArray.length;
                    }
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                if (n4 == n5) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    if (linkedBuffer.next == null) {
                        n4 = 0;
                        n5 = writeSession.nextBufferSize;
                        byArray = new byte[n5];
                        linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                    } else {
                        linkedBuffer = linkedBuffer.next;
                        linkedBuffer.offset = n4 = linkedBuffer.start;
                        byArray = linkedBuffer.buffer;
                        n5 = byArray.length;
                    }
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 0 & 0x3F);
                ++n2;
            } else {
                if (n4 == n5) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    if (linkedBuffer.next == null) {
                        n4 = 0;
                        n5 = writeSession.nextBufferSize;
                        byArray = new byte[n5];
                        linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                    } else {
                        linkedBuffer = linkedBuffer.next;
                        linkedBuffer.offset = n4 = linkedBuffer.start;
                        byArray = linkedBuffer.buffer;
                        n5 = byArray.length;
                    }
                }
                byArray[n4++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                if (n4 == n5) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    if (linkedBuffer.next == null) {
                        n4 = 0;
                        n5 = writeSession.nextBufferSize;
                        byArray = new byte[n5];
                        linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                    } else {
                        linkedBuffer = linkedBuffer.next;
                        linkedBuffer.offset = n4 = linkedBuffer.start;
                        byArray = linkedBuffer.buffer;
                        n5 = byArray.length;
                    }
                }
                byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                if (n4 == n5) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    if (linkedBuffer.next == null) {
                        n4 = 0;
                        n5 = writeSession.nextBufferSize;
                        byArray = new byte[n5];
                        linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                    } else {
                        linkedBuffer = linkedBuffer.next;
                        linkedBuffer.offset = n4 = linkedBuffer.start;
                        byArray = linkedBuffer.buffer;
                        n5 = byArray.length;
                    }
                }
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            }
            c2 = '\u0000';
        }
    }

    static LinkedBuffer writeUTF8(CharSequence charSequence, int n2, int n3, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        byte[] byArray = linkedBuffer.buffer;
        char c2 = '\u0000';
        int n4 = linkedBuffer.offset;
        int n5 = n4 + n3;
        while (true) {
            if (n2 != n3 && (c2 = charSequence.charAt(n2++)) < '\u0080') {
                byArray[n4++] = (byte)c2;
                continue;
            }
            if (n2 == n3 && c2 < '\u0080') {
                writeSession.size += n4 - linkedBuffer.offset;
                linkedBuffer.offset = n4;
                return linkedBuffer;
            }
            if (c2 < '\u0800') {
                if (++n5 > byArray.length) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    return StringSerializer.writeUTF8(charSequence, n2 - 1, n3, byArray, n4, byArray.length, writeSession, linkedBuffer);
                }
                byArray[n4++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            } else if (Character.isHighSurrogate(c2) && n2 < n3 && Character.isLowSurrogate(charSequence.charAt(n2))) {
                if ((n5 += 3) > byArray.length) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    return StringSerializer.writeUTF8(charSequence, n2 - 1, n3, byArray, n4, byArray.length, writeSession, linkedBuffer);
                }
                int n6 = Character.toCodePoint(c2, charSequence.charAt(n2));
                byArray[n4++] = (byte)(0xF0 | n6 >> 18 & 7);
                byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n6 >> 0 & 0x3F);
                ++n2;
            } else {
                if ((n5 += 2) > byArray.length) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4;
                    return StringSerializer.writeUTF8(charSequence, n2 - 1, n3, byArray, n4, byArray.length, writeSession, linkedBuffer);
                }
                byArray[n4++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            }
            c2 = '\u0000';
        }
    }

    public static LinkedBuffer writeUTF8(CharSequence charSequence, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return linkedBuffer;
        }
        return linkedBuffer.offset + n2 > linkedBuffer.buffer.length ? StringSerializer.writeUTF8(charSequence, 0, n2, linkedBuffer.buffer, linkedBuffer.offset, linkedBuffer.buffer.length, writeSession, linkedBuffer) : StringSerializer.writeUTF8(charSequence, 0, n2, writeSession, linkedBuffer);
    }

    public static LinkedBuffer writeAscii(CharSequence charSequence, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return linkedBuffer;
        }
        byte[] byArray = linkedBuffer.buffer;
        int n3 = linkedBuffer.offset;
        int n4 = linkedBuffer.buffer.length;
        writeSession.size += n2;
        if (n3 + n2 > n4) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (n3 == n4) {
                    linkedBuffer.offset = n3;
                    n3 = 0;
                    n4 = writeSession.nextBufferSize;
                    byArray = new byte[n4];
                    linkedBuffer = new LinkedBuffer(byArray, 0, linkedBuffer);
                }
                byArray[n3++] = (byte)charSequence.charAt(i2);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                byArray[n3++] = (byte)charSequence.charAt(i3);
            }
        }
        linkedBuffer.offset = n3;
        return linkedBuffer;
    }

    static void writeFixed2ByteInt(int n2, byte[] byArray, int n3, boolean bl2) {
        if (bl2) {
            byArray[n3++] = (byte)n2;
            byArray[n3] = (byte)(n2 >>> 8 & 0xFF);
        } else {
            byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
            byArray[n3] = (byte)n2;
        }
    }

    public static LinkedBuffer writeUTF8FixedDelimited(CharSequence charSequence, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        return StringSerializer.writeUTF8FixedDelimited(charSequence, false, writeSession, linkedBuffer);
    }

    public static LinkedBuffer writeUTF8FixedDelimited(CharSequence charSequence, boolean bl2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n2 = writeSession.size;
        int n3 = charSequence.length();
        int n4 = linkedBuffer.offset + 2;
        if (n4 > linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(n3 + 2 > writeSession.nextBufferSize ? n3 + 2 : writeSession.nextBufferSize, linkedBuffer);
            linkedBuffer.offset = 2;
            if (n3 == 0) {
                StringSerializer.writeFixed2ByteInt(0, linkedBuffer.buffer, 0, bl2);
                writeSession.size += 2;
                return linkedBuffer;
            }
            LinkedBuffer linkedBuffer2 = StringSerializer.writeUTF8(charSequence, 0, n3, writeSession, linkedBuffer);
            StringSerializer.writeFixed2ByteInt(writeSession.size - n2, linkedBuffer.buffer, 0, bl2);
            writeSession.size += 2;
            return linkedBuffer2;
        }
        if (n3 == 0) {
            StringSerializer.writeFixed2ByteInt(0, linkedBuffer.buffer, linkedBuffer.offset, bl2);
            linkedBuffer.offset = n4;
            writeSession.size += 2;
            return linkedBuffer;
        }
        if (n4 + n3 > linkedBuffer.buffer.length) {
            linkedBuffer.offset = n4;
            LinkedBuffer linkedBuffer3 = StringSerializer.writeUTF8(charSequence, 0, n3, linkedBuffer.buffer, n4, linkedBuffer.buffer.length, writeSession, linkedBuffer);
            StringSerializer.writeFixed2ByteInt(writeSession.size - n2, linkedBuffer.buffer, n4 - 2, bl2);
            writeSession.size += 2;
            return linkedBuffer3;
        }
        linkedBuffer.offset = n4;
        LinkedBuffer linkedBuffer4 = StringSerializer.writeUTF8(charSequence, 0, n3, writeSession, linkedBuffer);
        StringSerializer.writeFixed2ByteInt(writeSession.size - n2, linkedBuffer.buffer, n4 - 2, bl2);
        writeSession.size += 2;
        return linkedBuffer4;
    }

    private static LinkedBuffer writeUTF8OneByteDelimited(CharSequence charSequence, int n2, int n3, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n4 = writeSession.size;
        if (linkedBuffer.offset == linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(n3 + 1 > writeSession.nextBufferSize ? n3 + 1 : writeSession.nextBufferSize, linkedBuffer);
            linkedBuffer.offset = 1;
            LinkedBuffer linkedBuffer2 = StringSerializer.writeUTF8(charSequence, n2, n3, writeSession, linkedBuffer);
            linkedBuffer.buffer[0] = (byte)(writeSession.size - n4);
            ++writeSession.size;
            return linkedBuffer2;
        }
        int n5 = linkedBuffer.offset + 1;
        if (n5 + n3 > linkedBuffer.buffer.length) {
            linkedBuffer.offset = n5;
            byte[] byArray = linkedBuffer.buffer;
            LinkedBuffer linkedBuffer3 = StringSerializer.writeUTF8(charSequence, n2, n3, byArray, n5, byArray.length, writeSession, linkedBuffer);
            byArray[n5 - 1] = (byte)(writeSession.size - n4);
            ++writeSession.size;
            return linkedBuffer3;
        }
        linkedBuffer.offset = n5;
        LinkedBuffer linkedBuffer4 = StringSerializer.writeUTF8(charSequence, n2, n3, writeSession, linkedBuffer);
        linkedBuffer.buffer[n5 - 1] = (byte)(writeSession.size - n4);
        ++writeSession.size;
        return linkedBuffer4;
    }

    private static LinkedBuffer writeUTF8VarDelimited(CharSequence charSequence, int n2, int n3, int n4, int n5, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n6 = writeSession.size;
        int n7 = linkedBuffer.offset;
        int n8 = n7 + n5;
        if (n8 > linkedBuffer.buffer.length) {
            linkedBuffer = new LinkedBuffer(n3 + n5 > writeSession.nextBufferSize ? n3 + n5 : writeSession.nextBufferSize, linkedBuffer);
            n7 = linkedBuffer.start;
            linkedBuffer.offset = n8 = n7 + n5;
            LinkedBuffer linkedBuffer2 = StringSerializer.writeUTF8(charSequence, n2, n3, writeSession, linkedBuffer);
            int n9 = writeSession.size - n6;
            if (n9 < n4) {
                System.arraycopy(linkedBuffer.buffer, n8, linkedBuffer.buffer, n8 - 1, linkedBuffer.offset - n8);
                --n5;
                --linkedBuffer.offset;
            }
            writeSession.size += n5;
            while (--n5 > 0) {
                linkedBuffer.buffer[n7++] = (byte)(n9 & 0x7F | 0x80);
                n9 >>>= 7;
            }
            linkedBuffer.buffer[n7] = (byte)n9;
            return linkedBuffer2;
        }
        if (n8 + n3 > linkedBuffer.buffer.length) {
            linkedBuffer.offset = n8;
            LinkedBuffer linkedBuffer3 = StringSerializer.writeUTF8(charSequence, n2, n3, linkedBuffer.buffer, n8, linkedBuffer.buffer.length, writeSession, linkedBuffer);
            int n10 = writeSession.size - n6;
            if (n10 < n4) {
                System.arraycopy(linkedBuffer.buffer, n8, linkedBuffer.buffer, n8 - 1, linkedBuffer.offset - n8);
                --n5;
                --linkedBuffer.offset;
            }
            writeSession.size += n5;
            while (--n5 > 0) {
                linkedBuffer.buffer[n7++] = (byte)(n10 & 0x7F | 0x80);
                n10 >>>= 7;
            }
            linkedBuffer.buffer[n7] = (byte)n10;
            return linkedBuffer3;
        }
        linkedBuffer.offset = n8;
        LinkedBuffer linkedBuffer4 = StringSerializer.writeUTF8(charSequence, n2, n3, writeSession, linkedBuffer);
        int n11 = writeSession.size - n6;
        if (n11 < n4) {
            System.arraycopy(linkedBuffer.buffer, n8, linkedBuffer.buffer, n8 - 1, linkedBuffer.offset - n8);
            --n5;
            --linkedBuffer.offset;
        }
        writeSession.size += n5;
        while (--n5 > 0) {
            linkedBuffer.buffer[n7++] = (byte)(n11 & 0x7F | 0x80);
            n11 >>>= 7;
        }
        linkedBuffer.buffer[n7] = (byte)n11;
        return linkedBuffer4;
    }

    public static LinkedBuffer writeUTF8VarDelimited(CharSequence charSequence, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            if (linkedBuffer.offset == linkedBuffer.buffer.length) {
                linkedBuffer = new LinkedBuffer(writeSession.nextBufferSize, linkedBuffer);
            }
            linkedBuffer.buffer[linkedBuffer.offset++] = 0;
            ++writeSession.size;
            return linkedBuffer;
        }
        if (n2 < 43) {
            return StringSerializer.writeUTF8OneByteDelimited(charSequence, 0, n2, writeSession, linkedBuffer);
        }
        if (n2 < 5462) {
            return StringSerializer.writeUTF8VarDelimited(charSequence, 0, n2, 128, 2, writeSession, linkedBuffer);
        }
        if (n2 < 699051) {
            return StringSerializer.writeUTF8VarDelimited(charSequence, 0, n2, 16384, 3, writeSession, linkedBuffer);
        }
        if (n2 < 0x5555556) {
            return StringSerializer.writeUTF8VarDelimited(charSequence, 0, n2, 0x200000, 4, writeSession, linkedBuffer);
        }
        return StringSerializer.writeUTF8VarDelimited(charSequence, 0, n2, 0x10000000, 5, writeSession, linkedBuffer);
    }

    public static char highSurrogate(int n2) {
        return (char)((n2 >>> 10) + 55232);
    }

    public static char lowSurrogate(int n2) {
        return (char)((n2 & 0x3FF) + 56320);
    }
}

