/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.exception.util;

import ia.sh.org.apache.commons.math3.exception.util.ArgUtils;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ExceptionContext
implements Serializable {
    private static final long serialVersionUID = -6024911025449780478L;
    private Throwable throwable;
    private List msgPatterns;
    private List msgArguments;
    private Map context;

    public ExceptionContext(Throwable throwable) {
        this.throwable = throwable;
        this.msgPatterns = new ArrayList();
        this.msgArguments = new ArrayList();
        this.context = new HashMap();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void addMessage(Localizable localizable, Object ... objectArray) {
        this.msgPatterns.add(localizable);
        this.msgArguments.add(ArgUtils.flatten(objectArray));
    }

    public void setValue(String string, Object object) {
        this.context.put(string, object);
    }

    public Object getValue(String string) {
        return this.context.get(string);
    }

    public Set getKeys() {
        return this.context.keySet();
    }

    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        return this.buildMessage(locale, ": ");
    }

    public String getMessage(Locale locale, String string) {
        return this.buildMessage(locale, string);
    }

    private String buildMessage(Locale locale, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = this.msgPatterns.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Localizable localizable = (Localizable)this.msgPatterns.get(i2);
            Object[] objectArray = (Object[])this.msgArguments.get(i2);
            MessageFormat messageFormat = new MessageFormat(localizable.getLocalizedString(locale), locale);
            stringBuilder.append(messageFormat.format(objectArray));
            if (++n2 >= n3) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.throwable);
        this.serializeMessages(objectOutputStream);
        this.serializeContext(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.throwable = (Throwable)objectInputStream.readObject();
        this.deSerializeMessages(objectInputStream);
        this.deSerializeContext(objectInputStream);
    }

    private void serializeMessages(ObjectOutputStream objectOutputStream) {
        int n2 = this.msgPatterns.size();
        objectOutputStream.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Localizable localizable = (Localizable)this.msgPatterns.get(i2);
            objectOutputStream.writeObject(localizable);
            Object[] objectArray = (Object[])this.msgArguments.get(i2);
            int n3 = objectArray.length;
            objectOutputStream.writeInt(n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                if (objectArray[i3] instanceof Serializable) {
                    objectOutputStream.writeObject(objectArray[i3]);
                    continue;
                }
                objectOutputStream.writeObject(this.nonSerializableReplacement(objectArray[i3]));
            }
        }
    }

    private void deSerializeMessages(ObjectInputStream objectInputStream) {
        int n2 = objectInputStream.readInt();
        this.msgPatterns = new ArrayList(n2);
        this.msgArguments = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Localizable localizable = (Localizable)objectInputStream.readObject();
            this.msgPatterns.add(localizable);
            int n3 = objectInputStream.readInt();
            Object[] objectArray = new Object[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                objectArray[i3] = objectInputStream.readObject();
            }
            this.msgArguments.add(objectArray);
        }
    }

    private void serializeContext(ObjectOutputStream objectOutputStream) {
        int n2 = this.context.size();
        objectOutputStream.writeInt(n2);
        for (Map.Entry entry : this.context.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            Object v2 = entry.getValue();
            if (v2 instanceof Serializable) {
                objectOutputStream.writeObject(v2);
                continue;
            }
            objectOutputStream.writeObject(this.nonSerializableReplacement(v2));
        }
    }

    private void deSerializeContext(ObjectInputStream objectInputStream) {
        int n2 = objectInputStream.readInt();
        this.context = new HashMap();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = (String)objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            this.context.put(string, object);
        }
    }

    private String nonSerializableReplacement(Object object) {
        return "[Object could not be serialized: " + object.getClass().getName() + "]";
    }
}

