/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.random;

import ia.sh.org.apache.commons.math3.random.BitsStreamGenerator;
import ia.sh.org.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public abstract class AbstractWell
extends BitsStreamGenerator
implements Serializable {
    private static final long serialVersionUID = -817701723016583596L;
    protected int index;
    protected final int[] v;
    protected final int[] iRm1;
    protected final int[] iRm2;
    protected final int[] i1;
    protected final int[] i2;
    protected final int[] i3;

    protected AbstractWell(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null);
    }

    protected AbstractWell(int n2, int n3, int n4, int n5, int n6) {
        this(n2, n3, n4, n5, new int[]{n6});
    }

    protected AbstractWell(int n2, int n3, int n4, int n5, int[] nArray) {
        int n6 = 32;
        int n7 = (n2 + 32 - 1) / 32;
        this.v = new int[n7];
        this.index = 0;
        this.iRm1 = new int[n7];
        this.iRm2 = new int[n7];
        this.i1 = new int[n7];
        this.i2 = new int[n7];
        this.i3 = new int[n7];
        for (int i2 = 0; i2 < n7; ++i2) {
            this.iRm1[i2] = (i2 + n7 - 1) % n7;
            this.iRm2[i2] = (i2 + n7 - 2) % n7;
            this.i1[i2] = (i2 + n3) % n7;
            this.i2[i2] = (i2 + n4) % n7;
            this.i3[i2] = (i2 + n5) % n7;
        }
        this.setSeed(nArray);
    }

    protected AbstractWell(int n2, int n3, int n4, int n5, long l2) {
        this(n2, n3, n4, n5, new int[]{(int)(l2 >>> 32), (int)(l2 & 0xFFFFFFFFL)});
    }

    public void setSeed(int n2) {
        this.setSeed(new int[]{n2});
    }

    public void setSeed(int[] nArray) {
        if (nArray == null) {
            this.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
            return;
        }
        System.arraycopy(nArray, 0, this.v, 0, FastMath.min(nArray.length, this.v.length));
        if (nArray.length < this.v.length) {
            for (int i2 = nArray.length; i2 < this.v.length; ++i2) {
                long l2 = this.v[i2 - nArray.length];
                this.v[i2] = (int)(1812433253L * (l2 ^ l2 >> 30) + (long)i2 & 0xFFFFFFFFL);
            }
        }
        this.index = 0;
        this.clear();
    }

    public void setSeed(long l2) {
        this.setSeed(new int[]{(int)(l2 >>> 32), (int)(l2 & 0xFFFFFFFFL)});
    }

    protected abstract int next(int var1);
}

