/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.util;

import ia.sh.org.apache.commons.math3.exception.MathUnsupportedOperationException;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.NullArgumentException;
import ia.sh.org.apache.commons.math3.exception.ZeroException;
import ia.sh.org.apache.commons.math3.util.IntegerSequence$Incrementor$1;
import ia.sh.org.apache.commons.math3.util.IntegerSequence$Incrementor$MaxCountExceededCallback;
import java.util.Iterator;

public class IntegerSequence$Incrementor
implements Iterator {
    private static final IntegerSequence$Incrementor$MaxCountExceededCallback CALLBACK = new IntegerSequence$Incrementor$1();
    private final int init;
    private final int maximalCount;
    private final int increment;
    private final IntegerSequence$Incrementor$MaxCountExceededCallback maxCountCallback;
    private int count = 0;

    private IntegerSequence$Incrementor(int n2, int n3, int n4, IntegerSequence$Incrementor$MaxCountExceededCallback maxCountExceededCallback) {
        if (maxCountExceededCallback == null) {
            throw new NullArgumentException();
        }
        this.init = n2;
        this.maximalCount = n3;
        this.increment = n4;
        this.maxCountCallback = maxCountExceededCallback;
        this.count = n2;
    }

    public static IntegerSequence$Incrementor create() {
        return new IntegerSequence$Incrementor(0, 0, 1, CALLBACK);
    }

    public IntegerSequence$Incrementor withStart(int n2) {
        return new IntegerSequence$Incrementor(n2, this.maximalCount, this.increment, this.maxCountCallback);
    }

    public IntegerSequence$Incrementor withMaximalCount(int n2) {
        return new IntegerSequence$Incrementor(this.init, n2, this.increment, this.maxCountCallback);
    }

    public IntegerSequence$Incrementor withIncrement(int n2) {
        if (n2 == 0) {
            throw new ZeroException();
        }
        return new IntegerSequence$Incrementor(this.init, this.maximalCount, n2, this.maxCountCallback);
    }

    public IntegerSequence$Incrementor withCallback(IntegerSequence$Incrementor$MaxCountExceededCallback maxCountExceededCallback) {
        return new IntegerSequence$Incrementor(this.init, this.maximalCount, this.increment, maxCountExceededCallback);
    }

    public int getMaximalCount() {
        return this.maximalCount;
    }

    public int getCount() {
        return this.count;
    }

    public boolean canIncrement() {
        return this.canIncrement(1);
    }

    public boolean canIncrement(int n2) {
        int n3 = this.count + n2 * this.increment;
        return this.increment < 0 ? n3 > this.maximalCount : n3 < this.maximalCount;
    }

    public void increment(int n2) {
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException(n2);
        }
        if (!this.canIncrement(0)) {
            this.maxCountCallback.trigger(this.maximalCount);
        }
        this.count += n2 * this.increment;
    }

    public void increment() {
        this.increment(1);
    }

    public boolean hasNext() {
        return this.canIncrement(0);
    }

    public Integer next() {
        int n2 = this.count;
        this.increment();
        return n2;
    }

    public void remove() {
        throw new MathUnsupportedOperationException();
    }
}

