/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.blockscanner;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.blockscanner.BlockProcessor;
import me.casperge.realisticseasons.blockscanner.ChunkSystem;
import me.casperge.realisticseasons.blockscanner.SimpleLocation;
import me.casperge.realisticseasons.temperature.TemperatureSettings;
import me.casperge.realisticseasons.utils.ChunkUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkSupplier
extends BukkitRunnable {
    private RealisticSeasons main;
    private TemperatureSettings tempsettings;
    private HashMap<UUID, ChunkSystem> chunkSystems = new HashMap();
    private HashMap<UUID, SimpleLocation> playerLocations = new HashMap();
    private BlockProcessor processor;
    private HashMap<UUID, Integer> emptyHashmap = new HashMap();

    public ChunkSupplier(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.tempsettings = realisticSeasons.getTemperatureManager().getTempData().getTempSettings();
        this.processor = new BlockProcessor(realisticSeasons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.processor.isProcessing()) {
            return;
        }
        if (this.main.getNMSUtils().getTPS() < this.main.getSettings().minTPS && this.main.getSettings().prioritiseTPS) {
            this.main.getTemperatureManager().getTempData().updateBlockEffects(this.emptyHashmap);
            return;
        }
        Serializable serializable = this.chunkSystems;
        synchronized (serializable) {
            this.chunkSystems.clear();
            this.playerLocations.clear();
            if (!(this.main.getTemperatureManager().getTempData().isEnabled() || this.main.getSettings().fallingLeavesEnabled || this.main.getSettings().smallFallingLeavesEnabled)) {
                return;
            }
            if (!this.main.getSettings().fallingLeavesEnabled && !this.main.getSettings().smallFallingLeavesEnabled) {
                if (!this.main.getTemperatureManager().getTempData().isEnabled()) {
                    return;
                }
                if (!this.tempsettings.blockEffectsEnabled()) {
                    return;
                }
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!ChunkUtils.isChunkLoaded(player.getLocation()) || !this.main.getTemperatureManager().hasTemperature(player) && !this.main.getSeasonManager().worldData.containsKey(player.getWorld()) || !this.main.getTemperatureManager().getTempData().getEnabledWorlds().contains(player.getWorld()) && !this.main.getSettings().fallingLeavesEnabled && !this.main.getSettings().smallFallingLeavesEnabled) continue;
                int n = this.main.getNMSUtils().getMinHeight(player.getWorld());
                int n2 = this.main.getNMSUtils().getMaxHeight(player.getWorld());
                ChunkSystem chunkSystem = new ChunkSystem(player.getLocation().getChunk(), 1, n, n2);
                this.chunkSystems.put(player.getUniqueId(), chunkSystem);
                this.playerLocations.put(player.getUniqueId(), new SimpleLocation(player.getLocation(), n2, n));
            }
        }
        serializable = System.currentTimeMillis();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, new Runnable(){
            final /* synthetic */ Long val$timestamp;
            {
                this.val$timestamp = l;
            }

            @Override
            public void run() {
                while (System.currentTimeMillis() - this.val$timestamp <= 2000L) {
                    boolean bl = true;
                    for (UUID uUID : ChunkSupplier.this.chunkSystems.keySet()) {
                        ChunkSystem chunkSystem = (ChunkSystem)ChunkSupplier.this.chunkSystems.get(uUID);
                        if (chunkSystem.hasProcessed.get()) continue;
                        bl = false;
                    }
                    if (bl) {
                        if (!RealisticSeasons.isEnabled.get()) break;
                        ChunkSupplier.this.processor.process(ChunkSupplier.this.chunkSystems, ChunkSupplier.this.playerLocations);
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        break;
                    }
                }
            }
        });
    }
}

