/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.calendar.Calendar;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.calendar.Month;
import me.casperge.realisticseasons.calendar.Week;
import me.casperge.realisticseasons.calendar.Year;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class CalendarFileLoader {
    private RealisticSeasons main;
    private FileConfiguration calendar;
    private File calendarFile;
    private Year year;
    private int[] monthLengths = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public CalendarFileLoader(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.load();
    }

    public Calendar load() {
        Object object;
        Object object2;
        this.calendarFile = new File(this.main.getDataFolder(), "calendar.yml");
        if (!this.calendarFile.exists()) {
            try {
                InputStream inputStream = this.main.getResource("calendar.yml");
                FileUtils.copyInputStreamToFile(inputStream, this.calendarFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.calendar = YamlConfiguration.loadConfiguration((File)this.calendarFile);
        if (!this.calendar.contains("time-sync-offset")) {
            this.calendar.set("time-sync-offset", (Object)0);
            try {
                this.calendar.save(this.calendarFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        boolean bl = false;
        if (this.calendar.contains("sync-time-with-real-world")) {
            this.main.getSettings().syncWorldTimeWithRealWorld = this.calendar.getBoolean("sync-time-with-real-world");
        } else {
            this.calendar.set("sync-time-with-real-world", (Object)false);
            this.main.getSettings().syncWorldTimeWithRealWorld = false;
            bl = true;
        }
        if (this.calendar.contains("calendar-is-real-life-days")) {
            this.main.getSettings().isCalendarInRealLifeDays = this.calendar.getBoolean("calendar-is-real-life-days");
        } else {
            this.calendar.set("calendar-is-real-life-days", (Object)false);
            this.main.getSettings().isCalendarInRealLifeDays = false;
            bl = true;
        }
        if (this.calendar.contains("time-sync-timezone")) {
            this.main.getSettings().timezone = this.calendar.getString("time-sync-timezone");
        } else {
            this.calendar.set("time-sync-timezone", (Object)"system");
            bl = true;
        }
        List list = this.calendar.getStringList("week-days");
        Week week = new Week(list);
        boolean bl2 = this.main.getSettings().syncWorldTimeWithRealWorld;
        ArrayList<Month> arrayList = new ArrayList<Month>();
        int n = 0;
        Object object3 = this.calendar.getConfigurationSection("months").getKeys(false).iterator();
        while (object3.hasNext()) {
            object = object2 = (String)object3.next();
            int n2 = bl2 ? this.monthLengths[n] : this.calendar.getInt("months." + (String)object2 + ".days");
            int n3 = this.calendar.getInt("months." + (String)object2 + ".day-length-in-min");
            int n4 = this.calendar.getInt("months." + (String)object2 + ".night-length-in-min");
            arrayList.add(new Month((String)object, n2, n3, n4));
            ++n;
        }
        this.year = new Year(arrayList);
        this.main.getSettings().timeSyncOffset = this.calendar.getInt("time-sync-offset");
        object3 = this.dateFromString(this.calendar.getString("winter-start"));
        object2 = this.dateFromString(this.calendar.getString("spring-start"));
        object = this.dateFromString(this.calendar.getString("summer-start"));
        Date date = this.dateFromString(this.calendar.getString("fall-start"));
        if (object3 == null) {
            Bukkit.getLogger().severe("[RealisticSeasons] Could not parse date for winter start: " + this.calendar.getString("winter-start") + "(" + JavaUtils.getDayOfStringDate(this.calendar.getString("winter-start")) + ", " + this.getMonthFromString(this.calendar.getString("winter-start")) + ")");
        }
        if (object2 == null) {
            Bukkit.getLogger().severe("[RealisticSeasons] Could not parse date for spring start: " + this.calendar.getString("spring-start") + "(" + JavaUtils.getDayOfStringDate(this.calendar.getString("spring-start")) + ", " + this.getMonthFromString(this.calendar.getString("spring-start")) + ")");
        }
        if (object == null) {
            Bukkit.getLogger().severe("[RealisticSeasons] Could not parse date for summer start: " + this.calendar.getString("summer-start") + "(" + JavaUtils.getDayOfStringDate(this.calendar.getString("summer-start")) + ", " + this.getMonthFromString(this.calendar.getString("summer-start")) + ")");
        }
        if (date == null) {
            Bukkit.getLogger().severe("[RealisticSeasons] Could not parse date for fall start: " + this.calendar.getString("fall-start") + "(" + JavaUtils.getDayOfStringDate(this.calendar.getString("fall-start")) + ", " + this.getMonthFromString(this.calendar.getString("fall-start")) + ")");
        }
        this.main.getSettings().calendarEnabled = this.calendar.getBoolean("enabled");
        this.main.getSettings().americandateformat = this.calendar.getBoolean("american-date-format");
        if (!this.calendar.contains("worlds-without-events")) {
            bl = true;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("none");
            this.calendar.set("worlds-without-events", arrayList2);
        }
        if (!this.calendar.contains("synced-worlds")) {
            bl = true;
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add("none");
            this.calendar.set("synced-worlds", arrayList3);
        }
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (Object object4 : this.calendar.getStringList("synced-worlds")) {
            if (((String)object4).equalsIgnoreCase("none")) continue;
            arrayList4.add((String)object4);
        }
        ArrayList arrayList5 = new ArrayList();
        for (String string : this.calendar.getStringList("worlds-without-events")) {
            if (string.equalsIgnoreCase("none")) continue;
            arrayList5.add(string);
        }
        this.main.getSettings().worldsWithoutEvents = arrayList5;
        this.main.getSettings().syncedWorlds = arrayList4;
        if (this.calendar.contains("time")) {
            this.main.getSettings().timeFormat = this.calendar.getString("time.format");
            this.main.getSettings().AmPm = this.calendar.getBoolean("time.12-hour-clock.add-am-pm");
            this.main.getSettings().is12hourClock = this.calendar.getBoolean("time.12-hour-clock.enabled");
        } else {
            this.calendar.set("time.format", (Object)"$hours$:$minutes$");
            this.calendar.set("time.12-hour-clock.enabled", (Object)false);
            this.calendar.set("time.12-hour-clock.add-am-pm", (Object)false);
            this.main.getSettings().timeFormat = "$hours$:$minutes$";
            this.main.getSettings().AmPm = false;
            this.main.getSettings().is12hourClock = false;
            bl = true;
        }
        if (bl) {
            try {
                this.calendar.save(this.calendarFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return new Calendar(week, this.year, (Date)object3, (Date)object2, (Date)object, date);
    }

    public int getMonthIndex(List<Month> list, Month month) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getName().equals(month.getName())) continue;
            return i + 1;
        }
        return 1;
    }

    public int getMonthFromString(String string) {
        return this.getMonthIndex(this.year.getMonths(), this.year.getMonth(JavaUtils.getMonthOfStringDate(string)));
    }

    public Date dateFromString(String string) {
        try {
            return new Date(Integer.valueOf(JavaUtils.getDayOfStringDate(string)), this.getMonthFromString(string));
        }
        catch (NullPointerException nullPointerException) {
            Bukkit.getLogger().severe("Could not find month in: " + string + " as season start");
            return null;
        }
    }
}

