/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.commands.ToggleSeasonsCommand;
import me.casperge.realisticseasons.particle.ParticleManager;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.temperature.TempData;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataHandler {
    private RealisticSeasons main;
    private File dataFile;
    private YamlConfiguration data;

    public DataHandler(RealisticSeasons realisticSeasons) {
        this.dataFile = new File(realisticSeasons.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            File file = new File(realisticSeasons.getDataFolder(), "data/");
            if (file.isDirectory()) {
                this.dataFile = new File(realisticSeasons.getDataFolder(), "data/data.yml");
            } else {
                try {
                    InputStream inputStream = realisticSeasons.getResource("data.yml");
                    FileUtils.copyInputStreamToFile(inputStream, this.dataFile);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.main = realisticSeasons;
        this.load();
    }

    public void save() {
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<World, Season> object32 : this.main.getSeasonManager().worldData.entrySet()) {
            hashMap.put(object32.getKey().getName(), object32.getValue().getConfigName());
        }
        for (String string : hashMap.keySet()) {
            this.data.set("worlds." + string, hashMap.get(string));
        }
        if (this.main.getSeasonCycle().lastRecordedRealLifeTime != null) {
            this.data.set("last-recorded-date", (Object)this.main.getSeasonCycle().lastRecordedRealLifeTime.toString());
        }
        HashMap<World, Date> hashMap2 = this.main.getTimeManager().getDates();
        for (Object object2 : hashMap2.keySet()) {
            if (hashMap2.get(object2) == null) continue;
            this.data.set("dates." + object2.getName() + ".day", (Object)((Date)hashMap2.get(object2)).getDay());
            this.data.set("dates." + object2.getName() + ".month", (Object)((Date)hashMap2.get(object2)).getMonth());
            this.data.set("dates." + object2.getName() + ".year", (Object)((Date)hashMap2.get(object2)).getYear());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UUID uUID : ToggleSeasonsCommand.disabled) {
            arrayList.add(uUID.toString());
        }
        this.data.set("players.colorsdisabled", arrayList);
        object2 = new ArrayList();
        for (UUID uUID : this.main.getTemperatureManager().getTemperatureDisabled()) {
            object2.add(uUID.toString());
        }
        this.data.set("players.tempdisabled", object2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.main.getParticleManager();
        for (UUID uUID : ParticleManager.disabledParticles) {
            arrayList2.add(uUID.toString());
        }
        this.data.set("players.particlesdisabled", arrayList2);
        this.data.set("players.tempeffects", null);
        for (UUID uUID : this.main.getTemperatureManager().getTempData().getActiveCustomEffects().keySet()) {
            if (this.main.getTemperatureManager().getTempData().getActiveCustomEffects().get(uUID).size() == 0) continue;
            for (int i = 0; i < this.main.getTemperatureManager().getTempData().getActiveCustomEffects().get(uUID).size(); ++i) {
                TempData.CustomTemperatureEffect customTemperatureEffect = this.main.getTemperatureManager().getTempData().getActiveCustomEffects().get(uUID).get(i);
                this.data.set("players.tempeffects." + uUID.toString() + "." + String.valueOf(i) + ".modifier", (Object)customTemperatureEffect.getTemperatureModifier());
                this.data.set("players.tempeffects." + uUID.toString() + "." + String.valueOf(i) + ".start", (Object)customTemperatureEffect.getStartTime());
                this.data.set("players.tempeffects." + uUID.toString() + "." + String.valueOf(i) + ".duration", (Object)customTemperatureEffect.getDuration());
            }
        }
        this.data.set("temperature", null);
        for (World world : this.main.getTemperatureManager().getTempData().getEnabledWorlds()) {
            this.data.set("temperature." + world.getName(), (Object)true);
        }
        this.data.set("time-paused", null);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (World world : this.main.getTimeManager().getPausedWorlds()) {
            arrayList3.add(world.getName());
        }
        this.data.set("time-paused", arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (UUID uUID : this.main.getTemperatureManager().getKnownPlayers()) {
            arrayList4.add(uUID.toString());
        }
        this.data.set("players.knownplayers", arrayList4);
        this.data.set("players.fahrenheit-mode", null);
        ArrayList arrayList5 = new ArrayList();
        for (UUID uUID : this.main.getTemperatureManager().getFahrenheitEnabled()) {
            arrayList5.add(uUID.toString());
        }
        this.data.set("players.fahrenheit-mode", (Object)arrayList5);
        this.main.getBlockStorage().save(this.data);
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void load() {
        int n;
        World world;
        String string2;
        Object object;
        World world2;
        Object object2;
        Object object32;
        Collection collection;
        boolean bl = false;
        ConfigurationSection configurationSection = this.data.getConfigurationSection("worlds");
        if (configurationSection != null && !(collection = configurationSection.getKeys(false)).isEmpty()) {
            for (Object object32 : collection) {
                object2 = Bukkit.getWorld((String)object32);
                if (object2 == null || (world2 = configurationSection.getString((String)object32)) == null) continue;
                this.main.getSeasonManager().worldData.put((World)object2, Season.getSeason((String)world2));
                if (this.main.getSettings().affectTime && Season.getSeason((String)world2) != Season.DISABLED && Season.getSeason((String)world2) != Season.RESTORE && ((Boolean)object2.getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE)).booleanValue()) {
                    object2.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                }
                if (this.main.getTimeManager().getDate((World)object2) != null) continue;
                this.main.getTimeManager().setDate((World)object2, this.main.getTimeManager().getCalendar().getSeasonStart(Season.getSeason((String)world2)));
            }
        }
        collection = this.data.getStringList("players.colorsdisabled");
        for (Object object32 : collection) {
            ToggleSeasonsCommand.disabled.add(UUID.fromString((String)object32));
        }
        if (this.data.contains("players.tempdisabled")) {
            object = this.data.getStringList("players.tempdisabled");
            object32 = object.iterator();
            while (object32.hasNext()) {
                object2 = (String)object32.next();
                this.main.getTemperatureManager().disableTemperature(UUID.fromString((String)object2));
            }
        }
        if (this.data.contains("players.particlesdisabled")) {
            object = this.data.getStringList("players.particlesdisabled");
            object32 = new ArrayList();
            object2 = object.iterator();
            while (object2.hasNext()) {
                world2 = (String)object2.next();
                object32.add((UUID)UUID.fromString((String)world2));
            }
            ParticleManager.disabledParticles = object32;
        }
        if (this.data.contains("players.knownplayers")) {
            object = this.data.getStringList("players.knownplayers");
            object32 = new ArrayList();
            object2 = object.iterator();
            while (object2.hasNext()) {
                world2 = (String)object2.next();
                this.main.getTemperatureManager().loggedIn(UUID.fromString((String)world2));
            }
        }
        if (this.data.contains("last-recorded-date")) {
            object = ZonedDateTime.parse(this.data.getString("last-recorded-date"));
            this.main.setLoadedTime((ZonedDateTime)object);
        }
        if (this.data.isConfigurationSection("dates")) {
            object = new HashMap();
            object32 = this.data.getConfigurationSection("dates");
            if (object32 != null && !(object2 = this.data.getConfigurationSection("dates").getKeys(false)).isEmpty()) {
                world2 = object2.iterator();
                while (world2.hasNext()) {
                    string2 = (String)world2.next();
                    world = Bukkit.getWorld((String)string2);
                    if (world == null) continue;
                    int n2 = this.data.getInt("dates." + string2 + ".day");
                    int n3 = this.data.getInt("dates." + string2 + ".month");
                    n = this.data.getInt("dates." + string2 + ".year");
                    ((HashMap)object).put(world, new Date(n2, n3, n));
                }
            }
            this.main.getTimeManager().addToDatesRegister((HashMap<World, Date>)object);
        }
        if (this.data.isConfigurationSection("temperature")) {
            object = new ArrayList();
            object32 = this.data.getConfigurationSection("temperature");
            if (object32 != null && !(object2 = this.data.getConfigurationSection("temperature").getKeys(false)).isEmpty()) {
                world2 = object2.iterator();
                while (world2.hasNext()) {
                    string2 = (String)world2.next();
                    world = Bukkit.getWorld((String)string2);
                    if (world == null || !this.data.getBoolean("temperature." + string2)) continue;
                    object.add(world);
                }
            }
            object2 = object.iterator();
            while (object2.hasNext()) {
                world2 = (World)object2.next();
                this.main.getTemperatureManager().getTempData().enableWorld(world2);
            }
        }
        if (this.data.isList("time-paused")) {
            object = this.data.getStringList("time-paused");
            object32 = object.iterator();
            while (object32.hasNext()) {
                object2 = (String)object32.next();
                world2 = Bukkit.getWorld((String)object2);
                if (world2 == null) continue;
                this.main.getTimeManager().pauseTime(world2);
            }
        }
        if (this.data.contains("players.tempeffects")) {
            for (Object object32 : this.data.getConfigurationSection("players.tempeffects").getKeys(false)) {
                object2 = UUID.fromString((String)object32);
                for (String string2 : this.data.getConfigurationSection("players.tempeffects." + (String)object32).getKeys(false)) {
                    int n4 = this.data.getInt("players.tempeffects." + (String)object32 + "." + string2 + ".duration");
                    long l = this.data.getLong("players.tempeffects." + (String)object32 + "." + string2 + ".start");
                    n = this.data.getInt("players.tempeffects." + (String)object32 + "." + string2 + ".modifier");
                    this.main.getTemperatureManager().getTempData().applyCustomEffect((UUID)object2, n, n4, l);
                }
            }
        }
        if (this.data.contains("players.fahrenheit-mode")) {
            object = this.data.getStringList("players.fahrenheit-mode");
            object32 = object.iterator();
            while (object32.hasNext()) {
                object2 = (String)object32.next();
                this.main.getTemperatureManager().toggleFahrenheit(UUID.fromString((String)object2));
            }
        }
        if (this.data.isConfigurationSection("placedblocks")) {
            this.main.getBlockStorage().load(this.data.getConfigurationSection("placedblocks"));
        }
    }
}

