/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.Version;
import me.casperge.realisticseasons.biome.BlockReplacement;
import me.casperge.realisticseasons.biome.BlockReplacements;
import me.casperge.realisticseasons.season.Season;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;

public class Settings {
    public boolean modifyBlocks = true;
    public boolean affectTime = true;
    public boolean affectWeather = true;
    public boolean affectBiomes = true;
    public boolean affectCropsWinter = true;
    public boolean affectCropsSummer = true;
    public int delayPerTick = 4;
    public float spawnChanceAnimals = 10.0f;
    public int timeSyncOffset = 0;
    public boolean removeAnimalsOnSeasonChange = true;
    public boolean sendMessageOnSeasonCycle = true;
    public boolean spawnIceInWinter = true;
    public boolean snowmanCantPlaceSnow = false;
    public boolean snowmanAttackMobs = false;
    public String biomeDisplayName = "realisticseasons";
    public boolean spawnEntities = true;
    public float flowerchanceinspring = 5.0f;
    public boolean doSeasonCycle = true;
    public int maxBerryBushes = 20;
    public boolean snowRemoval = true;
    public boolean doBerryDamage = false;
    public boolean spawnBatsInFall = false;
    public boolean spawnCaveSpidersInFall = false;
    public boolean spawnFoxesInFall = false;
    public boolean spawnMooshroomInFall = false;
    public boolean spawnExtraSpidersInFall = false;
    public boolean spawnFrogsInFall = false;
    public boolean pumpkinsInFall = true;
    public float pumpkinchance = 20.0f;
    public boolean spawnExtraAnimalsInSpring = false;
    public boolean spawnExtraBeesInSpring = false;
    public boolean spawnExtraRabitsInSpring = false;
    public boolean spawnOcelotsInSummer = false;
    public boolean spawnPandasInSummer = false;
    public boolean spawnHusksInSummer = false;
    public boolean spawnParrotsInSummer = false;
    public boolean spawnWolfsInWinter = false;
    public boolean spawnFoxesInWinter = false;
    public String timezone = "system";
    public boolean spawnStraysInWinter = false;
    public boolean spawnPolarBearsInWinter = false;
    public boolean keepPlayerPlacedPlants = true;
    public boolean spawnSnowmanInWinter = false;
    public boolean terraGenSnowDisabled = true;
    public boolean snowmanWearPumpkin = false;
    public boolean calendarEnabled = true;
    public boolean americandateformat = false;
    public boolean pauseDynmapInWinter = true;
    public boolean regrowGrass = false;
    public String timeFormat = "\\$hours\\$:\\$minutes\\$";
    public boolean is12hourClock = false;
    public boolean AmPm = false;
    public boolean snowPlacement = true;
    public boolean keepNaturalSnow = true;
    public boolean spawnMushroomsInFall = true;
    public boolean prioritiseTPS = true;
    public boolean isCalendarInRealLifeDays = false;
    public boolean canCheckUnloadedChunks = true;
    public int delayPerAsyncChunk = 40;
    public Material fallingLeafItem = Material.KELP;
    public Integer fallingLeafCMD = 0;
    public double minTPS = 19.5;
    public List<String> syncedWorlds = new ArrayList<String>();
    public HashMap<Season, WeatherSettings> weathersettings = new HashMap();
    public boolean subSeasonsEnabled = true;
    public String SpringSummerAdjustment = "";
    public double SpringSummerWeight = 0.0;
    public int minTempModify = -999999;
    public int maxTempModify = 999999;
    public String SummerFallAdjustment = "";
    public double SummerFallWeight = 0.0;
    public String FallWinterAdjustment = "";
    public double FallWinterWeight = 0.0;
    public String WinterSpringAdjustment = "";
    public double WinterSpringWeight = 0.0;
    public boolean fallingLeavesEnabled = true;
    public float fallingLeavesChance = 0.5f;
    public List<Season> fallingLeavesSeasons = new ArrayList<Season>();
    public boolean smallFallingLeavesEnabled = true;
    public float smallFallingLeavesChance = 0.5f;
    public List<Season> smallFallingLeavesSeasons = new ArrayList<Season>();
    public boolean fallingStarsEnabled = true;
    public int fallingStarsHeight = 150;
    public float fallingStarsChance = 0.5f;
    public List<Season> fallingStarsSeasons = new ArrayList<Season>();
    public boolean nightSparksEnabled = true;
    public int nightSparksParticleCount = 500;
    public float nightSparksChance = 33.0f;
    public int nightSparksHeight = 40;
    public List<Season> nightSparksSeasons = new ArrayList<Season>();
    public boolean fireFliesEnabled = true;
    public float fireFliesChance = 0.03f;
    public List<Season> fireFliesSeasons = new ArrayList<Season>();
    public boolean sweatEffectEnabled = true;
    public int sweatMinTemperature = 45;
    public boolean coldBreathEnabled = true;
    public boolean coldBreathHideOwn = true;
    public boolean optimizedBiomes = true;
    public int coldBreathMaxTemperature = 0;
    public Season defaultSeason = Season.DISABLED;
    public int snowLayers = 1;
    public boolean syncWorldTimeWithRealWorld = false;
    public List<EntityType> fallAnimals = new ArrayList<EntityType>();
    public List<EntityType> springAnimals = new ArrayList<EntityType>();
    public List<EntityType> summerAnimals = new ArrayList<EntityType>();
    public List<EntityType> winterAnimals = new ArrayList<EntityType>();
    public List<EntityType> fullFallAnimals = new ArrayList<EntityType>();
    public List<EntityType> fullSpringAnimals = new ArrayList<EntityType>();
    public List<EntityType> fullSummerAnimals = new ArrayList<EntityType>();
    public List<EntityType> fullWinterAnimals = new ArrayList<EntityType>();
    public List<String> worldsWithoutEvents = new ArrayList<String>();
    private FileConfiguration config;
    private RealisticSeasons main;

    public Settings(RealisticSeasons realisticSeasons, boolean bl) {
        this.main = realisticSeasons;
        this.config = realisticSeasons.getRSConfig();
        this.load(bl);
        realisticSeasons.isFreshInstall = bl;
    }

    public void reload() {
        boolean bl = this.main.loadConfig();
        this.config = this.main.getRSConfig();
        this.load(bl);
    }

    public void load(boolean bl) {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.isOldConfig(this.config.getString("version"), "7.18") && !bl) {
            Bukkit.getLogger().info("[RealisticSeasons] Old config detected, updating chances to percentages.");
            object5 = this.config.getInt("flower-chance-in-spring");
            object4 = this.config.getInt("entities.fall.entities-pumpkin-chance");
            object3 = Integer.valueOf(this.config.getInt("entities.spawn-chance-animals"));
            this.config.set("flower-chance-in-spring", (Object)this.convertChanceToPercentage((Integer)object5));
            this.config.set("entities.fall.entities-pumpkin-chance", (Object)this.convertChanceToPercentage((int)object4));
            this.config.set("entities.spawn-chance-animals", (Object)this.convertChanceToPercentage((Integer)object3));
        }
        if (!Version.is_1_19_3_or_up()) {
            if (!this.config.contains("max-snow-layers")) {
                this.config.set("max-snow-layers", (Object)1);
            } else {
                this.snowLayers = this.config.getInt("max-snow-layers");
            }
        }
        this.fallingLeafItem = Material.valueOf((String)this.config.getString("falling-leaf-item"));
        if (this.fallingLeafItem == null) {
            this.fallingLeafItem = Material.KELP;
        }
        this.fallingLeafCMD = this.config.getInt("falling-leaf-custommodeldata");
        this.modifyBlocks = this.config.getBoolean("modify-blocks");
        this.sendMessageOnSeasonCycle = this.config.getBoolean("send-message-on-season-cycle");
        this.affectWeather = this.config.getBoolean("modify-weather-cycle");
        this.affectTime = this.config.getBoolean("modify-daynight-length");
        this.affectBiomes = this.config.getBoolean("modify-biome-on-client");
        this.snowRemoval = this.config.getBoolean("snow-and-ice-removal");
        this.delayPerTick = this.config.getInt("delay-per-operation");
        this.doSeasonCycle = this.config.getBoolean("automatic-season-cycling");
        this.maxBerryBushes = this.config.getInt("max-berrybushes-per-chunk");
        this.doBerryDamage = !this.config.getBoolean("disable-berry-damage-for-entities");
        this.regrowGrass = this.config.getBoolean("regrow-grass-everywhere");
        this.spawnMushroomsInFall = this.config.getBoolean("spawn-mushrooms-in-fall");
        this.optimizedBiomes = this.config.getBoolean("optimized-custom-biomes");
        object5 = this.config.getString("default-season");
        if (!((String)object5).equalsIgnoreCase("none") && (object4 = Season.valueOf((String)object5)) != null) {
            this.defaultSeason = object4;
        }
        this.prioritiseTPS = this.config.getBoolean("performance.prioritise-tps");
        this.minTPS = this.config.getDouble("performance.min-tps");
        this.keepPlayerPlacedPlants = this.config.getBoolean("keep-player-placed-plants");
        if (this.config.getKeys(false).contains("minecraft-days-per-season")) {
            int n = this.config.getInt("minecraft-days-per-season");
            this.config.set("length-in-minecraft-days-winter", (Object)n);
            this.config.set("length-in-minecraft-days-fall", (Object)n);
            this.config.set("length-in-minecraft-days-spring", (Object)n);
            this.config.set("length-in-minecraft-days-summer", (Object)n);
            this.config.set("minecraft-days-per-season", null);
        }
        this.pauseDynmapInWinter = this.config.getBoolean("dynmap-pause-renders-in-winter");
        this.snowmanCantPlaceSnow = this.config.getBoolean("disable-snow-placement-all-snowman");
        this.snowmanAttackMobs = this.config.getBoolean("snowman-attack-mobs");
        this.snowmanWearPumpkin = this.config.getBoolean("snowman-wear-pumpkin");
        this.biomeDisplayName = this.config.getString("biome-display-name").toLowerCase();
        this.spawnEntities = this.config.getBoolean("entities.spawn-entities");
        this.subSeasonsEnabled = this.config.getBoolean("sub-seasons.enabled");
        this.delayPerAsyncChunk = this.config.getInt("unloaded-chunks-check-delay");
        this.terraGenSnowDisabled = this.config.getBoolean("no-snow-on-leaves-for-terra");
        this.flowerchanceinspring = Float.valueOf(this.config.getString("flower-chance-in-spring").replaceAll("%", "")).floatValue();
        this.removeAnimalsOnSeasonChange = this.config.getBoolean("entities.despawn-season-animals");
        if (this.config.isConfigurationSection("messages")) {
            Bukkit.getLogger().severe("Your RealisticSeasons config still contains a messages section. Please note that this isn't used anymore and the lang.yml file is now used for messages. You can savely remove the messages section from the config.");
        }
        this.spawnChanceAnimals = Float.valueOf(this.config.getString("entities.spawn-chance-animals").replaceAll("%", "")).floatValue();
        if (this.config.getBoolean("entities.spawn-entities")) {
            this.spawnExtraAnimalsInSpring = this.config.getBoolean("entities.spring.spawn-extra-animals");
            this.spawnExtraBeesInSpring = this.config.getBoolean("entities.spring.spawn-extra-bees");
            this.spawnExtraRabitsInSpring = this.config.getBoolean("entities.spring.spawn-extra-rabits");
            this.spawnOcelotsInSummer = this.config.getBoolean("entities.summer.spawn-ocelots");
            this.spawnPandasInSummer = this.config.getBoolean("entities.summer.spawn-pandas");
            this.spawnParrotsInSummer = this.config.getBoolean("entities.summer.spawn-parrots");
            this.spawnHusksInSummer = this.config.getBoolean("entities.summer.replace-zombies-with-husks");
            this.spawnBatsInFall = this.config.getBoolean("entities.fall.spawn-bats");
            this.spawnFrogsInFall = this.config.getBoolean("entities.fall.spawn-frogs");
            this.spawnCaveSpidersInFall = this.config.getBoolean("entities.fall.spawn-cave-spiders");
            this.spawnFoxesInFall = this.config.getBoolean("entities.fall.spawn-foxes");
            this.spawnMooshroomInFall = this.config.getBoolean("entities.fall.spawn-mooshrooms");
            this.spawnExtraSpidersInFall = this.config.getBoolean("entities.fall.spawn-extra-spiders");
            this.spawnWolfsInWinter = this.config.getBoolean("entities.winter.spawn-wolfs");
            this.spawnFoxesInWinter = this.config.getBoolean("entities.winter.spawn-foxes");
            this.spawnPolarBearsInWinter = this.config.getBoolean("entities.winter.spawn-polarbears");
            this.spawnSnowmanInWinter = this.config.getBoolean("entities.winter.spawn-snowman");
            this.spawnStraysInWinter = this.config.getBoolean("entities.winter.replace-skeletons-with-strays");
        }
        this.spawnIceInWinter = this.config.getBoolean("spawn-ice-in-winter");
        this.pumpkinsInFall = this.config.getBoolean("entities.fall.give-entities-pumpkin");
        this.pumpkinchance = Float.valueOf(this.config.getString("entities.fall.entities-pumpkin-chance").replaceAll("%", "")).floatValue();
        this.keepNaturalSnow = this.config.getBoolean("keep-natural-snow");
        this.snowPlacement = this.config.getBoolean("snow-placement-enabled");
        String string = this.config.getString("sub-seasons.foliage-color-adjustments.WINTER-SPRING").toLowerCase().replaceAll("weight:", "");
        if (!string.contains("none") && ((String[])(object3 = string.split(","))).length == 2) {
            this.WinterSpringAdjustment = object3[0].replaceAll("#", "");
            this.WinterSpringWeight = Double.parseDouble((String)object3[1]);
        }
        if (this.config.getString("sub-seasons.foliage-color-adjustments.SPRING-SUMMER").equals("#FFFFFF,WEIGHT:0.3")) {
            this.config.set("sub-seasons.foliage-color-adjustments.SPRING-SUMMER", (Object)"#32CD32,WEIGHT:0.3");
        }
        if (!((String)(object3 = this.config.getString("sub-seasons.foliage-color-adjustments.SPRING-SUMMER").toLowerCase().replaceAll("weight:", ""))).contains("none") && ((String[])(object2 = ((String)object3).split(","))).length == 2) {
            this.SpringSummerAdjustment = object2[0].replaceAll("#", "");
            this.SpringSummerWeight = Double.parseDouble((String)object2[1]);
        }
        if (!((String)(object2 = this.config.getString("sub-seasons.foliage-color-adjustments.SUMMER-FALL").toLowerCase().replaceAll("weight:", ""))).contains("none") && ((String[])(object = ((String)object2).split(","))).length == 2) {
            this.SummerFallAdjustment = object[0].replaceAll("#", "");
            this.SummerFallWeight = Double.parseDouble((String)object[1]);
        }
        if (!((String)(object = this.config.getString("sub-seasons.foliage-color-adjustments.FALL-WINTER").toLowerCase().replaceAll("weight:", ""))).contains("none") && (objectArray = ((String)object).split(",")).length == 2) {
            this.FallWinterAdjustment = objectArray[0].replaceAll("#", "");
            this.FallWinterWeight = Double.parseDouble(objectArray[1]);
        }
        this.fallAnimals.clear();
        this.springAnimals.clear();
        this.summerAnimals.clear();
        this.winterAnimals.clear();
        this.minTempModify = this.config.getInt("temperature-modify-command.min");
        this.maxTempModify = this.config.getInt("temperature-modify-command.max");
        if (this.spawnFoxesInFall) {
            this.fallAnimals.add(EntityType.FOX);
        }
        this.fullFallAnimals.add(EntityType.FOX);
        if (this.spawnFrogsInFall && Version.is_1_19_or_up()) {
            this.fallAnimals.add(EntityType.FROG);
        }
        if (Version.is_1_19_or_up()) {
            this.fullFallAnimals.add(EntityType.FROG);
        }
        if (this.spawnMooshroomInFall) {
            this.fallAnimals.add(EntityType.MUSHROOM_COW);
        }
        this.fullFallAnimals.add(EntityType.MUSHROOM_COW);
        if (this.spawnExtraAnimalsInSpring) {
            this.springAnimals.add(EntityType.BEE);
        }
        this.fullSpringAnimals.add(EntityType.BEE);
        if (this.spawnExtraRabitsInSpring) {
            this.springAnimals.add(EntityType.RABBIT);
        }
        this.fullSpringAnimals.add(EntityType.RABBIT);
        if (this.spawnOcelotsInSummer) {
            this.summerAnimals.add(EntityType.OCELOT);
        }
        this.fullSummerAnimals.add(EntityType.OCELOT);
        if (this.spawnPandasInSummer) {
            this.summerAnimals.add(EntityType.PANDA);
        }
        this.fullSummerAnimals.add(EntityType.PANDA);
        if (this.spawnParrotsInSummer) {
            this.summerAnimals.add(EntityType.PARROT);
        }
        this.fullSummerAnimals.add(EntityType.PARROT);
        if (this.spawnWolfsInWinter) {
            this.winterAnimals.add(EntityType.WOLF);
        }
        this.fullWinterAnimals.add(EntityType.WOLF);
        if (this.spawnFoxesInWinter) {
            this.winterAnimals.add(EntityType.FOX);
        }
        this.fullWinterAnimals.add(EntityType.FOX);
        if (this.spawnPolarBearsInWinter) {
            this.winterAnimals.add(EntityType.POLAR_BEAR);
        }
        this.fullWinterAnimals.add(EntityType.POLAR_BEAR);
        if (this.spawnSnowmanInWinter) {
            this.winterAnimals.add(EntityType.SNOWMAN);
        }
        this.fullWinterAnimals.add(EntityType.SNOWMAN);
        if (this.spawnExtraAnimalsInSpring) {
            this.springAnimals.add(EntityType.COW);
            this.springAnimals.add(EntityType.SHEEP);
            this.springAnimals.add(EntityType.CHICKEN);
            this.springAnimals.add(EntityType.PIG);
        }
        this.fullSpringAnimals.add(EntityType.COW);
        this.fullSpringAnimals.add(EntityType.SHEEP);
        this.fullSpringAnimals.add(EntityType.CHICKEN);
        this.fullSpringAnimals.add(EntityType.PIG);
        this.fallingLeavesEnabled = this.config.getBoolean("particles.FALLING_LEAVES.enabled");
        this.fallingLeavesChance = Float.valueOf(this.config.getString("particles.FALLING_LEAVES.spawn-chance").replaceAll("%", "")).floatValue();
        this.fallingLeavesSeasons = this.seasonListFromStringList(this.config.getStringList("particles.FALLING_LEAVES.seasons"));
        this.smallFallingLeavesEnabled = this.config.getBoolean("particles.SMALL_FALLING_LEAVES.enabled");
        this.smallFallingLeavesChance = Float.valueOf(this.config.getString("particles.FALLING_LEAVES.spawn-chance").replaceAll("%", "")).floatValue();
        this.smallFallingLeavesSeasons = this.seasonListFromStringList(this.config.getStringList("particles.SMALL_FALLING_LEAVES.seasons"));
        this.fallingStarsEnabled = this.config.getBoolean("particles.SHOOTING_STARS.enabled");
        this.fallingStarsSeasons = this.seasonListFromStringList(this.config.getStringList("particles.SHOOTING_STARS.seasons"));
        this.fallingStarsHeight = this.config.getInt("particles.SHOOTING_STARS.relative-height");
        this.fallingStarsChance = Float.valueOf(this.config.getString("particles.SHOOTING_STARS.chance").replaceAll("%", "")).floatValue();
        this.nightSparksEnabled = this.config.getBoolean("particles.NIGHT_SPARKS.enabled");
        this.nightSparksSeasons = this.seasonListFromStringList(this.config.getStringList("particles.NIGHT_SPARKS.seasons"));
        this.nightSparksParticleCount = this.config.getInt("particles.NIGHT_SPARKS.particle-count");
        this.nightSparksHeight = this.config.getInt("particles.NIGHT_SPARKS.relative-height");
        this.nightSparksChance = Float.valueOf(this.config.getString("particles.NIGHT_SPARKS.event-chance").replaceAll("%", "")).floatValue();
        this.fireFliesEnabled = this.config.getBoolean("particles.FIREFLIES.enabled");
        this.fireFliesSeasons = this.seasonListFromStringList(this.config.getStringList("particles.FIREFLIES.seasons"));
        this.fireFliesChance = Float.valueOf(this.config.getString("particles.FIREFLIES.spawn-chance").replaceAll("%", "")).floatValue();
        this.sweatEffectEnabled = this.config.getBoolean("particles.SWEAT_EFFECT.enabled");
        this.sweatMinTemperature = this.config.getInt("particles.SWEAT_EFFECT.min-player-temperature");
        this.coldBreathEnabled = this.config.getBoolean("particles.COLD_BREATH.enabled");
        this.coldBreathHideOwn = this.config.getBoolean("particles.COLD_BREATH.hide-own-breath");
        this.coldBreathMaxTemperature = this.config.getInt("particles.COLD_BREATH.max-air-temperature");
        objectArray = new Season[]{Season.FALL, Season.SUMMER, Season.SPRING, Season.WINTER};
        for (String string2 : objectArray) {
            double d2 = Double.valueOf(this.config.getString("weather." + ((Season)((Object)string2)).getConfigName().toLowerCase() + ".daily-extra-downfall-chance").replaceAll("%", ""));
            boolean bl2 = this.config.getBoolean("weather." + ((Season)((Object)string2)).getConfigName().toLowerCase() + ".has-natural-downfall");
            this.weathersettings.put((Season)((Object)string2), new WeatherSettings(d2, bl2));
        }
        if (this.config.isConfigurationSection("biomes")) {
            this.config.set("biomes", null);
        }
        if (this.config.contains("length-in-minecraft-days-winter")) {
            this.config.set("length-in-minecraft-days-winter", null);
        }
        if (this.config.contains("length-in-minecraft-days-fall")) {
            this.config.set("length-in-minecraft-days-fall", null);
        }
        if (this.config.contains("length-in-minecraft-days-spring")) {
            this.config.set("length-in-minecraft-days-spring", null);
        }
        if (this.config.contains("length-in-minecraft-days-summer")) {
            this.config.set("length-in-minecraft-days-summer", null);
        }
        if (this.config.contains("affect-crop-growth")) {
            this.config.set("affect-crop-growth-summer", (Object)this.config.getBoolean("affect-crop-growth"));
            this.config.set("affect-crop-growth-winter", (Object)this.config.getBoolean("affect-crop-growth"));
            this.config.set("affect-crop-growth", null);
        }
        if (this.config.isConfigurationSection("block-replacements") && this.config.getBoolean("block-replacements.enabled")) {
            for (String string3 : this.config.getConfigurationSection("block-replacements.replacements").getKeys(false)) {
                List<Object> list;
                Object object6;
                String string2;
                String string4 = this.config.getString("block-replacements.replacements." + string3 + ".to-replace");
                string2 = this.config.getString("block-replacements.replacements." + string3 + ".replacement");
                String string5 = this.config.getString("block-replacements.replacements." + string3 + ".seasons");
                String string6 = this.config.getString("block-replacements.replacements." + string3 + ".sub-seasons");
                if (string4.equalsIgnoreCase("CHERRY_LEAVES") && !Version.is_1_20_or_up()) continue;
                Material material = Material.getMaterial((String)string4);
                if (material == null) {
                    Bukkit.getLogger().info("[RealisticSeasons] Unknown Material in config.yml: " + string4 + ". Ignoring section.");
                    continue;
                }
                if (string2.equalsIgnoreCase("CHERRY_LEAVES") && !Version.is_1_20_or_up()) continue;
                Material material2 = Material.getMaterial((String)string2);
                if (material2 == null) {
                    Bukkit.getLogger().info("[RealisticSeasons] Unknown Material in config.yml: " + string2 + ". Ignoring section.");
                    continue;
                }
                if (string5.contains(",")) {
                    object6 = string5.split(",");
                    list = new ArrayList();
                    for (int i = 0; i < ((String[])object6).length; ++i) {
                        list.add(Season.valueOf(object6[i].strip().toUpperCase()).intValue());
                    }
                } else {
                    list = Arrays.asList(Season.valueOf(string5.strip().toUpperCase()).intValue());
                }
                if (string6.contains(",")) {
                    String[] stringArray = string6.split(",");
                    object6 = new ArrayList();
                    for (int i = 0; i < stringArray.length; ++i) {
                        object6.add(Integer.valueOf(stringArray[i].strip()));
                    }
                } else {
                    object6 = Arrays.asList(Integer.valueOf(string6.strip()));
                }
                BlockReplacements.addBlockReplacement(new BlockReplacement(list, (List<Integer>)object6, material, material2));
            }
        }
        this.canCheckUnloadedChunks = this.config.getBoolean("remove-ice-in-unloaded-chunks");
        this.affectCropsWinter = this.config.getBoolean("affect-crop-growth-winter");
        this.affectCropsSummer = this.config.getBoolean("affect-crop-growth-summer");
        this.config.set("version", (Object)this.main.getDescription().getVersion());
        try {
            this.config.save(this.main.configFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean isOldConfig(String string, String string2) {
        if (string == null) {
            return true;
        }
        if (string.equals("")) {
            return true;
        }
        if (string.equals("1.0")) {
            return true;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n = Integer.valueOf(stringArray[0]);
        int n2 = Integer.valueOf(stringArray[1]);
        int n3 = Integer.valueOf(stringArray2[0]);
        int n4 = Integer.valueOf(stringArray2[1]);
        if (n < n3) {
            return true;
        }
        if (n > n3) {
            return false;
        }
        return n2 < n4;
    }

    private String convertChanceToPercentage(int n) {
        float f = 1.0f / (float)n * 100.0f;
        return String.valueOf(f) + "%";
    }

    private List<Season> seasonListFromStringList(List<String> list) {
        ArrayList<Season> arrayList = new ArrayList<Season>();
        for (String string : list) {
            arrayList.add(Season.valueOf(string.toUpperCase()));
        }
        return arrayList;
    }

    public class WeatherSettings {
        private double downfall;
        private boolean rain;

        public WeatherSettings(double d2, boolean bl) {
            this.downfall = d2;
            this.rain = bl;
        }

        public double getDownfallChance() {
            return this.downfall;
        }

        public boolean hasRain() {
            return this.rain;
        }
    }
}

