/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.event;

import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.data.Settings;
import me.casperge.realisticseasons.season.Season;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;

public class WorldEvents
implements Listener {
    RealisticSeasons main;

    public WorldEvents(RealisticSeasons realisticSeasons) {
        realisticSeasons.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)realisticSeasons);
        this.main = realisticSeasons;
    }

    @EventHandler
    public void weatherChange(WeatherChangeEvent weatherChangeEvent) {
        if (this.main.getSettings().affectWeather && this.main.getSeasonManager().getSeason(weatherChangeEvent.getWorld()) != Season.DISABLED && this.main.getSeasonManager().getSeason(weatherChangeEvent.getWorld()) != Season.RESTORE) {
            Settings.WeatherSettings weatherSettings = this.main.getSettings().weathersettings.get((Object)this.main.getSeasonManager().getSeason(weatherChangeEvent.getWorld()));
            if (weatherChangeEvent.toWeatherState() && !weatherSettings.hasRain()) {
                weatherChangeEvent.setCancelled(true);
            }
            if (this.main.getSeasonManager().getSeason(weatherChangeEvent.getWorld()) == Season.WINTER) {
                weatherChangeEvent.getWorld().setThunderDuration(0);
            }
        }
    }

    @EventHandler
    public void onWorldCreate(WorldInitEvent worldInitEvent) {
        World world = worldInitEvent.getWorld();
        if (world.getEnvironment() != World.Environment.THE_END && world.getEnvironment() != World.Environment.NETHER && this.main.getSeasonManager().getSeason(world) == Season.DISABLED) {
            this.main.getSeasonManager().setSeason(world, this.main.getSettings().defaultSeason);
        }
    }
}

