/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.particle.entity;

import java.util.List;
import me.casperge.enums.ArmorStandPart;
import me.casperge.interfaces.FakeArmorStand;
import me.casperge.realisticseasons.particle.entity.NMSEntityCreator;
import me.casperge.realisticseasons.particle.entity.SeasonEntity;
import me.casperge.realisticseasons.utils.BlockUtils;
import me.casperge.realisticseasons.utils.ChunkUtils;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class FallingLeaf
implements SeasonEntity {
    private int counter = 0;
    private Location currentLocation;
    private FakeArmorStand fakearm;
    private double FallingSpeed = 0.1;
    private Vector wind;
    private boolean isDestroyed = false;
    boolean yawIncreasing = true;
    Vector startVector;
    boolean isOnGround = false;
    private double maxArmYaw = JavaUtils.randomDouble(25.0, 35.0);
    private int blockCheckCount = 0;

    public FallingLeaf(Location location, List<Player> list, Vector vector, Material material, Integer n) {
        ItemMeta itemMeta;
        this.FallingSpeed = 0.1 + (0.01 - Math.random() / 50.0);
        double d2 = Math.random() * 360.0;
        this.currentLocation = location.clone();
        this.wind = vector;
        this.fakearm = NMSEntityCreator.createFakeArmorStand(location.getWorld(), location.getX(), location.getY(), location.getZ(), d2, true, false, false, true);
        ItemStack itemStack = new ItemStack(material);
        if (n != 0) {
            itemMeta = itemStack.getItemMeta();
            itemMeta.setCustomModelData(n);
            itemStack.setItemMeta(itemMeta);
        }
        this.fakearm.setItemSlot(0, itemStack);
        this.fakearm.sendSpawnPacket(list);
        this.currentLocation.setYaw((float)d2);
        this.startVector = this.currentLocation.getDirection().normalize();
        this.startVector = new Vector(-this.startVector.getZ(), 0.0, this.startVector.getX());
        itemMeta = new Vector(0, 0, 0);
    }

    private boolean isPlaceable(Block block) {
        return block.getType().equals((Object)Material.AIR) || ChunkUtils.naturalplants.contains(block.getType());
    }

    @Override
    public void tick(List<Player> list) {
        if (this.blockCheckCount > 4) {
            this.blockCheckCount = 0;
            Block block = this.currentLocation.getBlock();
            Material material = block.getType();
            if (!(material.equals((Object)Material.AIR) || ChunkUtils.naturalplants.contains(material) || this.isOnGround)) {
                if (material.equals((Object)Material.WATER) || material.equals((Object)Material.LAVA) || !BlockUtils.canLeafDrop(block)) {
                    this.fakearm.destroy(list);
                    this.isDestroyed = true;
                } else if (block.getRelative(BlockFace.UP).getType().equals((Object)Material.AIR) || ChunkUtils.naturalplants.contains(block.getRelative(BlockFace.UP).getType())) {
                    this.setOnGround(list);
                } else if (!(this.isPlaceable(block.getRelative(BlockFace.NORTH)) || this.isPlaceable(block.getRelative(BlockFace.SOUTH)) || this.isPlaceable(block.getRelative(BlockFace.WEST)) || this.isPlaceable(block.getRelative(BlockFace.EAST)))) {
                    this.fakearm.destroy(list);
                    this.isDestroyed = true;
                }
            }
        }
        ++this.blockCheckCount;
        if (!this.isOnGround && !this.isDestroyed) {
            float f = this.fakearm.getYaw(ArmorStandPart.RIGHT_ARM);
            float f2 = (float)((this.maxArmYaw + 10.0 - (double)Math.abs(f)) / 4.0);
            float f3 = 0.0f;
            if (this.yawIncreasing) {
                f3 = f + f2;
                if ((double)f3 > this.maxArmYaw) {
                    this.yawIncreasing = false;
                }
            } else {
                f3 = f - f2;
                if ((double)f3 < -this.maxArmYaw) {
                    this.yawIncreasing = true;
                }
                f2 = -f2;
            }
            this.currentLocation.add(this.wind.getX() / 10.0, -this.FallingSpeed, this.wind.getZ() / 10.0);
            this.currentLocation.add(this.startVector.clone().multiply(f2 / 50.0f));
            this.fakearm.move(this.currentLocation.clone(), list);
            this.fakearm.updatePose(ArmorStandPart.RIGHT_ARM, 0.0f, this.fakearm.getRoll(ArmorStandPart.RIGHT_ARM) + (float)(-3.0 + JavaUtils.randomDouble(0.0, 6.0)), f3, list);
        }
        if (this.counter > 300) {
            this.fakearm.destroy(list);
            this.isDestroyed = true;
        }
        ++this.counter;
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    @Override
    public Location getLocation() {
        return this.fakearm.getLocation();
    }

    public void setOnGround(List<Player> list) {
        this.fakearm.updatePose(ArmorStandPart.RIGHT_ARM, 0.0f, 0.0f, 0.0f, list);
        Location location = this.fakearm.getLocation().clone();
        location.setY((double)((float)this.fakearm.getLocation().getBlockY() + 0.2f));
        this.isOnGround = true;
        this.fakearm.move(location, list);
        this.counter = 280;
    }
}

