/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.runnables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.event.SeasonRefreshChunkEvent;
import me.casperge.realisticseasons.season.SeasonChunk;
import me.casperge.realisticseasons.utils.ChunkUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ChunkRefresher {
    public World w;
    public RealisticSeasons main;
    public HashMap<Player, Collection<SeasonChunk>> updateQueue;
    public BukkitTask task;
    public BukkitTask pretask;
    private Random r = new Random();
    private int viewDistance;

    public ChunkRefresher(final RealisticSeasons realisticSeasons, World world) {
        this.w = world;
        this.main = realisticSeasons;
        List list = world.getPlayers();
        this.viewDistance = Bukkit.getServer().getViewDistance();
        final ArrayList<String> arrayList = new ArrayList<String>();
        for (Player player : list) {
            Chunk chunk = player.getLocation().getChunk();
            arrayList.add(String.valueOf(chunk.getX()) + "," + String.valueOf(chunk.getZ()) + "," + chunk.getWorld().getName() + "," + player.getUniqueId().toString());
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)realisticSeasons, new Runnable(){

            @Override
            public void run() {
                final HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
                for (String string : arrayList) {
                    String[] stringArray = string.split(",");
                    int n = Integer.valueOf(stringArray[0]);
                    int n2 = Integer.valueOf(stringArray[1]);
                    String string2 = stringArray[2];
                    Collection<String> collection = ChunkUtils.aroundString(n, n2, string2, ChunkRefresher.this.viewDistance);
                    hashMap.put(stringArray[3], collection);
                }
                ChunkRefresher.this.pretask = Bukkit.getScheduler().runTaskTimer((Plugin)realisticSeasons.getPlugin(), new Runnable(){
                    HashMap<Player, Collection<SeasonChunk>> queue = new HashMap();

                    @Override
                    public void run() {
                        if (!hashMap.isEmpty()) {
                            Map.Entry entry = hashMap.entrySet().iterator().next();
                            Collection collection = (Collection)entry.getValue();
                            String string = (String)entry.getKey();
                            Player player = Bukkit.getPlayer((UUID)UUID.fromString(string));
                            if (player != null) {
                                if (!collection.isEmpty()) {
                                    Chunk chunk;
                                    String string2 = (String)collection.iterator().next();
                                    if (ChunkUtils.isChunkLoadedString(string2) && (chunk = ChunkUtils.chunkFromString(string2)) != null) {
                                        if (this.queue.containsKey(player)) {
                                            Collection<SeasonChunk> collection2 = this.queue.get(player);
                                            collection2.add(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L));
                                            this.queue.replace(player, collection2);
                                        } else {
                                            ArrayList<SeasonChunk> arrayList = new ArrayList<SeasonChunk>();
                                            arrayList.add(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L));
                                            this.queue.put(player, arrayList);
                                        }
                                    }
                                    collection.remove(string2);
                                    hashMap.replace(string, collection);
                                } else {
                                    hashMap.remove(string);
                                }
                            } else {
                                hashMap.remove(string);
                            }
                        } else {
                            ChunkRefresher.this.pretask.cancel();
                            ChunkRefresher.this.updateQueue = this.queue;
                            ChunkRefresher.this.runRefresher();
                        }
                    }
                }, 1L, 2L);
            }
        }, 1L);
    }

    public void runRefresher() {
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (!ChunkRefresher.this.updateQueue.isEmpty()) {
                    ArrayList<Player> arrayList = new ArrayList<Player>(ChunkRefresher.this.updateQueue.keySet());
                    Player player = arrayList.get(ChunkRefresher.this.r.nextInt(arrayList.size()));
                    Collection<SeasonChunk> collection = ChunkRefresher.this.updateQueue.get(player);
                    if (!collection.isEmpty() && player.isOnline()) {
                        Iterator<SeasonChunk> iterator = collection.iterator();
                        SeasonChunk seasonChunk = null;
                        if (iterator.hasNext()) {
                            seasonChunk = iterator.next();
                        }
                        collection.remove(seasonChunk);
                        ChunkRefresher.this.updateQueue.replace(player, collection);
                        if (player.getWorld() == seasonChunk.getWorld()) {
                            Location location = new Location(seasonChunk.getWorld(), (double)(seasonChunk.getX() * 16), player.getLocation().getY(), (double)(seasonChunk.getZ() * 16));
                            if (location.distance(player.getLocation()) < (double)(ChunkRefresher.this.viewDistance * 18) && seasonChunk.getWorld().isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ())) {
                                SeasonRefreshChunkEvent seasonRefreshChunkEvent = new SeasonRefreshChunkEvent(seasonChunk.getChunk(), player);
                                Bukkit.getPluginManager().callEvent((Event)seasonRefreshChunkEvent);
                                if (!seasonRefreshChunkEvent.isCancelled()) {
                                    ChunkRefresher.this.main.getNMSUtils().refreshChunk(player, seasonChunk.getChunk());
                                }
                            }
                        }
                    } else {
                        ChunkRefresher.this.updateQueue.remove(player);
                    }
                } else {
                    ChunkRefresher.this.main.getSeasonManager().refreshers.remove(ChunkRefresher.this.w);
                    ChunkRefresher.this.task.cancel();
                }
            }
        }, 0L, 2L);
    }
}

