/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.runnables;

import java.util.Random;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SeasonChunk;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;

public class RestoreWorldTicker
extends BukkitRunnable {
    private RealisticSeasons main;
    private World w;
    private Random r = new Random();
    private boolean hasChangedBlocks;

    public World getWorld() {
        return this.w;
    }

    public RestoreWorldTicker(RealisticSeasons realisticSeasons, World world) {
        this.main = realisticSeasons;
        this.w = world;
        for (Chunk chunk : world.getLoadedChunks()) {
            realisticSeasons.getSeasonManager().getQueue(world, Season.RESTORE).add(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), System.currentTimeMillis()));
        }
    }

    public static void checkChunk(SeasonChunk seasonChunk) {
        RealisticSeasons realisticSeasons = RealisticSeasons.getInstance();
        boolean bl = false;
        Chunk chunk = seasonChunk.getChunk();
        if (chunk == null) {
            return;
        }
        chunk.load();
        realisticSeasons.getAsyncChunkHandler().remove(seasonChunk);
        World world = seasonChunk.getWorld();
        if (world == null) {
            return;
        }
        if (!realisticSeasons.getChunkUtils().affectFlora(chunk)) {
            if (realisticSeasons.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld()) && realisticSeasons.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                realisticSeasons.getChunkUtils().unfreezeChunk(chunk);
            }
        } else {
            if (!realisticSeasons.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                return;
            }
            if (realisticSeasons.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                bl = realisticSeasons.getChunkUtils().unfreezeChunk(chunk);
                if (realisticSeasons.getSettings().regrowGrass) {
                    bl = true;
                }
                realisticSeasons.getChunkUtils().checkPopulation(chunk, 4.0f, 0.1f, 1, 1, Season.RESTORE, bl);
            }
        }
    }

    public void run() {
        if (this.main.getSeasonManager().getSeason(this.w) == Season.RESTORE && this.w.getEnvironment() != World.Environment.NETHER && this.w.getEnvironment() != World.Environment.THE_END) {
            if (!this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).isEmpty()) {
                if (this.main.getNMSUtils().getTPS() < this.main.getSettings().minTPS && this.main.getSettings().prioritiseTPS) {
                    return;
                }
                for (int i = 0; i < this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).size(); ++i) {
                    SeasonChunk seasonChunk = this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).get(this.r.nextInt(this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).size()));
                    if (seasonChunk.getWorld() != this.w || System.currentTimeMillis() - seasonChunk.getLoadTime() < 10000L) continue;
                    if (this.main.getSeasonManager().getCheckedList(this.w, Season.RESTORE).contains(seasonChunk) || !this.w.isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ())) {
                        this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).remove(seasonChunk);
                        continue;
                    }
                    if (!this.w.isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ())) {
                        this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).remove(seasonChunk);
                        continue;
                    }
                    if (seasonChunk.getX() > 1875000 || seasonChunk.getX() > 1875000 || seasonChunk.getX() < -1875000 || seasonChunk.getX() < -1875000) {
                        this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).remove(seasonChunk);
                        continue;
                    }
                    Chunk chunk = seasonChunk.getChunk();
                    if (!this.main.getChunkUtils().affectFlora(chunk)) {
                        if (this.main.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld()) && this.main.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                            this.main.getChunkUtils().unfreezeChunk(chunk);
                            this.main.getAsyncChunkHandler().remove(seasonChunk);
                        }
                        this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).remove(seasonChunk);
                        this.main.getSeasonManager().getCheckedList(this.w, Season.RESTORE).add(seasonChunk);
                    } else {
                        if (!this.main.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                            this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).remove(seasonChunk);
                            this.main.getSeasonManager().getCheckedList(this.w, Season.RESTORE).add(seasonChunk);
                            continue;
                        }
                        if (this.main.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                            this.hasChangedBlocks = this.main.getChunkUtils().unfreezeChunk(chunk);
                            this.main.getAsyncChunkHandler().remove(seasonChunk);
                            if (this.main.getSettings().regrowGrass) {
                                this.hasChangedBlocks = true;
                            }
                            this.main.getChunkUtils().checkPopulation(chunk, 4.0f, 0.1f, 1, 1, Season.RESTORE, this.hasChangedBlocks);
                        }
                        this.main.getSeasonManager().getQueue(this.w, Season.RESTORE).remove(seasonChunk);
                        this.main.getSeasonManager().getCheckedList(this.w, Season.RESTORE).add(seasonChunk);
                    }
                    break;
                }
            }
        } else {
            this.main.getSeasonManager().clearChunkCheckedList(this.w, Season.RESTORE);
            this.main.getSeasonManager().clearChunkQueue(this.w, Season.RESTORE);
            this.cancel();
        }
    }
}

