/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.runnables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.Version;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SeasonChunk;
import me.casperge.realisticseasons.utils.ChunkUtils;
import me.casperge.realisticseasons.utils.JavaUtils;
import me.casperge.realisticseasons.utils.SnowPatterns;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Snow;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class WinterBlockTicker
extends BukkitRunnable {
    private List<Material> destroyForSnow = new ArrayList<Material>();
    private List<SeasonChunk> checkedAtleastOnce = new ArrayList<SeasonChunk>();
    private RealisticSeasons main;
    private World w;
    private Random r = new Random();
    int currentIndexSnow = 0;
    private int iceID;
    private int snowID;
    private int snowLayers = 1;
    private int runDelay;
    private int travelCheck;
    private int travelCounter;
    private HashMap<Player, Location> lastLocation = new HashMap();
    private HashMap<Player, Boolean> traveling = new HashMap();
    private final BlockFace[] sideFaces = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH};

    public World getWorld() {
        return this.w;
    }

    public WinterBlockTicker(RealisticSeasons realisticSeasons, World world) {
        this.runDelay = realisticSeasons.getSettings().delayPerTick * 2;
        this.travelCounter = 1;
        this.travelCheck = 100 / this.runDelay;
        if (this.travelCheck < 1) {
            this.travelCheck = 1;
        }
        this.main = realisticSeasons;
        this.w = world;
        this.destroyForSnow.add(Material.GRASS);
        this.destroyForSnow.add(Material.TALL_GRASS);
        this.destroyForSnow.add(Material.DANDELION);
        this.destroyForSnow.add(Material.POPPY);
        this.destroyForSnow.add(Material.BLUE_ORCHID);
        this.destroyForSnow.add(Material.ALLIUM);
        this.destroyForSnow.add(Material.AZURE_BLUET);
        this.destroyForSnow.add(Material.ORANGE_TULIP);
        this.destroyForSnow.add(Material.PINK_TULIP);
        this.destroyForSnow.add(Material.RED_TULIP);
        this.destroyForSnow.add(Material.WHITE_TULIP);
        this.destroyForSnow.add(Material.OXEYE_DAISY);
        this.destroyForSnow.add(Material.CORNFLOWER);
        this.destroyForSnow.add(Material.LILY_OF_THE_VALLEY);
        this.destroyForSnow.add(Material.SWEET_BERRY_BUSH);
        this.destroyForSnow.add(Material.RED_MUSHROOM);
        this.destroyForSnow.add(Material.BROWN_MUSHROOM);
        SnowPatterns.generate();
        this.snowID = Version.getSnowID();
        this.iceID = Version.getIceID();
        this.snowLayers = realisticSeasons.getSettings().snowLayers;
    }

    public void run() {
        if (this.main.getSeasonManager().getSeason(this.w) == Season.WINTER && this.w.getEnvironment() != World.Environment.NETHER && this.w.getEnvironment() != World.Environment.THE_END) {
            if (Version.is_1_19_3_or_up()) {
                this.snowLayers = Integer.valueOf(this.w.getGameRuleValue("snowAccumulationHeight"));
            }
            if (!this.main.getSettings().modifyBlocks && this.main.getSettings().winterAnimals.size() == 0) {
                return;
            }
            if (this.main.getNMSUtils().getTPS() < this.main.getSettings().minTPS && this.main.getSettings().prioritiseTPS) {
                return;
            }
            if (this.w.getPlayers().size() > 0) {
                this.handleTravelTick();
                if (this.w.getPlayers().size() < 4 && this.r.nextInt(5 - this.w.getPlayers().size()) != 0) {
                    return;
                }
                boolean bl = false;
                Player player = (Player)this.w.getPlayers().get(this.r.nextInt(this.w.getPlayers().size()));
                for (int i = 0; i < this.w.getPlayers().size(); ++i) {
                    Player player2 = (Player)this.w.getPlayers().get(this.r.nextInt(this.w.getPlayers().size()));
                    if (this.isTraveling(player2) || player.getGameMode() == GameMode.SPECTATOR) continue;
                    player = player2;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return;
                }
                if (!player.getWorld().isChunkLoaded(player.getLocation().getBlockX() >> 4, player.getLocation().getBlockZ() >> 4)) {
                    return;
                }
                Collection<Chunk> collection = ChunkUtils.around(player.getLocation().getChunk(), 9);
                int n = this.main.getSeasonManager().getSubSeason(this.w).getPhase();
                for (Chunk chunk : collection) {
                    if (!this.main.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                        if (this.checkedAtleastOnce.contains(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L))) continue;
                        this.checkedAtleastOnce.add(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L));
                        continue;
                    }
                    Integer[] integerArray = SnowPatterns.getArray(chunk.getX(), chunk.getZ());
                    int n2 = (int)Math.floor(integerArray[this.currentIndexSnow] / 16);
                    int n3 = integerArray[this.currentIndexSnow] % 16;
                    Block block = player.getWorld().getHighestBlockAt(chunk.getX() * 16 + n2, chunk.getZ() * 16 + n3);
                    Chunk chunk2 = block.getChunk();
                    if (!this.main.getBlockUtils().affectBlockInWinter(block) || block.getLightFromBlocks() >= 11) continue;
                    if (block.getType() == Material.WATER) {
                        if (((Levelled)block.getBlockData()).getLevel() != 0 || !this.main.hasBlockChanges(chunk2.getX(), chunk2.getZ(), chunk2.getWorld()) || !this.main.getSettings().spawnIceInWinter) continue;
                        if (n < 2) {
                            int n4 = 2;
                            if (n == 0) {
                                n4 = 4;
                            }
                            if (JavaUtils.getRandom().nextInt(n4) != 0) continue;
                            boolean bl2 = false;
                            for (int i = 0; i < this.sideFaces.length; ++i) {
                                Material material = block.getRelative(this.sideFaces[i]).getType();
                                if (material == Material.WATER || material == Material.SEAGRASS || material == Material.TALL_SEAGRASS || material == Material.KELP_PLANT) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2) continue;
                            this.main.getNMSUtils().setBlockInNMSChunk(block.getWorld(), block.getX(), block.getY(), block.getZ(), this.iceID, (byte)0, false);
                            this.main.getAsyncChunkHandler().logChunk(new SeasonChunk(chunk2.getWorld().getName(), chunk2.getX(), chunk2.getZ(), 0L));
                            continue;
                        }
                        this.main.getNMSUtils().setBlockInNMSChunk(block.getWorld(), block.getX(), block.getY(), block.getZ(), this.iceID, (byte)0, false);
                        this.main.getAsyncChunkHandler().logChunk(new SeasonChunk(chunk2.getWorld().getName(), chunk2.getX(), chunk2.getZ(), 0L));
                        continue;
                    }
                    if (this.main.getBlockUtils().isSnowable(block) && this.w.hasStorm() && !this.main.getSeasonManager().refreshers.containsKey(this.w)) {
                        boolean bl3 = false;
                        if (!this.checkedAtleastOnce.contains(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L))) {
                            this.main.getAnimalUtils().updateAnimalSpawns(Season.WINTER, chunk);
                            this.checkedAtleastOnce.add(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L));
                            bl3 = true;
                        }
                        if (!this.main.hasBlockChanges(chunk2.getX(), chunk2.getZ(), chunk2.getWorld()) || !this.main.getSettings().snowPlacement || n == 0) continue;
                        this.main.getNMSUtils().setBlockInNMSChunk(block.getWorld(), block.getX(), block.getY() + 1, block.getZ(), this.snowID, (byte)0, false);
                        if (!bl3) continue;
                        this.main.getAsyncChunkHandler().logChunk(new SeasonChunk(chunk2.getWorld().getName(), chunk2.getX(), chunk2.getZ(), 0L));
                        continue;
                    }
                    if (this.destroyForSnow.contains(block.getRelative(0, 1, 0).getType()) && this.w.hasStorm() && !this.main.getSeasonManager().refreshers.containsKey(this.w)) {
                        boolean bl4 = false;
                        if (!this.checkedAtleastOnce.contains(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L))) {
                            this.main.getAnimalUtils().updateAnimalSpawns(Season.WINTER, chunk);
                            this.checkedAtleastOnce.add(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L));
                            bl4 = true;
                        }
                        if (!this.main.hasBlockChanges(chunk2.getX(), chunk2.getZ(), chunk2.getWorld()) || n == 0 || !this.main.getBlockUtils().affectFlora(block) || !this.main.getSettings().snowPlacement || this.main.getBlockStorage().isManualPlacedFlower(block.getRelative(0, 1, 0).getLocation())) continue;
                        this.main.getNMSUtils().setBlockInNMSChunk(block.getWorld(), block.getX(), block.getY() + 1, block.getZ(), this.snowID, (byte)0, false);
                        this.main.getNMSUtils().setBlockInNMSChunk(block.getWorld(), block.getX(), block.getY() + 2, block.getZ(), 0, (byte)0, false);
                        if (!bl4) continue;
                        this.main.getAsyncChunkHandler().logChunk(new SeasonChunk(chunk2.getWorld().getName(), chunk2.getX(), chunk2.getZ(), 0L));
                        continue;
                    }
                    if (block.getRelative(0, 1, 0).getType() != Material.SNOW || !this.w.hasStorm() || this.main.getSeasonManager().refreshers.containsKey(this.w) || this.snowLayers <= 1) continue;
                    if (!this.checkedAtleastOnce.contains(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L))) {
                        this.main.getAnimalUtils().updateAnimalSpawns(Season.WINTER, chunk);
                        this.checkedAtleastOnce.add(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), 0L));
                    }
                    if (!this.main.hasBlockChanges(chunk2.getX(), chunk2.getZ(), chunk2.getWorld()) || n == 0 || !this.main.getBlockUtils().affectFlora(block) || !this.main.getSettings().snowPlacement) continue;
                    Snow snow = (Snow)block.getRelative(0, 1, 0).getBlockData();
                    if (snow.getLayers() < snow.getMaximumLayers() && snow.getLayers() < this.snowLayers) {
                        snow.setLayers(snow.getLayers() + 1);
                    }
                    block.getRelative(0, 1, 0).setBlockData((BlockData)snow);
                }
                this.currentIndexSnow = this.currentIndexSnow < 255 ? ++this.currentIndexSnow : 0;
            }
        } else {
            this.cancel();
        }
    }

    private void handleTravelTick() {
        if (this.travelCheck != 1) {
            if (this.travelCounter != this.travelCheck) {
                ++this.travelCounter;
                return;
            }
            this.travelCounter = 1;
        }
        for (Player player : this.w.getPlayers()) {
            boolean bl = false;
            if (this.lastLocation.containsKey(player)) {
                if (ChunkUtils.get2dDistance(player.getLocation().getBlock(), this.lastLocation.get(player).getBlock()) > 30.0) {
                    bl = true;
                }
                this.lastLocation.replace(player, player.getLocation());
            } else {
                this.lastLocation.put(player, player.getLocation());
            }
            if (bl) {
                if (this.traveling.containsKey(player)) {
                    if (this.traveling.get(player).booleanValue()) continue;
                    this.traveling.replace(player, true);
                    continue;
                }
                this.traveling.put(player, true);
                continue;
            }
            if (this.traveling.containsKey(player)) {
                if (!this.traveling.get(player).booleanValue()) continue;
                this.traveling.replace(player, false);
                continue;
            }
            this.traveling.put(player, false);
        }
        for (Player player : new ArrayList<Player>(this.lastLocation.keySet())) {
            if (player.getWorld() == this.w) continue;
            this.lastLocation.remove(player);
        }
        for (Player player : new ArrayList<Player>(this.traveling.keySet())) {
            if (player.getWorld() == this.w) continue;
            this.traveling.remove(player);
        }
    }

    public boolean isTraveling(Player player) {
        if (!this.traveling.containsKey(player)) {
            return false;
        }
        return this.traveling.get(player);
    }
}

