/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.season;

import me.casperge.realisticseasons.data.LanguageManager;
import me.casperge.realisticseasons.data.MessageType;

public enum Season {
    WINTER("WINTER", 0){

        public String toString() {
            return LanguageManager.messages.get((Object)MessageType.WINTER_DISPLAY);
        }
    }
    ,
    SPRING("SPRING", 2){

        public String toString() {
            return LanguageManager.messages.get((Object)MessageType.SPRING_DISPLAY);
        }
    }
    ,
    SUMMER("SUMMER", 1){

        public String toString() {
            return LanguageManager.messages.get((Object)MessageType.SUMMER_DISPLAY);
        }
    }
    ,
    FALL("FALL", 3){

        public String toString() {
            return LanguageManager.messages.get((Object)MessageType.FALL_DISPLAY);
        }
    }
    ,
    DISABLED("DISABLED", 4){}
    ,
    RESTORE("RESTORE", 5){};

    private final String configName;
    private final int intValue;

    private Season(String string2, int n2) {
        this.configName = string2;
        this.intValue = n2;
    }

    public String getConfigName() {
        return this.configName;
    }

    public int intValue() {
        return this.intValue;
    }

    public static Season getSeason(String string) {
        if (string.equalsIgnoreCase("WINTER")) {
            return WINTER;
        }
        if (string.equalsIgnoreCase("SPRING")) {
            return SPRING;
        }
        if (string.equalsIgnoreCase("FALL")) {
            return FALL;
        }
        if (string.equalsIgnoreCase("SUMMER")) {
            return SUMMER;
        }
        if (string.equalsIgnoreCase("RESTORE")) {
            return RESTORE;
        }
        return DISABLED;
    }

    public Season getNextSeason() {
        switch (this) {
            case DISABLED: {
                return null;
            }
            case FALL: {
                return WINTER;
            }
            case RESTORE: {
                return null;
            }
            case SPRING: {
                return SUMMER;
            }
            case SUMMER: {
                return FALL;
            }
            case WINTER: {
                return SPRING;
            }
        }
        return null;
    }

    public Season getPreviousSeason() {
        switch (this) {
            case DISABLED: {
                return null;
            }
            case FALL: {
                return SUMMER;
            }
            case RESTORE: {
                return null;
            }
            case SPRING: {
                return WINTER;
            }
            case SUMMER: {
                return SPRING;
            }
            case WINTER: {
                return FALL;
            }
        }
        return null;
    }
}

