/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.season;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.api.SeasonChangeEvent;
import me.casperge.realisticseasons.biome.BiomeUtils;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.data.LanguageManager;
import me.casperge.realisticseasons.data.MessageType;
import me.casperge.realisticseasons.runnables.AnimalRemover;
import me.casperge.realisticseasons.runnables.ChunkRefresher;
import me.casperge.realisticseasons.runnables.FallBlockTicker;
import me.casperge.realisticseasons.runnables.RestoreWorldTicker;
import me.casperge.realisticseasons.runnables.SpringBlockTicker;
import me.casperge.realisticseasons.runnables.SummerBlockTicker;
import me.casperge.realisticseasons.runnables.TimeHandler;
import me.casperge.realisticseasons.runnables.WinterBlockTicker;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SeasonChunk;
import me.casperge.realisticseasons.season.SubSeason;
import me.casperge.realisticseasons.utils.ChunkUtils;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class SeasonManager {
    public RealisticSeasons main;
    public HashMap<World, Season> worldData = new HashMap();
    public HashMap<World, SubSeason> worldDataSubSeasons = new HashMap();
    public HashMap<World, ChunkRefresher> refreshers = new HashMap();
    private HashMap<World, List<SeasonChunk>> fallqueue = new HashMap();
    private HashMap<World, List<SeasonChunk>> fallchecked = new HashMap();
    private HashMap<World, List<SeasonChunk>> springqueue = new HashMap();
    private HashMap<World, List<SeasonChunk>> springchecked = new HashMap();
    private TimeHandler thandler;
    private AnimalRemover remover;
    private HashMap<World, List<SeasonChunk>> summerqueue = new HashMap();
    private HashMap<World, List<SeasonChunk>> summerchecked = new HashMap();
    private HashMap<World, List<SeasonChunk>> restorequeue = new HashMap();
    private HashMap<World, List<SeasonChunk>> restorechecked = new HashMap();
    private final Season[] queueseasons = new Season[]{Season.RESTORE, Season.SUMMER, Season.WINTER, Season.FALL, Season.SPRING};

    public SeasonManager(final RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)realisticSeasons, new Runnable(){

            @Override
            public void run() {
                if (JavaUtils.getRandom().nextInt(10) == 1) {
                    for (World world : SeasonManager.this.worldData.keySet()) {
                        if (SeasonManager.this.getCheckedList(world, SeasonManager.this.getSeason(world)) == null) continue;
                        if (SeasonManager.this.getCheckedList(world, SeasonManager.this.getSeason(world)).size() > 70000) {
                            SeasonManager.this.clearChunkCheckedList(world, SeasonManager.this.getSeason(world));
                        }
                        if (SeasonManager.this.getQueue(world, SeasonManager.this.getSeason(world)).size() <= 70000) continue;
                        SeasonManager.this.clearChunkQueue(world, SeasonManager.this.getSeason(world));
                    }
                }
                if (!realisticSeasons.getSettings().calendarEnabled) {
                    return;
                }
                SeasonManager.this.runSubSeasonCheck();
            }
        }, 400L, 400L);
    }

    public void runSubSeasonCheck() {
        for (World world : this.worldData.keySet()) {
            SubSeason subSeason;
            SubSeason subSeason2;
            if (this.getSeason(world) == Season.DISABLED || this.getSeason(world) == Season.RESTORE || !this.main.getSettings().subSeasonsEnabled || (subSeason2 = this.getSubSeason(world)) == (subSeason = this.main.getTimeManager().getCorrectSubSeason(world))) continue;
            this.setSubSeason(world, subSeason, true);
            this.clearChunkCheckedList(world, this.getSeason(world));
            this.clearChunkQueue(world, this.getSeason(world));
            for (Chunk chunk : world.getLoadedChunks()) {
                if (this.getQueue(world, this.getSeason(world)) == null) continue;
                this.getQueue(world, this.getSeason(world)).add(new SeasonChunk(world.getName(), chunk.getX(), chunk.getZ(), System.currentTimeMillis()));
            }
        }
    }

    public List<SeasonChunk> getQueue(World world, Season season) {
        switch (season) {
            case FALL: {
                if (!this.fallqueue.containsKey(world)) {
                    this.fallqueue.put(world, new ArrayList());
                }
                return this.fallqueue.get(world);
            }
            case SUMMER: {
                if (!this.summerqueue.containsKey(world)) {
                    this.summerqueue.put(world, new ArrayList());
                }
                return this.summerqueue.get(world);
            }
            case SPRING: {
                if (!this.springqueue.containsKey(world)) {
                    this.springqueue.put(world, new ArrayList());
                }
                return this.springqueue.get(world);
            }
            case RESTORE: {
                if (!this.restorequeue.containsKey(world)) {
                    this.restorequeue.put(world, new ArrayList());
                }
                return this.restorequeue.get(world);
            }
        }
        return null;
    }

    public List<SeasonChunk> getCheckedList(World world, Season season) {
        switch (season) {
            case FALL: {
                if (!this.fallchecked.containsKey(world)) {
                    this.fallchecked.put(world, new ArrayList());
                }
                return this.fallchecked.get(world);
            }
            case SUMMER: {
                if (!this.summerchecked.containsKey(world)) {
                    this.summerchecked.put(world, new ArrayList());
                }
                return this.summerchecked.get(world);
            }
            case SPRING: {
                if (!this.springchecked.containsKey(world)) {
                    this.springchecked.put(world, new ArrayList());
                }
                return this.springchecked.get(world);
            }
            case RESTORE: {
                if (!this.restorechecked.containsKey(world)) {
                    this.restorechecked.put(world, new ArrayList());
                }
                return this.restorechecked.get(world);
            }
        }
        return null;
    }

    public void clearChunkCheckedList(World world, Season season) {
        switch (season) {
            case FALL: {
                if (!this.fallchecked.containsKey(world)) {
                    return;
                }
                this.fallchecked.get(world).clear();
                return;
            }
            case SUMMER: {
                if (!this.summerchecked.containsKey(world)) {
                    return;
                }
                this.summerchecked.get(world).clear();
                return;
            }
            case SPRING: {
                if (!this.springchecked.containsKey(world)) {
                    return;
                }
                this.springchecked.get(world).clear();
                return;
            }
            case RESTORE: {
                if (!this.restorechecked.containsKey(world)) {
                    return;
                }
                this.restorechecked.get(world).clear();
                return;
            }
        }
    }

    public void clearChunkQueue(World world, Season season) {
        switch (season) {
            case FALL: {
                if (!this.fallqueue.containsKey(world)) {
                    return;
                }
                this.fallqueue.get(world).clear();
                return;
            }
            case SUMMER: {
                if (!this.summerqueue.containsKey(world)) {
                    return;
                }
                this.summerqueue.get(world).clear();
                return;
            }
            case SPRING: {
                if (!this.summerqueue.containsKey(world)) {
                    return;
                }
                this.summerqueue.get(world).clear();
                return;
            }
            case RESTORE: {
                if (!this.summerqueue.containsKey(world)) {
                    return;
                }
                this.summerqueue.get(world).clear();
                return;
            }
        }
    }

    public Season getNextSeason(World world) {
        Season season = this.getSeason(world);
        if (season == Season.SPRING) {
            return Season.SUMMER;
        }
        if (season == Season.SUMMER) {
            return Season.FALL;
        }
        if (season == Season.FALL) {
            return Season.WINTER;
        }
        if (season == Season.WINTER) {
            return Season.SPRING;
        }
        return null;
    }

    public void sendSeasonInfo(Player player) {
        if (player.getWorld().getEnvironment() != World.Environment.NETHER && player.getWorld().getEnvironment() != World.Environment.THE_END) {
            Season season = this.main.getSeasonManager().getSeason(player.getWorld());
            if (season == Season.DISABLED) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_DISABLED)));
                if (player.hasPermission("realisticseasons.admin")) {
                    player.sendMessage(ChatColor.RED + "Set one by running /rs set <season>");
                }
            } else if (season == Season.RESTORE) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_RESTORE)));
                if (player.hasPermission("realisticseasons.admin")) {
                    player.sendMessage(ChatColor.RED + "Set one by running /rs set <season>");
                }
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_CURRENTSEASON).replaceAll("\\$current_season\\$", season.toString())));
                if (this.main.getSettings().calendarEnabled) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_CURRENTDATE).replaceAll("\\$current_weekday\\$", this.main.getTimeManager().getWeekDay(this.main.getTimeManager().getDate(player.getWorld()))).replaceAll("\\$current_month\\$", this.main.getTimeManager().getCalendar().getMonth(this.main.getTimeManager().getDate(player.getWorld()).getMonth()).getName()).replaceAll("\\$current_day\\$", String.valueOf(this.main.getTimeManager().getDate(player.getWorld()).getDay())).replaceAll("\\$current_year\\$", String.valueOf(this.main.getTimeManager().getDate(player.getWorld()).getYear()))));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_DAYSUNTILNEXT).replaceAll("\\$next_season\\$", this.main.getSeasonManager().getNextSeason(player.getWorld()).toString()).replaceAll("\\$days_until_next_season\\$", String.valueOf(this.main.getTimeManager().getDaysUntilNextSeason(player.getWorld())))));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_TIME).replaceAll("\\$time\\$", this.main.getTimeManager().getTimeAsString(player.getWorld()))));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_EVENTS).replaceAll("\\$events\\$", this.main.getEventManager().getActiveEventsAsString(player.getWorld()))));
                }
                if (this.main.getTemperatureManager().getTempData().isEnabled()) {
                    int n = this.main.getTemperatureManager().getAirTemperature(player.getLocation());
                    ChatColor chatColor = this.main.getTemperatureManager().getColorCode(n);
                    if (this.main.getTemperatureManager().getTempData().getTempSettings().isConvertToFahrenheit() && !this.main.getTemperatureManager().hasFahrenheitEnabled(player) || !this.main.getTemperatureManager().getTempData().getTempSettings().isConvertToFahrenheit() && this.main.getTemperatureManager().hasFahrenheitEnabled(player)) {
                        n = JavaUtils.convertToFahrenheit(n);
                        String string = "&" + chatColor.getChar() + String.valueOf(n) + this.main.getTemperatureManager().getTempData().getTempSettings().getFahrenheitMessage();
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_AIRTEMPERATURE).replaceAll("\ufffdC", "").replaceAll("\ufffdF", "").replaceAll("\\$air_temperature\\$", string)));
                    } else {
                        String string = "&" + chatColor.getChar() + String.valueOf(n) + this.main.getTemperatureManager().getTempData().getTempSettings().getCelciusMessage();
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_AIRTEMPERATURE).replaceAll("\ufffdC", "").replaceAll("\ufffdF", "").replaceAll("\\$air_temperature\\$", string)));
                    }
                }
            }
        } else {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_DISABLED)));
        }
    }

    public void sendSeasonInfoToConsole(World world) {
        if (world.getEnvironment() != World.Environment.NETHER && world.getEnvironment() != World.Environment.THE_END) {
            Season season = this.main.getSeasonManager().getSeason(world);
            if (season == Season.DISABLED) {
                Bukkit.getLogger().info(LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_DISABLED));
            } else if (season == Season.RESTORE) {
                Bukkit.getLogger().info(LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_RESTORE));
            } else {
                Bukkit.getLogger().info(LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_CURRENTSEASON).replaceAll("\\$current_season\\$", season.toString()));
                if (this.main.getSettings().calendarEnabled) {
                    Bukkit.getLogger().info(LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_CURRENTDATE).replaceAll("\\$current_weekday\\$", this.main.getTimeManager().getWeekDay(this.main.getTimeManager().getDate(world))).replaceAll("\\$current_month\\$", this.main.getTimeManager().getCalendar().getMonth(this.main.getTimeManager().getDate(world).getMonth()).getName()).replaceAll("\\$current_day\\$", String.valueOf(this.main.getTimeManager().getDate(world).getDay())).replaceAll("\\$current_year\\$", String.valueOf(this.main.getTimeManager().getDate(world).getYear())));
                    Bukkit.getLogger().info(LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_DAYSUNTILNEXT).replaceAll("\\$next_season\\$", this.main.getSeasonManager().getNextSeason(world).toString()).replaceAll("\\$days_until_next_season\\$", String.valueOf(this.main.getTimeManager().getDaysUntilNextSeason(world))));
                    Bukkit.getLogger().info(LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_TIME).replaceAll("\\$time\\$", this.main.getTimeManager().getTimeAsString(world)));
                    Bukkit.getLogger().info(LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_EVENTS).replaceAll("\\$events\\$", this.main.getEventManager().getActiveEventsAsString(world)));
                }
            }
        } else {
            Bukkit.getLogger().info(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.SEASONSCOMMAND_DISABLED)));
        }
    }

    public void checkChunk(SeasonChunk seasonChunk) {
        World world = seasonChunk.getWorld();
        if (world == null) {
            return;
        }
        Season season = this.getSeason(world);
        if (season == Season.FALL) {
            FallBlockTicker.checkChunk(seasonChunk);
        } else if (season == Season.SUMMER) {
            SummerBlockTicker.checkChunk(seasonChunk);
        } else if (season == Season.SPRING) {
            if (this.getSubSeason(world).getPhase() > 1) {
                SpringBlockTicker.checkChunk(seasonChunk);
            }
        } else if (season == Season.RESTORE) {
            RestoreWorldTicker.checkChunk(seasonChunk);
        }
    }

    public SubSeason getSubSeason(World world) {
        if (!this.main.getSettings().subSeasonsEnabled) {
            return SubSeason.MIDDLE;
        }
        if (this.worldDataSubSeasons.containsKey(world)) {
            return this.worldDataSubSeasons.get(world);
        }
        SubSeason subSeason = this.main.getSettings().calendarEnabled && this.main.getSettings().subSeasonsEnabled ? this.main.getTimeManager().getCorrectSubSeason(world) : SubSeason.MIDDLE;
        this.worldDataSubSeasons.put(world, subSeason);
        return subSeason;
    }

    public void setSubSeason(World world, SubSeason subSeason, boolean bl) {
        if (this.getSubSeason(world) != subSeason) {
            this.worldDataSubSeasons.put(world, subSeason);
            if (bl) {
                new ChunkRefresher(this.main, world);
            }
            this.main.updateDynmap(this.worldData.get(world), subSeason, world);
            Season season = this.getSeason(world);
            if (season != null && (season != Season.DISABLED || season != Season.RESTORE)) {
                this.clearChunkCheckedList(world, season);
            }
        }
    }

    public Season nextSeason(World world) {
        if (!this.worldData.containsKey(world)) {
            return null;
        }
        if (this.worldData.get(world) == null) {
            return null;
        }
        Season season = this.getSeason(world);
        if (season == Season.SPRING) {
            this.setSeason(world, Season.SUMMER);
        } else if (season == Season.SUMMER) {
            this.setSeason(world, Season.FALL);
        } else if (season == Season.FALL) {
            this.setSeason(world, Season.WINTER);
        } else if (season == Season.WINTER) {
            this.setSeason(world, Season.SPRING);
        }
        return this.getSeason(world);
    }

    public boolean setSeason(World world, Season season, boolean bl) {
        if (this.getSeason(world) != season) {
            Object object;
            SeasonChangeEvent seasonChangeEvent = new SeasonChangeEvent(world, season, this.getSeason(world));
            Bukkit.getPluginManager().callEvent((Event)seasonChangeEvent);
            if (seasonChangeEvent.isCancelled()) {
                return false;
            }
            Season season2 = this.getSeason(world);
            if (this.getSeason(world) == null || this.getSeason(world) == Season.DISABLED) {
                this.worldData.put(world, season);
            }
            if (season == Season.WINTER) {
                this.setWinter(world);
                if (((Boolean)world.getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE)).booleanValue() && this.main.getSettings().affectTime) {
                    world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                }
            } else if (season == Season.FALL) {
                this.setFall(world);
                if (((Boolean)world.getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE)).booleanValue() && this.main.getSettings().affectTime) {
                    world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                }
            } else if (season == Season.SPRING) {
                this.setSpring(world);
                if (((Boolean)world.getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE)).booleanValue() && this.main.getSettings().affectTime) {
                    world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                }
            } else if (season == Season.SUMMER) {
                this.setSummer(world);
                if (((Boolean)world.getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE)).booleanValue() && this.main.getSettings().affectTime) {
                    world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                }
            } else if (season == Season.RESTORE) {
                this.setRestoring(world);
                if (this.main.getSettings().affectTime) {
                    world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
                }
            } else if (season == Season.DISABLED && this.main.getSettings().affectTime) {
                world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
            }
            if (season != Season.DISABLED) {
                // empty if block
            }
            if (season != Season.DISABLED && season != Season.RESTORE) {
                this.sendCycleMessage(world, season);
            }
            this.refreshers.put(world, new ChunkRefresher(this.main, world));
            this.worldData.replace(world, season);
            if (bl && season != Season.DISABLED && season != Season.RESTORE) {
                object = this.main.getTimeManager().getDate(world);
                if (object != null) {
                    Date date = this.main.getTimeManager().getCalendar().getSeasonStart(season);
                    Date date2 = ((Date)object).isLaterInYear(date) ? new Date(date.getDay(), date.getMonth(), ((Date)object).getYear()) : new Date(date.getDay(), date.getMonth(), ((Date)object).getYear() + 1);
                    this.main.getTimeManager().setDate(world, date2);
                } else {
                    this.main.getTimeManager().setDate(world, this.main.getTimeManager().getCalendar().getSeasonStart(season));
                }
            }
            if (this.main.getTemperatureManager().getTempData().isEnabled() && (season == Season.FALL || season == Season.WINTER || season == Season.SPRING || season == Season.SUMMER)) {
                if (season2 == Season.DISABLED || season2 == null) {
                    this.main.getTemperatureManager().loadWorld(world);
                } else if (this.main.getTemperatureManager().getTempData().isEnabledWorld(world) && this.main.getTemperatureManager().getTempData().isEnabled()) {
                    this.main.getTemperatureManager().getTempData().setBaseTemperature(world, this.main.getTemperatureManager().getTempUtils().generateNewBaseTemperature(world));
                }
            }
            if (season != Season.DISABLED && season != Season.RESTORE) {
                object = this.main.getTimeManager().getCorrectSubSeason(world);
                this.setSubSeason(world, (SubSeason)((Object)object), false);
                this.main.updateDynmap(season, (SubSeason)((Object)object), world);
            }
            this.main.getDataReader().save();
            this.runSubSeasonCheck();
            return true;
        }
        return false;
    }

    public boolean setSeason(World world, Season season) {
        return this.setSeason(world, season, true);
    }

    public Season getSeason(World world) {
        if (this.worldData.get(world) != null) {
            return this.worldData.get(world);
        }
        return Season.DISABLED;
    }

    public void checkWorlds() {
        if (this.main.getSettings().defaultSeason != Season.DISABLED) {
            for (World world : Bukkit.getWorlds()) {
                if (world.getEnvironment() == World.Environment.THE_END || world.getEnvironment() == World.Environment.NETHER || this.worldData.containsKey(world)) continue;
                this.setSeason(world, this.main.getSettings().defaultSeason);
            }
        }
    }

    public void setSpring(World world) {
        SpringBlockTicker springBlockTicker = new SpringBlockTicker(this.main, world);
        springBlockTicker.runTaskTimer((Plugin)this.main, 10L, this.main.getSettings().delayPerTick * 2);
    }

    public void setFall(World world) {
        FallBlockTicker fallBlockTicker = new FallBlockTicker(this.main, world);
        fallBlockTicker.runTaskTimer((Plugin)this.main, 10L, this.main.getSettings().delayPerTick * 2);
    }

    public void setSummer(World world) {
        SummerBlockTicker summerBlockTicker = new SummerBlockTicker(this.main, world);
        summerBlockTicker.runTaskTimer((Plugin)this.main, 10L, this.main.getSettings().delayPerTick * 2);
    }

    public void setWinter(World world) {
        WinterBlockTicker winterBlockTicker = new WinterBlockTicker(this.main, world);
        winterBlockTicker.runTaskTimer((Plugin)this.main, 10L, this.main.getSettings().delayPerTick * 2);
        this.main.updateDynmap(Season.WINTER, SubSeason.MIDDLE, world);
    }

    public void setRestoring(World world) {
        RestoreWorldTicker restoreWorldTicker = new RestoreWorldTicker(this.main, world);
        restoreWorldTicker.runTaskTimer((Plugin)this.main, 10L, this.main.getSettings().delayPerTick);
    }

    public void setup() {
        BiomeUtils.treeFallpackets = ChunkUtils.generateChunkPackets();
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() == World.Environment.NETHER || world.getEnvironment() == World.Environment.THE_END) continue;
            if (this.getSeason(world) == Season.WINTER) {
                this.setWinter(world);
                continue;
            }
            if (this.getSeason(world) == Season.SPRING) {
                this.setSpring(world);
                continue;
            }
            if (this.getSeason(world) == Season.SUMMER) {
                this.setSummer(world);
                continue;
            }
            if (this.getSeason(world) == Season.FALL) {
                this.setFall(world);
                continue;
            }
            if (this.getSeason(world) == Season.RESTORE) {
                this.setRestoring(world);
                continue;
            }
            this.setSeason(world, Season.DISABLED);
        }
        this.checkWorlds();
        if (this.main.getSettings().removeAnimalsOnSeasonChange) {
            this.remover = new AnimalRemover(this.main);
            this.remover.runTaskTimer((Plugin)this.main, 0L, 20L);
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.main, new Runnable(){

                @Override
                public void run() {
                    SeasonManager.this.remover.cancel();
                    SeasonManager.this.remover = new AnimalRemover(SeasonManager.this.main);
                    SeasonManager.this.remover.runTaskTimer((Plugin)SeasonManager.this.main, 0L, 20L);
                }
            }, 72000L, 72000L);
        }
        this.thandler = new TimeHandler(this.main);
        this.thandler.runTaskTimer((Plugin)this.main, 0L, 1L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.main, new Runnable(){

            @Override
            public void run() {
                SeasonManager.this.thandler.cancel();
                SeasonManager.this.thandler = new TimeHandler(SeasonManager.this.main);
                SeasonManager.this.thandler.runTaskTimer((Plugin)SeasonManager.this.main, 0L, 1L);
            }
        }, 72000L, 72000L);
    }

    public void sendCycleMessage(World world, Season season) {
        if (this.main.getSettings().sendMessageOnSeasonCycle) {
            String string = "";
            if (season == Season.FALL) {
                string = LanguageManager.messages.get((Object)MessageType.SEASON_TO_FALL);
            } else if (season == Season.WINTER) {
                string = LanguageManager.messages.get((Object)MessageType.SEASON_TO_WINTER);
            } else if (season == Season.SUMMER) {
                string = LanguageManager.messages.get((Object)MessageType.SEASON_TO_SUMMER);
            } else if (season == Season.SPRING) {
                string = LanguageManager.messages.get((Object)MessageType.SEASON_TO_SPRING);
            } else {
                return;
            }
            if (string == "") {
                return;
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getWorld() != world) continue;
                if (string.contains("ngtjrd")) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split("ngtjrd")) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string2));
                    }
                    continue;
                }
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
            }
        }
    }
}

