/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.seasonevent;

import java.util.ArrayList;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.seasonevent.SeasonCustomEvent;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class CustomDatedEvent
implements SeasonCustomEvent {
    private String name;
    private boolean doDisplay;
    private int startDay;
    private int startMonth;
    private int startYear;
    private int endDay;
    private int endMonth;
    private int endYear;
    private Date startDate;
    private Date endDate;
    private List<String> startCommands = new ArrayList<String>();
    private List<String> stopCommands = new ArrayList<String>();

    public CustomDatedEvent(ConfigurationSection configurationSection) {
        if (configurationSection.getBoolean("enabled")) {
            this.startCommands = configurationSection.getStringList("commands.start");
            this.stopCommands = configurationSection.getStringList("commands.stop");
        }
        this.name = configurationSection.getString("name");
        this.doDisplay = configurationSection.getBoolean("display-event");
        String string = configurationSection.getString("times.event-start.date");
        if (!string.contains("/")) {
            this.startDay = Integer.valueOf(string);
            this.startMonth = -1;
            this.startYear = -1;
        } else {
            boolean bl = RealisticSeasons.getInstance().getSettings().americandateformat;
            String[] stringArray = string.split("/");
            this.startDay = Integer.valueOf(stringArray[bl ? 1 : 0]);
            this.startMonth = Integer.valueOf(stringArray[bl ? 0 : 1]);
            if (stringArray.length == 2) {
                this.startYear = -1;
                this.startDate = new Date(this.startDay, this.startMonth);
            } else if (stringArray.length == 3) {
                this.startYear = Integer.valueOf(stringArray[2]);
                this.startDate = new Date(this.startDay, this.startMonth, this.startYear);
            } else {
                Bukkit.getLogger().severe("Invalid date input in custom-events.yml: " + string);
            }
        }
        String string2 = configurationSection.getString("times.event-stop.date");
        if (!string2.contains("/")) {
            this.endDay = Integer.valueOf(string2);
            this.endMonth = -1;
            this.endYear = -1;
        } else {
            boolean bl = RealisticSeasons.getInstance().getSettings().americandateformat;
            String[] stringArray = string2.split("/");
            this.endDay = Integer.valueOf(stringArray[bl ? 1 : 0]);
            this.endMonth = Integer.valueOf(stringArray[bl ? 0 : 1]);
            if (stringArray.length == 2) {
                this.endDate = new Date(this.endDay, this.endMonth);
                this.endYear = -1;
            } else if (stringArray.length == 3) {
                this.endYear = Integer.valueOf(stringArray[2]);
                this.endDate = new Date(this.endDay, this.endMonth, this.endYear);
            } else {
                Bukkit.getLogger().severe("Invalid date input in custom-events.yml: " + string2);
            }
        }
    }

    @Override
    public List<String> getCommands(boolean bl) {
        if (bl) {
            return this.startCommands;
        }
        return this.stopCommands;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean doDisplay() {
        return this.doDisplay;
    }

    public boolean isActive(Date date) {
        if (this.startMonth == -1 && this.startYear == -1) {
            return date.getDay() >= this.startDay && date.getDay() <= this.endDay;
        }
        if (this.startYear == -1) {
            return RealisticSeasons.getInstance().getTimeManager().getCalendar().getDaysUntil(this.startDate, this.endDate) >= RealisticSeasons.getInstance().getTimeManager().getCalendar().getDaysUntil(date, this.endDate);
        }
        if (this.startYear == this.endYear && date.getYear() == this.startYear || date.getYear() >= this.startYear && date.getYear() <= this.endYear) {
            if ((this.startYear != this.endYear || date.getYear() != this.startYear) && (date.getYear() == this.startYear ? !date.isLaterInYear(this.startDate) : date.getYear() == this.endYear && date.isLaterInYear(this.endDate))) {
                return false;
            }
            if (RealisticSeasons.getInstance().getTimeManager().getCalendar().getDaysUntil(this.startDate, this.endDate) >= RealisticSeasons.getInstance().getTimeManager().getCalendar().getDaysUntil(date, this.endDate)) {
                return true;
            }
        }
        return false;
    }
}

