/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.temperature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.casperge.realisticseasons.blockscanner.BlockEffect;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.temperature.CustomTemperatureItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.potion.PotionEffectType;

public class TemperatureSettings {
    private YamlConfiguration tempfile;
    private final Season[] seasons = new Season[]{Season.SPRING, Season.SUMMER, Season.FALL, Season.WINTER};
    private int temperatureUpdateInterval;
    private HashMap<Season, Integer> minTemperature = new HashMap();
    private HashMap<Season, Integer> maxTemperature = new HashMap();
    private HashMap<Armor, Integer> armorModifier = new HashMap();
    private HashMap<Weather, Integer> weatherModifier = new HashMap();
    private List<CustomTemperatureItem> customItems = new ArrayList<CustomTemperatureItem>();
    private HashMap<Season, Integer> swimmingModifier = new HashMap();
    private int waterBottleModifier;
    private int fullHungerModifier;
    private int maxSprintingModifier;
    private boolean heightModifying;
    private int leatherCap;
    private boolean blockEffectsEnabled;
    public HashMap<Material, BlockEffect> blockEffects = new HashMap();
    private int coldSlownessTemp;
    private int coldHungerTemp;
    private int coldFreezingTemp;
    private int warmNoHealingTemp;
    private int warmSlownessTemp;
    private int warmFireTemp;
    private int boostMinTemp;
    private int boostMaxTemp;
    private int waterBottleEffectDuration;
    private List<PotionEffectType> boostEffects = new ArrayList<PotionEffectType>();
    private boolean displayTempOnActionBar;
    private String actionbarDisplay;
    private boolean messageWarningsEnabled;
    private String messageOverheatingWarning;
    private String messageFreezingWarning;
    private String actionbarOverheatingWarning;
    private String actionbarFreezingWarning;
    private boolean actionbarWarningEnabled;
    private boolean convertToFahrenheit;
    private int netherTemperature;
    private int endTemperature;
    private String fahrenheit;
    private String celcius;
    private int lavaTemp;
    private boolean ipBasedTemperature;

    public TemperatureSettings(YamlConfiguration yamlConfiguration) {
        this.tempfile = yamlConfiguration;
        this.load();
    }

    public void load() {
        for (Object object : this.seasons) {
            this.minTemperature.put((Season)((Object)object), this.tempfile.getInt("modifiers.season-base-temperature." + object.getConfigName().toLowerCase() + ".min-temp"));
            this.maxTemperature.put((Season)((Object)object), this.tempfile.getInt("modifiers.season-base-temperature." + object.getConfigName().toLowerCase() + ".max-temp"));
            this.swimmingModifier.put((Season)((Object)object), this.tempfile.getInt("modifiers.touching-water." + object.getConfigName().toLowerCase()));
        }
        this.lavaTemp = this.tempfile.getInt("modifiers.lava-temperature");
        this.armorModifier.put(Armor.LEATHER, this.tempfile.getInt("modifiers.armor.leather"));
        this.armorModifier.put(Armor.IRON, this.tempfile.getInt("modifiers.armor.iron"));
        this.armorModifier.put(Armor.GOLD, this.tempfile.getInt("modifiers.armor.gold"));
        this.armorModifier.put(Armor.DIAMOND, this.tempfile.getInt("modifiers.armor.diamond"));
        this.armorModifier.put(Armor.NETHERITE, this.tempfile.getInt("modifiers.armor.netherite"));
        this.leatherCap = this.tempfile.getInt("modifiers.armor.leather-temperature-cap");
        this.weatherModifier.put(Weather.RAIN, this.tempfile.getInt("modifiers.weather.rain"));
        this.weatherModifier.put(Weather.STORM, this.tempfile.getInt("modifiers.weather.storm"));
        this.waterBottleModifier = this.tempfile.getInt("modifiers.foods-and-drinks.water-bottle");
        this.fullHungerModifier = this.tempfile.getInt("modifiers.foods-and-drinks.full-hunger-bar");
        this.heightModifying = this.tempfile.getBoolean("modifiers.height.enabled");
        this.waterBottleEffectDuration = this.tempfile.getInt("modifiers.foods-and-drinks.water-bottle-effect-duration");
        this.blockEffectsEnabled = this.tempfile.getBoolean("modifiers.block-effects.enabled");
        this.blockEffects.clear();
        for (String string : this.tempfile.getStringList("modifiers.block-effects.blocks")) {
            Object object;
            Material material = Material.valueOf((String)string.split("\\{")[0]);
            if (material == null) {
                Bukkit.getLogger().severe("[RealisticSeasons] Could not load block effect: Material " + string.split("\\{")[0] + " could not be found");
                continue;
            }
            object = this.blockEffectFromString(string.split("\\{")[1]);
            this.blockEffects.put(material, (BlockEffect)object);
        }
        this.coldSlownessTemp = this.tempfile.getInt("effects.cold.slowness");
        this.coldHungerTemp = this.tempfile.getInt("effects.cold.hunger");
        this.coldFreezingTemp = this.tempfile.getInt("effects.cold.freezing");
        this.temperatureUpdateInterval = this.tempfile.getInt("temperature-update-interval");
        this.warmNoHealingTemp = this.tempfile.getInt("effects.warm.no-healing");
        this.warmSlownessTemp = this.tempfile.getInt("effects.warm.slowness");
        this.warmFireTemp = this.tempfile.getInt("effects.warm.fire");
        this.netherTemperature = this.tempfile.getInt("modifiers.other-dimensions.nether");
        this.endTemperature = this.tempfile.getInt("modifiers.other-dimensions.end");
        this.maxSprintingModifier = this.tempfile.getInt("modifiers.max-sprinting-modifier");
        this.celcius = this.tempfile.getString("display.temperature.celcius");
        this.fahrenheit = this.tempfile.getString("display.temperature.fahrenheit");
        this.boostMinTemp = this.tempfile.getInt("effects.boosts.min");
        this.boostMaxTemp = this.tempfile.getInt("effects.boosts.max");
        for (String string : this.tempfile.getStringList("effects.boosts.potioneffects")) {
            if (string.equalsIgnoreCase("NONE")) continue;
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)string);
            if (potionEffectType != null) {
                this.boostEffects.add(potionEffectType);
                continue;
            }
            Bukkit.getLogger().warning("Could not find potion effect: " + string + " located in the temperature.yml file");
        }
        for (String string : this.tempfile.getConfigurationSection("custom.items").getKeys(false)) {
            if (!this.tempfile.getBoolean("custom.items." + string + ".enabled")) continue;
            this.customItems.add(this.fromConfigurationSection(this.tempfile.getConfigurationSection("custom.items." + string)));
        }
        this.displayTempOnActionBar = this.tempfile.getBoolean("display.temperature.actionbar");
        this.actionbarDisplay = this.tempfile.getString("display.temperature.actionbar-display").replaceAll("\ufffdC", "").replaceAll("\ufffdF", "");
        this.messageWarningsEnabled = this.tempfile.getBoolean("display.warnings.messages.enabled");
        this.messageOverheatingWarning = this.tempfile.getString("display.warnings.messages.overheating");
        this.messageFreezingWarning = this.tempfile.getString("display.warnings.messages.freezing");
        this.actionbarWarningEnabled = this.tempfile.getBoolean("display.warnings.actionbar.enabled");
        this.actionbarOverheatingWarning = this.tempfile.getString("display.warnings.actionbar.overheating");
        this.actionbarFreezingWarning = this.tempfile.getString("display.warnings.actionbar.freezing");
        this.convertToFahrenheit = this.tempfile.getBoolean("display.convert-to-fahrenheit");
        this.ipBasedTemperature = this.tempfile.getBoolean("display.ip-location-temp-type");
    }

    public int getMinTemperature(Season season) {
        if (this.minTemperature.get((Object)season) == null) {
            return this.minTemperature.get((Object)Season.SPRING);
        }
        return this.minTemperature.get((Object)season);
    }

    public int getMaxTemperature(Season season) {
        if (this.maxTemperature.get((Object)season) == null) {
            return this.maxTemperature.get((Object)Season.SPRING);
        }
        return this.maxTemperature.get((Object)season);
    }

    public int getArmorModifier(Armor armor) {
        return this.armorModifier.get((Object)armor);
    }

    public int getWeatherModifier(Weather weather) {
        return this.weatherModifier.get((Object)weather);
    }

    public List<CustomTemperatureItem> getCustomItems() {
        return this.customItems;
    }

    public int getTemperatureUpdateInterval() {
        return this.temperatureUpdateInterval;
    }

    public int getSwimmingModifier(Season season) {
        if (this.swimmingModifier.get((Object)season) == null) {
            return this.swimmingModifier.get((Object)Season.SPRING);
        }
        return this.swimmingModifier.get((Object)season);
    }

    public List<PotionEffectType> getBoostPotionEffects() {
        return this.boostEffects;
    }

    public String getActionbarFreezingWarning() {
        return this.actionbarFreezingWarning;
    }

    public String getActionbarOverheatingWarning() {
        return this.actionbarOverheatingWarning;
    }

    public String getFahrenheitMessage() {
        return this.fahrenheit;
    }

    public String getCelciusMessage() {
        return this.celcius;
    }

    public boolean isActionbarWarningEnabled() {
        return this.actionbarWarningEnabled;
    }

    public String getMessageFreezingWarning() {
        return this.messageFreezingWarning;
    }

    public String getMessageOverheatingWarning() {
        return this.messageOverheatingWarning;
    }

    public boolean isMessageWarningsEnabled() {
        return this.messageWarningsEnabled;
    }

    public String getActionbarDisplay() {
        return this.actionbarDisplay;
    }

    public boolean isDisplayTempOnActionBar() {
        return this.displayTempOnActionBar;
    }

    public int getBoostMaxTemp() {
        return this.boostMaxTemp;
    }

    public int getBoostMinTemp() {
        return this.boostMinTemp;
    }

    public int getWarmFireTemp() {
        return this.warmFireTemp;
    }

    public int getWarmSlownessTemp() {
        return this.warmSlownessTemp;
    }

    public int getWarmNoHealingTemp() {
        return this.warmNoHealingTemp;
    }

    public int getColdFreezingTemp() {
        return this.coldFreezingTemp;
    }

    public int getColdHungerTemp() {
        return this.coldHungerTemp;
    }

    public int getColdSlownessTemp() {
        return this.coldSlownessTemp;
    }

    public boolean isHeightModifying() {
        return this.heightModifying;
    }

    public int getWaterBottleModifier() {
        return this.waterBottleModifier;
    }

    public int getFullHungerModifier() {
        return this.fullHungerModifier;
    }

    public boolean blockEffectsEnabled() {
        return this.blockEffectsEnabled;
    }

    public boolean isConvertToFahrenheit() {
        return this.convertToFahrenheit;
    }

    public int getMaxSprintingModifier() {
        return this.maxSprintingModifier;
    }

    public int getNetherTemperature() {
        return this.netherTemperature;
    }

    public int getEndTemperature() {
        return this.endTemperature;
    }

    public boolean hasBlockEffect(Material material) {
        return this.blockEffects.containsKey(material);
    }

    public BlockEffect getBlockEffect(Material material) {
        return this.blockEffects.get(material);
    }

    private CustomTemperatureItem fromConfigurationSection(ConfigurationSection configurationSection) {
        Material material = Material.valueOf((String)configurationSection.getString("material").toUpperCase());
        if (material == null) {
            Bukkit.getLogger().severe("[RealisticSeasons] Material " + configurationSection.getString("material") + " could not be found during temperature item creation.");
            return null;
        }
        int n = configurationSection.getInt("custom-model-data");
        int n2 = configurationSection.getInt("temperature-modifier");
        boolean bl = configurationSection.getBoolean("activation.wearing");
        boolean bl2 = configurationSection.getBoolean("activation.holding");
        boolean bl3 = configurationSection.getBoolean("use-custom-model-data");
        return new CustomTemperatureItem(material, n, n2, bl, bl2, bl3);
    }

    public int getLeatherCap() {
        return this.leatherCap;
    }

    private BlockEffect blockEffectFromString(String string) {
        String[] stringArray;
        int n = 5;
        int n2 = 0;
        string = string.replaceAll("\\}", "");
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2[0].equalsIgnoreCase("range")) {
                n = Integer.valueOf(stringArray2[1]);
                continue;
            }
            if (!stringArray2[0].equalsIgnoreCase("modifier")) continue;
            n2 = Integer.valueOf(stringArray2[1]);
        }
        return new BlockEffect(n, n2);
    }

    public int getLavaTemp() {
        return this.lavaTemp;
    }

    public boolean isIpBasedTemperature() {
        return this.ipBasedTemperature;
    }

    public int getWaterBottleEffectDuration() {
        return this.waterBottleEffectDuration;
    }

    public static enum Armor {
        LEATHER,
        IRON,
        GOLD,
        DIAMOND,
        NETHERITE;

    }

    public static enum Weather {
        RAIN,
        STORM;

    }
}

