/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.utils;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Random;
import me.casperge.realisticseasons.RealisticSeasons;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;

public class JavaUtils {
    private static Random r;

    public static Random getRandom() {
        if (r == null) {
            r = new Random();
        }
        return r;
    }

    public static int gcd(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        return JavaUtils.gcd(n2, n % n2);
    }

    public static String getMonthOfStringDate(String string) {
        return string.substring(0, string.lastIndexOf(" "));
    }

    public static final double[] toCartesianAsVector(double d2) {
        if (d2 < 0.0 || d2 > 360.0) {
            throw new IndexOutOfBoundsException("angle ( " + d2 + " ) is out of bounds, should be between 0 and 360 degree");
        }
        double[] dArray = new double[]{Math.cos(Math.toRadians(d2)), Math.sin(Math.toRadians(d2))};
        return dArray;
    }

    public static String getDayOfStringDate(String string) {
        return string.substring(string.lastIndexOf(" ") + 1);
    }

    public static double randomDouble(double d2, double d3) {
        return Math.random() * (d3 - d2 + 1.0) + d2;
    }

    public static boolean isNumeric(String string) {
        if (string == null) {
            return false;
        }
        try {
            double d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static String mixColor(String string, String string2, double d2) {
        if (!string.contains("#")) {
            string = "#" + string;
        }
        if (!string2.contains("#")) {
            string2 = "#" + string2;
        }
        Color color = Color.decode(string);
        Color color2 = Color.decode(string2);
        Color color3 = JavaUtils.mixColor(color, color2, d2);
        return String.format("%02x%02x%02x", color3.getRed(), color3.getGreen(), color3.getBlue());
    }

    public static Color mixColor(Color color, Color color2, double d2) {
        float[] fArray = color.getComponents(null);
        float[] fArray2 = color2.getComponents(null);
        float[] fArray3 = new float[4];
        for (int i = 0; i < 4; ++i) {
            fArray3[i] = (float)(d2 * (double)fArray[i] + (1.0 - d2) * (double)fArray2[i]);
        }
        return new Color(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
    }

    public static void saveDefaultConfigValues(String string, String string2) {
        File file = new File(RealisticSeasons.getInstance().getDataFolder() + string);
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(RealisticSeasons.getInstance().getResource(string2), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (inputStreamReader != null) {
            YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)inputStreamReader);
            yamlConfiguration.setDefaults((Configuration)yamlConfiguration2);
            yamlConfiguration.options().copyDefaults(true);
            try {
                yamlConfiguration.save(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static int convertToFahrenheit(int n) {
        return n * 9 / 5 + 32;
    }

    public static String getGeoLocationCountryCode(String string) {
        String string2 = JavaUtils.getHttp("http://ip-api.com/line/" + string + "?fields=49471");
        if (string2 == null || !string2.startsWith("success")) {
            return "NL";
        }
        String[] stringArray = string2.split("\n");
        String string3 = stringArray[2];
        return string3;
    }

    private static String getHttp(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append(System.lineSeparator());
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int hexToDecimal(String string) {
        return Integer.parseInt(string, 16);
    }

    public static String decimalToHex(int n) {
        return String.format("%06X", 0xFFFFFF & n);
    }
}

