/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Objects;

public class RandomAccessFileInputStream
extends InputStream {
    private final boolean closeOnClose;
    private final RandomAccessFile randomAccessFile;

    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, false);
    }

    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile, boolean bl) {
        this.randomAccessFile = Objects.requireNonNull(randomAccessFile, "file");
        this.closeOnClose = bl;
    }

    @Override
    public int available() {
        long l = this.availableLong();
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public long availableLong() {
        return this.randomAccessFile.length() - this.randomAccessFile.getFilePointer();
    }

    @Override
    public void close() {
        super.close();
        if (this.closeOnClose) {
            this.randomAccessFile.close();
        }
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public boolean isCloseOnClose() {
        return this.closeOnClose;
    }

    @Override
    public int read() {
        return this.randomAccessFile.read();
    }

    @Override
    public int read(byte[] byArray) {
        return this.randomAccessFile.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        return this.randomAccessFile.read(byArray, n, n2);
    }

    private void seek(long l) {
        this.randomAccessFile.seek(l);
    }

    @Override
    public long skip(long l) {
        long l2;
        long l3;
        if (l <= 0L) {
            return 0L;
        }
        long l4 = this.randomAccessFile.getFilePointer();
        if (l4 >= (l3 = this.randomAccessFile.length())) {
            return 0L;
        }
        long l5 = l4 + l;
        long l6 = l2 = l5 > l3 ? l3 - 1L : l5;
        if (l2 > 0L) {
            this.seek(l2);
        }
        return this.randomAccessFile.getFilePointer() - l4;
    }
}

