/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.commands;

import com.xericker.mysteryboxes.Variables;
import com.xericker.mysteryboxes.commands.Command;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerIdentifier;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import utils.MessageUtils;

public class CommandUtils {
    private CommandUtils() {
    }

    public static void sendMessage(CommandSender commandSender, String string) {
        CommandUtils.sendMessage(commandSender, new String[]{string}, null);
    }

    public static void sendMessage(CommandSender commandSender, String[] stringArray) {
        CommandUtils.sendMessage(commandSender, stringArray, null);
    }

    public static void sendMessage(CommandSender commandSender, String string, Command command) {
        CommandUtils.sendMessage(commandSender, new String[]{string}, command);
    }

    public static void sendMessage(CommandSender commandSender, String[] textComponent, Command command) {
        String string = command != null ? command.getName() : null;
        StringBuilder stringBuilder = new StringBuilder();
        if (command != null && command.getArguments() != null) {
            for (Player player : command.getArguments()) {
                stringBuilder.append(" ").append((String)player);
            }
        }
        if (!(commandSender instanceof Player)) {
            for (String string2 : textComponent) {
                commandSender.sendMessage("\u00a77[\u00a7dMB\u00a77] \u00a7r\u00a7c" + string2);
            }
            if (string != null && stringBuilder.isEmpty()) {
                commandSender.sendMessage("\u00a77[\u00a7dMB\u00a77] \u00a7r\u00a7ePlease use the correct format:");
                commandSender.sendMessage("\u00a77[\u00a7dMB\u00a77] \u00a7r\u00a7b/mb " + string + String.valueOf(stringBuilder));
            }
            return;
        }
        Player player = (Player)commandSender;
        player.sendMessage(MessageUtils.getSeparator(Variables.SEPARATOR_COLOR));
        player.sendMessage("");
        for (String string3 : textComponent) {
            MessageUtils.sendCentered(player, "\u00a7c" + string3);
        }
        if (string != null && !stringBuilder.isEmpty()) {
            TextComponent textComponent2 = new TextComponent(MessageUtils.formatCenter("\u00a76\u00a7nClick\u00a7e to suggest the command"));
            textComponent2.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/mb " + string + " "));
            textComponent2.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a76\u00a7nClick\u00a7e to suggest \u00a7b/mb " + string).create()));
            player.sendMessage("");
            MessageUtils.sendCentered(player, "\u00a7ePlease use the correct format:");
            MessageUtils.sendCentered(player, "\u00a7b/mb " + string + String.valueOf(stringBuilder));
            player.sendMessage("");
            player.spigot().sendMessage((BaseComponent)textComponent2);
        }
        player.sendMessage("");
        player.sendMessage(MessageUtils.getSeparator(Variables.SEPARATOR_COLOR));
    }

    public static void sendDataFetchStart(CommandSender commandSender) {
        commandSender.sendMessage("\u00a77[\u00a7dMB\u00a77] \u00a7r\u00a7eGathering information about the player...");
    }

    public static void sendDataFetchFail(CommandSender commandSender) {
        commandSender.sendMessage("\u00a77[\u00a7dMB\u00a77] \u00a7r\u00a7cFailed to edit the player's data!");
        commandSender.sendMessage("\u00a77[\u00a7dMB\u00a77] \u00a7r\u00a7cThe syncing process took too long.");
    }

    public static PlayerData getPlayerData(CommandSender commandSender, String string) {
        Player player = Bukkit.getPlayer((String)string);
        if (player == null && PlayerIdentifier.getId(string) == null) {
            for (String string2 : ConfigParser.getStringList(LanguageValue.GENERAL_PLAYER_NOT_FOUND)) {
                commandSender.sendMessage(string2);
            }
            return null;
        }
        if (player != null) {
            string = player.getName();
        }
        UUID uUID = player != null ? player.getUniqueId() : PlayerIdentifier.getId(string);
        return PlayerDataManager.getData(uUID, 0);
    }

    public static boolean isPlayer(CommandSender commandSender, boolean bl) {
        if (commandSender instanceof Player) {
            return true;
        }
        if (!bl) {
            return true;
        }
        for (String string : ConfigParser.getStringList(LanguageValue.GENERAL_MUST_BE_PLAYER)) {
            commandSender.sendMessage(string);
        }
        return false;
    }
}

