/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.commands.executors;

import com.xericker.mysteryboxes.Variables;
import com.xericker.mysteryboxes.commands.Command;
import com.xericker.mysteryboxes.commands.CommandInterface;
import com.xericker.mysteryboxes.commands.CommandUtils;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import com.xericker.mysteryboxes.playerdata.player.PlayerIdentifier;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import utils.MessageUtils;

public class ExecuteStats
implements CommandInterface {
    @Override
    public boolean execute(CommandSender commandSender, Command command, String[] stringArray) {
        if (stringArray.length < 2) {
            CommandUtils.sendMessage(commandSender, "Oops! Some arguments are missing!", command);
            return false;
        }
        String string = stringArray[1];
        Player player = Bukkit.getPlayer((String)string);
        if (player == null && PlayerIdentifier.getId(string) == null) {
            for (String string2 : ConfigParser.getStringList(LanguageValue.GENERAL_PLAYER_NOT_FOUND)) {
                commandSender.sendMessage(string2);
            }
            return false;
        }
        UUID uUID = player != null ? player.getUniqueId() : PlayerIdentifier.getId(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(MessageUtils.getSeparator(Variables.SEPARATOR_COLOR));
        arrayList.add("");
        arrayList.add(MessageUtils.formatCenter("\u00a7f\u00a7l" + PlayerIdentifier.getName(uUID) + "'s Statistics"));
        arrayList.add("");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Mystery Boxes: \u00a7f{BOXES_AVAILABLE}");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Gift Packs: \u00a7f{BOXES_AVAILABLE}");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Mystery Dust: \u00a7f{DUST_AVAILABLE}");
        arrayList.add("");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Songs Progress: &e{SONG_UNLOCKED}&7/{SONG_MAX} &a{SONG_UNLOCKED_PERCENT}%");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Themes Progress: &e{THEME_UNLOCKED}&7/{THEME_MAX} &a{THEME_UNLOCKED_PERCENT}%");
        arrayList.add("");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Boxes Opened: \u00a7f{STATISTIC_BOXES_OPENED}");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Last Opening: \u00a7f{TIMESTAMP_BOX_OPEN}");
        arrayList.add("");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Boxes Crafted \u00a7f{STATISTIC_BOXES_CRAFTED}");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Last Crafting: \u00a7f{TIMESTAMP_BOX_CRAFT}");
        arrayList.add("");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Gifts Sent: \u00a7f{STATISTIC_GIFTS_SENT}");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Gifts Received: \u00a7f{STATISTIC_GIFTS_RECEIVED}");
        arrayList.add("\u00a78\ud83d\udd38 \u00a77Last Gift Sent: \u00a7f{TIMESTAMP_GIFT_SENT}");
        arrayList.add("");
        arrayList.add(MessageUtils.getSeparator(Variables.SEPARATOR_COLOR));
        for (String string3 : arrayList) {
            string3 = GeneralPlaceholders.translate((Object)uUID, string3);
            commandSender.sendMessage(string3);
        }
        return false;
    }
}

