/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.commands.executors.boxes;

import com.xericker.mysteryboxes.Variables;
import com.xericker.mysteryboxes.commands.Command;
import com.xericker.mysteryboxes.commands.CommandInterface;
import com.xericker.mysteryboxes.commands.CommandUtils;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxStatus;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.loots.LootStatus;
import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeData;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import utils.MessageUtils;

public class ExecuteBoxInfo
implements CommandInterface {
    @Override
    public boolean execute(CommandSender commandSender, Command command, String[] stringArray) {
        String string;
        if (stringArray.length < 2) {
            CommandUtils.sendMessage(commandSender, "Oops! Some arguments are missing!", command);
            return false;
        }
        Box box = BoxManager.getBox(stringArray[1]);
        if (box == null) {
            CommandUtils.sendMessage(commandSender, new String[]{"Could not find the specified box!", "", "\u00a7eType \u00a7b/mb " + Command.LISTBOXES.getName() + " \u00a7efor the list of Mystery Boxes"});
            return false;
        }
        commandSender.sendMessage(MessageUtils.getSeparator(Variables.SEPARATOR_COLOR));
        commandSender.sendMessage("");
        commandSender.sendMessage(MessageUtils.formatCenter(box.getBoxSettings().name));
        commandSender.sendMessage(MessageUtils.formatCenter("\u00a77ID: \u00a7r" + box.getId()));
        if (box.getStatus() != BoxStatus.ENABLED && box.getStatus() != BoxStatus.ERROR_LOOT_SETTINGS) {
            commandSender.sendMessage("");
            if (box.getBoxSettings().enabled) {
                string = box.getStatus().name();
                string = string.replace("ERROR_", "");
                string = string.replace("_", "-");
                string = string.toLowerCase();
                commandSender.sendMessage(MessageUtils.formatCenter("\u00a7cThere's a problem with the Mystery Box!"));
                commandSender.sendMessage(MessageUtils.formatCenter("\u00a7cCheck the settings under: \u00a7r" + string));
            } else {
                commandSender.sendMessage(MessageUtils.formatCenter("\u00a77This Mystery Box is disabled!"));
                commandSender.sendMessage(MessageUtils.formatCenter("\u00a77You can enable it in the config."));
            }
        }
        if (box.getStatus() == BoxStatus.ERROR_LOOT_SETTINGS && !box.getLoots().isEmpty()) {
            commandSender.sendMessage("");
            commandSender.sendMessage(MessageUtils.formatCenter("\u00a7cThere's a problem with Mystery Loots!"));
            commandSender.sendMessage(MessageUtils.formatCenter("\u00a7cPlease ensure that the loots assigned to this"));
            commandSender.sendMessage(MessageUtils.formatCenter("\u00a7cbox are enabled and have valid configurations."));
        }
        if (box.getBoxSettings().enabled && !box.getLoots().isEmpty()) {
            commandSender.sendMessage("");
            commandSender.sendMessage(MessageUtils.formatCenter("\u00a7r\u00a7lAssigned Loots"));
            commandSender.sendMessage("");
        }
        if (box.getBoxSettings().enabled && box.getLoots().isEmpty()) {
            string = new TextComponent(MessageUtils.formatCenter("\u00a76\u00a7nClick\u00a7e to learn about Mystery Loots"));
            string.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bit.ly/3TCKUR4"));
            string.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a76\u00a7nClick\u00a7e to open the wiki").create()));
            commandSender.sendMessage("");
            commandSender.sendMessage(MessageUtils.formatCenter("\u00a7cThere are no Mystery Loots"));
            commandSender.sendMessage(MessageUtils.formatCenter("\u00a7cassigned to this Mystery Box!"));
            commandSender.sendMessage("");
            commandSender.spigot().sendMessage((BaseComponent)string);
        }
        int n = 0;
        for (Loot loot : box.getLoots().keySet()) {
            Object object;
            ++n;
            Object object2 = "\u00a7a\u2714OK";
            if (loot.getLootSettings().enabled && loot.getStatus() != LootStatus.ENABLED) {
                object = loot.getStatus().name();
                object = ((String)object).replace("ERROR_", "");
                object = ((String)object).replace("_", "-");
                object = ((String)object).toLowerCase();
                object2 = "\u00a7c\u26a0 Failed: \u00a7r" + (String)object;
            }
            if (!loot.getLootSettings().enabled) {
                object2 = "\u00a7c\u2716DISABLED";
            }
            object = "\u00a78#" + n + " \u00a7r" + loot.getId();
            object = (String)object + " \u00a78- " + (loot.getLootSettings().valuable ? "\u00a7b\u2726" : "") + "\u00a7e" + String.valueOf(box.getLoots().get(loot)) + "%";
            object = (String)object + " \u00a78- " + (String)object2;
            String string2 = "\u00a77This loot has a \u00a7e" + String.valueOf(box.getLoots().get(loot)) + "% \u00a77chance\n\u00a77to drop from Mystery Boxes.";
            UpgradeData upgradeData = UpgradeManager.getData(Upgrade.TREASURE_HUNTER);
            if (upgradeData != null && loot.getLootSettings().valuable) {
                string2 = string2 + "\n";
                string2 = string2 + "\n\u00a7b\u2726 " + upgradeData.getGeneralSettings().name;
                string2 = string2 + "\n\u00a77This loot is considered 'valuable'.";
                string2 = string2 + "\n\u00a77The chance will be increased";
                string2 = string2 + "\n\u00a77based on the upgrade's bonus.";
            }
            TextComponent textComponent = new TextComponent((String)object);
            textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(string2).create()));
            commandSender.spigot().sendMessage((BaseComponent)textComponent);
        }
        commandSender.sendMessage("");
        commandSender.sendMessage(MessageUtils.getSeparator(Variables.SEPARATOR_COLOR));
        return false;
    }
}

